/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.connectionViewer;

import com.sybase.asa.common.IntegerTextField;
import com.sybase.asa.connectionViewer.DBConnectionViewer;
import com.sybase.asa.connectionViewer.DBConnectionViewerProperties;
import com.sybase.customization.CustomizationPage;
import com.sybase.helpManager.FactoryHelp;
import com.sybase.helpManager.HelpNotFoundException;
import com.sybase.helpManager.HelpViewer;
import com.sybase.util.Platform;
import com.sybase.util.SybLabel;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

class DBConnectionViewerCustomizationPage
extends JPanel
implements TableModelListener,
DocumentListener,
CustomizationPage {
    private static HelpViewer _helpViewer = null;
    DBConnectionViewer _connectionViewer;
    SybLabel _propertyLabel;
    PropertyTable _propertyTable;
    Vector<String> _propertyTableColumnNames;
    IntegerTextField _refreshRate = new IntegerTextField();

    DBConnectionViewerCustomizationPage(DBConnectionViewer dBConnectionViewer) {
        JPanel jPanel = new JPanel();
        SybLabel sybLabel = new SybLabel();
        JLabel jLabel = new JLabel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        this.add(jPanel);
        jPanel.add((Component)sybLabel);
        jPanel.add(this._refreshRate);
        jPanel.add(jLabel);
        this._propertyLabel = new SybLabel(DBConnectionViewer.getI18NMessage("customizer.select"));
        JScrollPane jScrollPane = new JScrollPane();
        if (Platform.isMacOS()) {
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setHorizontalScrollBarPolicy(32);
        } else {
            jScrollPane.setVerticalScrollBarPolicy(20);
            jScrollPane.setHorizontalScrollBarPolicy(30);
        }
        this._propertyTableColumnNames = new Vector(3);
        this._propertyTableColumnNames.add(DBConnectionViewer.getI18NMessage("customizer.display"));
        this._propertyTableColumnNames.add(DBConnectionViewer.getI18NMessage("customizer.propertyName"));
        this._propertyTableColumnNames.add(DBConnectionViewer.getI18NMessage("customizer.propertyDescription"));
        this._propertyTable = new PropertyTable(new CustomizerTableModel(new Vector(), (Vector)this._propertyTableColumnNames));
        this._propertyTable.setAutoResizeMode(0);
        this._propertyTable.setSelectionMode(0);
        this._propertyTable.getTableHeader().setDefaultRenderer(new LeftAlignedHeaderRenderer());
        this._propertyTable.getTableHeader().setReorderingAllowed(false);
        jScrollPane.getViewport().add(this._propertyTable);
        this._propertyLabel.setLabelFor((Component)this._propertyTable);
        sybLabel.setText(DBConnectionViewer.getI18NMessage("customizer.refreshRate"));
        sybLabel.setLabelFor((Component)this._refreshRate);
        sybLabel.setToolTipText(DBConnectionViewer.getI18NMessage("customizer.refreshRateTip"));
        this._refreshRate.getDocument().addDocumentListener(this);
        jLabel.setText(DBConnectionViewer.getI18NMessage("customizer.seconds"));
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        this.setLayout(gridBagLayout2);
        this.add((Component)this._propertyLabel);
        this.add(jScrollPane);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagLayout2.setConstraints((Component)this._propertyLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout2.setConstraints(jScrollPane, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout2.setConstraints(jPanel, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints((Component)sybLabel, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints2.ipadx = this._refreshRate.getPreferredSize().height * 2;
        gridBagConstraints2.weighty = 1.0;
        gridBagLayout.setConstraints(this._refreshRate, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(5, 0, 5, 5);
        gridBagConstraints2.ipadx = 100;
        gridBagConstraints2.weightx = 1.0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints2);
        this._connectionViewer = dBConnectionViewer;
        Vector vector = new Vector();
        FontMetrics fontMetrics = this._propertyTable.getFontMetrics(this._propertyTable.getFont());
        int n = fontMetrics.stringWidth(DBConnectionViewer.getI18NMessage("customizer.display"));
        int n2 = fontMetrics.stringWidth(DBConnectionViewer.getI18NMessage("customizer.propertyName"));
        int n3 = fontMetrics.stringWidth(DBConnectionViewer.getI18NMessage("customizer.propertyDescription"));
        Object[] objectArray = this._connectionViewer._propertyDescriptions.keySet().toArray();
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            String string = object.toString();
            String string2 = this._connectionViewer._propertyDescriptions.get(string);
            int n4 = fontMetrics.stringWidth(string);
            if (n4 > n2) {
                n2 = n4;
            }
            if ((n4 = fontMetrics.stringWidth(string2)) > n3) {
                n3 = n4;
            }
            Vector<Object> vector2 = new Vector<Object>(3);
            if (DBConnectionViewerProperties.checkConnectionProperty(string) > -1) {
                vector2.add(Boolean.TRUE);
            } else {
                vector2.add(Boolean.FALSE);
            }
            vector2.add(string);
            vector2.add(string2);
            vector.add(vector2);
        }
        ((CustomizerTableModel)this._propertyTable.getModel()).setDataVector(vector, this._propertyTableColumnNames);
        this._propertyTable.getColumnModel().getColumn(0).setPreferredWidth(n + 8);
        this._propertyTable.getColumnModel().getColumn(1).setPreferredWidth(n2 + 4);
        this._propertyTable.getColumnModel().getColumn(2).setPreferredWidth(n3 + 4);
        this._propertyTable.getColumnModel().getColumn(0).setResizable(false);
        this._propertyTable.getColumnModel().getColumn(1).setResizable(false);
        this._propertyTable.getColumnModel().getColumn(2).setResizable(false);
    }

    public void initialize() {
        this._propertyTable.getModel().removeTableModelListener(this);
        int n = this._propertyTable.getRowCount();
        for (int i = 0; i < n; ++i) {
            if (DBConnectionViewerProperties.checkConnectionProperty((String)this._propertyTable.getValueAt(i, 1)) > -1) {
                this._propertyTable.setValueAt(Boolean.TRUE, i, 0);
                continue;
            }
            this._propertyTable.setValueAt(Boolean.FALSE, i, 0);
        }
        this._propertyTable.getModel().addTableModelListener(this);
        this._refreshRate.setValue(DBConnectionViewerProperties.getRefreshRate() / 1000);
    }

    public boolean validateChanges() {
        return true;
    }

    public String getTitle() {
        return DBConnectionViewer.getI18NMessage("dbconnectionviewer.connectionViewer");
    }

    public void destroy() {
        this._propertyTable.getModel().removeTableModelListener(this);
        this._refreshRate.getDocument().removeDocumentListener(this);
        DBConnectionViewerProperties.reset();
    }

    private HelpViewer getHelpViewer() {
        if (_helpViewer == null) {
            String string = "sqlanywhere_";
            String string2 = Long.toString(11L);
            try {
                _helpViewer = FactoryHelp.getHelpViewer((String)DBConnectionViewer._helpFolder, (String)string, (String)string2);
            }
            catch (HelpNotFoundException helpNotFoundException) {
                // empty catch block
            }
        }
        return _helpViewer;
    }

    public void showHelp() {
        if (this.getHelpViewer() != null) {
            this.getHelpViewer().turnPage("HELP_DBCONNECTION_VIEWER_CUSTOMIZATION", SwingUtilities.windowForComponent(this));
        }
    }

    public Component getComponent() {
        return this;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getLastRow();
        if (n < 0 || n2 < 0) {
            return;
        }
        if (this._connectionViewer == null) {
            return;
        }
        for (int i = n; i <= n2; ++i) {
            String string = (String)this._propertyTable.getValueAt(i, 1);
            boolean bl = (Boolean)this._propertyTable.getValueAt(i, 0);
            if (bl) {
                DBConnectionViewerProperties.addConnectionProperty(string);
                continue;
            }
            DBConnectionViewerProperties.removeConnectionProperty(string);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        DBConnectionViewerProperties.setRefreshRate(this._refreshRate.getValue() * 1000);
        this._connectionViewer.setRefreshRate(this._refreshRate.getValue() * 1000);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    static class PropertySet {
        Vector data = null;
        int displayWidth = 0;
        int propertyNameWidth = 0;
        int propertyDescriptionWidth = 0;

        PropertySet() {
        }
    }

    static class LeftAlignedHeaderRenderer
    extends DefaultTableCellRenderer {
        LeftAlignedHeaderRenderer() {
            this.setHorizontalTextPosition(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            if (!jTable.isEnabled()) {
                this.setForeground(UIManager.getColor("TextField.inactiveForeground"));
            } else {
                this.setForeground(UIManager.getColor("TableHeader.foreground"));
            }
            JTableHeader jTableHeader = jTable.getTableHeader();
            if (jTableHeader != null) {
                if (jTable.isEnabled()) {
                    this.setForeground(jTableHeader.getForeground());
                }
                this.setBackground(jTableHeader.getBackground());
            }
            return this;
        }
    }

    static class CustomizerTableModel
    extends DefaultTableModel {
        CustomizerTableModel(Vector vector, int n) {
            super(vector, n);
        }

        CustomizerTableModel(int n, int n2) {
            super(n, n2);
        }

        CustomizerTableModel(Vector vector, Vector vector2) {
            super(vector, vector2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }
    }

    static class PropertyTable
    extends JTable {
        PropertyTable(TableModel tableModel) {
            super(tableModel);
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return Object.class;
        }
    }
}

