/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.connectionViewer;

import com.sybase.asa.connectionViewer.DBConnectionViewer;
import com.sybase.util.Platform;
import com.sybase.util.SybMessageFormat;
import com.sybase.util.SybOptionPane;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

class DBConnectionViewerProperties {
    private static String _connectionProperties;
    private static ArrayList<String> _connectionPropertyList;
    private static int _refreshRate;
    private static String _propertyFileName;
    private static String _pathSeparator;
    private static boolean _dirty;
    private static boolean _loaded;

    DBConnectionViewerProperties() {
    }

    static void load() {
        if (_loaded) {
            return;
        }
        _loaded = true;
        Properties properties = new Properties(System.getProperties());
        try {
            properties.load(new BufferedInputStream(new FileInputStream(_propertyFileName)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setProperties(properties);
        DBConnectionViewerProperties.reset();
    }

    static void store() {
        if (_dirty) {
            _dirty = false;
            try {
                System.setProperty("DBConnectionViewer.connectionProperties", _connectionProperties);
                System.setProperty("DBConnectionViewer.refreshRate", String.valueOf(_refreshRate));
                Properties properties = new Properties(System.getProperties());
                properties.setProperty("DBConnectionViewer.connectionProperties", System.getProperty("DBConnectionViewer.connectionProperties"));
                properties.setProperty("DBConnectionViewer.refreshRate", System.getProperty("DBConnectionViewer.refreshRate"));
                FileOutputStream fileOutputStream = new FileOutputStream(_propertyFileName);
                properties.store(fileOutputStream, "DBConnectionViewer user prefrerences");
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                Object[] objectArray = new Object[]{_propertyFileName};
                SybOptionPane.showConfirmDialog(null, (Object)SybMessageFormat.format((String)DBConnectionViewer.getI18NMessage("customizer.property.error"), (Object[])objectArray), (String)DBConnectionViewer.getI18NMessage("customizer.property.error.title"), (int)-1, (int)0);
            }
            catch (ClassCastException classCastException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    static void reset() {
        _connectionProperties = System.getProperty("DBConnectionViewer.connectionProperties", "userid,dbname,reqtype,lastreqtime,blockedon,commlink,name");
        _refreshRate = Integer.getInteger("DBConnectionViewer.refreshRate", 4000);
        DBConnectionViewerProperties.setConnectionPropertyList(_connectionProperties);
        _dirty = false;
    }

    static String getConnectionProperties() {
        if (!_loaded) {
            DBConnectionViewerProperties.load();
        }
        return _connectionProperties;
    }

    static void setConnectionProperties(String string) {
        _connectionProperties = string;
        _dirty = true;
    }

    static void addConnectionProperty(String string) {
        if (!_connectionPropertyList.contains(string = string.toLowerCase())) {
            _connectionPropertyList.add(string);
            _connectionProperties = _connectionProperties + "," + string;
            _dirty = true;
        }
    }

    static void removeConnectionProperty(String string) {
        int n = DBConnectionViewerProperties.checkConnectionProperty(string);
        if (n > -1) {
            _connectionPropertyList.remove(n);
            DBConnectionViewerProperties.propertyListToString();
            _dirty = true;
        }
    }

    static void moveConnectionProperty(int n, int n2) {
        try {
            String string = _connectionPropertyList.get(n);
            _connectionPropertyList.remove(n);
            _connectionPropertyList.add(n2, string);
            DBConnectionViewerProperties.propertyListToString();
            _dirty = true;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    private static void propertyListToString() {
        int n = _connectionPropertyList.size();
        StringBuffer stringBuffer = new StringBuffer(20 * n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(_connectionPropertyList.get(i)).append(",");
        }
        _connectionProperties = stringBuffer.length() > 0 ? stringBuffer.substring(0, stringBuffer.length() - 1) : "";
    }

    static int checkConnectionProperty(String string) {
        return _connectionPropertyList.indexOf(string.toLowerCase());
    }

    static void setConnectionPropertyList(String string) {
        _connectionPropertyList = new ArrayList(20);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().toLowerCase();
            if (_connectionPropertyList.contains(string2)) continue;
            _connectionPropertyList.add(string2);
        }
    }

    static ArrayList<String> getConnectionPropertyList() {
        if (!_loaded) {
            DBConnectionViewerProperties.load();
        }
        return new ArrayList<String>(_connectionPropertyList);
    }

    static int getRefreshRate() {
        if (!_loaded) {
            DBConnectionViewerProperties.load();
        }
        return _refreshRate;
    }

    static void setRefreshRate(int n) {
        _refreshRate = n;
        _dirty = true;
    }

    static {
        _propertyFileName = Platform.getUserConfigurationDirectory() + ".DBConnectionViewer" + 11;
        _pathSeparator = System.getProperty("path.separator");
        _dirty = false;
        _loaded = false;
    }
}

