/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.messageViewer;

import com.sybase.asa.common.ASAComponentsImageLoader;
import com.sybase.asa.common.event.DatabaseErrorEvent;
import com.sybase.asa.common.event.DatabaseErrorListener;
import com.sybase.asa.messageViewer.DBMessageViewerCustomizationPage;
import com.sybase.asa.messageViewer.DBMessageViewerProperties;
import com.sybase.asa.messageViewer.ReflectiveAction;
import com.sybase.customization.Customizable;
import com.sybase.customization.CustomizationPage;
import com.sybase.customization.CustomizeDialog;
import com.sybase.customization.CustomizerHost;
import com.sybase.util.DBConnectionAgent;
import com.sybase.util.Platform;
import com.sybase.util.SwingWorker;
import com.sybase.util.SybMenuItem;
import com.sybase.util.UIUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import javax.swing.AbstractListModel;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;

public class DBMessageViewer
extends JPanel
implements MouseListener,
ClipboardOwner,
Customizable {
    static String _helpFolder;
    static String _helpPrefix;
    static String _helpSuffix;
    static final String MESSAGE_VIEWER = "dbmessageviewer.messageViewer";
    static final String COPY = "dbmessageviewer.copy";
    static final String SELECT_ALL = "dbmessageviewer.selectAll";
    static final String CUSTOMIZE_MENUITEM = "dbmessageviewer.customizeMenuItem";
    static final String CUSTOMIZE_MENUITEM_MAC = "dbmessageviewer.customizeMenuItem_Mac";
    static final String CUSTOMIZER_DISPLAY = "customizer.display";
    static final String CUSTOMIZER_MESSAGES_ONLY = "customizer.messagesOnly";
    static final String CUSTOMIZER_MESSAGES_ONLY_TIP = "customizer.messagesOnlyTip";
    static final String CUSTOMIZER_TIME_AND_MESSAGES = "customizer.timeAndMessages";
    static final String CUSTOMIZER_TIME_AND_MESSAGES_TIP = "customizer.timeAndMessagesTip";
    static final String CUSTOMIZER_REFRESH_RATE = "customizer.refreshRate";
    static final String CUSTOMIZER_REFRESH_RATE_TIP = "customizer.refreshRateTip";
    static final String CUSTOMIZER_SECONDS = "customizer.seconds";
    static final String CUSTOMIZER_PROPERTY_ERROR = "customizer.property.error";
    static final String CUSTOMIZER_PROPERTY_ERROR_TITLE = "customizer.property.error.title";
    private static final int CATEGORY_LIMIT_DEFAULT = 400;
    private static final int CATEGORY_LIMIT_MAXIMUM = 5000;
    private static final MessageData MESSAGE_DATA_SUCCESS_NO_MESSAGES;
    private static final MessageData MESSAGE_DATA_FAILURE;
    private static final Clipboard CLIPBOARD;
    private static final String LINE_SEPARATOR;
    private static final String SQL_SELECT_DATABASE_NAME = "SELECT DB_PROPERTY( 'Name' )";
    private static final String SQL_SELECT_IS_VERSION_11 = "SELECT IF EXISTS( SELECT 1 FROM SYS.SYSPROCEDURE P JOIN SYS.SYSUSERPERMS U ON U.user_id = P.creator WHERE U.user_name = 'dbo' AND P.proc_name = 'sa_server_messages' ) THEN 'Y' ELSE 'N' ENDIF";
    private static final String SQL_SELECT_MESSAGE_CATEGORY_LIMIT = "SELECT PROPERTY( 'MessageCategoryLimit' )";
    private static final String SQL_SELECT_MESSAGE_WINDOW_SIZE = "SELECT PROPERTY( 'MessageWindowSize' )";
    private static final ResourceBundle RESOURCE_BUNDLE;
    private EventListenerList _listenerList = new EventListenerList();
    private DBConnectionAgent _connectionAgent;
    private int _refreshRate;
    private boolean _showTimeAndMessage;
    private Writer _writer;
    private JList _messagesList;
    private JScrollPane _messagesScrollPane;
    private Action _copySelectedMessagesAction;
    private Action _selectAllMessagesAction;
    private Action _customizeAction;
    private JPopupMenu _popupMenu;
    private Timer _timer;
    private MessageMaps _messageMaps;
    private BigDecimal _lastMessageId;
    private boolean _isPreVersion11;
    private int _categoryLimit;
    private SwingWorker _refreshWorker;
    private boolean _workerBusy;
    private CustomizerHost _customizerHost;
    private CustomizeDialog _customizeDialog;
    private boolean _isDestroyed;

    public static void setHelpFolder(String string, String string2, String string3) {
        _helpFolder = string;
        _helpPrefix = string2;
        _helpSuffix = string3;
    }

    public DBMessageViewer(DBConnectionAgent dBConnectionAgent) {
        this(dBConnectionAgent, DBMessageViewerProperties.getRefreshRate(), DBMessageViewerProperties.getShowTimeAndMessage());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBMessageViewer(DBConnectionAgent dBConnectionAgent, int n, boolean bl) {
        DBMessageViewerProperties.load();
        this._refreshRate = n;
        this._showTimeAndMessage = bl;
        this._messagesList = new JList(new MessagesListModel());
        this._messagesList.setSelectionMode(2);
        this._messagesScrollPane = new JScrollPane(this._messagesList);
        this._messagesScrollPane.setHorizontalScrollBarPolicy(Platform.isMacOS() ? 32 : 30);
        this._messagesScrollPane.setVerticalScrollBarPolicy(22);
        this._copySelectedMessagesAction = new ReflectiveAction(this, "copySelectedMessages", DBMessageViewer.getI18NMessage(COPY));
        this._selectAllMessagesAction = new ReflectiveAction(this, "selectAllMessages", DBMessageViewer.getI18NMessage(SELECT_ALL));
        this._customizeAction = new ReflectiveAction(this, "customizeActionPerformed", DBMessageViewer.getI18NMessage(Platform.isMacOS() ? CUSTOMIZE_MENUITEM_MAC : CUSTOMIZE_MENUITEM));
        this._customizeAction.setEnabled(false);
        InputMap inputMap = this._messagesList.getInputMap(1);
        ActionMap actionMap = this._messagesList.getActionMap();
        int n2 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if (inputMap != null && actionMap != null) {
            inputMap.put(KeyStroke.getKeyStroke(67, n2), "copy");
            inputMap.put(KeyStroke.getKeyStroke(155, n2), "copy");
            actionMap.put("copy", this._copySelectedMessagesAction);
            inputMap.put(KeyStroke.getKeyStroke(65, n2), "selectAll");
            actionMap.put("selectAll", this._selectAllMessagesAction);
        }
        this._popupMenu = new JPopupMenu();
        this._popupMenu.add((JMenuItem)new SybMenuItem(this._copySelectedMessagesAction));
        this._popupMenu.add((JMenuItem)new SybMenuItem(this._selectAllMessagesAction));
        this._popupMenu.add((JMenuItem)new SybMenuItem(this._customizeAction));
        this.setLayout(new BorderLayout());
        this.add((Component)this._messagesScrollPane, "Center");
        this._messagesList.addMouseListener(this);
        this._messagesScrollPane.addMouseListener(this);
        this._timer = new Timer(n, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBMessageViewer.this.refresh();
            }
        });
        this._timer.setInitialDelay(0);
        this._timer.setDelay(this._refreshRate);
        DBMessageViewer dBMessageViewer = this;
        synchronized (dBMessageViewer) {
            this._messageMaps = new MessageMaps();
            this._lastMessageId = BigDecimal.valueOf(-1L);
        }
        if (dBConnectionAgent != null) {
            ConnectionWorker connectionWorker = new ConnectionWorker(dBConnectionAgent);
            connectionWorker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        if (this._isDestroyed) {
            return;
        }
        this._messagesList.addMouseListener(this);
        this._messagesScrollPane.addMouseListener(this);
        this.stopRefreshing();
        if (this._customizeDialog != null) {
            this._customizeDialog.destroy();
        }
        this._listenerList = null;
        this._messagesList = null;
        this._messagesScrollPane = null;
        this._copySelectedMessagesAction = null;
        this._selectAllMessagesAction = null;
        this._customizeAction = null;
        this._popupMenu = null;
        this._timer = null;
        this._refreshWorker = null;
        this._customizerHost = null;
        this._customizeDialog = null;
        DBMessageViewer dBMessageViewer = this;
        synchronized (dBMessageViewer) {
            this._connectionAgent = null;
            this._writer = null;
            this._messageMaps = null;
            this._lastMessageId = null;
        }
        this._isDestroyed = true;
    }

    public synchronized DBConnectionAgent getConnectionAgent() {
        return this._connectionAgent;
    }

    public synchronized void setConnectionAgent(DBConnectionAgent dBConnectionAgent) {
        boolean bl;
        this._connectionAgent = dBConnectionAgent;
        if (this._connectionAgent == null) {
            bl = false;
        } else {
            boolean bl2;
            String string = this._getStringValue(SQL_SELECT_DATABASE_NAME);
            boolean bl3 = bl2 = string != null && string.equals("utility_db");
            if (bl2) {
                bl = false;
            } else {
                bl = true;
                string = this._getStringValue(SQL_SELECT_IS_VERSION_11);
                this._isPreVersion11 = string != null && !string.isEmpty() && string.charAt(0) == 'N';
                string = this._getStringValue(this._isPreVersion11 ? SQL_SELECT_MESSAGE_WINDOW_SIZE : SQL_SELECT_MESSAGE_CATEGORY_LIMIT);
                try {
                    this._categoryLimit = Math.min(Integer.valueOf(string), 5000);
                }
                catch (NumberFormatException numberFormatException) {
                    this._categoryLimit = 400;
                }
            }
        }
        this._copySelectedMessagesAction.setEnabled(bl);
        this._selectAllMessagesAction.setEnabled(bl);
        this._customizeAction.setEnabled(bl);
        if (bl) {
            this._clearMessages();
            if (this._timer != null && !this._timer.isRunning()) {
                this._timer.restart();
            }
        } else {
            this.stopRefreshing();
            this._clearMessages();
        }
    }

    public int getRefreshRate() {
        return this._refreshRate;
    }

    public void setRefreshRate(int n) {
        this._refreshRate = n;
        this._timer.setDelay(this._refreshRate);
    }

    public boolean getShowTimeAndMessage() {
        return this._showTimeAndMessage;
    }

    public void setShowTimeAndMessage(boolean bl) {
        if (this._showTimeAndMessage == bl) {
            return;
        }
        this._showTimeAndMessage = bl;
        this._clearMessages();
    }

    public synchronized Writer getWriter() {
        return this._writer;
    }

    public synchronized void setWriter(Writer writer) {
        this._writer = writer;
    }

    public synchronized void refresh() {
        if (this._connectionAgent == null) {
            return;
        }
        if (this._timer != null && !this._timer.isRunning()) {
            this._timer.restart();
        }
        this._refreshMessages();
    }

    public void stopRefreshing() {
        if (this._timer != null && this._timer.isRunning()) {
            this._timer.stop();
        }
        if (this._workerBusy) {
            this._refreshWorker.interrupt();
        }
    }

    public void copySelectedMessages() {
        int[] nArray = this._messagesList.getSelectedIndices();
        int n = nArray.length;
        if (n > 0) {
            StringBuilder stringBuilder = new StringBuilder(n * 80);
            for (int n2 : this._messagesList.getSelectedIndices()) {
                stringBuilder.append(this._messagesList.getModel().getElementAt(n2)).append(LINE_SEPARATOR);
            }
            CLIPBOARD.setContents(new StringSelection(stringBuilder.toString()), this);
        }
    }

    public void selectAllMessages() {
        int n = this._messagesList.getModel().getSize();
        if (n > 0) {
            this._messagesList.setSelectionInterval(0, n - 1);
        }
    }

    public void customizeActionPerformed() {
        CustomizeDialog customizeDialog = this._getCustomizeDialog(SwingUtilities.windowForComponent(this));
        customizeDialog.selectComponent((Customizable)this);
        UIUtils.ensureWindowIsVisible((Window)customizeDialog);
        customizeDialog.setVisible(true);
    }

    public void addDatabaseErrorListener(DatabaseErrorListener databaseErrorListener) {
        this._listenerList.add(DatabaseErrorListener.class, databaseErrorListener);
    }

    public void removeDatabaseErrorListener(DatabaseErrorListener databaseErrorListener) {
        this._listenerList.remove(DatabaseErrorListener.class, databaseErrorListener);
    }

    protected void fireDatabaseError(Object object, Exception exception) {
        if (this._timer != null && this._timer.isRunning()) {
            Object[] objectArray = this._listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != DatabaseErrorListener.class) continue;
                ((DatabaseErrorListener)objectArray[i + 1]).databaseError(new DatabaseErrorEvent(object, exception));
            }
        }
    }

    static String getI18NMessage(String string) {
        String string2;
        try {
            string2 = (String)RESOURCE_BUNDLE.getObject(string);
        }
        catch (MissingResourceException missingResourceException) {
            string2 = "";
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized String _getStringValue(String string) {
        String string2;
        Connection connection = this._connectionAgent.getConnection();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(string);
            resultSet.next();
            string2 = resultSet.getString(1);
        }
        catch (SQLException sQLException) {
            string2 = null;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            this._connectionAgent.freeConnection(connection);
        }
        return string2;
    }

    private void _refreshMessages() {
        if (!this._workerBusy) {
            this._workerBusy = true;
            this._refreshWorker = new SwingWorker(){

                public Object construct() {
                    return DBMessageViewer.this._getMessages();
                }

                public void finished() {
                    DBMessageViewer.this._workerBusy = false;
                    DBMessageViewer.this._updateDisplay((MessageData)this.getValue());
                }
            };
            this._refreshWorker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized MessageData _getMessages() {
        if (this._isDestroyed) {
            return MESSAGE_DATA_SUCCESS_NO_MESSAGES;
        }
        MessageData messageData = MESSAGE_DATA_SUCCESS_NO_MESSAGES;
        Connection connection = this._connectionAgent.getConnection();
        Statement statement = null;
        try {
            statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery((this._isPreVersion11 ? "CALL dbo.sa_get_server_messages( " : "CALL dbo.sa_server_messages( ") + String.valueOf(this._lastMessageId.add(BigDecimal.ONE)) + " )");
            if (resultSet.next()) {
                do {
                    BigDecimal bigDecimal = this._isPreVersion11 ? BigDecimal.valueOf(resultSet.getInt(1)) : resultSet.getBigDecimal(1);
                    String string = resultSet.getString(2);
                    Timestamp timestamp = resultSet.getTimestamp(3);
                    String string2 = this._isPreVersion11 ? null : resultSet.getString(4);
                    String string3 = this._isPreVersion11 ? null : resultSet.getString(5);
                    String string4 = this._isPreVersion11 ? null : resultSet.getString(6);
                    this._messageMaps.add(new Message(bigDecimal, string, timestamp, string2, string3, string4));
                    if (this._writer != null) {
                        this._writer.write(timestamp + " " + string + LINE_SEPARATOR);
                    }
                    this._lastMessageId = bigDecimal;
                } while (resultSet.next());
                messageData = new MessageData(this._messageMaps.idMap.values().toArray(new Message[this._messageMaps.idMap.size()]), true, true);
            }
        }
        catch (SQLException sQLException) {
            this.fireDatabaseError(this, sQLException);
            messageData = MESSAGE_DATA_FAILURE;
        }
        catch (IOException iOException) {
            this.fireDatabaseError(this, iOException);
            messageData = MESSAGE_DATA_FAILURE;
        }
        finally {
            if (statement != null) {
                try {
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            if (this._writer != null) {
                try {
                    this._writer.flush();
                }
                catch (IOException iOException) {}
            }
            this._connectionAgent.freeConnection(connection);
        }
        return messageData;
    }

    private void _updateDisplay(MessageData messageData) {
        if (this._isDestroyed) {
            return;
        }
        if (!messageData.success) {
            this.stopRefreshing();
        } else if (messageData.messagesAdded) {
            MessagesListModel messagesListModel = (MessagesListModel)this._messagesList.getModel();
            messagesListModel.setData(messageData.messages);
            int n = messagesListModel.getSize() - 1;
            this._messagesScrollPane.getViewport().scrollRectToVisible(this._messagesList.getCellBounds(n, n));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _clearMessages() {
        DBMessageViewer dBMessageViewer = this;
        synchronized (dBMessageViewer) {
            this._messageMaps.clear();
            this._lastMessageId = BigDecimal.valueOf(-1L);
        }
        ((MessagesListModel)this._messagesList.getModel()).clear();
    }

    private CustomizeDialog _getCustomizeDialog(Window window) {
        if (this.getCustomizerHost() != null) {
            return this.getCustomizerHost().getCustomizeDialog(window);
        }
        if (this._customizeDialog != null) {
            return this._customizeDialog;
        }
        this._customizeDialog = window instanceof Frame ? new CustomizeDialog((Frame)window) : new CustomizeDialog((Dialog)window);
        this._customizeDialog.addCustomizationPages((Customizable)this);
        return this._customizeDialog;
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this._handleMouseEvent(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this._handleMouseEvent(mouseEvent);
    }

    private void _handleMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this._popupMenu.show((JComponent)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable transferable) {
    }

    public CustomizationPage[] getCustomizationPages() {
        return new CustomizationPage[]{new DBMessageViewerCustomizationPage()};
    }

    public Icon getCustomizationGroupIcon() {
        return ASAComponentsImageLoader.getImageIcon("message_viewer", 1001);
    }

    public String getCustomizationGroupTitle() {
        return DBMessageViewer.getI18NMessage(MESSAGE_VIEWER);
    }

    public void acceptChanges() {
        DBMessageViewerProperties.store();
        this.setRefreshRate(DBMessageViewerProperties.getRefreshRate());
        this.setShowTimeAndMessage(DBMessageViewerProperties.getShowTimeAndMessage());
        this.refresh();
    }

    public void rejectChanges() {
    }

    public CustomizerHost getCustomizerHost() {
        return this._customizerHost;
    }

    public void setCustomizerHost(CustomizerHost customizerHost) {
        this._customizerHost = customizerHost;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        block11: {
            MESSAGE_DATA_SUCCESS_NO_MESSAGES = new MessageData(null, false, true);
            MESSAGE_DATA_FAILURE = new MessageData(null, false, false);
            CLIPBOARD = Toolkit.getDefaultToolkit().getSystemClipboard();
            LINE_SEPARATOR = System.getProperty("line.separator");
            ResourceBundle resourceBundle = null;
            String string = System.getProperty("language", System.getProperty("user.language", null));
            String string2 = System.getProperty("country", System.getProperty("user.region", null));
            try {
                if (string != null && string2 != null) {
                    try {
                        resourceBundle = ResourceBundle.getBundle("com.sybase.asa.messageViewer.DBMessageViewerResourceBundle", new Locale(string, string2));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (resourceBundle == null) {
                    try {
                        resourceBundle = ResourceBundle.getBundle("com.sybase.asa.messageViewer.DBMessageViewerResourceBundle", Locale.getDefault());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (resourceBundle != null) break block11;
                try {
                    resourceBundle = ResourceBundle.getBundle("com.sybase.asa.messageViewer.DBMessageViewerResourceBundle");
                }
                catch (Exception exception) {
                    throw new MissingResourceException("Can't find resource for base name com.sybase.asa.messageViewer.DBMessageViewerResourceBundle", "", "");
                }
            }
            finally {
                RESOURCE_BUNDLE = resourceBundle;
            }
        }
    }

    private static class MessagesListModel
    extends AbstractListModel {
        private Message[] _data;

        MessagesListModel() {
            this.clear();
        }

        Message[] getData() {
            return this._data;
        }

        void setData(Message[] messageArray) {
            this._data = messageArray;
            this.fireContentsChanged(this, 0, Integer.MAX_VALUE);
        }

        void clear() {
            this._data = new Message[0];
            this.fireContentsChanged(this, 0, Integer.MAX_VALUE);
        }

        @Override
        public Object getElementAt(int n) {
            try {
                return this._data[n];
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                return null;
            }
        }

        @Override
        public int getSize() {
            return this._data.length;
        }
    }

    private static class MessageData {
        Message[] messages;
        boolean messagesAdded;
        boolean success;

        MessageData(Message[] messageArray, boolean bl, boolean bl2) {
            this.messages = messageArray;
            this.messagesAdded = bl;
            this.success = bl2;
        }
    }

    private class MessageMaps {
        Map<String, List<Message>> categoryMap = new HashMap<String, List<Message>>();
        Map<BigDecimal, Message> idMap = new TreeMap<BigDecimal, Message>();

        MessageMaps() {
        }

        void add(Message message) {
            String string = message.category;
            List<Message> list = this.categoryMap.get(string);
            if (list == null) {
                list = new LinkedList<Message>();
                this.categoryMap.put(string, list);
            } else if (list.size() == DBMessageViewer.this._categoryLimit) {
                Message message2 = list.remove(0);
                this.idMap.remove(message2.id);
            }
            list.add(message);
            this.idMap.put(message.id, message);
        }

        void clear() {
            this.categoryMap.clear();
            this.idMap.clear();
        }
    }

    private class Message {
        BigDecimal id;
        String text;
        Timestamp timestamp;
        String severity;
        String category;
        String database;
        String displayText;

        Message(BigDecimal bigDecimal, String string, Timestamp timestamp, String string2, String string3, String string4) {
            this.id = bigDecimal;
            this.text = string;
            this.timestamp = timestamp;
            this.severity = string2;
            this.category = string3;
            this.database = string4;
            this.displayText = DBMessageViewer.this._showTimeAndMessage ? String.valueOf(timestamp) + ' ' + string : string;
        }

        public String toString() {
            return this.displayText;
        }
    }

    private class ConnectionWorker
    extends SwingWorker {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ConnectionWorker(DBConnectionAgent dBConnectionAgent) {
            DBMessageViewer dBMessageViewer2 = DBMessageViewer.this;
            synchronized (dBMessageViewer2) {
                DBMessageViewer.this._connectionAgent = dBConnectionAgent;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Object construct() {
            DBMessageViewer dBMessageViewer = DBMessageViewer.this;
            synchronized (dBMessageViewer) {
                DBMessageViewer.this.setConnectionAgent(DBMessageViewer.this._connectionAgent);
            }
            return null;
        }
    }
}

