/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.messageViewer;

import com.sybase.asa.messageViewer.DBMessageViewer;
import com.sybase.util.Platform;
import com.sybase.util.SybMessageFormat;
import com.sybase.util.SybOptionPane;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

class DBMessageViewerProperties {
    private static int _refreshRate;
    private static boolean _showTimeAndMessage;
    private static String _propertyFileName;
    private static boolean _dirty;
    private static boolean _loaded;

    DBMessageViewerProperties() {
    }

    static void load() {
        if (_loaded) {
            return;
        }
        _loaded = true;
        Properties properties = new Properties(System.getProperties());
        try {
            properties.load(new BufferedInputStream(new FileInputStream(_propertyFileName)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setProperties(properties);
        DBMessageViewerProperties.reset();
    }

    static void store() {
        if (_dirty) {
            _dirty = false;
            try {
                System.setProperty("DBMessageViewer.refreshRate", String.valueOf(_refreshRate));
                System.setProperty("DBMessageViewer.showTimeAndMessage", String.valueOf(_showTimeAndMessage));
                Properties properties = new Properties(System.getProperties());
                properties.setProperty("DBMessageViewer.refreshRate", System.getProperty("DBMessageViewer.refreshRate"));
                properties.setProperty("DBMessageViewer.showTimeAndMessage", System.getProperty("DBMessageViewer.showTimeAndMessage"));
                FileOutputStream fileOutputStream = new FileOutputStream(_propertyFileName);
                properties.store(fileOutputStream, "DBMessageViewer user prefrerences");
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                Object[] objectArray = new Object[]{_propertyFileName};
                SybOptionPane.showConfirmDialog(null, (Object)SybMessageFormat.format((String)DBMessageViewer.getI18NMessage("customizer.property.error"), (Object[])objectArray), (String)DBMessageViewer.getI18NMessage("customizer.property.error.title"), (int)-1, (int)0);
            }
            catch (ClassCastException classCastException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    static void reset() {
        _refreshRate = Integer.getInteger("DBMessageViewer.refreshRate", 4000);
        _showTimeAndMessage = Boolean.getBoolean("DBMessageViewer.showTimeAndMessage");
        _dirty = false;
    }

    static int getRefreshRate() {
        if (!_loaded) {
            DBMessageViewerProperties.load();
        }
        return _refreshRate;
    }

    static void setRefreshRate(int n) {
        _refreshRate = n;
        _dirty = true;
    }

    static boolean getShowTimeAndMessage() {
        if (!_loaded) {
            DBMessageViewerProperties.load();
        }
        return _showTimeAndMessage;
    }

    static void setShowTimeAndMessage(boolean bl) {
        _showTimeAndMessage = bl;
        _dirty = true;
    }

    static {
        _propertyFileName = Platform.getUserConfigurationDirectory() + ".DBMessageViewer" + 11;
        _dirty = false;
        _loaded = false;
    }
}

