/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.planview;

import com.sybase.asa.planview.AccessPlanException;
import com.sybase.asa.planview.PlanElement;
import com.sybase.asa.planview.Query;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class AccessPlan {
    private Handler handler = new Handler();

    public AccessPlan(Reader reader) throws AccessPlanException {
        this.build(reader, true);
    }

    public AccessPlan(String string) throws AccessPlanException {
        this.build(string, false);
    }

    public int getQueryCount() {
        return this.handler.queries.size();
    }

    public Query getQueryAt(int n) {
        if (n >= this.handler.queries.size()) {
            throw new IndexOutOfBoundsException(n + " / " + this.handler.queries.size());
        }
        return this.handler.queries.get(n);
    }

    public List<Query> getAllQueries() {
        return this.handler.queries;
    }

    public void setQueryName(int n, String string) {
        this.getQueryAt(n).setName(string);
    }

    private void build(Object object, boolean bl) throws AccessPlanException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            if (bl) {
                sAXParser.parse(new InputSource((Reader)object), (DefaultHandler)this.handler);
            } else {
                sAXParser.parse((String)object, (DefaultHandler)this.handler);
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new AccessPlanException(parserConfigurationException);
        }
        catch (SAXParseException sAXParseException) {
            throw new AccessPlanException(sAXParseException);
        }
        catch (SAXException sAXException) {
            throw new AccessPlanException(sAXException);
        }
        catch (IOException iOException) {
            throw new AccessPlanException(iOException);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throw new AccessPlanException(outOfMemoryError);
        }
    }

    public void addSubqueries(List<Query> list) {
        this.handler.queries.addAll(list);
    }

    private static final class Handler
    extends DefaultHandler {
        private StringBuffer _element_content;
        private PlanElement _current_operator;
        private Query _current_query;
        private int _count;
        public List<Query> queries;

        private Handler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            PlanElement planElement = null;
            if (string2.equals("asaPlan")) {
                String string4 = attributes.getValue("", "validQuery");
                if (string4 == null || string4.equalsIgnoreCase("true")) {
                    this.queries = new ArrayList<Query>();
                }
            } else if (string2.equals("query")) {
                this._current_query = new Query(attributes);
                this.queries.add(this._current_query);
                this._count = 0;
            } else if (string2.equals("operator")) {
                planElement = this._current_operator;
                this._current_operator = new PlanElement(attributes);
                ++this._count;
                if (planElement != null) {
                    this._current_operator.makeChildOf(planElement);
                }
            } else if (string2.equals("details") || string2.equals("advanceddetails") || string2.equals("tooltip") || string2.equals("originalquery")) {
                // empty if block
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            if (!string2.equals("asaPlan")) {
                if (string2.equals("query")) {
                    this._current_query = null;
                } else if (string2.equals("operator")) {
                    if (this._current_operator.getParent() == null) {
                        int n = 1;
                        PlanElement[] planElementArray = new PlanElement[this._count];
                        planElementArray[0] = this._current_operator;
                        for (int i = 0; i < this._count; ++i) {
                            n = planElementArray[i].levelTree(i, n, planElementArray);
                        }
                        this._current_query.setElements(planElementArray);
                    }
                    this._current_operator = this._current_operator.getParent();
                } else if (string2.equals("details")) {
                    this._current_operator.setDetailsValue(this._element_content.toString().trim());
                } else if (string2.equals("advanceddetails")) {
                    this._current_operator.setAdvancedDetailsValue(this._element_content.toString().trim());
                } else if (string2.equals("tooltip")) {
                    this._current_operator.setTooltip(this._element_content.toString().trim());
                } else if (string2.equals("originalquery")) {
                    // empty if block
                }
            }
            this._element_content = null;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (this._element_content == null) {
                this._element_content = new StringBuffer();
            }
            this._element_content.append(cArray, n, n2);
        }
    }
}

