/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.planview;

import java.io.IOException;
import java.io.Reader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.helpers.DefaultHandler;

public final class AccessPlanLoader {
    private String _sqlStatement;
    private Handler handler = new Handler();

    public boolean read(Reader reader) {
        if (reader == null) {
            throw new NullPointerException("Reader is null.");
        }
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        boolean bl = false;
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(new InputSource(reader), (DefaultHandler)this.handler);
            if (this.handler.sqlStatement != null) {
                this._sqlStatement = this.handler.sqlStatement.toString().trim();
                bl = true;
            }
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (IOException iOException) {
        }
        catch (SAXParseException sAXParseException) {
        }
        catch (SAXException sAXException) {
            // empty catch block
        }
        return bl;
    }

    public String getSQLStatement() {
        return this._sqlStatement;
    }

    private static final class Handler
    extends DefaultHandler {
        public StringBuffer sqlStatement;
        private boolean _collectingSQLStatement;

        private Handler() {
        }

        @Override
        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (string2.equals("originalquery")) {
                this._collectingSQLStatement = true;
                this.sqlStatement = new StringBuffer();
            }
        }

        @Override
        public void endElement(String string, String string2, String string3) {
            this._collectingSQLStatement = false;
        }

        @Override
        public void characters(char[] cArray, int n, int n2) {
            if (this._collectingSQLStatement) {
                this.sqlStatement.append(cArray, n, n2);
            }
        }
    }
}

