/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.planview;

import com.sybase.asa.planview.AccessPlan;
import com.sybase.asa.planview.AccessPlanException;
import com.sybase.asa.planview.BasicPlanElementView;
import com.sybase.asa.planview.PlanElement;
import com.sybase.asa.planview.PlanElementView;
import com.sybase.asa.planview.PlanSelectionEvent;
import com.sybase.asa.planview.PlanSelectionListener;
import com.sybase.asa.planview.PlanViewHelpManager;
import com.sybase.asa.planview.PlanViewProperties;
import com.sybase.asa.planview.Query;
import com.sybase.asa.planview.TreeGraph;
import com.sybase.util.DetailsErrorDialog;
import com.sybase.util.DialogUtils;
import com.sybase.util.JREUtils;
import com.sybase.util.SybButton;
import com.sybase.util.SybOptionPane;
import com.sybase.util.SybSplitPane;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.text.JTextComponent;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;

public final class AccessPlanViewer
extends JPanel
implements KeyListener,
PlanSelectionListener,
FocusListener,
ItemListener {
    private static int splitterLocation = 150;
    private static int MAIN_DETAILS = 0;
    private static int ADVANCED_DETAILS = 1;
    private String _currentURI;
    private Reader _currentReader;
    private Border _emptyBorder = BorderFactory.createMatteBorder(5, 5, 5, 5, SystemColor.window);
    private Border _focussedBorder = new CompoundBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, SystemColor.textHighlight), BorderFactory.createMatteBorder(4, 4, 4, 4, SystemColor.window));
    private int _fontsize;
    private String _fontname;
    private JComboBox _queryComboBox;
    private CardLayout _queryTreePanelLayout;
    private JPanel _queryTreePanel;
    private TreeGraph[] _query_trees;
    private JTextComponent[] _info_text;
    private JScrollPane[] _info_scroll;
    private MyJSplitPane _main_split;
    private JTabbedPane _info_tabs;
    private AccessPlan _plan;
    private ResizeListener _rl;
    private PlanElement _currentOperator = null;

    public AccessPlanViewer(String string, String string2, String string3) {
        super(new CardLayout());
        PlanViewProperties.load();
        PlanViewHelpManager.INSTANCE.init(string, string2, string3);
        this._info_text = new JTextComponent[2];
        this._info_scroll = new JScrollPane[2];
        this._info_tabs = new JTabbedPane(1);
        this.remakeInfoText();
        for (int i = 0; i < 2; ++i) {
            this._info_scroll[i] = new JScrollPane(this._info_text[i]);
            this._info_scroll[i].setPreferredSize(new Dimension(450, 450));
        }
        this._main_split = new MyJSplitPane(1, new JPanel(), this._info_tabs);
        this.add("SP", this._main_split);
        this._rl = new ResizeListener(this._main_split);
    }

    private void destroyInfoText() {
        for (int i = 0; i < 2; ++i) {
            if (this._info_text[i] == null) continue;
            this._info_text[i].setText("");
            this._info_text[i].removeFocusListener(this);
            this._info_text[i].removeKeyListener(this);
            this._info_text[i] = null;
        }
    }

    private void remakeInfoText() {
        this.destroyInfoText();
        for (int i = 0; i < 2; ++i) {
            this._info_text[i] = PlanViewProperties.getTestingMode() ? new JTextField() : new JEditorPane();
            this._info_text[i].setEditable(false);
            if (this._info_text[i] instanceof JEditorPane) {
                ((JEditorPane)this._info_text[i]).setContentType("text/html");
            }
            this._info_text[i].setBackground(SystemColor.window);
            this._info_text[i].setBorder(this._emptyBorder);
            this._info_text[i].addFocusListener(this);
            this._info_text[i].addKeyListener(this);
            if (!JREUtils.isAccessibilityExtensionLoaded()) continue;
            this._info_text[i].getCaret().setVisible(true);
            this._info_text[i].removeKeyListener(this);
            if (i == MAIN_DETAILS) {
                this._info_text[i].getAccessibleContext().setAccessibleName(AccessPlanViewer.getI18NMessage("accessible_name.details"));
                continue;
            }
            this._info_text[i].getAccessibleContext().setAccessibleName(AccessPlanViewer.getI18NMessage("accessible_name.advanceddetails"));
        }
        this._info_tabs.removeAll();
        this._info_tabs.add(AccessPlanViewer.getI18NMessage("accessible_name.details"), this._info_scroll[MAIN_DETAILS]);
        this._info_tabs.add(AccessPlanViewer.getI18NMessage("accessible_name.advanceddetails"), this._info_scroll[ADVANCED_DETAILS]);
    }

    public void subQuerySelect(String string) {
        this._queryComboBox.setSelectedItem(string);
        this._queryTreePanelLayout.show(this._queryTreePanel, (String)this._queryComboBox.getSelectedItem());
        int n = this._queryComboBox.getSelectedIndex();
        if (n != -1 && this._queryTreePanel.getComponentCount() > n) {
            JScrollPane jScrollPane = (JScrollPane)this._queryTreePanel.getComponent(n);
            TreeGraph treeGraph = (TreeGraph)jScrollPane.getViewport().getComponent(0);
            treeGraph.reset();
        }
    }

    @Override
    public void requestFocus() {
        if (this._main_split != null && this._queryComboBox != null && this._queryTreePanel != null) {
            this._main_split.resetToPreferredSizes();
            this._info_tabs.addComponentListener(this._rl);
            int n = this._queryComboBox.getSelectedIndex();
            if (n != -1 && this._queryTreePanel.getComponentCount() > n) {
                JScrollPane jScrollPane = (JScrollPane)this._queryTreePanel.getComponent(n);
                TreeGraph treeGraph = (TreeGraph)jScrollPane.getViewport().getComponent(0);
                treeGraph.requestFocus();
            }
        }
    }

    public void showHelp() {
        int n;
        boolean bl = false;
        if (this._main_split != null && this._queryComboBox != null && this._queryTreePanel != null && (n = this._queryComboBox.getSelectedIndex()) != -1 && this._queryTreePanel.getComponentCount() > n) {
            JScrollPane jScrollPane = (JScrollPane)this._queryTreePanel.getComponent(n);
            TreeGraph treeGraph = (TreeGraph)jScrollPane.getViewport().getComponent(0);
            treeGraph.showHelp();
            bl = true;
        }
        if (!bl) {
            PlanViewHelpManager.INSTANCE.openGeneralHelp();
        }
    }

    private Frame getFrameWindow() {
        Frame frame = (Frame)SwingUtilities.getAncestorOfClass(Frame.class, this);
        if (frame == null) {
            frame = AccessPlanViewer.getAnyFrameWindow();
        }
        return frame;
    }

    static Frame getAnyFrameWindow() {
        Frame frame = null;
        Frame[] frameArray = Frame.getFrames();
        for (int i = 0; i < frameArray.length; ++i) {
            if (!frameArray[i].isVisible()) continue;
            frame = frameArray[i];
            break;
        }
        return frame;
    }

    private boolean setupQueryTrees(List<Query> list) {
        boolean bl = true;
        try {
            this._plan = this._currentURI != null ? new AccessPlan(this._currentURI) : new AccessPlan(this._currentReader);
        }
        catch (AccessPlanException accessPlanException) {
            this._plan = null;
            DetailsErrorDialog.showDetailsErrorDialog((Frame)this.getFrameWindow(), (String)AccessPlanViewer.getI18NMessage("error"), (String)AccessPlanViewer.getI18NMessage("error.invalid_plan.message"), (Throwable)accessPlanException, null);
            return false;
        }
        if (this._plan != null) {
            if (list != null) {
                this._plan.addSubqueries(list);
            }
            int n = this._plan.getQueryCount();
            this._query_trees = new TreeGraph[n];
            if (this._queryComboBox == null) {
                this._queryComboBox = new JComboBox();
                this._queryComboBox.addItemListener(this);
                this._queryComboBox.getAccessibleContext().setAccessibleName(AccessPlanViewer.getI18NMessage("accessible_name.subqueries"));
            } else {
                this._queryComboBox.removeAllItems();
            }
            this._queryTreePanelLayout = new CardLayout();
            this._queryTreePanel = new JPanel(this._queryTreePanelLayout);
            for (int i = 0; i < n; ++i) {
                PlanElement[] planElementArray = this._plan.getQueryAt(i).getElements();
                if (planElementArray == null) {
                    SybOptionPane.showMessageDialog((Component)this, (Object)AccessPlanViewer.getI18NMessage("error.invalid_plan.message"), (String)AccessPlanViewer.getI18NMessage("error"), (int)0);
                    return false;
                }
                PlanElementView[] planElementViewArray = new PlanElementView[planElementArray.length];
                for (int j = 0; j < planElementArray.length; ++j) {
                    planElementViewArray[j] = new BasicPlanElementView(planElementArray[j]);
                }
                this._query_trees[i] = new TreeGraph(planElementViewArray, 4, 1, 20, this._plan.getQueryAt(i).getName(), this);
                this._query_trees[i].addPlanSelectionListener(this);
                this._query_trees[i].addFocusListener(this);
                this._query_trees[i].getAccessibleContext().setAccessibleName(AccessPlanViewer.getI18NMessage("accessible_name.tree"));
                JScrollPane jScrollPane = new JScrollPane(this._query_trees[i]);
                jScrollPane.setViewportBorder(this._emptyBorder);
                this._queryTreePanel.add(this._plan.getQueryAt(i).getName(), jScrollPane);
                this._queryComboBox.addItem(this._plan.getQueryAt(i).getName());
            }
            if (this._main_split != null) {
                JPanel jPanel = new JPanel(new GridBagLayout());
                GridBagConstraints gridBagConstraints = new GridBagConstraints();
                gridBagConstraints.gridy = 0;
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridwidth = 0;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.insets = new Insets(5, 5, 5, 5);
                jPanel.add((Component)this._queryComboBox, gridBagConstraints);
                gridBagConstraints.gridy = 1;
                gridBagConstraints.fill = 1;
                gridBagConstraints.gridheight = 0;
                gridBagConstraints.weighty = 1.0;
                gridBagConstraints.insets = new Insets(0, 0, 0, 0);
                jPanel.add((Component)this._queryTreePanel, gridBagConstraints);
                this._main_split.setLeftComponent(jPanel);
                this._main_split.resetToPreferredSizes();
                try {
                    Query query = this._plan.getQueryAt(0);
                    this.setCurrentOperator(query.getElements()[0]);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    SybOptionPane.showMessageDialog((Component)this, (Object)AccessPlanViewer.getI18NMessage("error.invalid_plan.message"), (String)AccessPlanViewer.getI18NMessage("error"), (int)0);
                    bl = false;
                }
            }
        } else {
            this._main_split.setLeftComponent(new JPanel());
            this._main_split.resetToPreferredSizes();
            for (int i = 0; i < 2; ++i) {
                this._info_scroll[i].setViewportView(this._info_text[i]);
                this._info_text[i].setText(AccessPlanViewer.getI18NMessage("error.no_plan"));
            }
            bl = false;
        }
        return bl;
    }

    public boolean setPlan(Reader reader) {
        this._currentURI = null;
        this._currentReader = reader;
        boolean bl = this.setupQueryTrees(null);
        return bl;
    }

    public boolean setPlanWithSubqueries(Reader reader, List<Query> list) {
        this._currentURI = null;
        this._currentReader = reader;
        boolean bl = this.setupQueryTrees(list);
        return bl;
    }

    private void setCurrentOperator(PlanElement planElement) {
        Object object;
        Object object2;
        int n;
        Object object3;
        String[] stringArray = new String[2];
        if (planElement == null) {
            throw new NullPointerException("op is null.");
        }
        if (this._currentOperator == planElement) {
            return;
        }
        this._currentOperator = planElement;
        String string = Integer.toHexString(SystemColor.windowText.getRGB() | 0x10000000).substring(2);
        if (this._fontname == null || this._fontsize == 0) {
            object3 = new SybButton();
            this._fontname = object3.getFont().getName();
            this._fontsize = object3.getFont().getSize();
        }
        for (n = 0; n < 2; ++n) {
            int n2 = 0;
            object2 = n == MAIN_DETAILS ? planElement.getDetailsValue() : planElement.getAdvancedDetailsValue();
            if (object2 != null && ((String)object2).length() > 0) {
                object = new StringBuffer((String)object2);
                n2 = ((String)object2).indexOf(" color=\"#000000\"", n2);
                while (n2 != -1) {
                    ((StringBuffer)object).replace(n2 + 9, n2 + 15, string);
                    n2 += 16;
                    n2 = ((String)object2).indexOf(" color=\"#000000\"", n2);
                }
                stringArray[n] = "<HTML><body><font face=\"" + this._fontname + "\" size=\"" + this._fontsize + "pt\">" + ((StringBuffer)object).toString() + "</font></body></HTML>";
                continue;
            }
            stringArray[n] = "";
        }
        try {
            System.gc();
            for (n = 0; n < 2; ++n) {
                this._info_text[n].setText(stringArray[n]);
                object3 = this._info_text[n].getDocument();
                if (!(object3 instanceof HTMLDocument) || (object = ((HTMLDocument)(object2 = (HTMLDocument)object3)).getStyleSheet()) == null) continue;
                ((StyleSheet)object).addRule("body { font : dialog; }");
            }
        }
        catch (Exception exception) {
            object2 = new StringBuffer(1024);
            ((StringBuffer)object2).append(stringArray[n]);
            ((StringBuffer)object2).append("\n");
            ((StringBuffer)object2).append(exception.getLocalizedMessage());
            ((StringBuffer)object2).append("\n");
            object = new StringWriter();
            PrintWriter printWriter = new PrintWriter((Writer)object);
            exception.printStackTrace(printWriter);
            printWriter.flush();
            ((StringBuffer)object2).append(((StringWriter)object).getBuffer().toString());
            Frame frame = this.getFrameWindow();
            if (frame != null) {
                DetailsErrorDialog.showDetailsErrorDialog((Frame)frame, (String)"Internal Error", (String)"Error! The plan could not be shown.\nPlease report the details to Sybase technical support", (String)((StringBuffer)object2).toString(), null);
            } else {
                System.err.println("Internal Error!\nThe plan could not be shown.\nPlease report the details to Sybase technical support\n" + ((StringBuffer)object2).toString());
            }
            this._info_text[MAIN_DETAILS].setText("");
        }
        for (n = 0; n < 2; ++n) {
            this._info_scroll[n].setViewportView(this._info_text[n]);
            this._info_text[n].setCaretPosition(0);
            object3 = this._info_scroll[n].getHorizontalScrollBar();
            object2 = this._info_scroll[n].getVerticalScrollBar();
            if (object3 != null) {
                ((JScrollBar)object3).setValue(((JScrollBar)object3).getMinimum());
            }
            if (object2 == null) continue;
            ((JScrollBar)object2).setValue(((JScrollBar)object2).getMinimum());
        }
        this._info_tabs.removeAll();
        this._info_tabs.add(AccessPlanViewer.getI18NMessage("accessible_name.details"), this._info_scroll[MAIN_DETAILS]);
        if (planElement.getAdvancedDetailsValue() != null) {
            this._info_tabs.add(AccessPlanViewer.getI18NMessage("accessible_name.advanceddetails"), this._info_scroll[ADVANCED_DETAILS]);
        }
        this._info_tabs.setSelectedIndex(MAIN_DETAILS);
        PlanViewHelpManager.INSTANCE.changeCurrentNode(planElement);
        System.gc();
    }

    static String getI18NMessage(String string) {
        ResourceBundle resourceBundle = null;
        try {
            resourceBundle = ResourceBundle.getBundle("com.sybase.asa.planview.PlanViewResourceBundle");
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        if (resourceBundle != null) {
            try {
                return resourceBundle.getString(string);
            }
            catch (MissingResourceException missingResourceException) {
                return string;
            }
        }
        return string;
    }

    public void print() {
        int n;
        if (this._main_split != null && this._queryComboBox != null && this._queryTreePanel != null && (n = this._queryComboBox.getSelectedIndex()) != -1 && this._queryTreePanel.getComponentCount() > n) {
            JScrollPane jScrollPane = (JScrollPane)this._queryTreePanel.getComponent(n);
            TreeGraph treeGraph = (TreeGraph)jScrollPane.getViewport().getComponent(0);
            treeGraph.printTree();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        JScrollPane jScrollPane = (JScrollPane)this._info_tabs.getSelectedComponent();
        JScrollBar jScrollBar = jScrollPane.getVerticalScrollBar();
        switch (keyEvent.getKeyCode()) {
            case 38: {
                jScrollBar.setValue(jScrollBar.getValue() - jScrollBar.getUnitIncrement(-1));
                keyEvent.consume();
                break;
            }
            case 40: {
                jScrollBar.setValue(jScrollBar.getValue() + jScrollBar.getUnitIncrement(1));
                keyEvent.consume();
                break;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void elementSelected(PlanSelectionEvent planSelectionEvent) {
        this.setCurrentOperator(planSelectionEvent.getSelectedElement());
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        if (focusEvent.getComponent() == this._info_text[MAIN_DETAILS]) {
            this._info_text[MAIN_DETAILS].setBorder(this._focussedBorder);
            this._info_text[MAIN_DETAILS].repaint();
        } else if (focusEvent.getComponent() == this._info_text[ADVANCED_DETAILS]) {
            this._info_text[ADVANCED_DETAILS].setBorder(this._focussedBorder);
            this._info_text[ADVANCED_DETAILS].repaint();
        } else if (component instanceof TreeGraph) {
            JScrollPane jScrollPane = (JScrollPane)component.getParent().getParent();
            jScrollPane.setViewportBorder(this._focussedBorder);
            jScrollPane.repaint();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        Component component = focusEvent.getComponent();
        if (component == this._info_text[MAIN_DETAILS]) {
            this._info_text[MAIN_DETAILS].setBorder(this._emptyBorder);
            this._info_text[MAIN_DETAILS].repaint();
        } else if (component == this._info_text[ADVANCED_DETAILS]) {
            this._info_text[ADVANCED_DETAILS].setBorder(this._emptyBorder);
            this._info_text[ADVANCED_DETAILS].repaint();
        } else if (component instanceof TreeGraph && component != null && component.getParent() != null) {
            JScrollPane jScrollPane = (JScrollPane)component.getParent().getParent();
            jScrollPane.setViewportBorder(this._emptyBorder);
            jScrollPane.repaint();
        }
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1 && itemEvent.getItem() != null) {
            this._queryTreePanelLayout.show(this._queryTreePanel, (String)this._queryComboBox.getSelectedItem());
            int n = this._queryComboBox.getSelectedIndex();
            if (n != -1 && this._queryTreePanel.getComponentCount() > n) {
                JScrollPane jScrollPane = (JScrollPane)this._queryTreePanel.getComponent(n);
                TreeGraph treeGraph = (TreeGraph)jScrollPane.getViewport().getComponent(0);
                treeGraph.reset();
            }
        }
    }

    public void destroy() {
        int n;
        this._info_tabs.removeComponentListener(this._rl);
        this._rl = null;
        DialogUtils.removeComponents((Container)this);
        this._currentURI = null;
        this._currentReader = null;
        if (this._queryComboBox != null) {
            this._queryComboBox.removeItemListener(this);
            this._queryComboBox = null;
        }
        this._queryTreePanelLayout = null;
        this._queryTreePanel = null;
        if (this._query_trees != null) {
            for (n = 0; n < this._query_trees.length; ++n) {
                this._query_trees[n].removeFocusListener(this);
                this._query_trees[n].removePlanSelectionListener(this);
                this._query_trees[n].destroy();
                this._query_trees[n] = null;
            }
            this._query_trees = null;
        }
        this.destroyInfoText();
        for (n = 0; n < 2; ++n) {
            this._info_scroll[n] = null;
        }
        this._main_split.removeAll();
        this._main_split.destroy();
        this._main_split = null;
        this._currentOperator = null;
        this._plan = null;
    }

    private static final class ResizeListener
    extends ComponentAdapter {
        private final JSplitPane _parent;

        public ResizeListener(JSplitPane jSplitPane) {
            this._parent = jSplitPane;
        }

        @Override
        public void componentMoved(ComponentEvent componentEvent) {
            splitterLocation = this._parent.getDividerLocation();
        }
    }

    private static final class MyJSplitPane
    extends SybSplitPane {
        MyJSplitPane(int n, Component component, Component component2) {
            super(n, component, component2);
        }

        @Override
        public void resetToPreferredSizes() {
            this.setDividerLocation(splitterLocation);
        }
    }
}

