/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.planview;

import com.sybase.asa.planview.PlanElement;
import com.sybase.asa.planview.PlanElementView;
import com.sybase.asa.planview.PlanViewProperties;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;

final class BasicPlanElementView
extends PlanElementView {
    private static final int BORDER = 5;
    private static final int LINE_SPACE = 3;
    private static final int FONTSIZE = 12;
    private String _name;

    BasicPlanElementView(PlanElement planElement) {
        super(planElement);
        this._name = null;
    }

    BasicPlanElementView(PlanElement planElement, String string) {
        super(planElement);
        this._name = string;
    }

    @Override
    public void refreshText() {
        if (PlanViewProperties.getShowLongNames()) {
            this.setText(this._name == null ? this._element.getName() : this._name);
        } else {
            this._element.truncateShortName();
            this.setText(this._name == null ? this._element.getShortName() : this._name);
        }
        Dimension dimension = this.getPreferredSize();
        this.setSize((int)dimension.getWidth(), (int)dimension.getHeight());
    }

    @Override
    public void setToolTipFont(String string) {
        int n = 0;
        int n2 = 0;
        String string2 = this._element.getTooltip();
        if (string2 != null && string2.length() > 0) {
            StringBuffer stringBuffer = new StringBuffer(string2);
            n = string2.indexOf(" color=\"#000000\"", n);
            while (n != -1) {
                stringBuffer.replace(n + n2, n + n2 + 16, "");
                n += 16;
                n2 -= 16;
                n = string2.indexOf(" color=\"#000000\"", n);
            }
            this.setToolTipText("<html><body><font face=\"" + string + "\" size=-1>" + stringBuffer.toString() + "</font><body></html>");
        }
    }

    @Override
    public Dimension getPreferredSize() {
        FontMetrics fontMetrics = this.getFontMetrics(new Font(null, 0, 12));
        int n = fontMetrics.stringWidth(this.getText()) + 20;
        int n2 = fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent() + 6;
        if (this.getKeyPerformance() != null && this.getKeyPerformance().length() > 0) {
            n2 *= 2;
            int n3 = fontMetrics.stringWidth(this.getKeyPerformance()) + 20;
            n = n > n3 ? n : n3;
        }
        return new Dimension(n, n2);
    }

    @Override
    public void paint(Graphics graphics) {
        Color color;
        Color color2;
        Color color3;
        this.setOpaque(false);
        Graphics2D graphics2D = (Graphics2D)graphics;
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this._isPrinting) {
            color3 = Color.white;
            color2 = Color.black;
            color = Color.black;
        } else {
            if (this.isSelected()) {
                color3 = PlanViewProperties.getSelectedBgColor();
                color = PlanViewProperties.getSelectedTextColor();
            } else {
                color3 = PlanViewProperties.getBgColor();
                color = PlanViewProperties.getTextColor();
            }
            color2 = this.getBorderColor();
        }
        int n = this._element.getPhysicalType().indexOf("Index") >= 0 ? PlanViewProperties.getIndScanShape() : (this._element.getLogicalType().equals("Scan") ? PlanViewProperties.getScanShape() : (this._element.isMaterialized() ? PlanViewProperties.getMaterializedShape() : PlanViewProperties.getDefaultShape()));
        this.paintNode(graphics, color3, color2, n, 4, 5);
        graphics.setColor(color);
        graphics.setFont(new Font(null, 0, 12));
        if (this.getText() != null) {
            graphics.drawString(this.getText(), 10, 3 + graphics.getFontMetrics().getMaxAscent());
        }
        if (this.getKeyPerformance() != null && this.getKeyPerformance().length() > 0) {
            graphics.drawString(this.getKeyPerformance(), 10, (3 + graphics.getFontMetrics().getMaxAscent()) * 2 + 1);
        }
    }
}

