/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.planview;

import com.sybase.asa.planview.AccessPlanViewer;
import com.sybase.util.SybLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

final class ColorChoiceComboBox
extends JComboBox
implements ActionListener {
    private boolean _ignoreColorChange;

    ColorChoiceComboBox() {
        this.addActionListener(this);
        String string = AccessPlanViewer.getI18NMessage("customize.color_choice_combobox.custom");
        this.setRenderer(new ColorChoiceRenderer());
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.stringWidth(string) + n + 2 + new SybLabel().getIconTextGap();
        this.addItem(new ColorFillIcon(Color.black, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.blue, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.cyan, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.darkGray, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.gray, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.green, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.lightGray, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.magenta, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.orange, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.pink, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.red, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.white, n2, n, 1));
        this.addItem(new ColorFillIcon(Color.yellow, n2, n, 1));
        this.addItem(new SybLabel(string, (Icon)new ColorFillIcon(Color.white, n, n, 1), 2));
    }

    Color getColor() {
        Object object = this.getSelectedItem();
        if (object instanceof JLabel) {
            JLabel jLabel = (JLabel)object;
            return ((ColorFillIcon)jLabel.getIcon()).getFillColor();
        }
        if (object instanceof ColorFillIcon) {
            return ((ColorFillIcon)object).getFillColor();
        }
        return null;
    }

    void setColor(Color color) {
        this._ignoreColorChange = true;
        if (color.equals(Color.black)) {
            this.setSelectedIndex(0);
        } else if (color.equals(Color.blue)) {
            this.setSelectedIndex(1);
        } else if (color.equals(Color.cyan)) {
            this.setSelectedIndex(2);
        } else if (color.equals(Color.darkGray)) {
            this.setSelectedIndex(3);
        } else if (color.equals(Color.gray)) {
            this.setSelectedIndex(4);
        } else if (color.equals(Color.green)) {
            this.setSelectedIndex(5);
        } else if (color.equals(Color.lightGray)) {
            this.setSelectedIndex(6);
        } else if (color.equals(Color.magenta)) {
            this.setSelectedIndex(7);
        } else if (color.equals(Color.orange)) {
            this.setSelectedIndex(8);
        } else if (color.equals(Color.pink)) {
            this.setSelectedIndex(9);
        } else if (color.equals(Color.red)) {
            this.setSelectedIndex(10);
        } else if (color.equals(Color.white)) {
            this.setSelectedIndex(11);
        } else if (color.equals(Color.yellow)) {
            this.setSelectedIndex(12);
        } else {
            this.setSelectedIndex(13);
            Object object = this.getSelectedItem();
            if (object instanceof JLabel) {
                JLabel jLabel = (JLabel)object;
                ((ColorFillIcon)jLabel.getIcon()).setFillColor(color);
                this.fireItemStateChanged(new ItemEvent(this, 701, this.selectedItemReminder, 1));
            }
        }
        this._ignoreColorChange = false;
    }

    void setCustomColor(Color color) {
        Object e = this.getItemAt(13);
        if (e instanceof JLabel) {
            JLabel jLabel = (JLabel)e;
            ((ColorFillIcon)jLabel.getIcon()).setFillColor(color);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (!this._ignoreColorChange) {
            Object object = this.getSelectedItem();
            if (object instanceof JLabel) {
                JLabel jLabel = (JLabel)object;
                Color color = JColorChooser.showDialog(this, null, ((ColorFillIcon)jLabel.getIcon()).getFillColor());
                if (color != null) {
                    ((ColorFillIcon)jLabel.getIcon()).setFillColor(color);
                }
                this.selectedItemChanged();
            }
        } else {
            this._ignoreColorChange = false;
        }
    }

    static final class ColorChoiceRenderer
    extends SybLabel
    implements ListCellRenderer {
        ColorChoiceRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == null) {
                this.setText("");
                this.setIcon(null);
            } else if (bl) {
                this.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
                this.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                if (object instanceof ColorFillIcon) {
                    this.setIcon((ColorFillIcon)object);
                    this.setText("");
                } else if (object instanceof JLabel) {
                    JLabel jLabel = (JLabel)object;
                    this.setIcon(jLabel.getIcon());
                    this.setText(jLabel.getText());
                }
            } else {
                if (object instanceof ColorFillIcon) {
                    this.setIcon((ColorFillIcon)object);
                    this.setText("");
                } else if (object instanceof JLabel) {
                    JLabel jLabel = (JLabel)object;
                    this.setIcon(jLabel.getIcon());
                    this.setText(jLabel.getText());
                }
                this.setBackground(UIManager.getColor("ComboBox.background"));
                this.setForeground(UIManager.getColor("ComboBox.foreground"));
            }
            return this;
        }
    }

    static final class ColorFillIcon
    implements Icon {
        protected int _width;
        protected int _height;
        protected Color _fillColor;
        protected Color _shadow;
        protected int _borderSize;
        protected int _fillHeight;
        protected int _fillWidth;
        public static final int BORDER_SIZE = 2;
        public static final int DEFAULT_SIZE = 32;

        ColorFillIcon(Color color, int n, int n2, int n3) {
            this._fillColor = color;
            this._borderSize = n3;
            this._width = n;
            this._height = n2;
            this._shadow = Color.black;
            this._fillWidth = n - 2 * n3;
            this._fillHeight = n2 - 2 * n3;
        }

        ColorFillIcon(Color color, int n) {
            this(color, n, n, 2);
        }

        ColorFillIcon(Color color) {
            this(color, 32, 32, 2);
        }

        void setShadow(Color color) {
            this._shadow = color;
        }

        void setFillColor(Color color) {
            this._fillColor = color;
        }

        Color getFillColor() {
            return this._fillColor;
        }

        @Override
        public int getIconWidth() {
            return this._width;
        }

        @Override
        public int getIconHeight() {
            return this._height;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = graphics.getColor();
            if (this._borderSize > 0) {
                graphics.setColor(this._shadow);
                for (int i = 0; i < this._borderSize; ++i) {
                    graphics.drawRect(n + i, n2 + i, this._width - 2 * i - 1, this._height - 2 * i - 1);
                }
            }
            graphics.setColor(this._fillColor);
            graphics.fillRect(n + this._borderSize, n2 + this._borderSize, this._fillWidth, this._fillHeight);
            graphics.setColor(color);
        }
    }
}

