/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.planview;

import com.sybase.asa.planview.PlanElement;
import com.sybase.asa.planview.PlanElementView;
import com.sybase.asa.planview.PlanViewProperties;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.SystemColor;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;

final class DetailPlanElementView
extends PlanElementView {
    private static final int BORDER = 10;
    private String _detail;
    private ColorManager _color_manager = null;

    DetailPlanElementView(PlanElement planElement) {
        super(planElement);
    }

    private ColorManager getColorManager() {
        if (this._color_manager == null) {
            this._color_manager = new ColorManager();
        }
        return this._color_manager;
    }

    @Override
    public void refreshText() {
        Color color;
        if (this._detail == null) {
            return;
        }
        ColorManager colorManager = this.getColorManager();
        if (this._isPrinting) {
            color = Color.black;
            colorManager.setSelected(false);
        } else {
            color = this.isSelected() ? PlanViewProperties.getSelectedTextColor() : PlanViewProperties.getTextColor();
            colorManager.setSelected(this.isSelected());
        }
        if (colorManager.hasChanged(color)) {
            this.setText(colorManager.replaceColor(this._detail, color));
        }
        Dimension dimension = this.getPreferredSize();
        this.setSize((int)(dimension.getWidth() + 20.0), (int)dimension.getHeight());
    }

    @Override
    public void setToolTipFont(String string) {
        String string2 = this._element.getTooltip();
        this._detail = string2 != null && string2.length() > 0 ? "<html><font face=\"" + string + "\" size=-1>" + this._element.getTooltip() + "</font></html>" : "";
        this.refreshText();
    }

    @Override
    public void paint(Graphics graphics) {
        Color color;
        Color color2;
        if (this._isPrinting) {
            color2 = Color.white;
            color = Color.black;
        } else {
            color2 = this.isSelected() ? PlanViewProperties.getSelectedBgColor() : PlanViewProperties.getBgColor();
            color = this.getBorderColor();
        }
        int n = this._element.getPhysicalType().indexOf("Index") >= 0 ? PlanViewProperties.getIndScanShape() : (this._element.getLogicalType().equals("Scan") ? PlanViewProperties.getScanShape() : (this._element.isMaterialized() ? PlanViewProperties.getMaterializedShape() : PlanViewProperties.getDefaultShape()));
        if (!this._isPrinting) {
            graphics.setColor(SystemColor.window);
            graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        try {
            if (this._isPrinting && Class.forName("com.sun.java.swing.plaf.windows.WindowsLookAndFeel").isInstance(lookAndFeel)) {
                UIManager.setLookAndFeel("com.sun.java.swing.plaf.motif.MotifLookAndFeel");
                this.updateUI();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.paintNode(graphics, color2, color, n, 16, 10);
        this.refreshText();
        this.setOpaque(false);
        this.paintComponent(graphics);
        if (this._isPrinting) {
            try {
                UIManager.setLookAndFeel(lookAndFeel);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private static class ColorManager {
        private static String _str;
        private static String _sel_str;
        private static Color _clr;
        private static Color _sel_clr;
        private boolean _selected = false;
        private Color _current_clr = null;

        public void setSelected(boolean bl) {
            this._selected = bl;
        }

        public boolean hasChanged(Color color) {
            return this._current_clr == null || !this._current_clr.equals(color);
        }

        public String replaceColor(String string, Color color) {
            String string2 = this.getColorString(color);
            this._current_clr = color;
            int n = 0;
            StringBuffer stringBuffer = new StringBuffer(string);
            n = string.indexOf(" color=\"#000000\"", n);
            while (n != -1) {
                stringBuffer.replace(n + 9, n + 15, string2);
                n += 16;
                n = string.indexOf(" color=\"#000000\"", n);
            }
            return stringBuffer.toString();
        }

        private String getColorString(Color color) {
            if (this._selected) {
                if (_sel_clr == null || !color.equals(_sel_clr)) {
                    this.calculateSelectedColor(color);
                }
                return _sel_str;
            }
            if (_clr == null || !color.equals(_clr)) {
                this.calculateColor(color);
            }
            return _str;
        }

        private void calculateColor(Color color) {
            _clr = color;
            _str = Integer.toHexString(_clr.getRGB() | 0x10000000).substring(2);
        }

        private void calculateSelectedColor(Color color) {
            _sel_clr = color;
            _sel_str = Integer.toHexString(_sel_clr.getRGB() | 0x10000000).substring(2);
        }

        static {
            _clr = null;
            _sel_clr = null;
        }
    }
}

