/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.planview;

import com.sybase.asa.planview.AccessPlanViewer;
import com.sybase.asa.planview.PlanElementView;
import com.sybase.asa.planview.TreeGraph;
import com.sybase.util.SybMessageFormat;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.print.PageFormat;
import java.util.Date;
import java.util.Vector;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import javax.swing.text.html.HTMLEditorKit;

final class DocumentedTreeGraph
extends TreeGraph {
    private Vector<PageView> _pageComponents = new Vector();
    private static double SCALE = 0.5;

    public DocumentedTreeGraph(PlanElementView[] planElementViewArray, int n, int n2, int n3, String string, AccessPlanViewer accessPlanViewer) {
        super(planElementViewArray, n, n2, n3, string, accessPlanViewer);
    }

    @Override
    protected int endPrintout(Graphics2D graphics2D, PageFormat pageFormat, int n) {
        int n2 = n - this._pages[0] * this._pages[1];
        if (n2 < this._pageComponents.size()) {
            graphics2D.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            graphics2D.setClip(0, 0, (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
            this._pageComponents.elementAt(n2).print(graphics2D);
            graphics2D.translate(-pageFormat.getImageableX(), -pageFormat.getImageableY());
            graphics2D.setClip(0, 0, (int)pageFormat.getWidth(), (int)pageFormat.getHeight());
            this.nonTreeFooter(graphics2D, pageFormat, n);
            return 0;
        }
        return 1;
    }

    @Override
    protected void preparePrintout(Graphics2D graphics2D, PageFormat pageFormat, int n) {
        StringBuffer stringBuffer = new StringBuffer("<html><body>");
        for (int i = 0; i < this._views.length; ++i) {
            stringBuffer.append("<br><strong><font size=+2>").append(i + 1 + ". ").append("</font></strong>");
            stringBuffer.append(this._views[i].getElement().getDetailsValue());
        }
        stringBuffer.append("</body></html>");
        JTextPane jTextPane = new JTextPane();
        jTextPane.setEditorKit(new HTMLEditorKit());
        jTextPane.setText(stringBuffer.toString());
        int n2 = (int)(pageFormat.getImageableWidth() / SCALE);
        int n3 = (int)(pageFormat.getImageableHeight() / SCALE);
        jTextPane.setSize(n2, n3);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        Rectangle rectangle = new Rectangle(0, 0, n2, n3);
        Shape shape = null;
        Position.Bias[] biasArray = new Position.Bias[2];
        while ((n6 = jTextPane.getUI().getRootView(jTextPane).viewToModel(0.0f, n4 + n3, rectangle, biasArray)) < jTextPane.getDocument().getEndPosition().getOffset() - 1) {
            try {
                shape = jTextPane.getUI().getRootView(jTextPane).modelToView(n6, rectangle, Position.Bias.Backward);
            }
            catch (BadLocationException badLocationException) {
                throw new RuntimeException("Could not parse detail HTML.");
            }
            n5 = (int)shape.getBounds().getY() + jTextPane.getFontMetrics(jTextPane.getFont()).getMaxDescent();
            rectangle = new Rectangle(0, 0, n2, n5 + n3);
            jTextPane.setSize(n2, n5 + n3);
            this._pageComponents.addElement(new PageView(jTextPane, n4, n5));
            n4 = n5;
        }
        this._pageComponents.addElement(new PageView(jTextPane, n4, n4 + n3));
    }

    private void nonTreeFooter(Graphics2D graphics2D, PageFormat pageFormat, int n) {
        Date date = new Date(System.currentTimeMillis());
        Object[] objectArray = new Object[]{date, this.getName()};
        String string = SybMessageFormat.format((String)AccessPlanViewer.getI18NMessage("printable.header"), (Object[])objectArray);
        graphics2D.setFont(graphics2D.getFont().deriveFont(0, 8.0f));
        int n2 = graphics2D.getFontMetrics().stringWidth(string);
        graphics2D.drawString(string, (int)(pageFormat.getImageableX() + (pageFormat.getImageableWidth() - (double)n2) / 2.0), (int)((double)graphics2D.getFontMetrics().getMaxAscent() + pageFormat.getImageableY() + pageFormat.getImageableHeight()));
        String string2 = 1 + n - this._pages[0] * this._pages[1] + "";
        n2 = graphics2D.getFontMetrics().stringWidth(string2);
        graphics2D.drawString(string2, (int)(pageFormat.getImageableX() + (pageFormat.getImageableWidth() - (double)n2) / 2.0), (int)((double)(graphics2D.getFontMetrics().getMaxAscent() + 8) + pageFormat.getImageableY() + pageFormat.getImageableHeight()));
    }

    private static class PageView {
        private JTextComponent _doc_view;
        private int _top;
        private int _bottom;

        public PageView(JTextComponent jTextComponent, int n, int n2) {
            this._doc_view = jTextComponent;
            this._top = (int)((double)n * SCALE);
            this._bottom = (int)((double)n2 * SCALE);
        }

        public void print(Graphics2D graphics2D) {
            Rectangle rectangle = new Rectangle(0, 0, this._doc_view.getWidth(), this._bottom - this._top);
            graphics2D.setClip(rectangle);
            AffineTransform affineTransform = new AffineTransform(SCALE, 0.0, 0.0, SCALE, 0.0, (double)(-this._top));
            graphics2D.transform(affineTransform);
            this._doc_view.getUI().paint(graphics2D, this._doc_view);
            try {
                graphics2D.transform(affineTransform.createInverse());
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new RuntimeException("Failed to invert transformation matrix");
            }
        }
    }
}

