/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.planview;

import com.sybase.asa.planview.PlanViewProperties;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.Attributes;

final class PlanElement {
    public static final int NOPARENT = -1;
    private PlanElement _parentElement;
    private Vector<PlanElement> _children;
    private int _parent;
    private int _firstChild;
    private int _lastChild;
    private String _log_type;
    private String _phys_type;
    private String _name;
    private String _long_name;
    private String _short_name;
    private String _value;
    private String _advanced_value;
    private String _tooltip;
    private boolean _is_materialized;
    private float _percent_cost;
    private long _num_rows;
    private double _runtime;
    private Vector<String> _subQueries;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PlanElement(Attributes attributes) {
        this._log_type = attributes.getValue("", "ltype");
        this._phys_type = attributes.getValue("", "ptype");
        this._long_name = attributes.getValue("", "lname");
        this._name = attributes.getValue("", "name");
        this._short_name = attributes.getValue("", "sname");
        String string = attributes.getValue("", "materialized");
        if (string != null) {
            if (string.equals("true")) {
                this._is_materialized = true;
            } else {
                if (!string.equals("false")) throw new RuntimeException("Invalid value for \"materialized\" attribute of \"operator\" tag.");
                this._is_materialized = false;
            }
        } else {
            this._is_materialized = false;
        }
        string = attributes.getValue("", "percentCost");
        this._percent_cost = string != null ? Float.parseFloat(string) : -1.0f;
        string = attributes.getValue("", "rowCount");
        this._num_rows = string != null ? Long.parseLong(string) : -1L;
        string = attributes.getValue("", "runtime");
        this._runtime = string != null ? Double.parseDouble(string) : -1.0;
        this._subQueries = new Vector();
        string = attributes.getValue("", "subQueries");
        if (string != null && string.length() > 0) {
            this.readSubqueries(string);
        }
        this.truncateShortName();
        this._value = null;
        this._advanced_value = null;
        this._tooltip = null;
        this._children = !this._log_type.equals("Scan") ? new Vector() : null;
        this._parent = -1;
    }

    private void readSubqueries(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";", false);
        while (stringTokenizer.hasMoreTokens()) {
            this._subQueries.addElement(stringTokenizer.nextToken());
        }
    }

    public boolean hasSubQueries() {
        return this._subQueries.size() > 0;
    }

    public Vector getSubQueries() {
        return this._subQueries;
    }

    public float getPercentCost() {
        return this._percent_cost;
    }

    public long getRowCount() {
        return this._num_rows;
    }

    public double getRuntime() {
        return this._runtime;
    }

    void truncateShortName() {
        if (this._log_type.equals("Scan")) {
            int n = PlanViewProperties.getTruncatedLength();
            this._short_name = this._short_name == null ? "" : (this._short_name.length() <= n + 2 ? this._short_name : this._short_name.substring(0, n) + "...");
        }
    }

    public boolean isMaterialized() {
        return this._is_materialized;
    }

    public int getChildCount() {
        return this._lastChild - this._firstChild + 1;
    }

    public int childAt(int n) {
        return this._firstChild + n;
    }

    public int firstChild() {
        return this._firstChild;
    }

    public int lastChild() {
        return this._lastChild;
    }

    public boolean isLeaf() {
        return this._lastChild < this._firstChild;
    }

    public int parent() {
        return this._parent;
    }

    public void makeChildOf(PlanElement planElement) {
        this._parentElement = planElement;
        planElement._children.add(this);
    }

    public PlanElement getParent() {
        return this._parentElement;
    }

    public int levelTree(int n, int n2, PlanElement[] planElementArray) {
        this._firstChild = n2;
        this._lastChild = this._firstChild - 1;
        if (this._children != null) {
            Enumeration<PlanElement> enumeration = this._children.elements();
            while (enumeration.hasMoreElements()) {
                ++this._lastChild;
                planElementArray[this._lastChild] = enumeration.nextElement();
                planElementArray[this._lastChild]._parent = n;
            }
            this._children = null;
        }
        return this._lastChild + 1;
    }

    public String getLogicalType() {
        return this._log_type;
    }

    public String getPhysicalType() {
        return this._phys_type;
    }

    public String getShortName() {
        return this._short_name;
    }

    public String getLongName() {
        return this._long_name;
    }

    public String getName() {
        return this._name;
    }

    public String getDetailsValue() {
        return this._value;
    }

    public void setDetailsValue(String string) {
        this._value = string;
    }

    public String getAdvancedDetailsValue() {
        return this._advanced_value;
    }

    public void setAdvancedDetailsValue(String string) {
        this._advanced_value = string;
    }

    public String getTooltip() {
        return this._tooltip;
    }

    public void setTooltip(String string) {
        this._tooltip = string;
    }

    public String toString() {
        return this._name;
    }
}

