/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.planview;

import com.sybase.asa.planview.AccessPlanViewer;
import com.sybase.asa.planview.PlanElement;
import com.sybase.asa.planview.PlanViewHelpManager;
import com.sybase.asa.planview.PlanViewProperties;
import com.sybase.asa.planview.TreeGeometry;
import com.sybase.asa.planview.TreeGraph;
import com.sybase.util.SybMenuItem;
import com.sybase.util.SybMessageFormat;
import com.sybase.util.SybOptionPane;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToggleButton;
import javax.swing.text.TextAction;

abstract class PlanElementView
extends JToggleButton
implements MouseListener {
    private TreeGeometry _geometry;
    protected PlanElement _element;
    protected TreeGraph _parentTree;
    protected boolean _isPrinting;
    private int _borderColor;
    private float _lineThickness;
    private String _keyPerformance;
    private static final int NUM_COLORS = 10;
    private static Color[] BorderColors = new Color[]{null, null, null, null, null, null, null, null, null, null};
    private static final Stroke DEFAULT_STROKE = new BasicStroke();
    private static final int THIN = 1;
    private static final int THICK = 2;
    private static final int THIN_INSET = 1;
    private static final int THICK_INSET = 1;
    private static final Stroke THIN_STROKE = new BasicStroke(1.0f);
    private static final Stroke THICK_STROKE = new BasicStroke(2.0f);
    private JPopupMenu _popup;
    private static final int MAX_MENU_SUBQUERIES = 10;
    private SybMenuItem _popupHelpItem;

    PlanElementView(PlanElement planElement) {
        int n;
        this._element = planElement;
        this._isPrinting = false;
        this._borderColor = 0;
        this._lineThickness = 1.0f;
        this._keyPerformance = "";
        if (planElement == null) {
            throw new NullPointerException("element is null");
        }
        this._popup = new JPopupMenu();
        SybMenuItem sybMenuItem = new SybMenuItem(AccessPlanViewer.getI18NMessage("popup.customize"));
        sybMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanElementView.this.customizeActionPerformed();
            }
        });
        this._popup.add((JMenuItem)sybMenuItem);
        sybMenuItem = new SybMenuItem(AccessPlanViewer.getI18NMessage("popup.print"));
        sybMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanElementView.this._parentTree.printTree();
            }
        });
        this._popup.add((JMenuItem)sybMenuItem);
        Enumeration enumeration = this._element.getSubQueries().elements();
        if (enumeration.hasMoreElements()) {
            this._popup.addSeparator();
        }
        for (n = 0; enumeration.hasMoreElements() && n < 10; ++n) {
            this._popup.add(new TextAction((String)enumeration.nextElement()){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PlanElementView.this.subQuerySelectedActionPerformed((String)this.getValue("Name"));
                }
            });
        }
        if (n == 10 && enumeration.hasMoreElements()) {
            this._popup.add(new TextAction(AccessPlanViewer.getI18NMessage("popup.more_subqueries")){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    PlanElementView.this.moreSubQueriesActionPerformed();
                }
            });
        }
        this._popup.addSeparator();
        this._popupHelpItem = new SybMenuItem(AccessPlanViewer.getI18NMessage("popup.help"));
        this._popupHelpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PlanElementView.this.showHelp();
            }
        });
        this._popup.add((JMenuItem)this._popupHelpItem);
        this.addMouseListener(this);
        this.setBorderPainted(false);
        this.setMargin(new Insets(0, 0, 0, 0));
        this.getAccessibleContext().setAccessibleName(this._element.getLongName());
        this.refreshText();
    }

    private void subQuerySelectedActionPerformed(String string) {
        this._parentTree.subQuerySelect(string);
    }

    private void moreSubQueriesActionPerformed() {
        String string = (String)SybOptionPane.showInputDialog((Component)this.getParent(), (Object)AccessPlanViewer.getI18NMessage("input.subqueries"), (String)AccessPlanViewer.getI18NMessage("input.title_subqueries"), (int)3, null, (Object[])this._element.getSubQueries().toArray(), this._element.getSubQueries().elementAt(0));
        if (string != null) {
            this._parentTree.subQuerySelect(string);
        }
    }

    @Override
    public boolean isShowing() {
        return this._isPrinting || super.isShowing();
    }

    public void setParentTree(TreeGraph treeGraph) {
        this._parentTree = treeGraph;
    }

    private void customizeActionPerformed() {
        if (this._parentTree != null) {
            this._parentTree.customizeActionPerformed();
        }
    }

    void showHelp() {
        PlanViewHelpManager.INSTANCE.openNode(this._element);
    }

    public PlanElement getElement() {
        return this._element;
    }

    public TreeGeometry getGeometry() {
        if (this._geometry == null) {
            this._geometry = new TreeGeometry();
        }
        return this._geometry;
    }

    public void setupGeometry(int n) {
        this.getGeometry().setSize(this.getWidth(), this.getHeight(), n);
    }

    public void setupGeometry(int n, int n2) {
        this.setupGeometry(n);
        this.getGeometry().makeLeafBoundary(n2);
    }

    public Enumeration getChildGeometries(final PlanElementView[] planElementViewArray) {
        return new Enumeration(){
            int i;
            {
                this.i = PlanElementView.this.firstChild();
            }

            @Override
            public boolean hasMoreElements() {
                return this.i <= PlanElementView.this.lastChild();
            }

            public Object nextElement() {
                ++this.i;
                return planElementViewArray[this.i - 1].getGeometry();
            }
        };
    }

    public int getChildCount() {
        return this._element.getChildCount();
    }

    public int childAt(int n) {
        return this._element.childAt(n);
    }

    public int firstChild() {
        return this._element.firstChild();
    }

    public int lastChild() {
        return this._element.lastChild();
    }

    public int parent() {
        return this._element.parent();
    }

    public boolean isLeaf() {
        return this._element.isLeaf();
    }

    public void setPrinting(boolean bl) {
        this._isPrinting = bl;
    }

    public float getLineThickness() {
        return this._lineThickness * (float)(PlanViewProperties.getMaxLineThickness() - 1) + 1.0f;
    }

    public Color getBorderColor() {
        if (!PlanViewProperties.getFastColor().equals(BorderColors[0]) || !PlanViewProperties.getSlowColor().equals(BorderColors[9])) {
            Color color = PlanViewProperties.getFastColor();
            Color color2 = PlanViewProperties.getSlowColor();
            PlanElementView.BorderColors[0] = color;
            PlanElementView.BorderColors[9] = color2;
            for (int i = 1; i < 9; ++i) {
                int n = (color2.getRed() - color.getRed()) * i / 10 + color.getRed();
                int n2 = (color2.getGreen() - color.getGreen()) * i / 10 + color.getGreen();
                int n3 = (color2.getBlue() - color.getBlue()) * i / 10 + color.getBlue();
                PlanElementView.BorderColors[i] = new Color(n << 16 | n2 << 8 | n3);
            }
        }
        return BorderColors[this._borderColor];
    }

    public String getKeyPerformance() {
        return PlanViewProperties.getShowKeyPerformance() ? this._keyPerformance : null;
    }

    protected void paintNode(Graphics graphics, Color color, Color color2, int n, int n2, int n3) {
        int n4;
        graphics.setColor(color);
        if (this._element.hasSubQueries()) {
            ((Graphics2D)graphics).setStroke(THICK_STROKE);
            n4 = 1;
        } else {
            ((Graphics2D)graphics).setStroke(THIN_STROKE);
            n4 = 1;
        }
        int n5 = this.getWidth();
        int n6 = this.getHeight();
        Polygon polygon = null;
        switch (n) {
            case 7: {
                graphics.fillOval(n4, n4, n5 - n4 * 2, n6 - n4 * 2);
                graphics.setColor(color2);
                graphics.drawOval(n4, n4, n5 - n4 * 2, n6 - n4 * 2);
                break;
            }
            case 6: {
                polygon = new Polygon();
                polygon.addPoint(n3, n4);
                polygon.addPoint(n5 - n3, n4);
                polygon.addPoint(n5 - n4, n6 / 2);
                polygon.addPoint(n5 - n3, n6 - n4);
                polygon.addPoint(n3, n6 - n4);
                polygon.addPoint(n4, n6 / 2);
                graphics.fillPolygon(polygon);
                graphics.setColor(color2);
                graphics.drawPolygon(polygon);
                break;
            }
            case 1: {
                graphics.fillRect(n4, n4, n5 - n4 * 2, n6 - n4 * 2);
                graphics.setColor(color2);
                graphics.drawRect(n4, n4, n5 - n4 * 2, n6 - n4 * 2);
                break;
            }
            case 2: {
                polygon = new Polygon();
                polygon.addPoint(n3, n4);
                polygon.addPoint(n5 - n4, n4);
                polygon.addPoint(n5 - n3, n6 - n4);
                polygon.addPoint(n4, n6 - n4);
                graphics.fillPolygon(polygon);
                graphics.setColor(color2);
                graphics.drawPolygon(polygon);
                break;
            }
            case 3: {
                polygon = new Polygon();
                polygon.addPoint(n4, n4);
                polygon.addPoint(n5 - n3, n4);
                polygon.addPoint(n5 - n4, n6 - n4);
                polygon.addPoint(n3, n6 - n4);
                graphics.fillPolygon(polygon);
                graphics.setColor(color2);
                graphics.drawPolygon(polygon);
                break;
            }
            case 5: {
                polygon = new Polygon();
                polygon.addPoint(n3, n4);
                polygon.addPoint(n5 - n3, n4);
                polygon.addPoint(n5 - n4, n6 - n4);
                polygon.addPoint(n4, n6 - n4);
                graphics.fillPolygon(polygon);
                graphics.setColor(color2);
                graphics.drawPolygon(polygon);
                break;
            }
            case 4: {
                polygon = new Polygon();
                polygon.addPoint(n4, n4);
                polygon.addPoint(n5 - n4, n4);
                polygon.addPoint(n5 - n3, n6 - n4);
                polygon.addPoint(n3, n6 - n4);
                graphics.fillPolygon(polygon);
                graphics.setColor(color2);
                graphics.drawPolygon(polygon);
                break;
            }
            default: {
                graphics.fillRoundRect(n4, n4, n5 - n4 * 2, n6 - n4 * 2, n2, n2);
                graphics.setColor(color2);
                graphics.drawRoundRect(n4, n4, n5 - n4 * 2, n6 - n4 * 2, n2, n2);
            }
        }
        ((Graphics2D)graphics).setStroke(DEFAULT_STROKE);
    }

    public void initGraphicalStats(long l, double d, PlanElementView[] planElementViewArray) {
        float f;
        double d2;
        if (l > 0L) {
            long l2 = this.getRowCount(planElementViewArray);
            this._lineThickness = (float)l2 / (float)l;
        }
        if (d > 0.0 && (d2 = this.getElement().getRuntime()) > 0.0) {
            this._borderColor = (int)((double)(BorderColors.length - 1) * d2 / d);
        }
        if ((f = this.getElement().getPercentCost()) > 0.0f) {
            Object[] objectArray = new Object[]{new Float(f)};
            this._keyPerformance = SybMessageFormat.format((String)AccessPlanViewer.getI18NMessage("view.runtime"), (Object[])objectArray);
        }
    }

    private long getRowCount(PlanElementView[] planElementViewArray) {
        long l = this.getElement().getRowCount();
        if (l < 0L) {
            l = 0L;
            for (int i = 0; i < this.getChildCount(); ++i) {
                l += planElementViewArray[this.childAt(i)].getRowCount(planElementViewArray);
            }
        }
        return l;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    public abstract void refreshText();

    public abstract void setToolTipFont(String var1);

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this._popupHelpItem.setEnabled(!PlanViewHelpManager.INSTANCE.getShowAsDisabled());
            this._popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    void destroy() {
        this.accessibleContext = null;
        this._geometry = null;
        this._element = null;
        this._parentTree = null;
        this._popupHelpItem = null;
        this._popup = null;
        this.removeMouseListener(this);
    }
}

