/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.planview;

import com.sybase.asa.planview.AccessPlanViewer;
import com.sybase.asa.planview.ColorChoiceComboBox;
import com.sybase.asa.planview.PlanViewProperties;
import com.sybase.asa.planview.ShapeChoiceComboBox;
import com.sybase.util.NumericTextField;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybLabel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;

class PlanViewCustomizer
extends JPanel
implements ItemListener {
    private ColorChoiceComboBox textColor;
    private ColorChoiceComboBox fastColor;
    private ColorChoiceComboBox slowColor;
    private ColorChoiceComboBox bgColor;
    private ColorChoiceComboBox lineColor;
    private ColorChoiceComboBox selectedTextColor;
    private ColorChoiceComboBox selectedBgColor;
    private ShapeChoiceComboBox defaultShape;
    private ShapeChoiceComboBox scanShape;
    private ShapeChoiceComboBox indScanShape;
    private ShapeChoiceComboBox materializedShape;
    private SybCheckBox showShortNames;
    private SybLabel truncatedLength_label;
    private JTextField truncatedLength;
    private SybCheckBox showKeyPerformance;
    private JTextField maxLineThickness;

    PlanViewCustomizer() {
        this.createUI();
        this.setControlValues();
    }

    boolean store() {
        PlanViewProperties.setTextColor(this.textColor.getColor());
        PlanViewProperties.setFastColor(this.fastColor.getColor());
        PlanViewProperties.setSlowColor(this.slowColor.getColor());
        PlanViewProperties.setBgColor(this.bgColor.getColor());
        PlanViewProperties.setLineColor(this.lineColor.getColor());
        PlanViewProperties.setSelectedTextColor(this.selectedTextColor.getColor());
        PlanViewProperties.setSelectedBgColor(this.selectedBgColor.getColor());
        PlanViewProperties.setDefaultShape(this.defaultShape.getShape());
        PlanViewProperties.setScanShape(this.scanShape.getShape());
        PlanViewProperties.setIndScanShape(this.indScanShape.getShape());
        PlanViewProperties.setMaterializedShape(this.materializedShape.getShape());
        PlanViewProperties.setShowLongNames(!this.showShortNames.isSelected());
        PlanViewProperties.setShowKeyPerformance(this.showKeyPerformance.isSelected());
        try {
            PlanViewProperties.setTruncatedLength(Integer.valueOf(this.truncatedLength.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            PlanViewProperties.setMaxLineThickness(Integer.valueOf(this.maxLineThickness.getText()));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return true;
    }

    private void createUI() {
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        this.setLayout(new BoxLayout(this, 1));
        this.setBorder(new EmptyBorder(5, 5, 0, 5));
        JPanel jPanel = new JPanel(new GridLayout(7, 2, 5, 5));
        jPanel.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(AccessPlanViewer.getI18NMessage("customize.colors")), emptyBorder));
        SybLabel sybLabel = new SybLabel(AccessPlanViewer.getI18NMessage("customize.text"));
        this.textColor = new ColorChoiceComboBox();
        sybLabel.setLabelFor((Component)this.textColor);
        jPanel.add((Component)sybLabel);
        jPanel.add(this.textColor);
        SybLabel sybLabel2 = new SybLabel(AccessPlanViewer.getI18NMessage("customize.fast"));
        this.fastColor = new ColorChoiceComboBox();
        sybLabel2.setLabelFor((Component)this.fastColor);
        jPanel.add((Component)sybLabel2);
        jPanel.add(this.fastColor);
        SybLabel sybLabel3 = new SybLabel(AccessPlanViewer.getI18NMessage("customize.slow"));
        this.slowColor = new ColorChoiceComboBox();
        sybLabel3.setLabelFor((Component)this.slowColor);
        jPanel.add((Component)sybLabel3);
        jPanel.add(this.slowColor);
        SybLabel sybLabel4 = new SybLabel(AccessPlanViewer.getI18NMessage("customize.background"));
        this.bgColor = new ColorChoiceComboBox();
        sybLabel4.setLabelFor((Component)this.bgColor);
        jPanel.add((Component)sybLabel4);
        jPanel.add(this.bgColor);
        SybLabel sybLabel5 = new SybLabel(AccessPlanViewer.getI18NMessage("customize.line"));
        this.lineColor = new ColorChoiceComboBox();
        sybLabel5.setLabelFor((Component)this.lineColor);
        jPanel.add((Component)sybLabel5);
        jPanel.add(this.lineColor);
        SybLabel sybLabel6 = new SybLabel(AccessPlanViewer.getI18NMessage("customize.selected_text"));
        this.selectedTextColor = new ColorChoiceComboBox();
        sybLabel6.setLabelFor((Component)this.selectedTextColor);
        jPanel.add((Component)sybLabel6);
        jPanel.add(this.selectedTextColor);
        SybLabel sybLabel7 = new SybLabel(AccessPlanViewer.getI18NMessage("customize.selected_background"));
        this.selectedBgColor = new ColorChoiceComboBox();
        sybLabel7.setLabelFor((Component)this.selectedBgColor);
        jPanel.add((Component)sybLabel7);
        jPanel.add(this.selectedBgColor);
        JPanel jPanel2 = new JPanel(new GridLayout(4, 2, 5, 5));
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(AccessPlanViewer.getI18NMessage("customize.shapes")), emptyBorder));
        SybLabel sybLabel8 = new SybLabel(AccessPlanViewer.getI18NMessage("customize.default_shape"));
        this.defaultShape = new ShapeChoiceComboBox();
        sybLabel8.setLabelFor((Component)this.defaultShape);
        jPanel2.add((Component)sybLabel8);
        jPanel2.add(this.defaultShape);
        SybLabel sybLabel9 = new SybLabel(AccessPlanViewer.getI18NMessage("customize.materialized_shape"));
        this.materializedShape = new ShapeChoiceComboBox();
        sybLabel9.setLabelFor((Component)this.materializedShape);
        jPanel2.add((Component)sybLabel9);
        jPanel2.add(this.materializedShape);
        SybLabel sybLabel10 = new SybLabel(AccessPlanViewer.getI18NMessage("customize.scan_shape"));
        this.scanShape = new ShapeChoiceComboBox();
        sybLabel10.setLabelFor((Component)this.scanShape);
        jPanel2.add((Component)sybLabel10);
        jPanel2.add(this.scanShape);
        SybLabel sybLabel11 = new SybLabel(AccessPlanViewer.getI18NMessage("customize.ind_scan_shape"));
        this.indScanShape = new ShapeChoiceComboBox();
        sybLabel11.setLabelFor((Component)this.indScanShape);
        jPanel2.add((Component)sybLabel11);
        jPanel2.add(this.indScanShape);
        this.showShortNames = new SybCheckBox(AccessPlanViewer.getI18NMessage("customize.show_short_names"));
        this.showShortNames.addItemListener((ItemListener)this);
        this.truncatedLength = new NumericTextField();
        this.truncatedLength.setColumns(10);
        this.truncatedLength_label = new SybLabel(AccessPlanViewer.getI18NMessage("customize.truncated_length"));
        this.truncatedLength_label.setLabelFor((Component)this.truncatedLength);
        this.showKeyPerformance = new SybCheckBox(AccessPlanViewer.getI18NMessage("customize.performance_show"));
        this.maxLineThickness = new NumericTextField();
        this.maxLineThickness.setColumns(10);
        SybLabel sybLabel12 = new SybLabel(AccessPlanViewer.getI18NMessage("customize.performance_line"));
        sybLabel12.setLabelFor((Component)this.maxLineThickness);
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        jPanel3.setAlignmentX(1.0f);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 21;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        jPanel3.add((Component)this.showShortNames, gridBagConstraints);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(0, 20, 0, 0);
        jPanel3.add((Component)this.truncatedLength_label, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel3.add((Component)this.truncatedLength, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel3.add((Component)this.showKeyPerformance, gridBagConstraints);
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        jPanel3.add((Component)sybLabel12, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel3.add((Component)this.maxLineThickness, gridBagConstraints);
        this.add(jPanel);
        this.add(jPanel2);
        this.add(jPanel3);
    }

    private void setControlValues() {
        this.textColor.setColor(PlanViewProperties.getTextColor());
        this.fastColor.setColor(PlanViewProperties.getFastColor());
        this.slowColor.setColor(PlanViewProperties.getSlowColor());
        this.bgColor.setColor(PlanViewProperties.getBgColor());
        this.lineColor.setColor(PlanViewProperties.getLineColor());
        this.selectedTextColor.setColor(PlanViewProperties.getSelectedTextColor());
        this.selectedBgColor.setColor(PlanViewProperties.getSelectedBgColor());
        this.defaultShape.setShape(PlanViewProperties.getDefaultShape());
        this.scanShape.setShape(PlanViewProperties.getScanShape());
        this.indScanShape.setShape(PlanViewProperties.getIndScanShape());
        this.materializedShape.setShape(PlanViewProperties.getMaterializedShape());
        this.showShortNames.setSelected(!PlanViewProperties.getShowLongNames());
        this.showKeyPerformance.setSelected(PlanViewProperties.getShowKeyPerformance());
        this.truncatedLength.setText(PlanViewProperties.getTruncatedLength() + "");
        this.maxLineThickness.setText(PlanViewProperties.getMaxLineThickness() + "");
        this.truncatedLength.setEnabled(!PlanViewProperties.getShowLongNames());
    }

    void destroy() {
        this.textColor = null;
        this.fastColor = null;
        this.slowColor = null;
        this.bgColor = null;
        this.lineColor = null;
        this.selectedTextColor = null;
        this.selectedBgColor = null;
        this.defaultShape = null;
        this.scanShape = null;
        this.indScanShape = null;
        this.materializedShape = null;
        if (this.showShortNames != null) {
            this.showShortNames.removeItemListener((ItemListener)this);
            this.showShortNames = null;
        }
        this.truncatedLength_label = null;
        this.showKeyPerformance = null;
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        this.enableControls();
    }

    private void enableControls() {
        boolean bl = this.showShortNames.isSelected();
        this.truncatedLength_label.setEnabled(bl);
        this.truncatedLength.setEnabled(bl);
    }
}

