/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.planview;

import com.sybase.asa.planview.AccessPlanViewer;
import com.sybase.asa.planview.IPlanViewHelpConstants;
import com.sybase.asa.planview.PlanElement;
import com.sybase.helpManager.FactoryHelp;
import com.sybase.helpManager.HelpErrorListener;
import com.sybase.helpManager.HelpNotFoundException;
import com.sybase.helpManager.HelpViewer;
import com.sybase.helpManager.HelpViewerException;
import com.sybase.helpManager.PageException;
import com.sybase.util.SybOptionPane;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;

final class PlanViewHelpManager
implements IPlanViewHelpConstants,
HelpErrorListener {
    public static PlanViewHelpManager INSTANCE = new PlanViewHelpManager();
    private HelpViewer _helpViewer;
    private boolean _notfound;
    private String _helpFolder;
    private String _helpPrefix;
    private String _helpSuffix;
    private boolean _showAsDisabled;

    private PlanViewHelpManager() {
    }

    public void init(String string, String string2, String string3) {
        this._helpFolder = string;
        this._helpPrefix = string2;
        this._helpSuffix = string3;
        this._notfound = false;
    }

    private void initHelpViewer() {
        if (!this._notfound) {
            try {
                this._helpViewer = FactoryHelp.getHelpViewer((String)this._helpFolder, (String)this._helpPrefix, (String)this._helpSuffix);
            }
            catch (HelpNotFoundException helpNotFoundException) {
                this._notfound = true;
            }
        }
    }

    void showHelpIndex(String string, boolean bl) {
        if (this._helpViewer == null) {
            this.initHelpViewer();
        }
        if (this._helpViewer != null) {
            Frame frame = AccessPlanViewer.getAnyFrameWindow();
            if (bl) {
                this._helpViewer.turnPage(string, (Window)frame);
            } else {
                this._helpViewer.turnPageSilent(string, (Window)frame);
            }
        }
    }

    public void changeCurrentNode(PlanElement planElement) {
        String string = "HELP_PLANVIEW_OPERATOR_" + planElement.getPhysicalType().toUpperCase();
        this.showHelpIndex(string, false);
    }

    public void openNode(PlanElement planElement) {
        String string = "HELP_PLANVIEW_OPERATOR_" + planElement.getPhysicalType().toUpperCase();
        this.showHelpIndex(string, true);
        if (this._helpViewer == null) {
            this.showErrorWindow();
        }
    }

    public void openGeneralHelp() {
        this.showHelpIndex("HELP_PLANVIEW_GENERAL", true);
        if (this._helpViewer == null) {
            this.showErrorWindow();
        }
    }

    private void showErrorWindow() {
        if (!this._showAsDisabled) {
            SybOptionPane.showMessageDialog((Component)AccessPlanViewer.getAnyFrameWindow(), (Object)AccessPlanViewer.getI18NMessage("help.error.message"), (String)AccessPlanViewer.getI18NMessage("error"), (int)0);
            this._showAsDisabled = true;
        }
    }

    public boolean getShowAsDisabled() {
        return this._showAsDisabled;
    }

    public void HelpViewerError(HelpViewerException helpViewerException) {
    }

    public void TurnPageError(PageException pageException) {
    }
}

