/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.planview;

import com.sybase.util.Platform;
import java.awt.Color;
import java.awt.SystemColor;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

final class PlanViewProperties {
    static final int SHAPE_ROUND_RECTANGLE = 0;
    static final int SHAPE_RECTANGLE = 1;
    static final int SHAPE_RIGHT_QUADRILATERAL = 2;
    static final int SHAPE_LEFT_QUADRILATERAL = 3;
    static final int SHAPE_BOTTOM_TRAPEZOID = 4;
    static final int SHAPE_TOP_TRAPEZOID = 5;
    static final int SHAPE_HEXAGON = 6;
    static final int SHAPE_OVAL = 7;
    private static final String _propertyFileName = Platform.getUserConfigurationDirectory() + ".ASAPlanView" + 11;
    private static String _pathSeparator = System.getProperty("path.separator");
    private static boolean _dirty;
    private static boolean _loaded;
    private static final String COLOR_SELECTED_BG = "ASAPlanView.Color.Selected.Bg";
    private static final Color COLOR_SELECTED_BG_DEFAULT;
    private static final String COLOR_SELECTED_TEXT = "ASAPlanView.Color.Selected.Text";
    private static final Color COLOR_SELECTED_TEXT_DEFAULT;
    private static final String COLOR_BG = "ASAPlanView.Color.Background";
    private static final Color COLOR_BG_DEFAULT;
    private static final String COLOR_LINE = "ASAPlanView.Color.Line";
    private static final Color COLOR_LINE_DEFAULT;
    private static final String COLOR_TEXT = "ASAPlanView.Color.Text";
    private static final Color COLOR_TEXT_DEFAULT;
    private static final String COLOR_FAST = "ASAPlanView.Color.Fast";
    private static final Color COLOR_FAST_DEFAULT;
    private static final String COLOR_SLOW = "ASAPlanView.Color.Slow";
    private static final Color COLOR_SLOW_DEFAULT;
    private static final String NAMES_LONG = "ASAPlanView.Names.Long";
    private static final boolean NAMES_LONG_DEFAULT = false;
    private static final String NAMES_TRUNCATED_LENGTH = "ASAPlanView.Names.TruncatedLength";
    private static final int NAMES_TRUNCATED_LENGTH_DEFAULT = 18;
    private static final String PERFORMANCE_SHOW = "ASAPlanView.Performance.show";
    private static final boolean PERFORMANCE_SHOW_DEFAULT = false;
    private static final String PERFORMANCE_LINE = "ASAPlanView.Performance.line";
    private static final int PERFORMANCE_LINE_DEFAULT = 6;
    private static final String SHAPE_DEFAULT = "ASAPlanView.Shape.Default";
    private static final int SHAPE_DEFAULT_DEFAULT = 0;
    private static final String SHAPE_MATERIALIZED = "ASAPlanView.Shape.Materialized";
    private static final int SHAPE_MATERIALIZED_DEFAULT = 6;
    private static final String SHAPE_SCAN = "ASAPlanView.Shape.Scan";
    private static final int SHAPE_SCAN_DEFAULT = 1;
    private static final String SHAPE_IND_SCAN = "ASAPlanView.Shape.IndScan";
    private static final int SHAPE_IND_SCAN_DEFAULT = 5;
    private static final String TESTING_MODE = "ASAPlanView.Debug.TestingMode";
    private static final boolean TESTING_MODE_DEFAULT = false;
    private static Color _selectedBgColor;
    private static Color _selectedTextColor;
    private static Color _bgColor;
    private static Color _textColor;
    private static Color _lineColor;
    private static Color _fastColor;
    private static Color _slowColor;
    private static boolean _showKeyPerformance;
    private static boolean _showLongNames;
    private static boolean _testingMode;
    private static int _truncatedLength;
    private static int _maxLineThickness;
    private static int _defaultShape;
    private static int _materializedShape;
    private static int _scanShape;
    private static int _indScanShape;

    private PlanViewProperties() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void load() {
        Properties properties = null;
        if (_loaded) {
            return;
        }
        _loaded = true;
        BufferedInputStream bufferedInputStream = null;
        try {
            bufferedInputStream = new BufferedInputStream(new FileInputStream(_propertyFileName));
            properties = new Properties();
            properties.load(bufferedInputStream);
            PlanViewProperties.loadSettingsFromProperty(properties);
        }
        catch (IOException iOException) {
        }
        finally {
            try {
                if (bufferedInputStream != null) {
                    bufferedInputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void store() {
        if (!_dirty) {
            return;
        }
        _dirty = false;
        Properties properties = new Properties();
        properties.setProperty(COLOR_BG, Integer.toString(_bgColor.getRGB()));
        properties.setProperty(COLOR_TEXT, Integer.toString(_textColor.getRGB()));
        properties.setProperty(COLOR_SLOW, Integer.toString(_slowColor.getRGB()));
        properties.setProperty(COLOR_FAST, Integer.toString(_fastColor.getRGB()));
        properties.setProperty(COLOR_LINE, Integer.toString(_lineColor.getRGB()));
        properties.setProperty(COLOR_SELECTED_BG, Integer.toString(_selectedBgColor.getRGB()));
        properties.setProperty(COLOR_SELECTED_TEXT, Integer.toString(_selectedTextColor.getRGB()));
        properties.setProperty(PERFORMANCE_SHOW, Boolean.toString(_showKeyPerformance));
        properties.setProperty(NAMES_LONG, Boolean.toString(_showLongNames));
        properties.setProperty(TESTING_MODE, Boolean.toString(_testingMode));
        properties.setProperty(PERFORMANCE_LINE, Integer.toString(_maxLineThickness));
        properties.setProperty(NAMES_TRUNCATED_LENGTH, Integer.toString(_truncatedLength));
        properties.setProperty(SHAPE_DEFAULT, Integer.toString(_defaultShape));
        properties.setProperty(SHAPE_SCAN, Integer.toString(_scanShape));
        properties.setProperty(SHAPE_IND_SCAN, Integer.toString(_indScanShape));
        properties.setProperty(SHAPE_MATERIALIZED, Integer.toString(_materializedShape));
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(_propertyFileName);
            properties.store(fileOutputStream, "ASAPlanView user prefrerences");
        }
        catch (IOException iOException) {
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                    fileOutputStream = null;
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static Color loadColor(Properties properties, String string, Color color) {
        Color color2 = color;
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            try {
                color2 = new Color(Integer.parseInt(string2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return color2;
    }

    private static int loadInteger(Properties properties, String string, int n) {
        int n2 = n;
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            try {
                n2 = Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n2;
    }

    private static boolean loadBoolean(Properties properties, String string, boolean bl) {
        boolean bl2 = bl;
        String string2 = properties.getProperty(string);
        if (string2 != null) {
            bl2 = Boolean.valueOf(string2);
        }
        return bl2;
    }

    private static void loadSettingsFromProperty(Properties properties) {
        _bgColor = PlanViewProperties.loadColor(properties, COLOR_BG, COLOR_BG_DEFAULT);
        _lineColor = PlanViewProperties.loadColor(properties, COLOR_LINE, COLOR_LINE_DEFAULT);
        _textColor = PlanViewProperties.loadColor(properties, COLOR_TEXT, COLOR_TEXT_DEFAULT);
        _slowColor = PlanViewProperties.loadColor(properties, COLOR_SLOW, COLOR_SLOW_DEFAULT);
        _fastColor = PlanViewProperties.loadColor(properties, COLOR_FAST, COLOR_FAST_DEFAULT);
        _selectedBgColor = PlanViewProperties.loadColor(properties, COLOR_SELECTED_BG, COLOR_SELECTED_BG_DEFAULT);
        _selectedTextColor = PlanViewProperties.loadColor(properties, COLOR_SELECTED_TEXT, COLOR_SELECTED_TEXT_DEFAULT);
        _showKeyPerformance = PlanViewProperties.loadBoolean(properties, PERFORMANCE_SHOW, false);
        _showLongNames = PlanViewProperties.loadBoolean(properties, NAMES_LONG, false);
        _testingMode = PlanViewProperties.loadBoolean(properties, TESTING_MODE, false);
        _maxLineThickness = PlanViewProperties.loadInteger(properties, PERFORMANCE_LINE, 6);
        _truncatedLength = PlanViewProperties.loadInteger(properties, NAMES_TRUNCATED_LENGTH, 18);
        _defaultShape = PlanViewProperties.loadInteger(properties, SHAPE_DEFAULT, 0);
        _scanShape = PlanViewProperties.loadInteger(properties, SHAPE_SCAN, 1);
        _indScanShape = PlanViewProperties.loadInteger(properties, SHAPE_IND_SCAN, 5);
        _materializedShape = PlanViewProperties.loadInteger(properties, SHAPE_MATERIALIZED, 6);
        _dirty = false;
    }

    static Color getBgColor() {
        return _bgColor;
    }

    static void setBgColor(Color color) {
        _bgColor = color;
        _dirty = true;
    }

    static Color getLineColor() {
        return _lineColor;
    }

    static void setLineColor(Color color) {
        _lineColor = color;
        _dirty = true;
    }

    static Color getTextColor() {
        return _textColor;
    }

    static void setTextColor(Color color) {
        _textColor = color;
        _dirty = true;
    }

    static Color getFastColor() {
        return _fastColor;
    }

    static void setFastColor(Color color) {
        _fastColor = color;
        _dirty = true;
    }

    static Color getSlowColor() {
        return _slowColor;
    }

    static void setSlowColor(Color color) {
        _slowColor = color;
        _dirty = true;
    }

    static Color getSelectedBgColor() {
        return _selectedBgColor;
    }

    static void setSelectedBgColor(Color color) {
        _selectedBgColor = color;
        _dirty = true;
    }

    static Color getSelectedTextColor() {
        return _selectedTextColor;
    }

    static void setSelectedTextColor(Color color) {
        _selectedTextColor = color;
        _dirty = true;
    }

    static boolean getShowLongNames() {
        return _showLongNames;
    }

    static void setShowLongNames(boolean bl) {
        _showLongNames = bl;
        _dirty = true;
    }

    static boolean getShowKeyPerformance() {
        return _showKeyPerformance;
    }

    static void setShowKeyPerformance(boolean bl) {
        _showKeyPerformance = bl;
        _dirty = true;
    }

    static int getMaxLineThickness() {
        return _maxLineThickness;
    }

    static void setMaxLineThickness(int n) {
        if (n > 0 && n < Integer.MAX_VALUE) {
            _maxLineThickness = n;
            _dirty = true;
        }
    }

    static int getTruncatedLength() {
        return _truncatedLength;
    }

    static void setTruncatedLength(int n) {
        if (n > 0 && n < Integer.MAX_VALUE) {
            _truncatedLength = n;
            _dirty = true;
        }
    }

    static int getDefaultShape() {
        return _defaultShape;
    }

    static void setDefaultShape(int n) {
        _defaultShape = n;
        _dirty = true;
    }

    static int getMaterializedShape() {
        return _materializedShape;
    }

    static void setMaterializedShape(int n) {
        _materializedShape = n;
        _dirty = true;
    }

    static int getScanShape() {
        return _scanShape;
    }

    static void setScanShape(int n) {
        _scanShape = n;
        _dirty = true;
    }

    static int getIndScanShape() {
        return _indScanShape;
    }

    static void setIndScanShape(int n) {
        _indScanShape = n;
        _dirty = true;
    }

    static boolean getTestingMode() {
        return _testingMode;
    }

    static void setTestingMode(boolean bl) {
        _testingMode = bl;
        _dirty = true;
    }

    static {
        COLOR_SELECTED_BG_DEFAULT = SystemColor.textHighlight;
        COLOR_SELECTED_TEXT_DEFAULT = SystemColor.textHighlightText;
        COLOR_BG_DEFAULT = SystemColor.window;
        COLOR_LINE_DEFAULT = SystemColor.textText;
        COLOR_TEXT_DEFAULT = SystemColor.textText;
        COLOR_FAST_DEFAULT = SystemColor.textText;
        COLOR_SLOW_DEFAULT = Color.red;
        _selectedBgColor = COLOR_SELECTED_BG_DEFAULT;
        _selectedTextColor = COLOR_SELECTED_TEXT_DEFAULT;
        _bgColor = COLOR_BG_DEFAULT;
        _textColor = COLOR_TEXT_DEFAULT;
        _lineColor = COLOR_LINE_DEFAULT;
        _fastColor = COLOR_FAST_DEFAULT;
        _slowColor = COLOR_SLOW_DEFAULT;
        _showKeyPerformance = false;
        _showLongNames = false;
        _testingMode = false;
        _truncatedLength = 18;
        _maxLineThickness = 6;
        _defaultShape = 0;
        _materializedShape = 6;
        _scanShape = 1;
        _indScanShape = 5;
    }
}

