/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.planview;

import com.sybase.asa.planview.AccessPlanViewer;
import com.sybase.asa.planview.PrintTreePanel;
import com.sybase.asa.planview.TreeGraph;
import com.sybase.util.DialogUtils;
import com.sybase.util.SybButton;
import com.sybase.util.SybModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.KeyStroke;

public final class PrintTreeDialog
extends SybModalDialog
implements ActionListener,
WindowListener {
    private PrintTreePanel _controls;
    private SybButton _ok;
    private SybButton _cancel;
    private boolean _isAccepted = false;
    protected static final String ESCAPE_KEY_PRESS = "ESCAPE_KEY_PRESS";

    @Override
    public void windowClosed(WindowEvent windowEvent) {
    }

    @Override
    public void windowIconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowActivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeiconified(WindowEvent windowEvent) {
    }

    @Override
    public void windowDeactivated(WindowEvent windowEvent) {
    }

    @Override
    public void windowOpened(WindowEvent windowEvent) {
    }

    @Override
    public void windowClosing(WindowEvent windowEvent) {
        this.cancel_actionPerformed();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._ok) {
            this.ok_actionPerformed();
        } else if (object == this._cancel || actionEvent.getActionCommand().equals(ESCAPE_KEY_PRESS)) {
            this.cancel_actionPerformed();
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public PrintTreeDialog(Frame frame, TreeGraph treeGraph) {
        super(frame);
        this.setTitle(AccessPlanViewer.getI18NMessage("print.title"));
        this.addWindowListener(this);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_PRESS, KeyStroke.getKeyStroke(27, 0, false), 2);
        this._ok = new SybButton();
        this._ok.setText(AccessPlanViewer.getI18NMessage("ok"));
        this._ok.addActionListener((ActionListener)this);
        this._ok.getAccessibleContext().setAccessibleDescription(AccessPlanViewer.getI18NMessage("ok_description"));
        this._cancel = new SybButton();
        this._cancel.setText(AccessPlanViewer.getI18NMessage("cancel"));
        this._cancel.addActionListener((ActionListener)this);
        this._cancel.getAccessibleContext().setAccessibleDescription(AccessPlanViewer.getI18NMessage("cancel_description"));
        this._controls = new PrintTreePanel(treeGraph, (JComponent)this._ok, (JComponent)this._cancel);
        Container container = this.getContentPane();
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setHgap(0);
        borderLayout.setVgap(0);
        container.setLayout(borderLayout);
        container.add((Component)this._controls, "Center");
        this.getRootPane().setDefaultButton((JButton)this._ok);
        this.pack();
        this.setResizable(false);
        this.setLocationRelativeTo(frame);
    }

    public void init(TreeGraph treeGraph) {
        this._controls.init(treeGraph);
    }

    public boolean isAccepted() {
        return this._isAccepted;
    }

    public TreeGraph getTreeGraph() {
        return this._controls.getTreeGraph();
    }

    public PageFormat getPageFormat() {
        return this._controls.getPageFormat();
    }

    public PrinterJob getPrinterJob() {
        return this._controls.getPrinterJob();
    }

    private void ok_actionPerformed() {
        this._isAccepted = true;
        this.setVisible(false);
    }

    private void cancel_actionPerformed() {
        this._isAccepted = false;
        this.setVisible(false);
    }

    public void destroy() {
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        DialogUtils.removeComponents((Container)((Object)this));
    }
}

