/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.planview;

import com.sybase.asa.planview.AccessPlanViewer;
import com.sybase.asa.planview.BasicPlanElementView;
import com.sybase.asa.planview.DetailPlanElementView;
import com.sybase.asa.planview.DocumentedTreeGraph;
import com.sybase.asa.planview.PlanElementView;
import com.sybase.asa.planview.TreeGraph;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import com.sybase.util.SybRadioButton;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.print.PageFormat;
import java.awt.print.PrinterJob;
import java.text.DecimalFormat;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;

public final class PrintTreePanel
extends JPanel
implements ActionListener {
    private TreeGraph _original_graph;
    private TreeGraph _detail_graph = null;
    private TreeGraph _documented_graph = null;
    private PageFormat _page_format;
    private PrinterJob _printer_job;
    private SybRadioButton _fit_to_pages;
    private SybRadioButton _print_to_scale;
    private JTextField _pages_tall;
    private int[] _pages_int = new int[2];
    private JTextField _pages_wide;
    private JTextField _scale;
    private double _scale_double;
    private SybRadioButton _print_detail;
    private SybRadioButton _print_documented;
    private SybRadioButton _print_basic;
    private SybButton _page_setup;
    private SybButton _printer_setup;
    private DecimalFormat _scale_format;
    private static final int PERCENT = 200;

    public PrintTreePanel(TreeGraph treeGraph, JComponent jComponent, JComponent jComponent2) {
        this._pages_int[0] = 1;
        this._pages_int[1] = 1;
        this._scale_double = 0.5;
        this._scale_format = new DecimalFormat("##0.0#");
        this.createForm(jComponent, jComponent2);
        this._print_detail.setSelected(true);
        this._print_to_scale.setSelected(true);
        this._pages_tall.setEnabled(false);
        this._pages_wide.setEnabled(false);
        this._printer_job = PrinterJob.getPrinterJob();
        this._page_format = this._printer_job.defaultPage();
        this.init(treeGraph);
    }

    public void init(TreeGraph treeGraph) {
        this._original_graph = treeGraph;
        String string = this._original_graph.getNodes()[0].getElement().getTooltip();
        if (string != null && string.length() > 0) {
            PlanElementView[] planElementViewArray = this._original_graph.getNodes();
            PlanElementView[] planElementViewArray2 = new PlanElementView[planElementViewArray.length];
            PlanElementView[] planElementViewArray3 = new PlanElementView[planElementViewArray.length];
            for (int i = 0; i < planElementViewArray.length; ++i) {
                planElementViewArray2[i] = new DetailPlanElementView(planElementViewArray[i].getElement());
                planElementViewArray3[i] = new BasicPlanElementView(planElementViewArray[i].getElement(), i + 1 + ". " + planElementViewArray[i].getElement().getName());
            }
            this._detail_graph = new TreeGraph(planElementViewArray2, 4, 5, 20, treeGraph.getName(), null);
            this._documented_graph = new DocumentedTreeGraph(planElementViewArray3, 4, 1, 20, treeGraph.getName(), null);
            if (this._fit_to_pages.isSelected()) {
                this.fitToPages_clicked();
            }
            this._print_detail.setEnabled(true);
            this._print_documented.setEnabled(true);
        } else {
            this._print_basic.setSelected(true);
            this._print_detail.setEnabled(false);
            this._print_documented.setEnabled(false);
        }
        this.getTreeGraph().setPrintScale(this._scale_double, this._pages_int, this._page_format);
        this._scale.setText(this._scale_format.format(this._scale_double * 200.0));
        this._pages_tall.setText(this._pages_int[0] + "");
        this._pages_wide.setText(this._pages_int[1] + "");
    }

    private void createForm(JComponent jComponent, JComponent jComponent2) {
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel(new GridLayout(1, 4, 5, 0));
        Box box = new Box(1);
        Box box2 = new Box(0);
        Box box3 = new Box(0);
        this._scale = new JTextField(7);
        this._scale.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                PrintTreePanel.this.scale_keyTyped();
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        box2.add(this._scale);
        box2.add(Box.createHorizontalStrut(5));
        SybLabel sybLabel = new SybLabel(AccessPlanViewer.getI18NMessage("print.scale_to_1"));
        box2.add((Component)sybLabel);
        this._pages_tall = new JTextField(7);
        this._pages_tall.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                PrintTreePanel.this.pagesTall_keyTyped();
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        box3.add(this._pages_tall);
        box3.add(Box.createHorizontalStrut(5));
        sybLabel = new SybLabel(AccessPlanViewer.getI18NMessage("print.fit_to_1"));
        box3.add((Component)sybLabel);
        box3.add(Box.createHorizontalStrut(5));
        sybLabel.setLabelFor((Component)this._pages_tall);
        this._pages_wide = new JTextField(7);
        this._pages_wide.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
            }

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                PrintTreePanel.this.pagesWide_keyTyped();
            }

            @Override
            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        box3.add(this._pages_wide);
        box3.add(Box.createHorizontalStrut(5));
        sybLabel = new SybLabel(AccessPlanViewer.getI18NMessage("print.fit_to_2"));
        box3.add((Component)sybLabel);
        sybLabel.setLabelFor((Component)this._pages_wide);
        ButtonGroup buttonGroup = new ButtonGroup();
        this._print_to_scale = new SybRadioButton(AccessPlanViewer.getI18NMessage("print.scale_to_0"));
        this._print_to_scale.addActionListener((ActionListener)this);
        buttonGroup.add((AbstractButton)this._print_to_scale);
        this._fit_to_pages = new SybRadioButton(AccessPlanViewer.getI18NMessage("print.fit_to_0"));
        this._fit_to_pages.addActionListener((ActionListener)this);
        buttonGroup.add((AbstractButton)this._fit_to_pages);
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), AccessPlanViewer.getI18NMessage("print.scale")));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints((Component)this._print_to_scale, gridBagConstraints);
        jPanel.add((Component)this._print_to_scale);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 0);
        gridBagLayout.setConstraints((Component)this._fit_to_pages, gridBagConstraints);
        jPanel.add((Component)this._fit_to_pages);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 0, 0, 5);
        gridBagLayout.setConstraints(box2, gridBagConstraints);
        jPanel.add(box2);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 5, 5);
        gridBagLayout.setConstraints(box3, gridBagConstraints);
        jPanel.add(box3);
        buttonGroup = new ButtonGroup();
        this._print_basic = new SybRadioButton(AccessPlanViewer.getI18NMessage("print.print_basic"));
        this._print_basic.addActionListener((ActionListener)this);
        buttonGroup.add((AbstractButton)this._print_basic);
        box.add((Component)this._print_basic);
        this._print_detail = new SybRadioButton(AccessPlanViewer.getI18NMessage("print.print_details"));
        this._print_detail.addActionListener((ActionListener)this);
        buttonGroup.add((AbstractButton)this._print_detail);
        box.add((Component)this._print_detail);
        this._print_documented = new SybRadioButton(AccessPlanViewer.getI18NMessage("print.print_documented"));
        this._print_documented.addActionListener((ActionListener)this);
        buttonGroup.add((AbstractButton)this._print_documented);
        box.add((Component)this._print_documented);
        if (jComponent != null) {
            jPanel2.add((Component)jComponent, 0);
        }
        if (jComponent2 != null) {
            jPanel2.add((Component)jComponent2, 1);
        }
        this._printer_setup = new SybButton(AccessPlanViewer.getI18NMessage("print.printer_setup"));
        this._printer_setup.addActionListener((ActionListener)this);
        jPanel2.add((Component)this._printer_setup, 2);
        this._page_setup = new SybButton(AccessPlanViewer.getI18NMessage("print.page_setup"));
        this._page_setup.addActionListener((ActionListener)this);
        jPanel2.add((Component)this._page_setup);
        gridBagLayout = new GridBagLayout();
        gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 0, 0, 0);
        gridBagConstraints.anchor = 17;
        gridBagLayout.setConstraints(box, gridBagConstraints);
        this.add(box);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 14;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.add(jPanel2);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this._printer_setup) {
            this.printerSetup_clicked();
        } else if (object == this._page_setup) {
            this.pageFormat_clicked();
        } else if (object == this._print_detail || object == this._print_documented || object == this._print_basic) {
            this.printFormat_selected();
        } else if (object == this._print_to_scale) {
            this.printToScale_clicked();
        } else if (object == this._fit_to_pages) {
            this.fitToPages_clicked();
        }
    }

    private void printerSetup_clicked() {
        this._printer_job.printDialog();
    }

    private void pageFormat_clicked() {
        this._page_format = this._printer_job.pageDialog(this._page_format);
        if (this._fit_to_pages.isSelected()) {
            this._scale_double = this.getTreeGraph().setPrintScale(this._pages_int[1], this._pages_int[0], this._page_format);
            this._scale.setText(this._scale_format.format(this._scale_double * 200.0));
        } else {
            this.getTreeGraph().setPrintScale(this._scale_double, this._pages_int, this._page_format);
            this._pages_tall.setText(this._pages_int[0] + "");
            this._pages_wide.setText(this._pages_int[1] + "");
        }
    }

    private void printFormat_selected() {
        if (this._fit_to_pages.isSelected()) {
            this._scale_double = this.getTreeGraph().setPrintScale(this._pages_int[1], this._pages_int[0], this._page_format);
            this._scale.setText(this._scale_format.format(this._scale_double * 200.0));
        } else {
            this.getTreeGraph().setPrintScale(this._scale_double, this._pages_int, this._page_format);
            this._pages_tall.setText(this._pages_int[0] + "");
            this._pages_wide.setText(this._pages_int[1] + "");
        }
    }

    private void scale_keyTyped() {
        try {
            double d = Double.parseDouble(this._scale.getText()) / 200.0;
            if (d > 0.001) {
                this._scale_double = d;
                this.getTreeGraph().setPrintScale(this._scale_double, this._pages_int, this._page_format);
                this._pages_tall.setText(this._pages_int[0] + "");
                this._pages_wide.setText(this._pages_int[1] + "");
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void pagesWide_keyTyped() {
        try {
            int n = Integer.parseInt(this._pages_wide.getText());
            if (n > 0) {
                this._pages_int[1] = n;
                this._scale_double = this.getTreeGraph().setPrintScale(this._pages_int[1], this._pages_int[0], this._page_format);
                this._scale.setText(this._scale_format.format(this._scale_double * 200.0));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void pagesTall_keyTyped() {
        try {
            int n = Integer.parseInt(this._pages_tall.getText());
            if (n > 0) {
                this._pages_int[0] = n;
                this._scale_double = this.getTreeGraph().setPrintScale(this._pages_int[1], this._pages_int[0], this._page_format);
                this._scale.setText(this._scale_format.format(this._scale_double * 200.0));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void fitToPages_clicked() {
        this._scale_double = this.getTreeGraph().setPrintScale(this._pages_int[1], this._pages_int[0], this._page_format);
        this._scale.setText(this._scale_format.format(this._scale_double * 200.0));
        this._pages_tall.setEnabled(true);
        this._pages_wide.setEnabled(true);
        this._scale.setEnabled(false);
        this._pages_tall.requestFocus();
    }

    private void printToScale_clicked() {
        this.getTreeGraph().setPrintScale(this._scale_double, this._pages_int, this._page_format);
        this._pages_tall.setText(this._pages_int[0] + "");
        this._pages_wide.setText(this._pages_int[1] + "");
        this._pages_tall.setEnabled(false);
        this._pages_wide.setEnabled(false);
        this._scale.setEnabled(true);
        this._scale.requestFocus();
    }

    public TreeGraph getTreeGraph() {
        if (this._print_detail.isSelected()) {
            return this._detail_graph;
        }
        if (this._print_documented.isSelected()) {
            return this._documented_graph;
        }
        return this._original_graph;
    }

    public PageFormat getPageFormat() {
        return this._page_format;
    }

    public PrinterJob getPrinterJob() {
        return this._printer_job;
    }
}

