/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.planview;

import com.sybase.asa.planview.AccessPlanViewer;
import com.sybase.util.SybLabel;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Polygon;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

final class ShapeChoiceComboBox
extends JComboBox {
    ShapeChoiceComboBox() {
        this.setRenderer(new ShapeChoiceRenderer());
        String string = AccessPlanViewer.getI18NMessage("customize.color_choice_combobox.custom");
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.stringWidth(string) + n + 2 + new SybLabel().getIconTextGap();
        this.addItem(new ShapeFillIcon(0, n2, n, 1));
        this.addItem(new ShapeFillIcon(1, n2, n, 1));
        this.addItem(new ShapeFillIcon(2, n2, n, 1));
        this.addItem(new ShapeFillIcon(3, n2, n, 1));
        this.addItem(new ShapeFillIcon(4, n2, n, 1));
        this.addItem(new ShapeFillIcon(5, n2, n, 1));
        this.addItem(new ShapeFillIcon(6, n2, n, 1));
        this.addItem(new ShapeFillIcon(7, n2, n, 1));
    }

    int getShape() {
        ShapeFillIcon shapeFillIcon = (ShapeFillIcon)this.getItemAt(this.getSelectedIndex());
        return shapeFillIcon.getShape();
    }

    void setShape(int n) {
        switch (n) {
            case 0: {
                this.setSelectedIndex(0);
                break;
            }
            case 1: {
                this.setSelectedIndex(1);
                break;
            }
            case 2: {
                this.setSelectedIndex(2);
                break;
            }
            case 3: {
                this.setSelectedIndex(3);
                break;
            }
            case 4: {
                this.setSelectedIndex(4);
                break;
            }
            case 5: {
                this.setSelectedIndex(5);
                break;
            }
            case 6: {
                this.setSelectedIndex(6);
                break;
            }
            case 7: {
                this.setSelectedIndex(7);
                break;
            }
            default: {
                this.setSelectedIndex(0);
            }
        }
    }

    static final class ShapeChoiceRenderer
    extends SybLabel
    implements ListCellRenderer {
        ShapeChoiceRenderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object == null) {
                this.setText("");
                this.setIcon(null);
            } else if (bl) {
                this.setBackground(UIManager.getColor("ComboBox.selectionBackground"));
                this.setForeground(UIManager.getColor("ComboBox.selectionForeground"));
                if (object instanceof ShapeFillIcon) {
                    this.setIcon((ShapeFillIcon)object);
                    this.setText("");
                } else if (object instanceof JLabel) {
                    JLabel jLabel = (JLabel)object;
                    this.setIcon(jLabel.getIcon());
                    this.setText(jLabel.getText());
                }
            } else {
                if (object instanceof ShapeFillIcon) {
                    this.setIcon((ShapeFillIcon)object);
                    this.setText("");
                } else if (object instanceof JLabel) {
                    JLabel jLabel = (JLabel)object;
                    this.setIcon(jLabel.getIcon());
                    this.setText(jLabel.getText());
                }
                this.setBackground(UIManager.getColor("ComboBox.background"));
                this.setForeground(UIManager.getColor("ComboBox.foreground"));
            }
            return this;
        }
    }

    static final class ShapeFillIcon
    implements Icon {
        protected int _width;
        protected int _height;
        protected Color _shadow;
        protected int _borderSize;
        protected int _fillHeight;
        protected int _fillWidth;
        protected int _shape;
        public static final int BORDER_SIZE = 2;
        public static final int DEFAULT_SIZE = 32;

        ShapeFillIcon(int n, int n2, int n3, int n4) {
            this._shape = n;
            this._borderSize = n4;
            this._width = n2;
            this._height = n3;
            this._shadow = Color.black;
            this._fillWidth = n2 - 2 * n4;
            this._fillHeight = n3 - 2 * n4;
        }

        ShapeFillIcon(int n, int n2) {
            this(n, n2, n2, 2);
        }

        ShapeFillIcon(int n) {
            this(n, 32, 32, 2);
        }

        void setShadow(Color color) {
            this._shadow = color;
        }

        void setShape(int n) {
            this._shape = n;
        }

        int getShape() {
            return this._shape;
        }

        @Override
        public int getIconWidth() {
            return this._width;
        }

        @Override
        public int getIconHeight() {
            return this._height;
        }

        @Override
        public void paintIcon(Component component, Graphics graphics, int n, int n2) {
            Color color = Color.white;
            Color color2 = Color.black;
            graphics.setColor(color);
            int n3 = this._width;
            int n4 = this._height;
            Polygon polygon = null;
            switch (this._shape) {
                case 7: {
                    graphics.fillOval(0, 0, n3 - 1, n4 - 1);
                    graphics.setColor(color2);
                    graphics.drawOval(0, 0, n3 - 1, n4 - 1);
                    break;
                }
                case 6: {
                    polygon = new Polygon();
                    polygon.addPoint(5, 0);
                    polygon.addPoint(n3 - 1 - 5, 0);
                    polygon.addPoint(n3 - 1, n4 / 2);
                    polygon.addPoint(n3 - 1 - 5, n4 - 1);
                    polygon.addPoint(5, n4 - 1);
                    polygon.addPoint(0, n4 / 2);
                    graphics.fillPolygon(polygon);
                    graphics.setColor(color2);
                    graphics.drawPolygon(polygon);
                    break;
                }
                case 1: {
                    graphics.fillRect(0, 0, n3 - 1, n4 - 1);
                    graphics.setColor(color2);
                    graphics.drawRect(0, 0, n3 - 1, n4 - 1);
                    break;
                }
                case 2: {
                    polygon = new Polygon();
                    polygon.addPoint(5, 0);
                    polygon.addPoint(n3 - 1, 0);
                    polygon.addPoint(n3 - 1 - 5, n4 - 1);
                    polygon.addPoint(0, n4 - 1);
                    graphics.fillPolygon(polygon);
                    graphics.setColor(color2);
                    graphics.drawPolygon(polygon);
                    break;
                }
                case 3: {
                    polygon = new Polygon();
                    polygon.addPoint(0, 0);
                    polygon.addPoint(n3 - 1 - 5, 0);
                    polygon.addPoint(n3 - 1, n4 - 1);
                    polygon.addPoint(5, n4 - 1);
                    graphics.fillPolygon(polygon);
                    graphics.setColor(color2);
                    graphics.drawPolygon(polygon);
                    break;
                }
                case 5: {
                    polygon = new Polygon();
                    polygon.addPoint(5, 0);
                    polygon.addPoint(n3 - 1 - 5, 0);
                    polygon.addPoint(n3 - 1, n4 - 1);
                    polygon.addPoint(0, n4 - 1);
                    graphics.fillPolygon(polygon);
                    graphics.setColor(color2);
                    graphics.drawPolygon(polygon);
                    break;
                }
                case 4: {
                    polygon = new Polygon();
                    polygon.addPoint(0, 0);
                    polygon.addPoint(n3 - 1, 0);
                    polygon.addPoint(n3 - 1 - 5, n4 - 1);
                    polygon.addPoint(5, n4 - 1);
                    graphics.fillPolygon(polygon);
                    graphics.setColor(color2);
                    graphics.drawPolygon(polygon);
                    break;
                }
                default: {
                    graphics.fillRoundRect(1, 1, n3 - 1, n4 - 1, 4, 4);
                    graphics.setColor(color2);
                    graphics.drawRoundRect(0, 0, n3 - 1, n4 - 1, 4, 4);
                }
            }
        }
    }
}

