/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.planview;

import com.sybase.asa.planview.UVCoord;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.util.Enumeration;

final class TreeGeometry {
    private UVTreeBoundary _boundary;
    private UVCoord _offset = new UVCoord(0, 0);
    private UVCoord _size = new UVCoord(0, 0);
    private int _x_pos;
    private int _y_pos;
    protected Line _line_to_parent;

    public int getWidth(int n) {
        return Math.abs(this._size.getX(n));
    }

    public int getHeight(int n) {
        return Math.abs(this._size.getY(n));
    }

    public int getXOffset(int n) {
        return this._offset.getX(n);
    }

    public int getX() {
        return this._x_pos;
    }

    public int getY() {
        return this._y_pos;
    }

    public Line getLineToParent() {
        return this._line_to_parent;
    }

    public int getYOffset(int n) {
        return this._offset.getY(n);
    }

    public void makeLeafBoundary(int n) {
        this._boundary = new UVTreeBoundary(this._size, n);
    }

    public void setSize(int n, int n2, int n3) {
        this._size = n3 == 1 || n3 == 2 ? new UVCoord(n, n2) : new UVCoord(n2, n);
    }

    public void setPosition(int n, int n2, int n3) {
        this._x_pos = n + this.getXOffset(n3);
        this._y_pos = n2 + this.getYOffset(n3);
    }

    public void mergeWithChildren(Enumeration enumeration, int n, int n2, int n3) {
        int n4;
        TreeGeometry treeGeometry;
        TreeGeometry treeGeometry2 = treeGeometry = (TreeGeometry)enumeration.nextElement();
        this._boundary = treeGeometry._boundary;
        treeGeometry._boundary = null;
        int n5 = n4 = treeGeometry._size.v + 2 * n;
        int n6 = treeGeometry._size.u;
        while (enumeration.hasMoreElements()) {
            treeGeometry = (TreeGeometry)enumeration.nextElement();
            int n7 = this._boundary.mergeWith(treeGeometry._boundary);
            if (n3 == 2 || n3 == 3) {
                treeGeometry._offset.u = treeGeometry._size.u - n6;
                n6 = treeGeometry._size.u;
            } else {
                treeGeometry._offset.u = 0;
            }
            treeGeometry._offset.v = n7 + n4;
            n4 = treeGeometry._size.v + 2 * n;
            n5 += n7 + n4;
            treeGeometry._boundary = null;
        }
        this.joinToChildren(treeGeometry2, n5, n, n2, n3);
    }

    private void joinToChildren(TreeGeometry treeGeometry, int n, int n2, int n3, int n4) {
        int n5 = n2 + n3;
        int n6 = (n - this._size.v) / 2 - n2;
        int n7 = n6 + this._size.v + 2 * n2 - n;
        treeGeometry._offset.u = n4 == 2 || n4 == 3 ? n5 + treeGeometry._size.u : n5 + this._size.u;
        treeGeometry._offset.v = n7;
        this._boundary.extend(this._size.u, n5, n7, n6);
    }

    public void clearLineToParent() {
        this._line_to_parent = null;
    }

    public void makeLineToParent(TreeGeometry treeGeometry, int n) {
        int n2;
        int n3;
        int n4;
        int n5;
        switch (n) {
            case 1: {
                n5 = this._x_pos;
                n4 = this._y_pos + this.getHeight(n) / 2;
                n3 = treeGeometry._x_pos + treeGeometry.getWidth(n);
                n2 = treeGeometry._y_pos + treeGeometry.getHeight(n) / 2;
                break;
            }
            case 2: {
                n5 = this._x_pos + this.getWidth(n);
                n4 = this._y_pos + this.getHeight(n) / 2;
                n3 = treeGeometry._x_pos;
                n2 = treeGeometry._y_pos + treeGeometry.getHeight(n) / 2;
                break;
            }
            case 4: {
                n5 = this._x_pos + this.getWidth(n) / 2;
                n4 = this._y_pos;
                n3 = treeGeometry._x_pos + treeGeometry.getWidth(n) / 2;
                n2 = treeGeometry._y_pos + treeGeometry.getHeight(n);
                break;
            }
            case 3: {
                n5 = this._x_pos + this.getWidth(n) / 2;
                n4 = this._y_pos + this.getHeight(n);
                n3 = treeGeometry._x_pos + treeGeometry.getWidth(n) / 2;
                n2 = treeGeometry._y_pos;
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown orientation: " + n);
            }
        }
        if (Math.abs(n5 - n3) == 1) {
            n3 = n5;
        }
        if (Math.abs(n4 - n2) == 1) {
            n2 = n4;
        }
        this._line_to_parent = new Line(n5, n4, n3, n2);
    }

    static final class UVTreeBoundary {
        private UVLineSegment _upper_head;
        private UVLineSegment _upper_tail;
        private UVLineSegment _lower_head;
        private UVLineSegment _lower_tail;

        UVTreeBoundary(UVCoord uVCoord, int n) {
            this(uVCoord.u, uVCoord.v, n);
        }

        UVTreeBoundary(int n, int n2, int n3) {
            this._upper_head = this._upper_tail = new UVLineSegment(n + 2 * n3, 0, null);
            this._lower_tail = new UVLineSegment(0, -n2 - 2 * n3, null);
            this._lower_head = new UVLineSegment(n + 2 * n3, 0, this._lower_tail);
        }

        void extend(int n, int n2, int n3, int n4) {
            this._upper_head = n3 != 0 ? new UVLineSegment(n, 0, new UVLineSegment(n2, n3, this._upper_head)) : new UVLineSegment(n + n2, 0, this._upper_head);
            this._lower_head = n4 != 0 ? new UVLineSegment(n, 0, new UVLineSegment(n2, n4, this._lower_head)) : new UVLineSegment(n + n2, 0, this._lower_head);
        }

        public String toString() {
            return "< Upper [ " + this._upper_head.toString() + " ]\n" + "  Lower [ " + this._lower_head.toString() + " ] >";
        }

        int mergeWith(UVTreeBoundary uVTreeBoundary) {
            int n = 0;
            int n2 = 0;
            int n3 = 0;
            UVLineSegment uVLineSegment = this._lower_head;
            UVLineSegment uVLineSegment2 = uVTreeBoundary._upper_head;
            while (uVLineSegment2 != null && uVLineSegment != null) {
                int n4 = uVLineSegment.offset(uVLineSegment2, n3, n2);
                n2 += n4;
                n += n4;
                if (n3 + uVLineSegment2._du <= uVLineSegment._du) {
                    n2 += uVLineSegment2._dv;
                    n3 += uVLineSegment2._du;
                    uVLineSegment2 = uVLineSegment2._link;
                    continue;
                }
                n2 -= uVLineSegment._dv;
                n3 -= uVLineSegment._du;
                uVLineSegment = uVLineSegment._link;
            }
            if (uVLineSegment2 != null) {
                UVLineSegment uVLineSegment3 = this._upper_tail.bridge(uVLineSegment2, n3, n2);
                this._upper_tail = uVLineSegment3._link != null ? uVTreeBoundary._upper_tail : uVLineSegment3;
                this._lower_tail = uVTreeBoundary._lower_tail;
            } else {
                UVLineSegment uVLineSegment4 = uVTreeBoundary._lower_tail.bridge(uVLineSegment, -n3, -n2);
                if (uVLineSegment4._link == null) {
                    this._lower_tail = uVLineSegment4;
                }
            }
            this._lower_head = uVTreeBoundary._lower_head;
            return n;
        }

        static final class UVLineSegment {
            int _du;
            int _dv;
            UVLineSegment _link;

            UVLineSegment(int n, int n2, UVLineSegment uVLineSegment) {
                this._du = n;
                this._dv = n2;
                this._link = uVLineSegment;
            }

            UVLineSegment(UVCoord uVCoord, UVLineSegment uVLineSegment) {
                this._du = uVCoord.u;
                this._dv = uVCoord.v;
                this._link = uVLineSegment;
            }

            public String toString() {
                StringBuffer stringBuffer = new StringBuffer("( " + this._du + ", " + this._dv + " )");
                UVLineSegment uVLineSegment = this._link;
                while (uVLineSegment != null) {
                    stringBuffer.append(", ( " + uVLineSegment._du + ", " + uVLineSegment._dv + " )");
                    uVLineSegment = uVLineSegment._link;
                }
                return stringBuffer.toString();
            }

            int offset(UVLineSegment uVLineSegment, int n, int n2) {
                if (this._du <= n || n + uVLineSegment._du <= 0) {
                    return 0;
                }
                n2 = this._du * uVLineSegment._dv - uVLineSegment._du * this._dv > 0 ? (n < 0 ? n * uVLineSegment._dv / uVLineSegment._du - n2 : (n > 0 ? n * this._dv / this._du - n2 : -n2)) : (this._du < n + uVLineSegment._du ? this._dv - (this._du - n) * uVLineSegment._dv / uVLineSegment._du - n2 : (this._du > n + uVLineSegment._du ? (uVLineSegment._du + n) * this._dv / this._du - uVLineSegment._dv - n2 : this._dv - uVLineSegment._dv - n2));
                return n2 > 0 ? n2 : 0;
            }

            UVLineSegment bridge(UVLineSegment uVLineSegment, int n, int n2) {
                int n3 = n + uVLineSegment._du;
                int n4 = uVLineSegment._du == 0 ? uVLineSegment._dv : n3 * uVLineSegment._dv / uVLineSegment._du;
                UVLineSegment uVLineSegment2 = new UVLineSegment(n3, n4, uVLineSegment._link);
                n4 = n2 + uVLineSegment._dv - n4;
                this._link = n4 != 0 ? new UVLineSegment(0, n4, uVLineSegment2) : uVLineSegment2;
                return uVLineSegment2;
            }
        }
    }

    static final class Line {
        int _start_x;
        int _start_y;
        int _end_x;
        int _end_y;

        Line(int n, int n2, int n3, int n4) {
            this._start_x = n;
            this._start_y = n2;
            this._end_x = n3;
            this._end_y = n4;
        }

        void offset(int n, int n2) {
            this._start_x += n;
            this._start_y += n2;
            this._end_x += n;
            this._end_y += n2;
        }

        void paint(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.drawLine(this._start_x, this._start_y, this._end_x, this._end_y);
        }
    }
}

