/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.planview;

import com.sybase.asa.planview.AccessPlanViewer;
import com.sybase.asa.planview.CustomizeDialog;
import com.sybase.asa.planview.PlanElement;
import com.sybase.asa.planview.PlanElementView;
import com.sybase.asa.planview.PlanSelectionEvent;
import com.sybase.asa.planview.PlanSelectionListener;
import com.sybase.asa.planview.PlanViewHelpManager;
import com.sybase.asa.planview.PlanViewProperties;
import com.sybase.asa.planview.PrintTreeDialog;
import com.sybase.asa.planview.TreeGeometry;
import com.sybase.util.SybMenuItem;
import com.sybase.util.SybMessageFormat;
import com.sybase.util.SybOptionPane;
import com.sybase.util.UIUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import javax.swing.ButtonGroup;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JToolTip;
import javax.swing.ToolTipManager;

public class TreeGraph
extends JPanel
implements ActionListener,
Printable,
KeyListener,
MouseListener {
    protected PlanElementView[] _views;
    private MouseListener[] _viewMouseListener = null;
    private String _name;
    private long _IOCount = 0L;
    private long _rowCount = 0L;
    private double _runtime = 0.0;
    private int _orientation;
    private int _border;
    private int _level_separation;
    private int[] _extremes;
    protected int[] _pages;
    private boolean _print_initialized;
    private double _print_scale;
    private static final int MIN_X = 0;
    private static final int MIN_Y = 1;
    private static final int MAX_X = 2;
    private static final int MAX_Y = 3;
    protected static final int HEAD_FOOT_FONT_SIZE = 8;
    protected static final int HEAD_FOOT_SIZE = 16;
    public static final int PAGES_VERT = 0;
    public static final int PAGES_HORZ = 1;
    public static final int BASIC_BORDER = 1;
    public static final int DETAIL_BORDER = 5;
    public static final int BASIC_LEVEL = 20;
    public static final int DETAIL_LEVEL = 20;
    private static CustomizeDialog _customizeDialog = null;
    private PrintTreeDialog _printDialog = null;
    private ArrayList<PlanSelectionListener> _selection_listeners;
    private ButtonGroup _buttonGroup = new ButtonGroup();
    private JPopupMenu _popup;
    private SybMenuItem _popupHelpItem;
    private String _toolTipFontName;
    private AccessPlanViewer _accessPlanViewer;
    private int _selectedIndex;

    public TreeGraph(PlanElementView[] planElementViewArray, int n, int n2, int n3, String string, AccessPlanViewer accessPlanViewer) {
        this._name = string;
        this._border = n2;
        this._level_separation = n3;
        this._print_initialized = false;
        this._pages = new int[2];
        this._accessPlanViewer = accessPlanViewer;
        ToolTipManager.sharedInstance().setDismissDelay(Integer.MAX_VALUE);
        this._popup = new JPopupMenu();
        SybMenuItem sybMenuItem = new SybMenuItem(AccessPlanViewer.getI18NMessage("popup.customize"));
        sybMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeGraph.this.customizeActionPerformed();
            }
        });
        this._popup.add((JMenuItem)sybMenuItem);
        sybMenuItem = new SybMenuItem(AccessPlanViewer.getI18NMessage("popup.print"));
        sybMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeGraph.this.printTree();
            }
        });
        this._popup.add((JMenuItem)sybMenuItem);
        this._popup.addSeparator();
        this._popupHelpItem = new SybMenuItem(AccessPlanViewer.getI18NMessage("popup.help"));
        this._popupHelpItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TreeGraph.this.helpActionPerformed();
            }
        });
        this._popup.add((JMenuItem)this._popupHelpItem);
        this.setLayout(null);
        this.setBackground(SystemColor.window);
        this._views = planElementViewArray;
        this._orientation = n;
        this._print_scale = 1.0;
        this.addViews();
        this.layoutTree();
        this.reset();
        this.addKeyListener(this);
        this.addMouseListener(this);
    }

    public void subQuerySelect(String string) {
        if (this._accessPlanViewer != null) {
            this._accessPlanViewer.subQuerySelect(string);
        }
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void printTree() {
        Container container;
        for (container = this.getParent(); container != null && !(container instanceof Frame); container = container.getParent()) {
        }
        if (this._printDialog == null) {
            this._printDialog = new PrintTreeDialog((Frame)container, this);
        } else {
            this._printDialog.init(this);
        }
        this._printDialog.setVisible(true);
        Cursor cursor = this.getCursor();
        this.setCursor(new Cursor(3));
        if (this._printDialog.isAccepted()) {
            boolean bl;
            PrinterJob printerJob = this._printDialog.getPrinterJob();
            PageFormat pageFormat = this._printDialog.getPageFormat();
            TreeGraph treeGraph = this._printDialog.getTreeGraph();
            try {
                printerJob.setPrintable(treeGraph, pageFormat);
                printerJob.print();
                bl = true;
            }
            catch (PrinterException printerException) {
                this._print_initialized = false;
                this.setCursor(cursor);
                SybOptionPane.showMessageDialog((Component)this, (Object)SybMessageFormat.format((String)AccessPlanViewer.getI18NMessage("message.print_failed"), (Object[])new Object[]{printerException.getLocalizedMessage()}), (String)AccessPlanViewer.getI18NMessage("error"), (int)0);
                bl = false;
            }
            this._print_initialized = false;
            this.setCursor(cursor);
            if (bl) {
                SybOptionPane.showMessageDialog((Component)this, (Object)AccessPlanViewer.getI18NMessage("message.print_done"), (String)AccessPlanViewer.getI18NMessage("completed"), (int)1);
            }
        } else {
            this._print_initialized = false;
            this.setCursor(cursor);
        }
    }

    public void reset() {
        this._selectedIndex = 0;
        this._views[this._selectedIndex].doClick();
    }

    public void refresh() {
        for (int i = 0; i < this._views.length; ++i) {
            this._views[i].refreshText();
        }
        this.layoutTree();
    }

    public void moveDown() {
        PlanElementView planElementView = this._views[this._selectedIndex];
        if (!planElementView.isLeaf()) {
            this._selectedIndex = planElementView.firstChild();
            this._views[this._selectedIndex].doClick();
        }
    }

    public void moveUp() {
        if (this._selectedIndex != 0) {
            PlanElementView planElementView = this._views[this._selectedIndex];
            this._selectedIndex = planElementView.getElement().parent();
            this._views[this._selectedIndex].doClick();
        }
    }

    public void moveLeft() {
        PlanElementView planElementView;
        if (this._selectedIndex != 0 && this._selectedIndex > (planElementView = this._views[this._views[this._selectedIndex].parent()]).firstChild()) {
            --this._selectedIndex;
            this._views[this._selectedIndex].doClick();
        }
    }

    public void moveRight() {
        PlanElementView planElementView;
        if (this._selectedIndex != 0 && this._selectedIndex < (planElementView = this._views[this._views[this._selectedIndex].parent()]).lastChild()) {
            ++this._selectedIndex;
            this._views[this._selectedIndex].doClick();
        }
    }

    void showHelp() {
        PlanElementView planElementView = this._views[this._selectedIndex];
        if (planElementView != null) {
            planElementView.showHelp();
        }
    }

    public void setNodes(PlanElementView[] planElementViewArray) {
        this.removeAll();
        this._views = planElementViewArray;
        this.addViews();
        this.layoutTree();
    }

    public PlanElementView[] getNodes() {
        return this._views;
    }

    public void layoutTree() {
        this.generateOffsets();
        this._extremes = null;
        this.plantTree(this._views[0], 0, 0);
        this.placeNodes();
    }

    private void generateOffsets() {
        for (int i = this._views.length - 1; i >= 0; --i) {
            PlanElementView planElementView = this._views[i];
            if (!planElementView.isLeaf()) {
                planElementView.setupGeometry(this._orientation);
                planElementView.getGeometry().mergeWithChildren(planElementView.getChildGeometries(this._views), this._border, this._level_separation, this._orientation);
                continue;
            }
            planElementView.setupGeometry(this._orientation, this._border);
        }
    }

    private void plantTree(PlanElementView planElementView, int n, int n2) {
        TreeGeometry treeGeometry = planElementView.getGeometry();
        treeGeometry.setPosition(n, n2, this._orientation);
        this.adjustExtremes(treeGeometry);
        if (!planElementView.isLeaf()) {
            int n3 = planElementView.firstChild();
            PlanElementView planElementView2 = this._views[n3];
            TreeGeometry treeGeometry2 = planElementView2.getGeometry();
            int n4 = treeGeometry.getX() + treeGeometry2.getXOffset(this._orientation);
            int n5 = treeGeometry.getY() + treeGeometry2.getYOffset(this._orientation);
            this.plantTree(planElementView2, treeGeometry.getX(), treeGeometry.getY());
            ++n3;
            while (n3 <= planElementView.lastChild()) {
                planElementView2 = this._views[n3];
                treeGeometry2 = planElementView2.getGeometry();
                this.plantTree(planElementView2, n4, n5);
                n4 += treeGeometry2.getXOffset(this._orientation);
                n5 += treeGeometry2.getYOffset(this._orientation);
                ++n3;
            }
        }
        this.connectToParent(planElementView);
    }

    private void placeNodes() {
        PlanElementView planElementView = this._views[0];
        TreeGeometry treeGeometry = planElementView.getGeometry();
        planElementView.setLocation(treeGeometry.getX() - this._extremes[0], treeGeometry.getY() - this._extremes[1]);
        for (int i = 1; i < this._views.length; ++i) {
            planElementView = this._views[i];
            treeGeometry = planElementView.getGeometry();
            planElementView.setLocation(treeGeometry.getX() - this._extremes[0], treeGeometry.getY() - this._extremes[1]);
            treeGeometry.getLineToParent().offset(-this._extremes[0], -this._extremes[1]);
        }
    }

    private String getToolTipFont() {
        if (this._toolTipFontName == null) {
            JToolTip jToolTip = new JToolTip();
            jToolTip.setTipText("text");
            Font font = jToolTip.getFont();
            this._toolTipFontName = font.getName();
        }
        return this._toolTipFontName;
    }

    private void addViews() {
        PlanElementView planElementView;
        int n;
        for (n = 0; n < this._views.length; ++n) {
            planElementView = this._views[n];
            planElementView.setToolTipFont(this.getToolTipFont());
            if (this._rowCount < planElementView.getElement().getRowCount()) {
                this._rowCount = planElementView.getElement().getRowCount();
            }
            if (!(this._runtime < planElementView.getElement().getRuntime())) continue;
            this._runtime = planElementView.getElement().getRuntime();
        }
        if (this._rowCount < 10L) {
            this._rowCount = 10L;
        }
        for (n = 0; n < this._views.length; ++n) {
            this._views[n].initGraphicalStats(this._rowCount, this._runtime, this._views);
        }
        this._viewMouseListener = new MouseListener[this._views.length];
        for (n = 0; n < this._views.length; ++n) {
            planElementView = this._views[n];
            this.processView(planElementView, n);
        }
    }

    private void processView(final PlanElementView planElementView, final int n) {
        this._buttonGroup.add(planElementView);
        this._viewMouseListener[n] = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                TreeGraph.this.requestFocus();
                TreeGraph.this._selectedIndex = n;
                planElementView.doClick();
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        };
        planElementView.addMouseListener(this._viewMouseListener[n]);
        planElementView.setParentTree(this);
        this.add(planElementView);
        planElementView.addActionListener(this);
    }

    @Override
    public boolean isFocusable() {
        return true;
    }

    private void connectToParent(PlanElementView planElementView) {
        int n = planElementView.parent();
        if (n != -1) {
            planElementView.getGeometry().makeLineToParent(this._views[n].getGeometry(), this._orientation);
        } else {
            planElementView.getGeometry().clearLineToParent();
        }
    }

    private void adjustExtremes(TreeGeometry treeGeometry) {
        if (this._extremes == null) {
            this._extremes = new int[]{treeGeometry.getX(), treeGeometry.getY(), treeGeometry.getX() + treeGeometry.getWidth(this._orientation), treeGeometry.getY() + treeGeometry.getHeight(this._orientation)};
        }
        this._extremes[0] = Math.min(treeGeometry.getX(), this._extremes[0]);
        this._extremes[1] = Math.min(treeGeometry.getY(), this._extremes[1]);
        this._extremes[2] = Math.max(treeGeometry.getX() + treeGeometry.getWidth(this._orientation), this._extremes[2]);
        this._extremes[3] = Math.max(treeGeometry.getY() + treeGeometry.getHeight(this._orientation), this._extremes[3]);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this._extremes[2] - this._extremes[0] + 50, this._extremes[3] - this._extremes[1] + 50);
    }

    @Override
    protected void paintComponent(Graphics graphics) {
        this.refresh();
        super.paintComponent(graphics);
        graphics.setColor(PlanViewProperties.getLineColor());
        this.paintLines(graphics);
    }

    @Override
    protected void printChildren(Graphics graphics) {
    }

    @Override
    protected void printComponent(Graphics graphics) {
        graphics.setColor(Color.white);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        graphics.setColor(Color.black);
        this.paintLines(graphics);
        for (int i = 0; i < this._views.length; ++i) {
            graphics.translate(this._views[i].getX(), this._views[i].getY());
            this._views[i].print(graphics);
            graphics.translate(-this._views[i].getX(), -this._views[i].getY());
        }
    }

    @Override
    protected void printBorder(Graphics graphics) {
    }

    private void paintLines(Graphics graphics) {
        for (int i = 1; i < this._views.length; ++i) {
            ((Graphics2D)graphics).setStroke(new BasicStroke(this._views[i].getLineThickness(), 1, 1));
            this._views[i].getGeometry().getLineToParent().paint(graphics);
        }
        ((Graphics2D)graphics).setStroke(new BasicStroke(1.0f));
    }

    public void addPlanSelectionListener(PlanSelectionListener planSelectionListener) {
        if (this._selection_listeners == null) {
            this._selection_listeners = new ArrayList();
        }
        this._selection_listeners.add(planSelectionListener);
    }

    public void removePlanSelectionListener(PlanSelectionListener planSelectionListener) {
        if (this._selection_listeners != null) {
            this._selection_listeners.remove(planSelectionListener);
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        PlanElement planElement = ((PlanElementView)actionEvent.getSource()).getElement();
        PlanSelectionEvent planSelectionEvent = new PlanSelectionEvent(planElement, this);
        if (this._selection_listeners != null) {
            for (int i = this._selection_listeners.size() - 1; i >= 0; --i) {
                PlanSelectionListener planSelectionListener = this._selection_listeners.get(i);
                planSelectionListener.elementSelected(planSelectionEvent);
            }
        }
    }

    void customizeActionPerformed() {
        Serializable serializable;
        this._popup.setVisible(false);
        if (_customizeDialog == null) {
            for (serializable = this.getParent(); serializable != null && !(serializable instanceof Frame); serializable = ((Component)serializable).getParent()) {
            }
            _customizeDialog = new CustomizeDialog((Frame)serializable);
        }
        UIUtils.ensureWindowIsVisible((Window)((Object)_customizeDialog));
        _customizeDialog.setVisible(true);
        serializable = this.getCursor();
        this.setCursor(new Cursor(3));
        this.refresh();
        this.setSize(this.getPreferredSize());
        this.setCursor((Cursor)serializable);
    }

    private void helpActionPerformed() {
        PlanViewHelpManager.INSTANCE.openGeneralHelp();
    }

    public void setPrintScale(double d, int[] nArray, PageFormat pageFormat) {
        int n;
        this._print_scale = d;
        for (n = 0; n < this._views.length; ++n) {
            this._views[n].setPrinting(true);
        }
        this.refresh();
        this.setSize(this.getPreferredSize());
        for (n = 0; n < this._views.length; ++n) {
            this._views[n].setPrinting(false);
        }
        nArray[0] = (int)(((double)this.getHeight() * this._print_scale + 16.0) / pageFormat.getImageableHeight()) + 1;
        nArray[1] = (int)((double)this.getWidth() * this._print_scale / pageFormat.getImageableWidth()) + 1;
    }

    public double setPrintScale(int n, int n2, PageFormat pageFormat) {
        double d;
        int n3;
        double d2 = (double)n * pageFormat.getImageableWidth();
        double d3 = (double)n2 * pageFormat.getImageableHeight();
        for (n3 = 0; n3 < this._views.length; ++n3) {
            this._views[n3].setPrinting(true);
        }
        this.refresh();
        this.setSize(this.getPreferredSize());
        for (n3 = 0; n3 < this._views.length; ++n3) {
            this._views[n3].setPrinting(false);
        }
        double d4 = d2 / (double)(this.getWidth() + 1);
        this._print_scale = d4 < (d = (d3 - 16.0) / (double)(this.getHeight() + 1)) ? d4 : d;
        return this._print_scale;
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        int n2;
        Graphics2D graphics2D = (Graphics2D)graphics;
        int n3 = 1;
        if (!this._print_initialized) {
            this._print_initialized = true;
            for (n2 = 0; n2 < this._views.length; ++n2) {
                this._views[n2].setPrinting(true);
            }
            this.refresh();
            this.setSize(this.getPreferredSize());
            this._pages[0] = (int)(((double)this.getHeight() * this._print_scale + 16.0) / pageFormat.getImageableHeight()) + 1;
            this._pages[1] = (int)((double)this.getWidth() * this._print_scale / pageFormat.getImageableWidth()) + 1;
            this.preparePrintout(graphics2D, pageFormat, n);
        } else if (n < this._pages[1] * this._pages[0]) {
            for (n2 = 0; n2 < this._views.length; ++n2) {
                this._views[n2].setPrinting(true);
            }
        }
        if (n < this._pages[1] * this._pages[0]) {
            if (n == 0) {
                graphics2D.translate(0, 16);
            }
            graphics2D.translate((int)pageFormat.getImageableX() + 1, (int)pageFormat.getImageableY() + 1);
            graphics2D.setClip(0, 0, (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableHeight());
            AffineTransform affineTransform = new AffineTransform(this._print_scale, 0.0, 0.0, this._print_scale, -((double)(n % this._pages[1]) * pageFormat.getImageableWidth()), -((double)(n / this._pages[1]) * pageFormat.getImageableHeight()));
            graphics2D.transform(affineTransform);
            this.print(graphics2D);
            try {
                graphics2D.transform(affineTransform.createInverse());
            }
            catch (NoninvertibleTransformException noninvertibleTransformException) {
                throw new RuntimeException("Failed to invert transformation matrix");
            }
            if (n == 0) {
                graphics2D.translate(0, -16);
            }
            graphics2D.translate(-((int)pageFormat.getImageableX()), -((int)pageFormat.getImageableY()));
            graphics2D.setClip(0, 0, (int)pageFormat.getWidth(), (int)pageFormat.getHeight());
            this.printMargins(graphics2D, pageFormat, n);
            n3 = 0;
            for (int i = 0; i < this._views.length; ++i) {
                this._views[i].setPrinting(false);
            }
        } else {
            n3 = this.endPrintout(graphics2D, pageFormat, n);
        }
        return n3;
    }

    protected int endPrintout(Graphics2D graphics2D, PageFormat pageFormat, int n) {
        return 1;
    }

    protected void preparePrintout(Graphics2D graphics2D, PageFormat pageFormat, int n) {
    }

    private void printMargins(Graphics2D graphics2D, PageFormat pageFormat, int n) {
        graphics2D.setColor(Color.white);
        graphics2D.fillRect(0, 0, (int)pageFormat.getImageableX(), (int)pageFormat.getHeight());
        graphics2D.fillRect((int)(pageFormat.getImageableX() + pageFormat.getImageableWidth()), 0, (int)pageFormat.getWidth(), (int)pageFormat.getHeight());
        graphics2D.fillRect((int)pageFormat.getImageableX(), 0, (int)pageFormat.getImageableWidth(), (int)pageFormat.getImageableY());
        graphics2D.fillRect((int)pageFormat.getImageableX(), (int)(pageFormat.getImageableY() + pageFormat.getImageableHeight()), (int)pageFormat.getImageableWidth(), (int)pageFormat.getHeight());
        graphics2D.setColor(Color.black);
        if (n == 0) {
            this.printHeader(graphics2D, pageFormat);
        }
        if (this._pages[1] * this._pages[0] > 1) {
            this.printFooter(graphics2D, pageFormat, n);
            graphics2D.setStroke(new BasicStroke(0.25f));
            int n2 = (int)pageFormat.getImageableX();
            int n3 = (int)pageFormat.getImageableY();
            graphics2D.drawLine(n2 - 9, n3, n2, n3);
            graphics2D.drawLine(n2, n3 - 9, n2, n3);
            n2 = (int)(pageFormat.getImageableX() + pageFormat.getImageableWidth());
            graphics2D.drawLine(n2, n3, n2 + 9, n3);
            graphics2D.drawLine(n2, n3 - 9, n2, n3);
            n3 = (int)(pageFormat.getImageableY() + pageFormat.getImageableHeight());
            graphics2D.drawLine(n2, n3, n2 + 9, n3);
            graphics2D.drawLine(n2, n3, n2, n3 + 9);
            n2 = (int)pageFormat.getImageableX();
            graphics2D.drawLine(n2 - 9, n3, n2, n3);
            graphics2D.drawLine(n2, n3, n2, n3 + 9);
        }
    }

    private void printHeader(Graphics2D graphics2D, PageFormat pageFormat) {
        Date date = new Date(System.currentTimeMillis());
        Object[] objectArray = new Object[]{date, this._name};
        String string = SybMessageFormat.format((String)AccessPlanViewer.getI18NMessage("printable.header"), (Object[])objectArray);
        graphics2D.setFont(new Font(null, 0, 8));
        graphics2D.drawString(string, (int)pageFormat.getImageableX(), (int)((double)graphics2D.getFontMetrics().getMaxAscent() + pageFormat.getImageableY()));
    }

    private void printFooter(Graphics2D graphics2D, PageFormat pageFormat, int n) {
        Date date = new Date(System.currentTimeMillis());
        Object[] objectArray = new Object[]{date, this._name};
        String string = SybMessageFormat.format((String)AccessPlanViewer.getI18NMessage("printable.header"), (Object[])objectArray);
        graphics2D.setFont(graphics2D.getFont().deriveFont(0, 8.0f));
        int n2 = graphics2D.getFontMetrics().stringWidth(string);
        graphics2D.drawString(string, (int)(pageFormat.getImageableX() + (pageFormat.getImageableWidth() - (double)n2) / 2.0), (int)((double)graphics2D.getFontMetrics().getMaxAscent() + pageFormat.getImageableY() + pageFormat.getImageableHeight()));
        int n3 = n / this._pages[1];
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = AccessPlanViewer.getI18NMessage("printable.row_ids");
        do {
            stringBuffer.insert(0, string2.charAt(n3 % string2.length()));
            n3 /= string2.length();
        } while (--n3 >= 0);
        objectArray[0] = stringBuffer.toString();
        objectArray[1] = new Integer(n % this._pages[1] + 1);
        String string3 = SybMessageFormat.format((String)AccessPlanViewer.getI18NMessage("printable.footer"), (Object[])objectArray);
        n2 = graphics2D.getFontMetrics().stringWidth(string3);
        graphics2D.drawString(string3, (int)(pageFormat.getImageableX() + (pageFormat.getImageableWidth() - (double)n2) / 2.0), (int)((double)(graphics2D.getFontMetrics().getMaxAscent() + 8) + pageFormat.getImageableY() + pageFormat.getImageableHeight()));
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 38: {
                this.moveUp();
                break;
            }
            case 40: {
                this.moveDown();
                break;
            }
            case 37: {
                this.moveLeft();
                break;
            }
            case 39: {
                this.moveRight();
                break;
            }
            case 112: {
                this.showHelp();
                keyEvent.consume();
                break;
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.requestFocus();
        this.maybeShowPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this._popupHelpItem.setEnabled(!PlanViewHelpManager.INSTANCE.getShowAsDisabled());
            this._popup.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    void destroy() {
        this.removeAll();
        this.removeKeyListener(this);
        this.removeMouseListener(this);
        if (this._selection_listeners != null) {
            this._selection_listeners.clear();
            this._selection_listeners = null;
        }
        this._buttonGroup = null;
        this._popup = null;
        this._popupHelpItem = null;
        this._accessPlanViewer = null;
        if (this._views != null) {
            for (int i = 0; i < this._views.length; ++i) {
                this._views[i].destroy();
                this._views[i].removeMouseListener(this._viewMouseListener[i]);
                this._viewMouseListener[i] = null;
                this._views[i] = null;
            }
        }
        this._viewMouseListener = null;
        this._views = null;
    }
}

