/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.propertyViewer;

import com.sybase.asa.common.ASAComponentsImageLoader;
import com.sybase.asa.common.ArrayListTableModel;
import com.sybase.asa.common.DatabaseVersion;
import com.sybase.asa.common.FastCellRenderer;
import com.sybase.asa.common.event.DatabaseErrorEvent;
import com.sybase.asa.common.event.DatabaseErrorListener;
import com.sybase.asa.propertyViewer.DBPropertyViewerCustomizationPage;
import com.sybase.asa.propertyViewer.DBPropertyViewerProperties;
import com.sybase.asa.propertyViewer.ReflectiveAction;
import com.sybase.customization.Customizable;
import com.sybase.customization.CustomizationPage;
import com.sybase.customization.CustomizeDialog;
import com.sybase.customization.CustomizerHost;
import com.sybase.util.DBConnectionAgent;
import com.sybase.util.Platform;
import com.sybase.util.SwingWorker;
import com.sybase.util.SybMenuItem;
import com.sybase.util.UIUtils;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DBPropertyViewer
extends JPanel
implements Customizable,
MouseListener,
ChangeListener {
    DBConnectionAgent _connectionAgent = null;
    int _refreshRate;
    JTabbedPane _propertyTabPane;
    HashMap<Object, Object> _serverPropertyDescriptions = new HashMap();
    int _serverPropertyHashCode = -1;
    ArrayList<String> _serverPropertyList;
    String _serverPropertiesSelect;
    ArrayList<Object> _serverName;
    JPanel _serverPropertiesPanel;
    ReadOnlyTable _serverProperties;
    JTable _serverPropertyHeader;
    JScrollPane _serverPropertiesScrollPane;
    private SwingWorker _refreshWorker = null;
    private boolean _workerBusy = false;
    private JPopupMenu _popupMenu;
    CustomizeDialog _customizeDialog = null;
    CustomizerHost _customizerHost = null;
    HashMap<Object, Object> _databasePropertyDescriptions = new HashMap();
    int _databasePropertyHashCode = -1;
    ArrayList<String> _databasePropertyList;
    String _databasePropertiesSelect;
    Insets _insets5505 = new Insets(5, 5, 0, 5);
    JPanel _databasePropertiesPanel;
    ReadOnlyTable _databaseProperties;
    JTable _databasePropertyHeader;
    JScrollPane _databasePropertiesScrollPane;
    SimpleCellRenderer _simpleCellRenderer = new SimpleCellRenderer();
    Timer _timer;
    private EventListenerList _listenerList = new EventListenerList();
    static String _helpFolder;
    static String _helpPrefix;
    static String _helpSuffix;
    static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    private Action _customizeAction;
    static final String CUSTOMIZER_DISPLAY = "customizer.display";
    static final String CUSTOMIZER_PROPERTY_NAME = "customizer.propertyName";
    static final String CUSTOMIZER_PROPERTY_DESCRIPTION = "customizer.propertyDescription";
    static final String CUSTOMIZER_SERVER = "customizer.server";
    static final String CUSTOMIZER_SERVER_PROPERTIES = "customizer.serverProperties";
    static final String CUSTOMIZER_DATABASES = "customizer.databases";
    static final String CUSTOMIZER_DATABASE_PROPERTIES = "customizer.databaseProperties";
    static final String CUSTOMIZER_SERVER_SELECT = "customizer.serverSelect";
    static final String CUSTOMIZER_DATABASE_SELECT = "customizer.databaseSelect";
    static final String CUSTOMIZER_REFRESH_RATE = "customizer.refreshRate";
    static final String CUSTOMIZER_REFRESH_RATE_TIP = "customizer.refreshRateTip";
    static final String CUSTOMIZER_SECONDS = "customizer.seconds";
    static final String CUSTOMIZER_PROPERTY_ERROR = "customizer.property.error";
    static final String CUSTOMIZER_PROPERTY_ERROR_TITLE = "customizer.property.error.title";
    static final String CUSTOMIZE_MENUITEM = "dbpropertyviewer.customizeMenuItem";
    static final String CUSTOMIZE_MENUITEM_MAC = "dbpropertyviewer.customizeMenuItem_Mac";
    static final String PROPERTY_VIEWER = "dbpropertyviewer.propertyViewer";

    public DBPropertyViewer(DBConnectionAgent dBConnectionAgent) {
        this(dBConnectionAgent, DBPropertyViewerProperties.getRefreshRate());
    }

    public DBPropertyViewer(DBConnectionAgent dBConnectionAgent, int n) {
        Object object;
        DBPropertyViewerProperties.load();
        this._databasePropertyHeader = new JTable(new RowHeaderTableModel(null));
        this._databasePropertyHeader.setShowHorizontalLines(false);
        this._databasePropertyHeader.setShowVerticalLines(true);
        this._databasePropertyHeader.setRowSelectionAllowed(false);
        this._serverPropertyHeader = new JTable(new RowHeaderTableModel(null));
        this._serverPropertyHeader.setShowHorizontalLines(false);
        this._serverPropertyHeader.setShowVerticalLines(true);
        this._serverPropertyHeader.setRowSelectionAllowed(false);
        if (dBConnectionAgent != null) {
            object = new ConnectionWorker(dBConnectionAgent);
            object.start();
        }
        this._timer = new Timer(n, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBPropertyViewer.this.refresh();
            }
        });
        this._timer.setInitialDelay(0);
        this._customizeAction = new ReflectiveAction(this, "customizeActionPerformed", Platform.isMacOS() ? DBPropertyViewer.getI18NMessage(CUSTOMIZE_MENUITEM_MAC) : DBPropertyViewer.getI18NMessage(CUSTOMIZE_MENUITEM));
        this._customizeAction.setEnabled(false);
        this._popupMenu = new JPopupMenu();
        this._popupMenu.add((JMenuItem)new SybMenuItem(this._customizeAction));
        object = new GridBagLayout();
        this.setLayout((LayoutManager)object);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this._propertyTabPane = new JTabbedPane();
        this._propertyTabPane.setTabPlacement(1);
        this._serverPropertiesPanel = new JPanel();
        this._databasePropertiesPanel = new JPanel();
        this._propertyTabPane.addTab(DBPropertyViewer.getI18NMessage(CUSTOMIZER_DATABASES), this._databasePropertiesPanel);
        this._propertyTabPane.addTab(DBPropertyViewer.getI18NMessage(CUSTOMIZER_SERVER), this._serverPropertiesPanel);
        this._propertyTabPane.addChangeListener(this);
        this._propertyTabPane.setSelectedIndex(0);
        this._propertyTabPane.addChangeListener(this);
        this.add(this._propertyTabPane);
        ((GridBagLayout)object).setConstraints(this._propertyTabPane, gridBagConstraints);
        this._serverPropertiesScrollPane = new JScrollPane();
        if (Platform.isMacOS()) {
            this._serverPropertiesScrollPane.setVerticalScrollBarPolicy(22);
            this._serverPropertiesScrollPane.setHorizontalScrollBarPolicy(32);
        } else {
            this._serverPropertiesScrollPane.setVerticalScrollBarPolicy(20);
            this._serverPropertiesScrollPane.setHorizontalScrollBarPolicy(30);
        }
        this._serverPropertiesScrollPane.addMouseListener(this);
        this._serverProperties = new ReadOnlyTable(new ArrayListTableModel(new ArrayList<ArrayList<Object>>(), this._serverName));
        this._serverProperties.setOpaque(true);
        this._serverProperties.setShowHorizontalLines(true);
        this._serverProperties.setShowVerticalLines(true);
        this._serverProperties.setAutoResizeMode(0);
        this._serverProperties.setSelectionMode(0);
        this._serverProperties.getTableHeader().setReorderingAllowed(false);
        this._serverProperties.addMouseListener(this);
        this._serverProperties.unregisterKeyboardAction(KeyStroke.getKeyStroke(113, 0));
        this._serverPropertiesScrollPane.getViewport().setBackground(this._serverProperties.getBackground());
        this._serverPropertiesScrollPane.getViewport().add(this._serverProperties);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 0, 0));
        jPanel.add(this._serverPropertyHeader);
        jPanel.setBackground(this._serverPropertyHeader.getBackground());
        this._serverPropertiesScrollPane.setRowHeaderView(jPanel);
        this._serverPropertiesPanel.add(this._serverPropertiesScrollPane);
        object = new GridBagLayout();
        this._serverPropertiesPanel.setLayout((LayoutManager)object);
        ((GridBagLayout)object).setConstraints(this._serverPropertiesScrollPane, gridBagConstraints);
        this._databasePropertiesScrollPane = new JScrollPane();
        if (Platform.isMacOS()) {
            this._databasePropertiesScrollPane.setVerticalScrollBarPolicy(22);
            this._databasePropertiesScrollPane.setHorizontalScrollBarPolicy(32);
        } else {
            this._databasePropertiesScrollPane.setVerticalScrollBarPolicy(20);
            this._databasePropertiesScrollPane.setHorizontalScrollBarPolicy(30);
        }
        this._databasePropertiesScrollPane.addMouseListener(this);
        this._databaseProperties = new ReadOnlyTable(new ArrayListTableModel(new ArrayList<ArrayList<Object>>(), new ArrayList<Object>()));
        this._databaseProperties.setOpaque(true);
        this._databaseProperties.setShowHorizontalLines(true);
        this._databaseProperties.setShowVerticalLines(true);
        this._databaseProperties.setAutoResizeMode(0);
        this._databaseProperties.setSelectionMode(0);
        this._databaseProperties.getTableHeader().setReorderingAllowed(false);
        this._databaseProperties.addMouseListener(this);
        this._databaseProperties.unregisterKeyboardAction(KeyStroke.getKeyStroke(113, 0));
        this._databasePropertiesScrollPane.getViewport().setBackground(this._databaseProperties.getBackground());
        this._databasePropertiesScrollPane.getViewport().add(this._databaseProperties);
        jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(1, 0, 0));
        jPanel.add(this._databasePropertyHeader);
        jPanel.setBackground(this._databasePropertyHeader.getBackground());
        this._databasePropertiesScrollPane.setRowHeaderView(jPanel);
        this._databasePropertiesPanel.add(this._databasePropertiesScrollPane);
        object = new GridBagLayout();
        this._databasePropertiesPanel.setLayout((LayoutManager)object);
        ((GridBagLayout)object).setConstraints(this._databasePropertiesScrollPane, gridBagConstraints);
        this.setRefreshRate(n);
    }

    public void setConnectionAgent(DBConnectionAgent dBConnectionAgent) {
        this._connectionAgent = dBConnectionAgent;
        if (this._connectionAgent != null) {
            this._databasePropertyList = DBPropertyViewerProperties.getDatabasePropertyList();
            this._serverPropertyList = DBPropertyViewerProperties.getServerPropertyList();
            this._databasePropertyHashCode = -1;
            this._serverPropertyHashCode = -1;
            this.collectPropertyDescriptions();
            this.checkPropertyList();
            this._customizeAction.setEnabled(true);
        } else {
            this.stopRefreshing();
            this.clearDisplay();
            this._customizeAction.setEnabled(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void collectPropertyDescriptions() {
        Connection connection = this._connectionAgent.getConnection();
        try {
            String string;
            String string2;
            this._serverName = new ArrayList(1);
            PreparedStatement preparedStatement = connection.prepareStatement("SELECT property( 'name' )");
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            this._serverName.add(resultSet.getString(1));
            preparedStatement.close();
            preparedStatement = connection.prepareStatement("select property_name( i ) as prop, property_description( i ) as description from ( select row_num-1 from dbo.RowGenerator union all select row_num +254 from dbo.RowGenerator ) as r( i ) where property( prop ) is not null       and not exists (select * from SYS.SYSOPTION where \"option\"=prop and user_id=2) order by prop");
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
                string = resultSet.getString(2);
                if (string == null || string.trim().length() == 0) {
                    string = string2;
                }
                this._serverPropertyDescriptions.put(string2.toLowerCase(), string);
            }
            preparedStatement.close();
            preparedStatement = DatabaseVersion.getDatabaseVersion(connection.getMetaData().getDatabaseProductVersion()).getMajorVersion() > 9 ? connection.prepareStatement("select property_name(row_num) as PropName, property_description(row_num) as PropDescription, db_property( row_num, Number ) as Value from dbo.sa_rowgenerator(1,property('LastDatabaseProperty')),dbo.sa_db_list() where PropName is not null and Value is not null order by PropName ") : connection.prepareStatement("SELECT property_name( i ) as prop, property_description( i ) as description from ( select row_num-1 from dbo.RowGenerator union all select row_num +254 from dbo.RowGenerator ) as r( i ) where db_property( prop ) is not null       and (prop in ('Compression') or not exists (select * from SYS.SYSOPTION where \"option\"=prop and user_id=2)) order by prop");
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                string2 = resultSet.getString(1);
                string = resultSet.getString(2);
                if (string == null || string.trim().length() == 0) {
                    string = string2;
                }
                this._databasePropertyDescriptions.put(string2.toLowerCase(), string);
            }
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            this._connectionAgent.freeConnection(connection);
            this.fireDatabaseError(this, sQLException);
        }
        finally {
            this._connectionAgent.freeConnection(connection);
        }
    }

    public DBConnectionAgent getConnectionAgent() {
        return this._connectionAgent;
    }

    public void setRefreshRate(int n) {
        this._refreshRate = n;
        this._timer.stop();
        if (this._refreshRate > 0) {
            this._timer.setInitialDelay(0);
            this._timer.setDelay(this._refreshRate);
            this._timer.start();
        }
    }

    public int getRefreshRate() {
        return this._refreshRate;
    }

    public void refresh() {
        if (this._connectionAgent == null) {
            return;
        }
        if (this._timer != null && !this._timer.isRunning()) {
            this._timer.restart();
        }
        this.refreshProperties();
    }

    public void stopRefreshing() {
        this._timer.stop();
        this._refreshWorker.interrupt();
    }

    void clearDisplay() {
        this._serverPropertyHashCode = -1;
        this._serverPropertyHeader.setModel(new RowHeaderTableModel(null));
        this._serverName = new ArrayList();
        ((ArrayListTableModel)this._serverProperties.getModel()).setDataArrayList(new ArrayList<ArrayList<Object>>(), this._serverName);
        this._serverProperties.updateUI();
        this._databasePropertyHashCode = -1;
        this._databasePropertyHeader.setModel(new RowHeaderTableModel(null));
        ((ArrayListTableModel)this._databaseProperties.getModel()).setDataArrayList(new ArrayList<ArrayList<Object>>(), new ArrayList<Object>());
        this._databaseProperties.updateUI();
    }

    void checkPropertyList() {
        int n;
        String[] stringArray;
        int n2;
        if (this._serverPropertyList == null) {
            return;
        }
        int n3 = this._serverPropertyList.hashCode();
        if (this._serverPropertyHeader.isDisplayable() && n3 != this._serverPropertyHashCode) {
            this._serverPropertyHashCode = n3;
            this._serverPropertiesSelect = null;
            for (int i = this._serverPropertyList.size() - 1; i > -1; --i) {
                if (this._serverPropertyDescriptions.get(this._serverPropertyList.get(i)) != null) continue;
                this._serverPropertyList.remove(i);
            }
            FontMetrics fontMetrics = this._serverPropertyHeader.getFontMetrics(this._serverPropertyHeader.getFont());
            n2 = 0;
            stringArray = new String[this._serverPropertyList.size()];
            n = this._serverPropertyList.size();
            for (int i = 0; i < n; ++i) {
                String string;
                stringArray[i] = string = (String)this._serverPropertyDescriptions.get(this._serverPropertyList.get(i).toLowerCase());
                int n4 = fontMetrics.stringWidth(string);
                if (n4 <= n2) continue;
                n2 = n4;
            }
            this._serverPropertyHeader.setModel(new RowHeaderTableModel(stringArray));
            this._serverPropertyHeader.getColumnModel().getColumn(0).setCellRenderer(this._simpleCellRenderer);
            this._serverPropertyHeader.getColumnModel().getColumn(0).setPreferredWidth(n2 + 4);
            StringBuffer stringBuffer = new StringBuffer(256).append("SELECT ");
            int n5 = this._serverPropertyList.size();
            for (n = 0; n < n5; ++n) {
                String string = this._serverPropertyList.get(n);
                stringBuffer.append("property( '").append(string).append("' ), ");
            }
            n = stringBuffer.length() - 2;
            stringBuffer.replace(n, n + 2, "");
            this._serverPropertiesSelect = stringBuffer.toString();
        }
        if (this._databasePropertyList == null) {
            return;
        }
        n3 = this._databasePropertyList.hashCode();
        if (this._databasePropertyHeader.isDisplayable() && n3 != this._databasePropertyHashCode) {
            this._databasePropertyHashCode = n3;
            this._databasePropertiesSelect = null;
            for (int i = this._databasePropertyList.size() - 1; i > -1; --i) {
                if (this._databasePropertyDescriptions.get(this._databasePropertyList.get(i)) != null) continue;
                this._databasePropertyList.remove(i);
            }
            FontMetrics fontMetrics = this._databasePropertyHeader.getFontMetrics(this._databasePropertyHeader.getFont());
            n2 = 0;
            stringArray = new String[this._databasePropertyList.size()];
            n = this._databasePropertyList.size();
            for (int i = 0; i < n; ++i) {
                String string = (String)this._databasePropertyDescriptions.get(this._databasePropertyList.get(i).toLowerCase());
                if (string == null) continue;
                stringArray[i] = string;
                int n6 = fontMetrics.stringWidth(string);
                if (n6 <= n2) continue;
                n2 = n6;
            }
            this._databasePropertyHeader.setModel(new RowHeaderTableModel(stringArray));
            this._databasePropertyHeader.getColumnModel().getColumn(0).setCellRenderer(this._simpleCellRenderer);
            this._databasePropertyHeader.getColumnModel().getColumn(0).setPreferredWidth(n2 + 4);
            StringBuffer stringBuffer = new StringBuffer(1000).append("begin\n    declare current_db_id int;\n    declare local temporary table db_info(\n        ___Name    varchar( 255 ) null");
            StringBuffer stringBuffer2 = new StringBuffer(1000);
            int n7 = this._databasePropertyList.size();
            for (int i = 0; i < n7; ++i) {
                String string = this._databasePropertyList.get(i);
                stringBuffer.append(",\n ").append(string).append(" varchar( 255 ) null");
                stringBuffer2.append(",\n db_property ( '").append(string).append("', current_db_id )");
            }
            stringBuffer.append("    ) in SYSTEM not transactional;\n    set current_db_id = null;\n    database_loop:\n    loop\n        set current_db_id = NEXT_DATABASE( current_db_id );\n        if current_db_id is NULL then\n            leave database_loop\n        end if;\n        insert into db_info values(\n            DB_NAME( current_db_id )\n");
            stringBuffer.append(stringBuffer2);
            stringBuffer.append("        );\n    end loop database_loop;\n    select * from db_info;\nend\n");
            this._databasePropertiesSelect = stringBuffer.toString();
        }
    }

    void refreshProperties() {
        if (this._connectionAgent != null) {
            this.checkPropertyList();
            if (this._refreshWorker != null && this._workerBusy) {
                this._refreshWorker.interrupt();
            }
            if (this._serverPropertiesPanel.isVisible() && this._serverPropertiesSelect != null && !this._workerBusy) {
                this._workerBusy = true;
                this._refreshWorker = new RefreshServerWorker();
                this._refreshWorker.start();
            } else if (this._databasePropertiesPanel.isVisible() && this._databasePropertiesSelect != null && !this._workerBusy) {
                this._workerBusy = true;
                this._refreshWorker = new RefreshDatabaseWorker();
                this._refreshWorker.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PropertySet getServerProperties() {
        PropertySet propertySet = new PropertySet();
        propertySet.success = true;
        propertySet.data = new ArrayList();
        Connection connection = this._connectionAgent.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(this._serverPropertiesSelect);
            ResultSet resultSet = preparedStatement.executeQuery();
            resultSet.next();
            int n = this._serverPropertyList.size();
            for (int i = 0; i < n; ++i) {
                ArrayList<String> arrayList = new ArrayList<String>(1);
                arrayList.add(resultSet.getString(i + 1));
                propertySet.data.add(arrayList);
            }
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            this._connectionAgent.freeConnection(connection);
            this.fireDatabaseError(this, sQLException);
            propertySet.success = false;
        }
        finally {
            this._connectionAgent.freeConnection(connection);
        }
        return propertySet;
    }

    void updateServerDisplay(PropertySet propertySet) {
        if (!propertySet.success) {
            this.stopRefreshing();
            return;
        }
        int n = this._serverProperties.getSelectedRow();
        ((ArrayListTableModel)this._serverProperties.getModel()).setDataArrayList(propertySet.data, this._serverName);
        if (n > -1) {
            try {
                this._serverProperties.setRowSelectionInterval(n, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        FontMetrics fontMetrics = this._serverProperties.getFontMetrics(this._serverProperties.getFont());
        TableColumnModel tableColumnModel = this._serverProperties.getColumnModel();
        int n2 = this._serverProperties.getRowCount();
        int n3 = this._serverProperties.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            int n4 = fontMetrics.stringWidth(this._serverName.get(0).toString()) + 16;
            for (int j = 0; j < n2; ++j) {
                int n5;
                String string = (String)this._serverProperties.getValueAt(j, i);
                if (string == null || (n5 = fontMetrics.stringWidth(string) + 4) <= n4) continue;
                n4 = n5;
            }
            tableColumn.setPreferredWidth(n4);
            tableColumn.setResizable(false);
            tableColumn.setCellRenderer(new FastCellRenderer());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PropertySet getDatabaseProperties() {
        PropertySet propertySet = new PropertySet();
        propertySet.success = true;
        propertySet.data = new ArrayList();
        propertySet.databaseNames = new ArrayList();
        Connection connection = this._connectionAgent.getConnection();
        try {
            PreparedStatement preparedStatement = connection.prepareStatement(this._databasePropertiesSelect);
            ResultSet resultSet = preparedStatement.executeQuery();
            int n = 0;
            while (resultSet.next()) {
                propertySet.databaseNames.add(resultSet.getString(1));
                int n2 = this._databasePropertyList.size() + 1;
                for (int i = 1; i < n2; ++i) {
                    ArrayList<Object> arrayList;
                    if (n == 0) {
                        arrayList = new ArrayList();
                        propertySet.data.add(arrayList);
                    }
                    arrayList = propertySet.data.get(i - 1);
                    arrayList.add(resultSet.getString(i + 1));
                }
                ++n;
            }
            preparedStatement.close();
        }
        catch (SQLException sQLException) {
            this._connectionAgent.freeConnection(connection);
            this.fireDatabaseError(this, sQLException);
            propertySet.success = false;
        }
        finally {
            this._connectionAgent.freeConnection(connection);
        }
        return propertySet;
    }

    void updateDatabaseDisplay(PropertySet propertySet) {
        if (!propertySet.success) {
            this.stopRefreshing();
            return;
        }
        int n = this._databaseProperties.getSelectedRow();
        ((ArrayListTableModel)this._databaseProperties.getModel()).setDataArrayList(propertySet.data, propertySet.databaseNames);
        if (n > -1) {
            try {
                this._databaseProperties.setRowSelectionInterval(n, n);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        FontMetrics fontMetrics = this._databaseProperties.getFontMetrics(this._databaseProperties.getFont());
        TableColumnModel tableColumnModel = this._databaseProperties.getColumnModel();
        int n2 = this._databaseProperties.getRowCount();
        int n3 = this._databaseProperties.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            TableColumn tableColumn = tableColumnModel.getColumn(i);
            tableColumn.sizeWidthToFit();
            int n4 = tableColumn.getPreferredWidth();
            for (int j = 0; j < n2; ++j) {
                int n5;
                String string = (String)this._databaseProperties.getValueAt(j, i);
                if (string == null || (n5 = fontMetrics.stringWidth(string) + 4) <= n4) continue;
                n4 = n5;
            }
            tableColumn.setPreferredWidth(n4);
            tableColumn.setResizable(false);
            tableColumn.setCellRenderer(new FastCellRenderer());
        }
    }

    public void addDatabaseErrorListener(DatabaseErrorListener databaseErrorListener) {
        this._listenerList.add(DatabaseErrorListener.class, databaseErrorListener);
    }

    public void removeDatabaseErrorListener(DatabaseErrorListener databaseErrorListener) {
        this._listenerList.remove(DatabaseErrorListener.class, databaseErrorListener);
    }

    protected void fireDatabaseError(Object object, Exception exception) {
        if (this._timer != null && !this._timer.isRunning()) {
            Object[] objectArray = this._listenerList.getListenerList();
            for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                if (objectArray[i] != DatabaseErrorListener.class) continue;
                ((DatabaseErrorListener)objectArray[i + 1]).databaseError(new DatabaseErrorEvent(object, exception));
            }
        }
    }

    private static ResourceBundle getResourceBundle() {
        ResourceBundle resourceBundle = null;
        String string = System.getProperty("language", System.getProperty("user.language", null));
        String string2 = System.getProperty("country", System.getProperty("user.region", null));
        if (string != null && string2 != null) {
            try {
                resourceBundle = ResourceBundle.getBundle("com.sybase.asa.propertyViewer.DBPropertyViewerResourceBundle", new Locale(string, string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle("com.sybase.asa.propertyViewer.DBPropertyViewerResourceBundle", Locale.getDefault());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            try {
                resourceBundle = ResourceBundle.getBundle("com.sybase.asa.propertyViewer.DBPropertyViewerResourceBundle");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (resourceBundle == null) {
            throw new MissingResourceException("Can't find resource for base name com.sybase.asa.propertyViewer.DBPropertyViewerResourceBundle", "", "");
        }
        return resourceBundle;
    }

    static final String getI18NMessage(String string) {
        String string2 = "";
        try {
            string2 = (String)DBPropertyViewer.getResourceBundle().getObject(string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string2;
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this._popupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger()) {
            this._popupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    public CustomizationPage[] getCustomizationPages() {
        return new CustomizationPage[]{new DBPropertyViewerCustomizationPage(this)};
    }

    public Icon getCustomizationGroupIcon() {
        return ASAComponentsImageLoader.getImageIcon("property_viewer", 1001);
    }

    public String getCustomizationGroupTitle() {
        return DBPropertyViewer.getI18NMessage(PROPERTY_VIEWER);
    }

    public void acceptChanges() {
        DBPropertyViewerProperties.store();
        this._serverPropertyList = DBPropertyViewerProperties.getServerPropertyList();
        this._databasePropertyList = DBPropertyViewerProperties.getDatabasePropertyList();
        this.refreshProperties();
    }

    public void rejectChanges() {
    }

    public CustomizerHost getCustomizerHost() {
        return this._customizerHost;
    }

    public void setCustomizerHost(CustomizerHost customizerHost) {
        this._customizerHost = customizerHost;
    }

    CustomizeDialog getCustomizeDialog(Window window) {
        if (this.getCustomizerHost() != null) {
            return this.getCustomizerHost().getCustomizeDialog(window);
        }
        if (this._customizeDialog == null) {
            this._customizeDialog = window instanceof Dialog ? new CustomizeDialog((Dialog)window) : new CustomizeDialog((Frame)window);
            this._customizeDialog.addCustomizationPages((Customizable)this);
        }
        return this._customizeDialog;
    }

    void customizeActionPerformed() {
        CustomizeDialog customizeDialog = this.getCustomizeDialog(SwingUtilities.windowForComponent(this));
        customizeDialog.selectComponent((Customizable)this);
        UIUtils.ensureWindowIsVisible((Window)customizeDialog);
        customizeDialog.setVisible(true);
    }

    public void destroy() {
        if (this._timer != null) {
            this._timer.stop();
        }
        this._propertyTabPane.removeChangeListener(this);
        this._databaseProperties.removeMouseListener(this);
        this._databasePropertiesScrollPane.removeMouseListener(this);
        this._serverProperties.removeMouseListener(this);
        this._serverPropertiesScrollPane.removeMouseListener(this);
        if (this._customizeDialog != null) {
            this._customizeDialog.destroy();
            this._customizeDialog = null;
        }
    }

    public static void setHelpFolder(String string, String string2, String string3) {
        _helpFolder = string;
        _helpPrefix = string2;
        _helpSuffix = string3;
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        this._timer.restart();
    }

    private class RefreshDatabaseWorker
    extends SwingWorker {
        private RefreshDatabaseWorker() {
        }

        public Object construct() {
            return DBPropertyViewer.this.getDatabaseProperties();
        }

        public void finished() {
            DBPropertyViewer.this._workerBusy = false;
            DBPropertyViewer.this.updateDatabaseDisplay((PropertySet)this.getValue());
        }
    }

    private class RefreshServerWorker
    extends SwingWorker {
        private RefreshServerWorker() {
        }

        public Object construct() {
            return DBPropertyViewer.this.getServerProperties();
        }

        public void finished() {
            DBPropertyViewer.this._workerBusy = false;
            DBPropertyViewer.this.updateServerDisplay((PropertySet)this.getValue());
        }
    }

    class ConnectionWorker
    extends SwingWorker {
        ConnectionWorker(DBConnectionAgent dBConnectionAgent) {
            DBPropertyViewer.this._connectionAgent = dBConnectionAgent;
        }

        public Object construct() {
            DBPropertyViewer.this.setConnectionAgent(DBPropertyViewer.this._connectionAgent);
            return null;
        }
    }

    static class StringList
    extends ArrayList<String> {
        StringList() {
        }

        StringList(int n) {
            super(n);
        }
    }

    static class PropertySet {
        boolean success = false;
        ArrayList<ArrayList<Object>> data = null;
        ArrayList<Object> databaseNames = null;

        PropertySet() {
        }
    }

    static class SimpleCellRenderer
    extends DefaultTableCellRenderer {
        static final Border NO_FOCUS_BORDER = BorderFactory.createCompoundBorder(new EmptyBorder(1, 1, 1, 1), null);

        SimpleCellRenderer() {
            this.setBorder(NO_FOCUS_BORDER);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setForeground(jTable.getForeground());
            this.setBackground(jTable.getBackground());
            this.setBorder(NO_FOCUS_BORDER);
            return this;
        }
    }

    static class RowHeaderTableModel
    extends AbstractTableModel {
        String[] _rowHeaders;

        RowHeaderTableModel(String[] stringArray) {
            this._rowHeaders = stringArray;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this._rowHeaders[n];
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this._rowHeaders == null ? 0 : this._rowHeaders.length;
        }
    }

    static class ReadOnlyTable
    extends JTable {
        ReadOnlyTable(TableModel tableModel) {
            super(tableModel);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

