/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.propertyViewer;

import com.sybase.asa.common.IntegerTextField;
import com.sybase.asa.propertyViewer.DBPropertyViewer;
import com.sybase.asa.propertyViewer.DBPropertyViewerProperties;
import com.sybase.customization.CustomizationPage;
import com.sybase.helpManager.FactoryHelp;
import com.sybase.helpManager.HelpNotFoundException;
import com.sybase.helpManager.HelpViewer;
import com.sybase.util.Platform;
import com.sybase.util.SybLabel;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableModel;

class DBPropertyViewerCustomizationPage
extends JPanel
implements TableModelListener,
DocumentListener,
CustomizationPage {
    private static HelpViewer _helpViewer = null;
    DBPropertyViewer _propertyViewer;
    PropertyTable _databasePropertyTable;
    Vector<String> _databasePropertyTableColumnNames;
    PropertyTable _serverPropertyTable;
    Vector<String> _serverPropertyTableColumnNames;
    IntegerTextField _refreshRate = new IntegerTextField();

    DBPropertyViewerCustomizationPage(DBPropertyViewer dBPropertyViewer) {
        Vector<Object> vector;
        int n;
        String string;
        String string2;
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        SybLabel sybLabel = new SybLabel();
        JLabel jLabel = new JLabel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel3.setLayout(gridBagLayout);
        this.add(jPanel3);
        jPanel3.add((Component)sybLabel);
        jPanel3.add(this._refreshRate);
        jPanel3.add(jLabel);
        SybLabel sybLabel2 = new SybLabel(DBPropertyViewer.getI18NMessage("customizer.serverSelect"));
        JScrollPane jScrollPane = new JScrollPane();
        if (Platform.isMacOS()) {
            jScrollPane.setVerticalScrollBarPolicy(22);
            jScrollPane.setHorizontalScrollBarPolicy(32);
        } else {
            jScrollPane.setVerticalScrollBarPolicy(20);
            jScrollPane.setHorizontalScrollBarPolicy(30);
        }
        this._serverPropertyTableColumnNames = new Vector(3);
        this._serverPropertyTableColumnNames.add(DBPropertyViewer.getI18NMessage("customizer.display"));
        this._serverPropertyTableColumnNames.add(DBPropertyViewer.getI18NMessage("customizer.propertyName"));
        this._serverPropertyTableColumnNames.add(DBPropertyViewer.getI18NMessage("customizer.propertyDescription"));
        this._serverPropertyTable = new PropertyTable(new CustomizerTableModel(new Vector(), (Vector)this._serverPropertyTableColumnNames));
        this._serverPropertyTable.setAutoResizeMode(0);
        this._serverPropertyTable.setSelectionMode(0);
        this._serverPropertyTable.getTableHeader().setDefaultRenderer(new LeftAlignedHeaderRenderer());
        this._serverPropertyTable.getTableHeader().setReorderingAllowed(false);
        jScrollPane.getViewport().add(this._serverPropertyTable);
        sybLabel2.setLabelFor((Component)this._serverPropertyTable);
        SybLabel sybLabel3 = new SybLabel(DBPropertyViewer.getI18NMessage("customizer.databaseSelect"));
        JScrollPane jScrollPane2 = new JScrollPane();
        if (Platform.isMacOS()) {
            jScrollPane2.setVerticalScrollBarPolicy(22);
            jScrollPane2.setHorizontalScrollBarPolicy(32);
        } else {
            jScrollPane2.setVerticalScrollBarPolicy(20);
            jScrollPane2.setHorizontalScrollBarPolicy(30);
        }
        this._databasePropertyTableColumnNames = new Vector(3);
        this._databasePropertyTableColumnNames.add(DBPropertyViewer.getI18NMessage("customizer.display"));
        this._databasePropertyTableColumnNames.add(DBPropertyViewer.getI18NMessage("customizer.propertyName"));
        this._databasePropertyTableColumnNames.add(DBPropertyViewer.getI18NMessage("customizer.propertyDescription"));
        this._databasePropertyTable = new PropertyTable(new CustomizerTableModel(new Vector(), (Vector)this._databasePropertyTableColumnNames));
        this._databasePropertyTable.setAutoResizeMode(0);
        this._databasePropertyTable.setSelectionMode(0);
        this._databasePropertyTable.getTableHeader().setDefaultRenderer(new LeftAlignedHeaderRenderer());
        this._databasePropertyTable.getTableHeader().setReorderingAllowed(false);
        jScrollPane2.getViewport().add(this._databasePropertyTable);
        sybLabel3.setLabelFor((Component)this._databasePropertyTable);
        sybLabel.setText(DBPropertyViewer.getI18NMessage("customizer.refreshRate"));
        sybLabel.setLabelFor((Component)this._refreshRate);
        sybLabel.setToolTipText(DBPropertyViewer.getI18NMessage("customizer.refreshRateTip"));
        this._refreshRate.getDocument().addDocumentListener(this);
        jLabel.setText(DBPropertyViewer.getI18NMessage("customizer.seconds"));
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        this.setLayout(gridBagLayout2);
        this.add(jPanel2);
        jPanel2.add((Component)sybLabel3);
        jPanel2.add(jScrollPane2);
        this.add(jPanel);
        jPanel.add((Component)sybLabel2);
        jPanel.add(jScrollPane);
        JTabbedPane jTabbedPane = new JTabbedPane();
        jTabbedPane.setTabPlacement(1);
        jTabbedPane.addTab(DBPropertyViewer.getI18NMessage("customizer.databaseProperties"), jPanel2);
        jTabbedPane.addTab(DBPropertyViewer.getI18NMessage("customizer.serverProperties"), jPanel);
        jTabbedPane.setSelectedIndex(0);
        this.add(jTabbedPane);
        GridBagLayout gridBagLayout3 = new GridBagLayout();
        jPanel.setLayout(gridBagLayout3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagLayout3.setConstraints((Component)sybLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagLayout3.setConstraints(jScrollPane, gridBagConstraints);
        GridBagLayout gridBagLayout4 = new GridBagLayout();
        jPanel2.setLayout(gridBagLayout4);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.anchor = 13;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints2.weightx = 1.0;
        gridBagLayout4.setConstraints((Component)sybLabel3, gridBagConstraints2);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.insets = new Insets(0, 5, 0, 5);
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 1.0;
        gridBagLayout4.setConstraints(jScrollPane2, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.anchor = 13;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints3.weightx = 1.0;
        gridBagLayout2.setConstraints(jTabbedPane, gridBagConstraints3);
        gridBagLayout2.setConstraints(jScrollPane2, gridBagConstraints3);
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagLayout2.setConstraints(jPanel3, gridBagConstraints3);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
        gridBagLayout.setConstraints((Component)sybLabel, gridBagConstraints4);
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.gridx = 1;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints4.ipadx = this._refreshRate.getPreferredSize().height * 2;
        gridBagConstraints4.weighty = 1.0;
        gridBagLayout.setConstraints(this._refreshRate, gridBagConstraints4);
        gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridy = 0;
        gridBagConstraints4.insets = new Insets(5, 0, 5, 5);
        gridBagConstraints4.ipadx = 100;
        gridBagConstraints4.weightx = 1.0;
        gridBagLayout.setConstraints(jLabel, gridBagConstraints4);
        this._propertyViewer = dBPropertyViewer;
        Vector vector2 = new Vector();
        FontMetrics fontMetrics = this._serverPropertyTable.getFontMetrics(this._serverPropertyTable.getFont());
        int n2 = fontMetrics.stringWidth(DBPropertyViewer.getI18NMessage("customizer.display"));
        int n3 = fontMetrics.stringWidth(DBPropertyViewer.getI18NMessage("customizer.propertyName"));
        int n4 = fontMetrics.stringWidth(DBPropertyViewer.getI18NMessage("customizer.propertyDescription"));
        Object[] objectArray = this._propertyViewer._serverPropertyDescriptions.keySet().toArray();
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            string2 = object.toString();
            string = (String)this._propertyViewer._serverPropertyDescriptions.get(string2);
            n = fontMetrics.stringWidth(string2);
            if (n > n3) {
                n3 = n;
            }
            if ((n = fontMetrics.stringWidth(string)) > n4) {
                n4 = n;
            }
            vector = new Vector<Object>(3);
            if (DBPropertyViewerProperties.checkServerProperty(string2) > -1) {
                vector.add(Boolean.TRUE);
            } else {
                vector.add(Boolean.FALSE);
            }
            vector.add(string2);
            vector.add(string);
            vector2.add(vector);
        }
        ((CustomizerTableModel)this._serverPropertyTable.getModel()).setDataVector(vector2, this._serverPropertyTableColumnNames);
        this._serverPropertyTable.getModel().addTableModelListener(this);
        this._serverPropertyTable.getColumnModel().getColumn(0).setPreferredWidth(n2 + 8);
        this._serverPropertyTable.getColumnModel().getColumn(1).setPreferredWidth(n3 + 4);
        this._serverPropertyTable.getColumnModel().getColumn(2).setPreferredWidth(n4 + 4);
        this._serverPropertyTable.getColumnModel().getColumn(0).setResizable(false);
        this._serverPropertyTable.getColumnModel().getColumn(1).setResizable(false);
        this._serverPropertyTable.getColumnModel().getColumn(2).setResizable(false);
        vector2 = new Vector();
        fontMetrics = this._databasePropertyTable.getFontMetrics(this._databasePropertyTable.getFont());
        n3 = fontMetrics.stringWidth(DBPropertyViewer.getI18NMessage("customizer.propertyName"));
        n4 = fontMetrics.stringWidth(DBPropertyViewer.getI18NMessage("customizer.propertyDescription"));
        objectArray = this._propertyViewer._databasePropertyDescriptions.keySet().toArray();
        Arrays.sort(objectArray);
        for (Object object : objectArray) {
            string2 = object.toString();
            string = (String)this._propertyViewer._databasePropertyDescriptions.get(string2);
            n = fontMetrics.stringWidth(string2);
            if (n > n3) {
                n3 = n;
            }
            if ((n = fontMetrics.stringWidth(string)) > n4) {
                n4 = n;
            }
            vector = new Vector(3);
            if (DBPropertyViewerProperties.checkDatabaseProperty(string2) > -1) {
                vector.add(Boolean.TRUE);
            } else {
                vector.add(Boolean.FALSE);
            }
            vector.add(string2);
            vector.add(string);
            vector2.add(vector);
        }
        ((CustomizerTableModel)this._databasePropertyTable.getModel()).setDataVector(vector2, this._databasePropertyTableColumnNames);
        this._databasePropertyTable.getModel().addTableModelListener(this);
        this._databasePropertyTable.getColumnModel().getColumn(0).setPreferredWidth(n2 + 8);
        this._databasePropertyTable.getColumnModel().getColumn(1).setPreferredWidth(n3 + 4);
        this._databasePropertyTable.getColumnModel().getColumn(2).setPreferredWidth(n4 + 4);
        this._databasePropertyTable.getColumnModel().getColumn(0).setResizable(false);
        this._databasePropertyTable.getColumnModel().getColumn(1).setResizable(false);
        this._databasePropertyTable.getColumnModel().getColumn(2).setResizable(false);
    }

    public void initialize() {
        int n;
        this._serverPropertyTable.getModel().removeTableModelListener(this);
        this._databasePropertyTable.getModel().removeTableModelListener(this);
        int n2 = this._serverPropertyTable.getRowCount();
        for (n = 0; n < n2; ++n) {
            if (DBPropertyViewerProperties.checkServerProperty((String)this._serverPropertyTable.getValueAt(n, 1)) > -1) {
                this._serverPropertyTable.setValueAt(Boolean.TRUE, n, 0);
                continue;
            }
            this._serverPropertyTable.setValueAt(Boolean.FALSE, n, 0);
        }
        n2 = this._databasePropertyTable.getRowCount();
        for (n = 0; n < n2; ++n) {
            if (DBPropertyViewerProperties.checkDatabaseProperty((String)this._databasePropertyTable.getValueAt(n, 1)) > -1) {
                this._databasePropertyTable.setValueAt(Boolean.TRUE, n, 0);
                continue;
            }
            this._databasePropertyTable.setValueAt(Boolean.FALSE, n, 0);
        }
        this._serverPropertyTable.getModel().addTableModelListener(this);
        this._databasePropertyTable.getModel().addTableModelListener(this);
        this._refreshRate.setValue(DBPropertyViewerProperties.getRefreshRate() / 1000);
    }

    public boolean validateChanges() {
        return true;
    }

    public String getTitle() {
        return DBPropertyViewer.getI18NMessage("dbpropertyviewer.propertyViewer");
    }

    public void destroy() {
        this._serverPropertyTable.getModel().removeTableModelListener(this);
        this._databasePropertyTable.getModel().removeTableModelListener(this);
        this._refreshRate.getDocument().removeDocumentListener(this);
        DBPropertyViewerProperties.reset();
    }

    private HelpViewer getHelpViewer() {
        if (_helpViewer == null) {
            String string = "sqlanywhere_";
            String string2 = Long.toString(11L);
            try {
                _helpViewer = FactoryHelp.getHelpViewer((String)DBPropertyViewer._helpFolder, (String)string, (String)string2);
            }
            catch (HelpNotFoundException helpNotFoundException) {
                // empty catch block
            }
        }
        return _helpViewer;
    }

    public void showHelp() {
        if (this.getHelpViewer() != null) {
            this.getHelpViewer().turnPage("HELP_DBPROPERTY_VIEWER_CUSTOMIZATION", SwingUtilities.windowForComponent(this));
        }
    }

    public Component getComponent() {
        return this;
    }

    @Override
    public void tableChanged(TableModelEvent tableModelEvent) {
        int n = tableModelEvent.getFirstRow();
        int n2 = tableModelEvent.getLastRow();
        if (n < 0 || n2 < 0) {
            return;
        }
        if (this._propertyViewer == null) {
            return;
        }
        for (int i = n; i <= n2; ++i) {
            boolean bl;
            String string;
            if (tableModelEvent.getSource() == this._serverPropertyTable.getModel()) {
                string = (String)this._serverPropertyTable.getValueAt(i, 1);
                bl = (Boolean)this._serverPropertyTable.getValueAt(i, 0);
                if (bl) {
                    DBPropertyViewerProperties.addServerProperty(string);
                    continue;
                }
                DBPropertyViewerProperties.removeServerProperty(string);
                continue;
            }
            string = (String)this._databasePropertyTable.getValueAt(i, 1);
            bl = (Boolean)this._databasePropertyTable.getValueAt(i, 0);
            if (bl) {
                DBPropertyViewerProperties.addDatabaseProperty(string);
                continue;
            }
            DBPropertyViewerProperties.removeDatabaseProperty(string);
        }
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
        DBPropertyViewerProperties.setRefreshRate(this._refreshRate.getValue() * 1000);
        this._propertyViewer.setRefreshRate(this._refreshRate.getValue() * 1000);
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
        this.changedUpdate(documentEvent);
    }

    static class LeftAlignedHeaderRenderer
    extends DefaultTableCellRenderer {
        LeftAlignedHeaderRenderer() {
            this.setHorizontalTextPosition(2);
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setBorder(UIManager.getBorder("TableHeader.cellBorder"));
            if (!jTable.isEnabled()) {
                this.setForeground(UIManager.getColor("TextField.inactiveForeground"));
            } else {
                this.setForeground(UIManager.getColor("TableHeader.foreground"));
            }
            JTableHeader jTableHeader = jTable.getTableHeader();
            if (jTableHeader != null) {
                if (jTable.isEnabled()) {
                    this.setForeground(jTableHeader.getForeground());
                }
                this.setBackground(jTableHeader.getBackground());
            }
            return this;
        }
    }

    static class CustomizerTableModel
    extends DefaultTableModel {
        CustomizerTableModel(Vector vector, int n) {
            super(vector, n);
        }

        CustomizerTableModel(int n, int n2) {
            super(n, n2);
        }

        CustomizerTableModel(Vector vector, Vector vector2) {
            super(vector, vector2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 0;
        }
    }

    static class PropertyTable
    extends JTable {
        PropertyTable(TableModel tableModel) {
            super(tableModel);
        }

        public Class getColumnClass(int n) {
            if (n == 0) {
                return Boolean.class;
            }
            return Object.class;
        }
    }
}

