/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.asa.propertyViewer;

import com.sybase.asa.propertyViewer.DBPropertyViewer;
import com.sybase.util.Platform;
import com.sybase.util.SybMessageFormat;
import com.sybase.util.SybOptionPane;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;

class DBPropertyViewerProperties {
    private static String _serverProperties;
    private static ArrayList<String> _serverPropertyList;
    private static String _databaseProperties;
    private static ArrayList<String> _databasePropertyList;
    private static int _refreshRate;
    private static String _propertyFileName;
    private static String _pathSeparator;
    private static boolean _dirty;
    private static boolean _loaded;

    DBPropertyViewerProperties() {
    }

    static void load() {
        if (_loaded) {
            return;
        }
        _loaded = true;
        Properties properties = new Properties(System.getProperties());
        try {
            properties.load(new BufferedInputStream(new FileInputStream(_propertyFileName)));
        }
        catch (Exception exception) {
            // empty catch block
        }
        System.setProperties(properties);
        DBPropertyViewerProperties.reset();
    }

    static void store() {
        if (_dirty) {
            _dirty = false;
            try {
                System.setProperty("DBPropertyViewer.serverProperties", _serverProperties);
                System.setProperty("DBPropertyViewer.databaseProperties", _databaseProperties);
                System.setProperty("DBPropertyViewer.refreshRate", String.valueOf(_refreshRate));
                Properties properties = new Properties(System.getProperties());
                properties.setProperty("DBPropertyViewer.serverProperties", System.getProperty("DBPropertyViewer.serverProperties"));
                properties.setProperty("DBPropertyViewer.databaseProperties", System.getProperty("DBPropertyViewer.databaseProperties"));
                properties.setProperty("DBPropertyViewer.refreshRate", System.getProperty("DBPropertyViewer.refreshRate"));
                FileOutputStream fileOutputStream = new FileOutputStream(_propertyFileName);
                properties.store(fileOutputStream, "DBPropertyViewer user prefrerences");
                fileOutputStream.close();
            }
            catch (IOException iOException) {
                Object[] objectArray = new Object[]{_propertyFileName};
                SybOptionPane.showConfirmDialog(null, (Object)SybMessageFormat.format((String)DBPropertyViewer.getI18NMessage("customizer.property.error"), (Object[])objectArray), (String)DBPropertyViewer.getI18NMessage("customizer.property.error.title"), (int)-1, (int)0);
            }
            catch (ClassCastException classCastException) {
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    static void reset() {
        _serverProperties = System.getProperty("DBPropertyViewer.serverProperties", "packetsreceived,bytesreceived,packetssent,bytessent,multipacketssent,multipacketsreceived,remoteputwait,sendfail,freebuffers,totalbuffers");
        _databaseProperties = System.getProperty("DBPropertyViewer.databaseProperties", "checkpointurgency,recoveryurgency");
        _refreshRate = Integer.getInteger("DBPropertyViewer.refreshRate", 4000);
        DBPropertyViewerProperties.setServerPropertyList(_serverProperties);
        DBPropertyViewerProperties.setDatabasePropertyList(_databaseProperties);
        _dirty = false;
    }

    static String getServerProperties() {
        if (!_loaded) {
            DBPropertyViewerProperties.load();
        }
        return _serverProperties;
    }

    static void setServerProperties(String string) {
        _serverProperties = string;
        _dirty = true;
    }

    static void addServerProperty(String string) {
        if (!_serverPropertyList.contains(string = string.toLowerCase())) {
            _serverPropertyList.add(string);
            _serverProperties = _serverProperties + "," + string;
            _dirty = true;
        }
    }

    static void removeServerProperty(String string) {
        int n = DBPropertyViewerProperties.checkServerProperty(string);
        if (n > -1) {
            _serverPropertyList.remove(n);
            DBPropertyViewerProperties.serverPropertyListToString();
            _dirty = true;
        }
    }

    private static void serverPropertyListToString() {
        int n = _serverPropertyList.size();
        StringBuffer stringBuffer = new StringBuffer(20 * n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(_serverPropertyList.get(i)).append(",");
        }
        _serverProperties = stringBuffer.length() > 0 ? stringBuffer.substring(0, stringBuffer.length() - 1) : "";
    }

    static int checkServerProperty(String string) {
        return _serverPropertyList.indexOf(string.toLowerCase());
    }

    static void setServerPropertyList(String string) {
        _serverPropertyList = new ArrayList(20);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().toLowerCase();
            if (_serverPropertyList.contains(string2)) continue;
            _serverPropertyList.add(string2);
        }
    }

    static ArrayList<String> getServerPropertyList() {
        if (!_loaded) {
            DBPropertyViewerProperties.load();
        }
        return new ArrayList<String>(_serverPropertyList);
    }

    static String getDatabaseProperties() {
        if (!_loaded) {
            DBPropertyViewerProperties.load();
        }
        return _databaseProperties;
    }

    static void setDatabaseProperties(String string) {
        _databaseProperties = string;
        _dirty = true;
    }

    static void addDatabaseProperty(String string) {
        if (!_databasePropertyList.contains(string = string.toLowerCase())) {
            _databasePropertyList.add(string);
            _databaseProperties = _databaseProperties + "," + string;
            _dirty = true;
        }
    }

    static void removeDatabaseProperty(String string) {
        int n = DBPropertyViewerProperties.checkDatabaseProperty(string);
        if (n > -1) {
            _databasePropertyList.remove(n);
            DBPropertyViewerProperties.databasePropertyListToString();
            _dirty = true;
        }
    }

    private static void databasePropertyListToString() {
        int n = _databasePropertyList.size();
        StringBuffer stringBuffer = new StringBuffer(20 * n);
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(_databasePropertyList.get(i)).append(",");
        }
        _databaseProperties = stringBuffer.length() > 0 ? stringBuffer.substring(0, stringBuffer.length() - 1) : "";
    }

    static int checkDatabaseProperty(String string) {
        return _databasePropertyList.indexOf(string.toLowerCase());
    }

    static void setDatabasePropertyList(String string) {
        _databasePropertyList = new ArrayList(20);
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().toLowerCase();
            if (_databasePropertyList.contains(string2)) continue;
            _databasePropertyList.add(string2);
        }
    }

    static ArrayList<String> getDatabasePropertyList() {
        if (!_loaded) {
            DBPropertyViewerProperties.load();
        }
        return new ArrayList<String>(_databasePropertyList);
    }

    static int getRefreshRate() {
        if (!_loaded) {
            DBPropertyViewerProperties.load();
        }
        return _refreshRate;
    }

    static void setRefreshRate(int n) {
        _refreshRate = n;
        _dirty = true;
    }

    static {
        _propertyFileName = Platform.getUserConfigurationDirectory() + ".DBPropertyViewer" + 11;
        _pathSeparator = System.getProperty("path.separator");
        _dirty = false;
        _loaded = false;
    }
}

