/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.dbdiagram;

import com.sybase.dbdiagram.ClickablePanel;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import javax.swing.JTable;
import javax.swing.RowSorter;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.RowSorterEvent;
import javax.swing.event.RowSorterListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableModel;

class CellPanel
extends ClickablePanel
implements ComponentListener,
RowSorterListener,
TableColumnModelListener {
    JTable _table;
    int _row;
    int _column;

    CellPanel(JTable jTable, int n, int n2) {
        this._table = jTable;
        this._row = n;
        this._column = n2;
        this._table.add(this);
        this.reposition();
        Object object = this._table.getModel().getValueAt(n, n2);
        String string = object == null ? null : object.toString();
        this.setToolTipText(string);
        this.addFocusListener(this);
        this._table.getColumnModel().addColumnModelListener(this);
        this._table.addComponentListener(this);
        RowSorter<? extends TableModel> rowSorter = this._table.getRowSorter();
        if (rowSorter != null) {
            rowSorter.addRowSorterListener(this);
        }
    }

    @Override
    protected void releaseResources() {
        if (this._table != null) {
            this._table.getColumnModel().removeColumnModelListener(this);
            this._table.removeComponentListener(this);
            RowSorter<? extends TableModel> rowSorter = this._table.getRowSorter();
            if (rowSorter != null) {
                rowSorter.removeRowSorterListener(this);
            }
            this._table.remove(this);
            this._table = null;
        }
        super.releaseResources();
    }

    private void reposition() {
        int n = this._table.convertRowIndexToView(this._row);
        Rectangle rectangle = this._table.getCellRect(n, this._column, false);
        this.setLocation(rectangle.x, rectangle.y);
        this.setSize(rectangle.width, rectangle.height);
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        this.reposition();
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        super.focusGained(focusEvent);
        if (this._table != null) {
            this._table.scrollRectToVisible(this.getBounds());
        }
    }

    @Override
    public void sorterChanged(RowSorterEvent rowSorterEvent) {
        this.reposition();
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void columnMarginChanged(ChangeEvent changeEvent) {
        this.reposition();
    }

    @Override
    public void columnAdded(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnRemoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnMoved(TableColumnModelEvent tableColumnModelEvent) {
    }

    @Override
    public void columnSelectionChanged(ListSelectionEvent listSelectionEvent) {
    }
}

