/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.dbdiagram;

import com.sybase.dbdiagram.DBDiagramUtils;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

class ClickablePanel
extends JPanel
implements FocusListener,
KeyListener,
MouseListener {
    static final int BORDER_WIDTH = 2;
    private static final Border FOCUSED_BORDER = new CompoundBorder(UIManager.getBorder("List.focusCellHighlightBorder"), BorderFactory.createEmptyBorder(1, 1, 1, 1));
    private static final Border UNFOCUSED_BORDER = BorderFactory.createEmptyBorder(2, 2, 2, 2);
    protected ArrayList<ActionListener> _listeners = new ArrayList(1);
    private boolean _showBorder = true;

    ClickablePanel() {
        this(null);
    }

    ClickablePanel(LayoutManager layoutManager) {
        super(layoutManager);
        this.setBorder(UNFOCUSED_BORDER);
        this.setCursor(DBDiagramUtils.getHandCursor());
        this.setFocusable(true);
        this.setOpaque(false);
        this.addFocusListener(this);
        this.addKeyListener(this);
        this.addMouseListener(this);
    }

    protected void releaseResources() {
        this.removeFocusListener(this);
        this.removeKeyListener(this);
        this.removeMouseListener(this);
        if (this._listeners != null) {
            this._listeners.clear();
            this._listeners = null;
        }
    }

    protected void addActionListener(ActionListener actionListener) {
        this._listeners.add(actionListener);
    }

    protected void fireActionPerformed(ActionEvent actionEvent) {
        for (int i = 0; this._listeners != null && i < this._listeners.size(); ++i) {
            this._listeners.get(i).actionPerformed(actionEvent);
        }
    }

    protected void removeActionListener(ActionListener actionListener) {
        this._listeners.remove(actionListener);
    }

    protected void removeAllActionListeners() {
        this._listeners.clear();
    }

    protected void setShowBorder(boolean bl) {
        if (bl) {
            if (this.hasFocus()) {
                this.setBorder(FOCUSED_BORDER);
            } else {
                this.setBorder(UNFOCUSED_BORDER);
            }
        } else {
            this.setBorder(null);
        }
        this._showBorder = bl;
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.isEnabled() & this._showBorder) {
            this.setBorder(FOCUSED_BORDER);
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.isEnabled() & this._showBorder) {
            this.setBorder(UNFOCUSED_BORDER);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10 || keyEvent.getKeyCode() == 32) {
            this.fireActionPerformed(new ActionEvent(this, keyEvent.getID(), "keyPressed"));
        } else if (keyEvent.getKeyCode() == 9) {
            if ((keyEvent.getModifiersEx() & 0x40) == 0) {
                this.transferFocus();
            } else {
                this.transferFocusBackward();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.isEnabled() && mouseEvent.getX() >= 0 && mouseEvent.getX() <= this.getWidth() && mouseEvent.getY() >= 0 && mouseEvent.getY() <= this.getHeight()) {
            this.requestFocusInWindow();
            this.fireActionPerformed(new ActionEvent(this, mouseEvent.getID(), "mousePressed"));
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }
}

