/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.dbdiagram;

import com.sybase.dbdiagram.ClickablePanel;
import com.sybase.dbdiagram.DBDiagramResourcesBase;
import com.sybase.dbdiagram.DBDiagramUtils;
import com.sybase.dbdiagram.EmptyComponent;
import com.sybase.dbdiagram.printing.PrintingComponent;
import com.sybase.dbdiagram.printing.PrintingJCWrapper;
import com.sybase.dbdiagram.printing.PrintingLabel;
import com.sybase.dbdiagram.printing.PrintingPanel;
import com.sybase.util.SybLabel;
import com.sybase.util.UIUtils;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

class DBDiagramCollapsiblePanel
extends JPanel
implements ActionListener,
ComponentListener,
MouseListener {
    private static final int MAX_WARNINGS_IN_HEADER = 3;
    private static final int TITLE_ICON_GAP = 5;
    private static final Border TITLE_ICON_BORDER = new EmptyBorder(0, 0, 0, 5);
    private static ImageIcon COLLAPSE_ICON = null;
    private static ImageIcon EXPAND_ICON = null;
    private static DBDiagramResourcesBase _bundle = null;
    private static Font _normalTitleFont = null;
    private static Color _normalTitleColor = null;
    private ActionListener _listener = null;
    private boolean _isCollapsed;
    private int _extraWarningCount = 0;
    private ClickablePanel _headerPanel;
    private JPanel _headerCenterPanel;
    private JLabel _iconLabel;
    private SybLabel _titleLabel;
    private ArrayList<JLabel> _warningLabels;
    private JLabel _extraWarningsLabel = null;
    private JLabel _collapsedStateIconLabel;
    private Component _minWidthStrut;
    private JComponent _bodyComponent;

    DBDiagramCollapsiblePanel(String string, Icon icon, JComponent jComponent) {
        if (COLLAPSE_ICON == null) {
            COLLAPSE_ICON = UIUtils.getExplorerBarGroupCollapseButton();
            EXPAND_ICON = UIUtils.getExplorerBarGroupExpandButton();
        }
        if (_bundle == null) {
            _bundle = DBDiagramResourcesBase.getBundle();
        }
        this._bodyComponent = jComponent;
        this._headerPanel = new ClickablePanel();
        this._headerPanel.setLayout(new BorderLayout());
        this._headerPanel.setCursor(null);
        this._headerCenterPanel = new JPanel();
        this._headerCenterPanel.setOpaque(false);
        this._headerCenterPanel.setLayout(new GridBagLayout());
        this._headerPanel.add((Component)this._headerCenterPanel, "Center");
        this._iconLabel = new JLabel(icon);
        this._iconLabel.setBorder(TITLE_ICON_BORDER);
        this._headerPanel.add((Component)this._iconLabel, "Before");
        this._titleLabel = DBDiagramUtils.createSybLabelForWarning(string);
        if (_normalTitleFont == null) {
            Font font = UIManager.getDefaults().getFont("InternalFrame.titleFont");
            _normalTitleFont = font == null ? this._titleLabel.getFont() : font;
            _normalTitleColor = UIUtils.getExplorerBarHeaderTextColor();
        }
        this._titleLabel.setFont(_normalTitleFont);
        this._titleLabel.setForeground(_normalTitleColor);
        this._titleLabel.setLabelFor((Component)this._headerPanel);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 19, 2, DBDiagramUtils.ZERO_INSETS, 0, 0);
        this._headerCenterPanel.add((Component)this._titleLabel, gridBagConstraints);
        this._collapsedStateIconLabel = new JLabel(EXPAND_ICON);
        this._headerPanel.add((Component)this._collapsedStateIconLabel, "After");
        JPanel jPanel = UIUtils.createExplorerBarHeader();
        jPanel.setLayout(new GridLayout(1, 1));
        jPanel.add(this._headerPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel, "First");
        this.add((Component)this._bodyComponent, "Center");
        this._minWidthStrut = new EmptyComponent(new Dimension(this._bodyComponent.getPreferredSize().width, 0));
        this.add(this._minWidthStrut, "Last");
        this._isCollapsed = false;
        this.collapsedChanged();
        this._headerPanel.addActionListener(this);
        this._bodyComponent.addComponentListener(this);
    }

    void releaseResources() {
        if (this._warningLabels != null) {
            for (int i = this._warningLabels.size() - 1; i >= 0; --i) {
                this._warningLabels.get(i).removeMouseListener(this);
            }
            this._warningLabels.clear();
            this._warningLabels = null;
        }
        if (this._headerPanel != null) {
            this._headerPanel.removeActionListener(this);
            this._headerPanel.releaseResources();
            this._headerPanel = null;
        }
        if (this._bodyComponent != null) {
            this._bodyComponent.removeComponentListener(this);
            this._bodyComponent = null;
        }
        this._headerCenterPanel = null;
        this._iconLabel = null;
        this._titleLabel = null;
        this._collapsedStateIconLabel = null;
        this._minWidthStrut = null;
        this._listener = null;
    }

    void addActionListener(ActionListener actionListener) {
        this._listener = actionListener;
    }

    @Override
    public void addFocusListener(FocusListener focusListener) {
        this._headerPanel.addFocusListener(focusListener);
    }

    void addWarning(String string) {
        if (this._warningLabels == null) {
            this._warningLabels = new ArrayList(3);
        }
        if (this._warningLabels.size() == 0) {
            DBDiagramUtils.showWarning((JLabel)this._titleLabel);
        }
        if (this._warningLabels.size() == 3) {
            Dimension dimension;
            if (this._extraWarningCount == 0) {
                if (this._extraWarningsLabel == null) {
                    this._extraWarningsLabel = new JLabel(" ");
                    dimension = this._extraWarningsLabel.getPreferredSize();
                    dimension.width = 0;
                    this._extraWarningsLabel.setPreferredSize(dimension);
                    this._extraWarningsLabel.addMouseListener(this);
                }
                JLabel jLabel = this._warningLabels.remove(2);
                this._headerCenterPanel.remove(jLabel);
                jLabel.removeMouseListener(this);
                this._warningLabels.add(this._extraWarningsLabel);
                GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 2, DBDiagramUtils.ZERO_INSETS, 0, 0);
                this._headerCenterPanel.add((Component)this._extraWarningsLabel, gridBagConstraints);
                if (!this._isCollapsed) {
                    this._extraWarningsLabel.setVisible(false);
                }
                this._extraWarningCount = 1;
            }
            ++this._extraWarningCount;
            String string2 = _bundle.getFormatted("PLUS_MORE_WARNINGS", Integer.toString(this._extraWarningCount));
            this._extraWarningsLabel.setText(string2);
            this._extraWarningsLabel.setToolTipText(string2);
            dimension = new Dimension(this._titleLabel.getPreferredSize().width, this._extraWarningsLabel.getPreferredSize().height);
            this._extraWarningsLabel.setPreferredSize(dimension);
        } else {
            JLabel jLabel = new JLabel(string);
            jLabel.setToolTipText(string);
            Dimension dimension = jLabel.getPreferredSize();
            dimension.width = 0;
            jLabel.setPreferredSize(dimension);
            jLabel.addMouseListener(this);
            this._warningLabels.add(jLabel);
            GridBagConstraints gridBagConstraints = new GridBagConstraints(0, this._warningLabels.size(), 1, 1, 1.0, 0.0, 10, 2, DBDiagramUtils.ZERO_INSETS, 0, 0);
            this._headerCenterPanel.add((Component)jLabel, gridBagConstraints);
            if (!this._isCollapsed) {
                jLabel.setVisible(false);
            }
        }
    }

    void clearWarnings() {
        if (this._warningLabels != null && this._warningLabels.size() > 0) {
            for (int i = this._warningLabels.size() - 1; i >= 0; --i) {
                JLabel jLabel = this._warningLabels.get(i);
                this._headerCenterPanel.remove(jLabel);
                if (jLabel == this._extraWarningsLabel) continue;
                jLabel.removeMouseListener(this);
            }
            this._warningLabels.clear();
            DBDiagramUtils.clearWarning((JLabel)this._titleLabel, _normalTitleFont, _normalTitleColor);
            this._headerCenterPanel.repaint();
        }
        this._extraWarningCount = 0;
    }

    PrintingComponent createTitlePrintingComponent(Graphics graphics) {
        PrintingComponent printingComponent;
        PrintingPanel printingPanel = new PrintingPanel();
        PrintingJCWrapper printingJCWrapper = new PrintingJCWrapper(this._iconLabel);
        if (this._warningLabels == null || this._warningLabels.size() == 0) {
            String string = this._titleLabel.getText();
            Font font = this._titleLabel.getFont();
            FontMetrics fontMetrics = graphics.getFontMetrics(font);
            Color color = UIManager.getColor("Label.color");
            printingComponent = new PrintingLabel(string, font, fontMetrics, color);
        } else {
            printingComponent = new PrintingJCWrapper((JComponent)this._titleLabel);
        }
        printingComponent.setX(((PrintingComponent)printingJCWrapper).getWidth() + 5);
        if (((PrintingComponent)printingJCWrapper).getHeight() >= printingComponent.getHeight()) {
            printingComponent.setY((((PrintingComponent)printingJCWrapper).getHeight() - printingComponent.getHeight()) / 2);
        } else {
            printingJCWrapper.setY((printingComponent.getHeight() - ((PrintingComponent)printingJCWrapper).getHeight()) / 2);
        }
        printingPanel.add(printingJCWrapper);
        printingPanel.add(printingComponent);
        return printingPanel;
    }

    JComponent getBodyComponent() {
        return this._bodyComponent;
    }

    boolean isCollapsed() {
        return this._isCollapsed;
    }

    void removeActionListener(ActionListener actionListener) {
        if (this._listener == actionListener) {
            this._listener = null;
        }
    }

    @Override
    public void removeFocusListener(FocusListener focusListener) {
        this._headerPanel.removeFocusListener(focusListener);
    }

    void setCollapsed(boolean bl) {
        this._isCollapsed = bl;
        this.collapsedChanged();
    }

    void toggleCollapsedState() {
        this._isCollapsed = !this._isCollapsed;
        this.collapsedChanged();
    }

    private void collapsedChanged() {
        if (this._isCollapsed) {
            this._collapsedStateIconLabel.setIcon(EXPAND_ICON);
            this._bodyComponent.setVisible(false);
            if (this._warningLabels != null) {
                for (int i = 0; i < this._warningLabels.size(); ++i) {
                    this._warningLabels.get(i).setVisible(true);
                }
            }
        } else {
            this._collapsedStateIconLabel.setIcon(COLLAPSE_ICON);
            this._bodyComponent.setVisible(true);
            if (this._warningLabels != null) {
                for (int i = 0; i < this._warningLabels.size(); ++i) {
                    this._warningLabels.get(i).setVisible(false);
                }
            }
        }
        if (this._listener != null) {
            this._listener.actionPerformed(new ActionEvent(this, 1001, ""));
        }
    }

    @Override
    public void componentResized(ComponentEvent componentEvent) {
        Dimension dimension = new Dimension(this._bodyComponent.getPreferredSize().width, 0);
        this._minWidthStrut.setPreferredSize(dimension);
    }

    @Override
    public void componentMoved(ComponentEvent componentEvent) {
    }

    @Override
    public void componentShown(ComponentEvent componentEvent) {
    }

    @Override
    public void componentHidden(ComponentEvent componentEvent) {
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this._isCollapsed = !this._isCollapsed;
        this.collapsedChanged();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this._isCollapsed = !this._isCollapsed;
        this.collapsedChanged();
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }
}

