/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.dbdiagram;

import com.sybase.asa.common.ASAComponentsImageLoader;
import com.sybase.dbdiagram.CellPanel;
import com.sybase.dbdiagram.ClickablePanel;
import com.sybase.dbdiagram.ClientNotifier;
import com.sybase.dbdiagram.DBDiagramClient;
import com.sybase.dbdiagram.DBDiagramCollapsiblePanel;
import com.sybase.dbdiagram.DBDiagramResourcesBase;
import com.sybase.dbdiagram.DBDiagramUtils;
import com.sybase.dbdiagram.EmptyComponent;
import com.sybase.dbdiagram.PathnameCellRenderer;
import com.sybase.dbdiagram.PrintingLabelMetadata;
import com.sybase.dbdiagram.StatisticsTableModel;
import com.sybase.dbdiagram.ToolTipCellRenderer;
import com.sybase.dbdiagram.ToolTipTableHeader;
import com.sybase.dbdiagram.TopologyNode;
import com.sybase.dbdiagram.WarningAwareCellRenderer;
import com.sybase.dbdiagram.printing.PrintingComponent;
import com.sybase.dbdiagram.printing.PrintingJCWrapper;
import com.sybase.dbdiagram.printing.PrintingLabel;
import com.sybase.dbdiagram.printing.PrintingLine;
import com.sybase.dbdiagram.printing.PrintingPaginatedPanel;
import com.sybase.dbdiagram.printing.PrintingPanel;
import com.sybase.util.CommandLineParser;
import com.sybase.util.PrintDialog;
import com.sybase.util.PrintJobListener;
import com.sybase.util.PrintJobThread;
import com.sybase.util.ProtocolOption;
import com.sybase.util.SybButton;
import com.sybase.util.SybLimitedWidthLabel;
import com.sybase.util.SybMultiLineLabel;
import com.sybase.util.SybOptionPane;
import com.sybase.util.SybPathnameLabel;
import com.sybase.util.UIUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterJob;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableColumnModel;

public class DBDiagramPanel
extends JPanel
implements Printable {
    public static final int DB_VERSION_10 = 1000;
    public static final int DB_VERSION_11 = 1100;
    static final int PRINTING_LABEL_NORMAL = 0;
    static final int PRINTING_LABEL_TABLE_HEADER = 1;
    static final int PRINTING_LABEL_WARNING_WITH_ICON = 2;
    static final int PRINTING_LABEL_WARNING_FONT_ONLY = 3;
    static final int PRINTING_LABEL_WARNING_SIZE_ONLY = 4;
    static final int PRINTING_LABEL_TITLE = 5;
    private static final int MAX_STATE_INFOS = 5;
    private static final int PRINTING_WARNING_ICON_GAP = 5;
    private static final int MAX_TRANSACTION_TIMES = 5;
    private static final int MAX_VISIBLE_DBSPACES = 5;
    private static final int MAX_VISIBLE_BLOCKED_CONNS = 5;
    private static final int MAX_VISIBLE_REMOTE_SERVERS = 5;
    private static final int MAX_VISIBLE_ML_TABLE_OWNERS = 5;
    private static final int MAX_VISIBLE_SQL_REMOTE_USERS = 5;
    private static final int STATISTICS_PANEL_GRIDY = 0;
    private static final int DBSPACES_PANEL_GRIDY = 1;
    private static final int LOGS_PANEL_GRIDY = 2;
    private static final int USERS_PANEL_GRIDY = 3;
    private static final int MIRRORING_PANEL_GRIDY = 4;
    private static final int REM_SERVERS_PANEL_GRIDY = 5;
    private static final int ML_SERVER_PANEL_GRIDY = 6;
    private static final int SQL_REMOTE_PANEL_GRIDY = 7;
    private static final int REFRESH_PANEL_GRIDY = 8;
    private static final int EXTRA_SPACE_GRIDY = 9;
    private static final int MAX_DB_NAME_WIDTH = 360;
    private static final int MAX_STATIC_INFO_WIDTH = 180;
    private static final int MAX_DB_NODE_WIDTH = 74;
    private static final int MAX_MIRRORING_NODE_WIDTH = 100;
    private static final int TOPOLOGY_NODE_ICON_GAP = 4;
    private static final int DB_NODE_ICON_GAP = 8;
    private static final int MIN_DISTANCE_FROM_DB_NODE = 88;
    private static final int COLLAPSIBLE_PANEL_IMAGE_TYPE = 1002;
    private static final int DATABASE_ICON_IMAGE_TYPE = 1002;
    private static final int FEATURE_ICON_IMAGE_TYPE = 1001;
    private static final int TOPOLOGY_NODE_IMAGE_TYPE = 1002;
    private static final int RIGHT_DESCRIPTION_GAP = 10;
    private static final Insets DESCRIPTION_LABEL_INSETS = new Insets(0, 0, 0, 10);
    private static final int NEW_PARAGRAPH_GAP = 10;
    private static final Insets TOP_GAP_INSETS = new Insets(10, 0, 0, 0);
    private static final Insets BOTTOM_GAP_INSETS = new Insets(0, 0, 10, 0);
    private static final int INDENT = 20;
    private static final Insets INDENTED_LABEL_INSETS = new Insets(0, 20, 0, 0);
    private static final Insets INDENTED_DESCRIPTION_LABEL_INSETS = new Insets(0, 20, 0, 10);
    private static final int ML_SERVER_GAP_ABOVE_TABLE = 5;
    private static final Insets ML_SERVER_TABLE_INSETS = new Insets(5, 20, 10, 0);
    private static final int PREFERRED_TABLE_WIDTH = 300;
    private static final float TITLE_FONT_SIZE_INCREMENT = 4.0f;
    private static final float DB_NODE_FONT_SIZE_INCREMENT = 1.0f;
    private static final int PRINTING_MINIMUM_WIDTH = 800;
    private static final int PRINTING_STATIC_INFO_FEATURES_MARGIN = 5;
    private static final int PRINTING_COLLAPSIBLE_PANEL_GAP = 20;
    private static final int PRINTING_TITLE_BODY_GAP = 3;
    private static final int PRINTING_BODY_INDENT = 32;
    private static final PrintingLabelMetadata NORMAL_PRINTING_METADATA = new PrintingLabelMetadata(0, false, 4);
    private static LinkedList<StateInfo> _stateInfoList = null;
    static DBDiagramResourcesBase bundle = null;
    private static String _unknownValueStr = null;
    private static ToolTipCellRenderer _toolTipCellRenderer = null;
    private static PathnameCellRenderer _filenameCellRenderer = null;
    private static ImageIcon _featureDisabledIcon = null;
    private static ImageIcon _featureEnabledIcon = null;
    private static ImageIcon _featureUnknownIcon = null;
    private static ImageIcon _greenLightIcon = null;
    private static ImageIcon _redLightIcon = null;
    private static Color _printingTextColor = null;
    private static Color _printingWarningColor = null;
    private static Font _printingTextFont = null;
    private static Font _printingTitleFont = null;
    private static Font _printingHeaderFont = null;
    private static Font _printingWarningFont = null;
    private static ImageIcon _printingWarningIcon = null;
    private static int _printingWarningHeight = 0;
    private static SimpleDateFormat _dateParser = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private ImageIcon _dbIcon = null;
    private DBDiagramClient _client;
    private int _databaseVersion;
    private String _panelTitle;
    private ActionListener _topologyActionListener;
    private ActionListener _collapsiblePanelActionListener;
    private FocusListener _collapsiblePanelFocusListener;
    private boolean _fitToPage = false;
    private PrintingPaginatedPanel _printingPanel = null;
    private FontMetrics _printingTextMetrics = null;
    private FontMetrics _printingTitleMetrics = null;
    private FontMetrics _printingHeaderMetrics = null;
    private FontMetrics _printingWarningMetrics = null;
    private PrintJobThread _printJobThread = null;
    private PrintJobListener _printJobListener = null;
    private boolean _showSQLExceptionDialog = false;
    private boolean _isRefreshing = false;
    private boolean _atLeastOneWarning = false;
    private boolean _isStopped = true;
    private boolean _resourcesReleased = false;
    private boolean _logEnabled = false;
    private boolean _mirrorLogEnabled = false;
    private boolean _remServersEnabled = false;
    private boolean _mirroringEnabled = false;
    private boolean _mobilinkEnabled = false;
    private boolean _qanywhereEnabled = false;
    private boolean _notifierEnabled = false;
    private boolean _sqlRemoteEnabled = false;
    private boolean _staticInfoShown = false;
    private boolean _mlServerRefreshStarted = false;
    private boolean _dbspacesCleared = false;
    private boolean _logsCleared = false;
    private boolean _mirroringCleared = false;
    private boolean _remServersCleared = false;
    private boolean _sqlRemoteCleared = false;
    private boolean _statisticsCleared = false;
    private boolean _usersCleared = false;
    private boolean _topologyNeedsUpdate = false;
    private StateInfo _stateInfoToRestore = null;
    private StateInfo _stateInfoToSave = null;
    private String _dbName = "";
    private String _mainDirectory = null;
    private File _stateFile = null;
    private ArrayList<ClientNotifier> _clientNotifiers = null;
    private StatisticsTableModel _dbspacesTableModel = null;
    private ArrayList<CellPanel> _dbspacesCellPanels = null;
    private StatisticsTableModel _transTimesTableModel = null;
    private StatisticsTableModel _blockedConnsTableModel = null;
    private StatisticsTableModel _remServersTableModel = null;
    private ArrayList<CellPanel> _remServersCellPanels = null;
    private StatisticsTableModel _mobilinkTableModel = null;
    private StatisticsTableModel _qanywhereTableModel = null;
    private StatisticsTableModel _notifierTableModel = null;
    private StatisticsTableModel _sqlRemoteTableModel = null;
    private HashMap<String, String[]> _mlServerTableOwners = null;
    private int _mobilinkTableGridy = 0;
    private int _qanywhereTableGridy = 0;
    private int _notifierTableGridy = 0;
    private JSplitPane _splitPane;
    private JPanel _staticInfoPanel;
    private JPanel _featuresPanel;
    private JPanel _detailsPanel;
    private JScrollPane _leftScrollPane;
    private SybLimitedWidthLabel _dbNameLabel;
    private JLabel _versionLabel;
    private SybLimitedWidthLabel _platformLabel;
    private SybLimitedWidthLabel _hostNameLabel;
    private JLabel _portLabel;
    private JLabel _webPortLabel;
    private JLabel _alternateNameDesc;
    private SybLimitedWidthLabel _alternateNameLabel;
    private JLabel _pageSizeLabel;
    private SybButton _checkForUpdatesButton;
    private JLabel _featuresLabel;
    private TopologyPanel _topologyDiagramPanel;
    private TopologyNode _dbNode;
    private GridBagConstraints _dbNodeGBC;
    private TopologyNode _arbiterNode;
    private GridBagConstraints _arbiterNodeGBC;
    private TopologyNode _mirrorNode;
    private GridBagConstraints _mirrorNodeGBC;
    private TopologyNode _mobilinkNode;
    private GridBagConstraints _mobilinkNodeGBC;
    private TopologyNode _qanywhereNode;
    private GridBagConstraints _qanywhereNodeGBC;
    private TopologyNode _remServersNode;
    private GridBagConstraints _remServersNodeGBC;
    private TopologyNode _sqlRemoteNode;
    private GridBagConstraints _sqlRemoteNodeGBC;
    private Component _leftTopologyStrut;
    private Component _midLeftTopologyStrut;
    private Component _midRightTopologyStrut;
    private Component _rightTopologyStrut;
    private JLabel _detailsLabel;
    private JLabel _refreshingLabel;
    private JScrollPane _detailsScrollPane;
    private JPanel _collapsiblePanelsPanel;
    private DBDiagramCollapsiblePanel _statisticsPanel;
    private JLabel _diskReadsLabel;
    private JLabel _diskWritesLabel;
    private JLabel _currentIOLabel;
    private ClickablePanel _unschReqClickPanel;
    private JLabel _unschReqDesc;
    private JLabel _unschReqLabel;
    private DBDiagramCollapsiblePanel _dbspacesPanel;
    private JTable _dbspacesTable;
    private DBDiagramCollapsiblePanel _logsPanel = null;
    private SybPathnameLabel _logFileLabel = null;
    private ClickablePanel _logSpaceClickPanel = null;
    private JLabel _logSpaceLabel = null;
    private JLabel _mirrorLogDesc = null;
    private JLabel _mirrorLogFileDesc = null;
    private SybPathnameLabel _mirrorLogFileLabel = null;
    private JLabel _mirrorLogSpaceDesc = null;
    private ClickablePanel _mirrorLogSpaceClickPanel = null;
    private JLabel _mirrorLogSpaceLabel = null;
    private DBDiagramCollapsiblePanel _usersPanel;
    private JLabel _userCountLabel;
    private JLabel _maxConnsLabel;
    private JLabel _transTimesLabel;
    private JScrollPane _transTimesScrollPane;
    private JTable _transTimesTable;
    private ClickablePanel _blockedConnsClickPanel;
    private JLabel _blockedConnCountDesc;
    private JLabel _blockedConnCountLabel;
    private JScrollPane _blockedConnsScrollPane;
    private JTable _blockedConnsTable;
    private DBDiagramCollapsiblePanel _mirroringPanel = null;
    private SybMultiLineLabel _mirroringLabel = null;
    private SybLimitedWidthLabel _primaryNameLabel = null;
    private SybPathnameLabel _primaryStateFileLabel = null;
    private SybLimitedWidthLabel _arbiterNameLabel = null;
    private ClickablePanel _arbiterStatusClickPanel = null;
    private JLabel _arbiterStatusLabel = null;
    private SybLimitedWidthLabel _mirrorNameLabel = null;
    private ClickablePanel _mirrorStatusClickPanel = null;
    private JLabel _mirrorStatusLabel = null;
    private JLabel _mirroringStateLabel = null;
    private JLabel _mirroringModeLabel = null;
    private JLabel _mirroringSeqLabel = null;
    private DBDiagramCollapsiblePanel _remServersPanel = null;
    private JTable _remServersTable = null;
    private DBDiagramCollapsiblePanel _mlServerPanel = null;
    private JPanel _mlServerBody = null;
    private SybMultiLineLabel _refreshMLServerLabel = null;
    private SybButton _refreshMLServerButton = null;
    private JLabel _mobilinkLabel = null;
    private JScrollPane _mobilinkScrollPane = null;
    private JTable _mobilinkTable = null;
    private JLabel _lastUploadDesc = null;
    private JLabel _lastUploadLabel = null;
    private JLabel _lastDownloadDesc = null;
    private JLabel _lastDownloadLabel = null;
    private JLabel _qanywhereLabel = null;
    private JScrollPane _qanywhereScrollPane = null;
    private JTable _qanywhereTable = null;
    private JLabel _lastActivityDesc = null;
    private JLabel _lastActivityLabel = null;
    private JScrollPane _notifierScrollPane = null;
    private JTable _notifierTable = null;
    private JLabel _notifierCountDesc = null;
    private JLabel _notifierCountLabel = null;
    private DBDiagramCollapsiblePanel _sqlRemotePanel = null;
    private JTable _sqlRemoteTable = null;

    public DBDiagramPanel(DBDiagramClient dBDiagramClient, int n, String string) {
        boolean bl = false;
        if (dBDiagramClient == null) {
            throw new IllegalArgumentException("client cannot be null");
        }
        this._client = dBDiagramClient;
        switch (n) {
            case 1000: 
            case 1100: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid database version: " + n);
            }
        }
        this._databaseVersion = n;
        this._panelTitle = string;
        try {
            bl = this.getPropertyStr("PROPERTY", "IsNetworkServer").equalsIgnoreCase("yes");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this._dbIcon = bl ? ASAComponentsImageLoader.getImageIcon("server", 1002) : ASAComponentsImageLoader.getImageIcon("engine", 1002);
        if (_stateInfoList == null) {
            _stateInfoList = new LinkedList();
            bundle = DBDiagramResourcesBase.getBundle();
            _unknownValueStr = bundle.getString("UNKNOWN_VALUE");
            DBDiagramUtils.init();
            _toolTipCellRenderer = new ToolTipCellRenderer();
            _filenameCellRenderer = new PathnameCellRenderer();
            _featureDisabledIcon = ASAComponentsImageLoader.getImageIcon("blank", 1001);
            _featureEnabledIcon = ASAComponentsImageLoader.getImageIcon("feature_enabled", 1001);
            _featureUnknownIcon = ASAComponentsImageLoader.getImageIcon("feature_unknown", 1001);
            _greenLightIcon = ASAComponentsImageLoader.getImageIcon("greenlight", 1002);
            _redLightIcon = ASAComponentsImageLoader.getImageIcon("redlight", 1002);
            _printingTextColor = UIManager.getColor("Label.foreground");
            _printingWarningColor = DBDiagramUtils.WARNING_COLOR;
            _printingTextFont = UIManager.getFont("Label.font");
            _printingHeaderFont = _printingWarningFont = DBDiagramUtils.boldFont(_printingTextFont);
            _printingTitleFont = DBDiagramUtils.increaseFontSize(_printingHeaderFont, 8.0f);
            _printingWarningIcon = DBDiagramUtils._warningIcon;
            _printingWarningHeight = Math.max(_printingWarningFont.getSize(), _printingWarningIcon.getIconHeight());
        }
        this.setOpaque(false);
        this.createUI();
    }

    public void releaseResources() {
        int n;
        this.stop();
        this._resourcesReleased = true;
        if (this._stateInfoToRestore != null && this._stateInfoToSave == null) {
            _stateInfoList.add(this._stateInfoToRestore);
        } else {
            if (this._stateInfoToSave == null) {
                this._stateInfoToSave = new StateInfo();
            }
            this._stateInfoToSave.dbName = this._dbName;
            this._stateInfoToSave.wasStatisticsPanelCollapsed = this._statisticsPanel.isCollapsed();
            this._stateInfoToSave.wasDbspacesPanelCollapsed = this._dbspacesPanel.isCollapsed();
            if (this._logsPanel != null) {
                this._stateInfoToSave.wasLogsPanelCollapsed = this._logsPanel.isCollapsed();
            }
            this._stateInfoToSave.wasUsersPanelCollapsed = this._usersPanel.isCollapsed();
            if (this._mirroringPanel != null) {
                this._stateInfoToSave.wasMirroringPanelCollapsed = this._mirroringPanel.isCollapsed();
            }
            if (this._remServersPanel != null) {
                this._stateInfoToSave.wasRemServersPanelCollapsed = this._remServersPanel.isCollapsed();
            }
            if (this._mlServerPanel != null) {
                this._stateInfoToSave.wasMLServerPanelCollapsed = this._mlServerPanel.isCollapsed();
            }
            if (this._sqlRemotePanel != null) {
                this._stateInfoToSave.wasSQLRemotePanelCollapsed = this._sqlRemotePanel.isCollapsed();
            }
            if (this._detailsScrollPane.getHorizontalScrollBar().isVisible()) {
                this._stateInfoToSave.detailsHSBValue = this._detailsScrollPane.getHorizontalScrollBar().getValue();
            }
            if (this._detailsScrollPane.getVerticalScrollBar().isVisible()) {
                this._stateInfoToSave.detailsVSBValue = this._detailsScrollPane.getVerticalScrollBar().getValue();
            }
            if (this._leftScrollPane.getVerticalScrollBar().isVisible()) {
                this._stateInfoToSave.leftVSBValue = this._leftScrollPane.getVerticalScrollBar().getValue();
            }
            this._stateInfoToSave.splitPaneDividerLocation = this._splitPane.getDividerLocation();
            if (_stateInfoList.size() >= 5) {
                _stateInfoList.remove(0);
            }
            _stateInfoList.add(this._stateInfoToSave);
        }
        this._dbName = null;
        this._mainDirectory = null;
        this._dbNameLabel = null;
        this._versionLabel = null;
        this._platformLabel = null;
        this._hostNameLabel = null;
        this._portLabel = null;
        this._webPortLabel = null;
        this._alternateNameDesc = null;
        this._alternateNameLabel = null;
        this._pageSizeLabel = null;
        this._checkForUpdatesButton = null;
        this._featuresLabel = null;
        if (this._dbNode != null) {
            this._dbNode.releaseResources();
            this._dbNode = null;
            this._dbNodeGBC = null;
        }
        if (this._arbiterNode != null) {
            this._arbiterNode.removeActionListener(this._topologyActionListener);
            this._arbiterNode.releaseResources();
            this._arbiterNode = null;
            this._arbiterNodeGBC = null;
        }
        if (this._mirrorNode != null) {
            this._mirrorNode.removeActionListener(this._topologyActionListener);
            this._mirrorNode.releaseResources();
            this._mirrorNode = null;
            this._mirrorNodeGBC = null;
        }
        if (this._mobilinkNode != null) {
            this._mobilinkNode.removeActionListener(this._topologyActionListener);
            this._mobilinkNode.releaseResources();
            this._mobilinkNode = null;
            this._mobilinkNodeGBC = null;
        }
        if (this._qanywhereNode != null) {
            this._qanywhereNode.removeActionListener(this._topologyActionListener);
            this._qanywhereNode.releaseResources();
            this._qanywhereNode = null;
            this._qanywhereNodeGBC = null;
        }
        if (this._remServersNode != null) {
            this._remServersNode.removeActionListener(this._topologyActionListener);
            this._remServersNode.releaseResources();
            this._remServersNode = null;
            this._remServersNodeGBC = null;
        }
        if (this._sqlRemoteNode != null) {
            this._sqlRemoteNode.removeActionListener(this._topologyActionListener);
            this._sqlRemoteNode.releaseResources();
            this._sqlRemoteNode = null;
            this._sqlRemoteNodeGBC = null;
        }
        this._leftTopologyStrut = null;
        this._midLeftTopologyStrut = null;
        this._midRightTopologyStrut = null;
        this._rightTopologyStrut = null;
        this._topologyDiagramPanel = null;
        this._topologyActionListener = null;
        this._detailsLabel = null;
        this._refreshingLabel = null;
        if (this._clientNotifiers != null) {
            for (n = 0; n < this._clientNotifiers.size(); ++n) {
                this._clientNotifiers.get(n).releaseResources();
            }
            this._clientNotifiers.clear();
            this._clientNotifiers = null;
        }
        if (this._statisticsPanel != null) {
            this._statisticsPanel.removeFocusListener(this._collapsiblePanelFocusListener);
            this._statisticsPanel.releaseResources();
            this._statisticsPanel = null;
            this._diskReadsLabel = null;
            this._diskWritesLabel = null;
            this._currentIOLabel = null;
            if (this._unschReqClickPanel != null) {
                this._unschReqClickPanel.releaseResources();
                this._unschReqClickPanel = null;
            }
            this._unschReqDesc = null;
            this._unschReqLabel = null;
        }
        if (this._dbspacesPanel != null) {
            this._dbspacesPanel.removeFocusListener(this._collapsiblePanelFocusListener);
            this._dbspacesPanel.releaseResources();
            this._dbspacesPanel = null;
            if (this._dbspacesTableModel != null) {
                this._dbspacesTableModel.releaseResources();
                this._dbspacesTableModel = null;
            }
            if (this._dbspacesCellPanels != null) {
                for (n = 0; n < this._dbspacesCellPanels.size(); ++n) {
                    this._dbspacesCellPanels.get(n).releaseResources();
                }
                this._dbspacesCellPanels.clear();
                this._dbspacesCellPanels = null;
            }
            this._dbspacesTable = null;
        }
        if (this._logsPanel != null) {
            this._logsPanel.removeFocusListener(this._collapsiblePanelFocusListener);
            this._logsPanel.releaseResources();
            this._logsPanel = null;
            this._logFileLabel = null;
            if (this._logSpaceClickPanel != null) {
                this._logSpaceClickPanel.releaseResources();
                this._logSpaceClickPanel = null;
            }
            this._logSpaceLabel = null;
            this._mirrorLogDesc = null;
            this._mirrorLogFileDesc = null;
            this._mirrorLogFileLabel = null;
            this._mirrorLogSpaceDesc = null;
            if (this._mirrorLogSpaceClickPanel != null) {
                this._mirrorLogSpaceClickPanel.releaseResources();
                this._mirrorLogSpaceClickPanel = null;
            }
            this._mirrorLogSpaceLabel = null;
        }
        if (this._usersPanel != null) {
            this._usersPanel.removeFocusListener(this._collapsiblePanelFocusListener);
            this._usersPanel.releaseResources();
            this._usersPanel = null;
            if (this._transTimesTableModel != null) {
                this._transTimesTableModel.releaseResources();
                this._transTimesTableModel = null;
            }
            if (this._blockedConnsTableModel != null) {
                this._blockedConnsTableModel.releaseResources();
                this._blockedConnsTableModel = null;
            }
            if (this._blockedConnsClickPanel != null) {
                this._blockedConnsClickPanel.releaseResources();
            }
            this._userCountLabel = null;
            this._maxConnsLabel = null;
            this._transTimesLabel = null;
            this._transTimesScrollPane = null;
            this._transTimesTable = null;
            this._blockedConnCountDesc = null;
            this._blockedConnCountLabel = null;
            this._blockedConnsScrollPane = null;
            this._blockedConnsTable = null;
        }
        if (this._mirroringPanel != null) {
            this._mirroringPanel.removeFocusListener(this._collapsiblePanelFocusListener);
            this._mirroringPanel.releaseResources();
            this._mirroringPanel = null;
            this._mirroringLabel = null;
            this._primaryNameLabel = null;
            this._primaryStateFileLabel = null;
            this._arbiterNameLabel = null;
            this._arbiterStatusClickPanel = null;
            this._arbiterStatusLabel = null;
            this._mirrorNameLabel = null;
            this._mirrorStatusClickPanel = null;
            this._mirrorStatusLabel = null;
            this._mirroringStateLabel = null;
            this._mirroringModeLabel = null;
            this._mirroringSeqLabel = null;
        }
        if (this._remServersPanel != null) {
            this._remServersPanel.removeFocusListener(this._collapsiblePanelFocusListener);
            this._remServersPanel.releaseResources();
            this._remServersPanel = null;
            if (this._remServersTableModel != null) {
                this._remServersTableModel.releaseResources();
                this._remServersTableModel = null;
            }
            if (this._remServersCellPanels != null) {
                for (n = 0; n < this._remServersCellPanels.size(); ++n) {
                    this._remServersCellPanels.get(n).releaseResources();
                }
                this._remServersCellPanels.clear();
                this._remServersCellPanels = null;
            }
            this._remServersTable = null;
        }
        if (this._mlServerPanel != null) {
            this._mlServerPanel.removeFocusListener(this._collapsiblePanelFocusListener);
            this._mlServerPanel.releaseResources();
            this._mlServerPanel = null;
            this._mlServerBody = null;
            this._refreshMLServerLabel = null;
            this._refreshMLServerButton = null;
            if (this._mobilinkTableModel != null) {
                this._mobilinkTableModel.releaseResources();
                this._mobilinkTableModel = null;
            }
            this._mobilinkScrollPane = null;
            this._mobilinkTable = null;
            this._mobilinkLabel = null;
            this._lastUploadDesc = null;
            this._lastUploadLabel = null;
            this._lastDownloadDesc = null;
            this._lastDownloadLabel = null;
            if (this._qanywhereTableModel != null) {
                this._qanywhereTableModel.releaseResources();
                this._qanywhereTableModel = null;
            }
            this._qanywhereScrollPane = null;
            this._qanywhereTable = null;
            this._qanywhereLabel = null;
            this._lastActivityDesc = null;
            this._lastActivityLabel = null;
            if (this._notifierTableModel != null) {
                this._notifierTableModel.releaseResources();
                this._notifierTableModel = null;
            }
            this._notifierScrollPane = null;
            this._notifierTable = null;
            this._notifierCountDesc = null;
            this._notifierCountLabel = null;
        }
        if (this._sqlRemotePanel != null) {
            this._sqlRemotePanel.removeFocusListener(this._collapsiblePanelFocusListener);
            this._sqlRemotePanel.releaseResources();
            this._sqlRemotePanel = null;
            if (this._sqlRemoteTableModel != null) {
                this._sqlRemoteTableModel.releaseResources();
                this._sqlRemoteTableModel = null;
            }
            this._sqlRemoteTable = null;
        }
        this._collapsiblePanelActionListener = null;
        this._collapsiblePanelFocusListener = null;
        this._staticInfoPanel = null;
        this._featuresPanel = null;
        this._detailsScrollPane = null;
        this._detailsPanel = null;
        this._leftScrollPane = null;
        this._splitPane = null;
        this._printingPanel = null;
        this._printingTextMetrics = null;
        this._printingHeaderMetrics = null;
        this._printingWarningMetrics = null;
        this._printJobThread = null;
        this._client = null;
    }

    public void setShowSQLExceptionDialog(boolean bl) {
        this._showSQLExceptionDialog = bl;
    }

    public void start() {
        this._isStopped = false;
        this.refreshAll();
    }

    public void stop() {
        this._isStopped = true;
        this._isRefreshing = false;
    }

    private void clearClientNotifiers() {
        int n;
        this._unschReqClickPanel.setEnabled(false);
        this._unschReqClickPanel.removeAllActionListeners();
        if (this._logSpaceClickPanel != null) {
            this._logSpaceClickPanel.setEnabled(false);
            this._logSpaceClickPanel.removeAllActionListeners();
        }
        if (this._mirrorLogSpaceClickPanel != null) {
            this._mirrorLogSpaceClickPanel.setEnabled(false);
            this._mirrorLogSpaceClickPanel.removeAllActionListeners();
        }
        this._blockedConnsClickPanel.setEnabled(false);
        this._blockedConnsClickPanel.removeAllActionListeners();
        if (this._arbiterStatusClickPanel != null) {
            this._arbiterStatusClickPanel.setEnabled(false);
            this._arbiterStatusClickPanel.removeAllActionListeners();
        }
        if (this._mirrorStatusClickPanel != null) {
            this._mirrorStatusClickPanel.setEnabled(false);
            this._mirrorStatusClickPanel.removeAllActionListeners();
        }
        for (n = 0; n < this._dbspacesCellPanels.size(); ++n) {
            this._dbspacesCellPanels.get(n).releaseResources();
        }
        this._dbspacesCellPanels.clear();
        if (this._remServersCellPanels != null) {
            for (n = 0; n < this._remServersCellPanels.size(); ++n) {
                this._remServersCellPanels.get(n).releaseResources();
            }
            this._remServersCellPanels.clear();
        }
        for (n = 0; n < this._clientNotifiers.size(); ++n) {
            this._clientNotifiers.get(n).releaseResources();
        }
        this._clientNotifiers.clear();
    }

    private void clearDbspaces() {
        this._dbspacesTableModel.clear();
        this.resizeTable(this._dbspacesTable, 0);
        this._dbspacesPanel.clearWarnings();
        this._dbspacesCleared = true;
    }

    private void clearLogs() {
        if (this._logsPanel != null) {
            this._logSpaceLabel.setText(_unknownValueStr);
            this._logSpaceClickPanel.setShowBorder(false);
            this._logSpaceClickPanel.setToolTipText(null);
            DBDiagramUtils.clearWarning(this._logSpaceLabel);
            this._mirrorLogSpaceLabel.setText(_unknownValueStr);
            this._mirrorLogSpaceClickPanel.setShowBorder(false);
            this._mirrorLogSpaceClickPanel.setToolTipText(null);
            DBDiagramUtils.clearWarning(this._mirrorLogSpaceLabel);
            this._logsPanel.clearWarnings();
        }
        this._logsCleared = true;
    }

    private void clearMirroring() {
        if (this._mirroringPanel != null) {
            this._arbiterStatusClickPanel.setShowBorder(false);
            this._arbiterStatusLabel.setText(_unknownValueStr);
            DBDiagramUtils.clearWarning(this._arbiterStatusLabel);
            this._mirrorStatusClickPanel.setShowBorder(false);
            this._mirrorStatusLabel.setText(_unknownValueStr);
            DBDiagramUtils.clearWarning(this._mirrorStatusLabel);
            this._mirroringModeLabel.setText(_unknownValueStr);
            this._mirroringSeqLabel.setText(_unknownValueStr);
            this._mirroringStateLabel.setText(_unknownValueStr);
            this._mirroringPanel.clearWarnings();
            this._arbiterNode.setWarning(false);
            this._mirrorNode.setWarning(false);
        }
        this._mirroringCleared = true;
    }

    private void clearMLServer() {
        if (this._mlServerPanel != null) {
            if (this._mobilinkTable != null) {
                this._mobilinkTableModel.clear();
                this.resizeTable(this._mobilinkTable, 0);
            }
            this._mobilinkLabel.setText(bundle.getString("UNKNOWN_MOBILINK"));
            this._lastUploadLabel.setText(_unknownValueStr);
            this._lastDownloadLabel.setText(_unknownValueStr);
            if (this._qanywhereTable != null) {
                this._qanywhereTableModel.clear();
                this.resizeTable(this._qanywhereTable, 0);
            }
            this._qanywhereLabel.setText(bundle.getString("UNKNOWN_QANYWHERE"));
            this._lastActivityLabel.setText(_unknownValueStr);
            if (this._notifierTable != null) {
                this._notifierTableModel.clear();
                this.resizeTable(this._notifierTable, 0);
            }
            this._notifierCountLabel.setText(_unknownValueStr);
        }
    }

    private void clearRemServers() {
        if (this._remServersPanel != null) {
            this._remServersTableModel.clear();
            this.resizeTable(this._remServersTable, 0);
            this._remServersPanel.clearWarnings();
            this._remServersNode.setWarning(false);
        }
        this._remServersCleared = true;
    }

    private void clearSQLRemote() {
        if (this._sqlRemotePanel != null) {
            this._sqlRemoteTableModel.clear();
            this.resizeTable(this._sqlRemoteTable, 0);
            this._sqlRemotePanel.clearWarnings();
        }
        this._sqlRemoteCleared = true;
    }

    private void clearStatistics() {
        this._diskReadsLabel.setText(_unknownValueStr);
        this._diskWritesLabel.setText(_unknownValueStr);
        this._currentIOLabel.setText(_unknownValueStr);
        this._unschReqClickPanel.setShowBorder(false);
        this.clearWarningHack(this._unschReqDesc, this._unschReqLabel);
        this._unschReqLabel.setText(_unknownValueStr);
        DBDiagramUtils.clearWarning(this._unschReqLabel);
        this._statisticsPanel.clearWarnings();
        this._statisticsCleared = true;
    }

    private void clearUsers() {
        this._transTimesTableModel.clear();
        this.resizeTable(this._transTimesTable, 0);
        this._blockedConnsTableModel.clear();
        this.resizeTable(this._blockedConnsTable, 0);
        this._userCountLabel.setText(_unknownValueStr);
        this._transTimesLabel.setText(bundle.getString("UNKNOWN_TRANSACTION_TIMES"));
        this._transTimesScrollPane.setVisible(false);
        this._blockedConnsClickPanel.setShowBorder(false);
        this.clearWarningHack(this._blockedConnCountDesc, this._blockedConnCountLabel);
        this._blockedConnCountLabel.setText(_unknownValueStr);
        this._blockedConnsScrollPane.setVisible(false);
        this._usersPanel.clearWarnings();
        this._usersCleared = true;
    }

    private void clearWarningHack(JLabel jLabel, JLabel jLabel2) {
        jLabel.setBorder(null);
        jLabel.setCursor(null);
        DBDiagramUtils.clearWarning(jLabel);
        jLabel2.setBorder(null);
        jLabel2.setCursor(null);
        DBDiagramUtils.clearWarning(jLabel2);
    }

    private void collapsiblePanelClicked(DBDiagramCollapsiblePanel dBDiagramCollapsiblePanel) {
        this.scrollToCollapsiblePanel(dBDiagramCollapsiblePanel);
    }

    private void createArbiterNode(String string) {
        this._arbiterNode = new TopologyNode(bundle.getString("ARBITER_NODE"), Integer.MAX_VALUE, string, 100, ASAComponentsImageLoader.getImageIcon("mirroring_server", 1002), 4, true, true, bundle.getString("DB_MIRRORING_FEATURE"));
        this._arbiterNode.setEnabled(false);
        this._arbiterNode.addActionListener(this._topologyActionListener);
        this._arbiterNodeGBC = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 19, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        this._topologyDiagramPanel.add((Component)this._arbiterNode, this._arbiterNodeGBC);
    }

    private GridBagConstraints createCollapsiblePanelGBC(int n) {
        return new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 10, 2, TOP_GAP_INSETS, 0, 0);
    }

    private void createCollapsiblePanels() {
        this._collapsiblePanelActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBDiagramPanel.this.collapsiblePanelClicked((DBDiagramCollapsiblePanel)actionEvent.getSource());
            }
        };
        this._collapsiblePanelFocusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                Container container = SwingUtilities.getAncestorOfClass(DBDiagramCollapsiblePanel.class, (Component)focusEvent.getSource());
                DBDiagramPanel.this.scrollToCollapsiblePanel((DBDiagramCollapsiblePanel)container);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
            }
        };
        this.createStatisticsPanel();
        this.createDbspacesPanel();
        this.createUsersPanel();
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 9, 1, 1, 0.0, 1.0, 10, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        this._collapsiblePanelsPanel.add((Component)new EmptyComponent(), gridBagConstraints);
    }

    private void createDatabaseNode(String string) {
        this._dbNode = new TopologyNode(string, 74, ASAComponentsImageLoader.getImageIcon("database", 1002), 8, false, false, null);
        this._dbNodeGBC = new GridBagConstraints(2, 1, 1, 1, 0.0, 1.0, 19, 3, DBDiagramUtils.ZERO_INSETS, 0, 0);
        this._topologyDiagramPanel.add((Component)this._dbNode, this._dbNodeGBC);
    }

    private void createDbspacesPanel() {
        JPanel jPanel = UIUtils.createExplorerBarGroup();
        jPanel.setLayout(new GridLayout(1, 1));
        String[] stringArray = new String[]{bundle.getString("NAME_COLUMN"), bundle.getString("FILE_COLUMN"), bundle.getString("SPACE_COLUMN")};
        this._dbspacesTableModel = new StatisticsTableModel(3, stringArray, 5);
        this._dbspacesCellPanels = new ArrayList(5);
        this._dbspacesTable = new JTable(this._dbspacesTableModel);
        TableColumnModel tableColumnModel = this._dbspacesTable.getColumnModel();
        tableColumnModel.getColumn(1).setCellRenderer(_filenameCellRenderer);
        tableColumnModel.getColumn(2).setCellRenderer(new WarningAwareCellRenderer(this._dbspacesTableModel));
        this._dbspacesTable.setTableHeader(new ToolTipTableHeader(tableColumnModel));
        this._dbspacesTable.setAutoCreateRowSorter(true);
        this._dbspacesTable.setColumnSelectionAllowed(false);
        this._dbspacesTable.setDefaultRenderer(Object.class, _toolTipCellRenderer);
        this._dbspacesTable.setFocusable(false);
        this.resizeTable(this._dbspacesTable, 0);
        this._dbspacesTable.setRowSelectionAllowed(false);
        this._dbspacesTable.getTableHeader().setReorderingAllowed(false);
        jPanel.add(new JScrollPane(this._dbspacesTable));
        this._dbspacesPanel = new DBDiagramCollapsiblePanel(bundle.getString("DBSPACES_TITLE"), ASAComponentsImageLoader.getImageIcon("dbspace", 1002), jPanel);
        this._dbspacesPanel.setCollapsed(true);
        this._dbspacesPanel.addActionListener(this._collapsiblePanelActionListener);
        this._dbspacesPanel.addFocusListener(this._collapsiblePanelFocusListener);
        this._dbspacesPanel.setOpaque(false);
        this._collapsiblePanelsPanel.add((Component)this._dbspacesPanel, this.createCollapsiblePanelGBC(1));
    }

    private PrintingPanel createDbspacesPrintPanel(Graphics graphics, int n) {
        PrintingPanel printingPanel = new PrintingPanel();
        PrintingComponent printingComponent = this._dbspacesPanel.createTitlePrintingComponent(graphics);
        printingPanel.add(printingComponent);
        int n2 = 32;
        int n3 = printingComponent.getHeight();
        n3 += 3;
        int n4 = n - n2;
        PrintingLabelMetadata[] printingLabelMetadataArray = new PrintingLabelMetadata[3];
        printingLabelMetadataArray[0] = NORMAL_PRINTING_METADATA.createCopy();
        printingLabelMetadataArray[0].maxWidth = n4 / 3;
        printingLabelMetadataArray[1] = NORMAL_PRINTING_METADATA.createCopy();
        printingLabelMetadataArray[1].truncateToFit = true;
        printingLabelMetadataArray[1].truncationType = 1;
        printingLabelMetadataArray[2] = printingLabelMetadataArray[0].createCopy();
        printingLabelMetadataArray[2].warningType = 2;
        printingComponent = this.createPrintingTable(this._dbspacesTable, printingLabelMetadataArray, n4);
        printingComponent.setX(n2);
        printingComponent.setY(n3);
        printingPanel.add(printingComponent);
        return printingPanel;
    }

    private void createDetailsComponents() {
        this._clientNotifiers = new ArrayList(10);
        int n = 0;
        this._detailsLabel = new JLabel(bundle.getString("HEALTH_AND_STATISTICS"), 0);
        DBDiagramUtils.boldLabelFont(this._detailsLabel);
        DBDiagramUtils.increaseLabelFontSize(this._detailsLabel, 4.0f);
        this.setShowWarningAtTop(false);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, n, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 0, 5), 0, 0);
        this._detailsPanel.add((Component)this._detailsLabel, gridBagConstraints);
        this._refreshingLabel = new JLabel(bundle.getFormatted("LAST_UPDATED", _dateParser.format(new Date())));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0);
        this._detailsPanel.add((Component)this._refreshingLabel, gridBagConstraints);
        JSeparator jSeparator = new JSeparator(0);
        jSeparator.setMinimumSize(jSeparator.getPreferredSize());
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 1.0, 0.0, 10, 2, DBDiagramUtils.ZERO_INSETS, 0, 0);
        this._detailsPanel.add((Component)jSeparator, gridBagConstraints);
        this._collapsiblePanelsPanel = UIUtils.createExplorerBar();
        this._collapsiblePanelsPanel.setBorder(new EmptyBorder(5, 5, 5, 5));
        this._collapsiblePanelsPanel.setLayout(new GridBagLayout());
        this._detailsScrollPane = new JScrollPane(this._collapsiblePanelsPanel);
        this._detailsScrollPane.setOpaque(false);
        this._detailsScrollPane.getViewport().setOpaque(false);
        this.createCollapsiblePanels();
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 10, 1, DBDiagramUtils.ZERO_INSETS, 0, 0);
        this._detailsPanel.add((Component)this._detailsScrollPane, gridBagConstraints);
    }

    private void createFeaturesComponents() {
        int n = 0;
        this._featuresLabel = new JLabel(bundle.getString("FEATURES"));
        DBDiagramUtils.boldLabelFont(this._featuresLabel);
        DBDiagramUtils.increaseLabelFontSize(this._featuresLabel, 4.0f);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 5, 0), 0, 0);
        this._featuresPanel.add((Component)this._featuresLabel, gridBagConstraints);
        this._topologyDiagramPanel = new TopologyPanel();
        this._topologyDiagramPanel.setOpaque(false);
        this._topologyDiagramPanel.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 1.0, 1.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0);
        this._featuresPanel.add((Component)this._topologyDiagramPanel, gridBagConstraints);
        this._topologyActionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBDiagramPanel.this.topologyNodeClicked(actionEvent);
            }
        };
        this._leftTopologyStrut = new EmptyComponent();
        gridBagConstraints = new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 10, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        this._topologyDiagramPanel.add(this._leftTopologyStrut, gridBagConstraints);
        this._midLeftTopologyStrut = new EmptyComponent();
        gridBagConstraints = new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        this._topologyDiagramPanel.add(this._midLeftTopologyStrut, gridBagConstraints);
        this._midRightTopologyStrut = new EmptyComponent();
        gridBagConstraints = new GridBagConstraints(3, 1, 1, 1, 0.0, 0.0, 10, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        this._topologyDiagramPanel.add(this._midRightTopologyStrut, gridBagConstraints);
        this._rightTopologyStrut = new EmptyComponent();
        gridBagConstraints = new GridBagConstraints(4, 3, 1, 1, 0.0, 0.0, 10, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        this._topologyDiagramPanel.add(this._rightTopologyStrut, gridBagConstraints);
        this.createRemServersNode();
        this.createSQLRemoteNode();
        this.createMirrorNode(" ");
        this.createArbiterNode(" ");
    }

    private PrintingPanel createFeaturesPrintPanel() {
        PrintingPanel printingPanel = new PrintingPanel();
        PrintingJCWrapper printingJCWrapper = new PrintingJCWrapper(this._featuresLabel);
        int n = ((PrintingComponent)printingJCWrapper).getHeight() + 5;
        PrintingJCWrapper printingJCWrapper2 = new PrintingJCWrapper(this._topologyDiagramPanel);
        printingJCWrapper2.setY(n);
        int n2 = Math.max(((PrintingComponent)printingJCWrapper).getWidth(), printingPanel.getWidth());
        if (n2 > ((PrintingComponent)printingJCWrapper2).getWidth()) {
            printingJCWrapper2.setX((n2 - ((PrintingComponent)printingJCWrapper2).getWidth()) / 2);
        }
        printingPanel.add(printingJCWrapper2);
        if (printingPanel.getWidth() > ((PrintingComponent)printingJCWrapper).getWidth()) {
            printingJCWrapper.setX((printingPanel.getWidth() - ((PrintingComponent)printingJCWrapper).getWidth()) / 2);
        }
        printingPanel.add(printingJCWrapper);
        return printingPanel;
    }

    private void createLogsPanel() {
        JPanel jPanel = UIUtils.createExplorerBarGroup();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        JLabel jLabel = new JLabel(bundle.getString("TRANSACTION_LOG"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel(bundle.getString("FILE_NAME"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, INDENTED_DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._logFileLabel = new SybPathnameLabel(_unknownValueStr, 0);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 2, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._logFileLabel, gridBagConstraints);
        jLabel = new JLabel(bundle.getString("FREE_SPACE"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, INDENTED_DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._logSpaceClickPanel = new ClickablePanel(new GridLayout(1, 1));
        this._logSpaceClickPanel.setEnabled(false);
        this._logSpaceLabel = DBDiagramUtils.createJLabelForWarning(_unknownValueStr);
        this._logSpaceClickPanel.add(this._logSpaceLabel);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._logSpaceClickPanel, gridBagConstraints);
        this._mirrorLogDesc = new JLabel(bundle.getString("MIRROR_LOG"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, TOP_GAP_INSETS, 0, 0);
        jPanel.add((Component)this._mirrorLogDesc, gridBagConstraints);
        this._mirrorLogFileDesc = new JLabel(bundle.getString("FILE_NAME"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, INDENTED_DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)this._mirrorLogFileDesc, gridBagConstraints);
        this._mirrorLogFileLabel = new SybPathnameLabel(_unknownValueStr, 0);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 2, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._mirrorLogFileLabel, gridBagConstraints);
        this._mirrorLogSpaceDesc = new JLabel(bundle.getString("FREE_SPACE"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, INDENTED_DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)this._mirrorLogSpaceDesc, gridBagConstraints);
        this._mirrorLogSpaceClickPanel = new ClickablePanel(new GridLayout(1, 1));
        this._mirrorLogSpaceClickPanel.setEnabled(false);
        this._mirrorLogSpaceLabel = DBDiagramUtils.createJLabelForWarning(_unknownValueStr);
        this._mirrorLogSpaceClickPanel.add(this._mirrorLogSpaceLabel);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._mirrorLogSpaceClickPanel, gridBagConstraints);
        this._logsPanel = new DBDiagramCollapsiblePanel(bundle.getString("TRANSACTION_LOGS_TITLE"), ASAComponentsImageLoader.getImageIcon("proc", 1002), jPanel);
        this._logsPanel.setCollapsed(true);
        this._logsPanel.addActionListener(this._collapsiblePanelActionListener);
        this._logsPanel.addFocusListener(this._collapsiblePanelFocusListener);
        this._logsPanel.setOpaque(false);
        this._collapsiblePanelsPanel.add((Component)this._logsPanel, this.createCollapsiblePanelGBC(2));
    }

    private PrintingPanel createLogsPrintPanel(Graphics graphics, int n) {
        PrintingPanel printingPanel = new PrintingPanel();
        PrintingComponent printingComponent = this._logsPanel.createTitlePrintingComponent(graphics);
        printingPanel.add(printingComponent);
        int n2 = 32;
        int n3 = printingComponent.getHeight();
        printingComponent = this.createPrintingLabel(bundle.getString("TRANSACTION_LOG"));
        printingComponent.setLocation(n2, n3 += 3);
        printingPanel.add(printingComponent);
        n2 += 20;
        n3 += printingComponent.getHeight();
        String[] stringArray = new String[]{bundle.getString("FILE_NAME"), bundle.getString("FREE_SPACE")};
        boolean[] blArray = new boolean[]{false, this._logSpaceClickPanel.isEnabled()};
        PrintingLabelMetadata printingLabelMetadata = new PrintingLabelMetadata();
        printingLabelMetadata.maxWidth = n / 2;
        printingLabelMetadata.truncationType = 0;
        printingLabelMetadata.warningType = 4;
        PrintingLabelMetadata[] printingLabelMetadataArray = new PrintingLabelMetadata[]{printingLabelMetadata, printingLabelMetadata};
        printingComponent = this.createPrintingLabelsColumn(stringArray, null, printingLabelMetadataArray);
        printingComponent.setLocation(n2, n3);
        printingPanel.add(printingComponent);
        stringArray = new String[]{this._logFileLabel.getFullText(), this._logSpaceLabel.getText()};
        PrintingLabelMetadata printingLabelMetadata2 = new PrintingLabelMetadata();
        printingLabelMetadata2.maxWidth = n - (n2 += printingComponent.getWidth() + 10);
        printingLabelMetadata2.truncationType = 1;
        printingLabelMetadataArray[0] = printingLabelMetadata2;
        printingLabelMetadata.warningType = 2;
        printingComponent = this.createPrintingLabelsColumn(stringArray, null, printingLabelMetadataArray);
        printingComponent.setLocation(n2, n3);
        printingPanel.add(printingComponent);
        n2 = 32;
        n3 += printingComponent.getHeight();
        printingComponent = this.createPrintingLabel(this._mirrorLogDesc.getText());
        printingComponent.setLocation(n2, n3 += 10);
        printingPanel.add(printingComponent);
        if (this._mirrorLogEnabled) {
            n2 += 20;
            n3 += printingComponent.getHeight();
            stringArray = new String[]{bundle.getString("FILE_NAME"), bundle.getString("FREE_SPACE")};
            blArray = new boolean[]{false, this._mirrorLogSpaceClickPanel.isEnabled()};
            printingLabelMetadata.warningType = 4;
            printingLabelMetadataArray[0] = printingLabelMetadata;
            printingComponent = this.createPrintingLabelsColumn(stringArray, null, printingLabelMetadataArray);
            printingComponent.setLocation(n2, n3);
            printingPanel.add(printingComponent);
            n2 += printingComponent.getWidth() + 10;
            stringArray = new String[]{this._mirrorLogFileLabel.getFullText(), this._mirrorLogSpaceLabel.getText()};
            printingLabelMetadata.warningType = 2;
            printingLabelMetadataArray[0] = printingLabelMetadata2;
            printingComponent = this.createPrintingLabelsColumn(stringArray, null, printingLabelMetadataArray);
            printingComponent.setLocation(n2, n3);
            printingPanel.add(printingComponent);
        }
        return printingPanel;
    }

    private void createMLServerPanel() {
        this._mlServerBody = UIUtils.createExplorerBarGroup();
        this._mlServerBody.setLayout(new GridBagLayout());
        int n = 0;
        this._refreshMLServerLabel = new SybMultiLineLabel(bundle.getString("REFRESH_ML_SERVER_NOTE"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, n, 2, 1, 1.0, 0.0, 21, 2, DBDiagramUtils.ZERO_INSETS, 0, 0);
        this._mlServerBody.add((Component)this._refreshMLServerLabel, gridBagConstraints);
        this._refreshMLServerButton = new SybButton(bundle.getString("REFRESH_ML_SERVER_BUTTON"));
        this._refreshMLServerButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBDiagramPanel.this.refreshMLServerClicked();
            }
        });
        this._refreshMLServerButton.setEnabled(false);
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 21, 0, new Insets(5, 0, 10, 0), 0, 0);
        this._mlServerBody.add((Component)this._refreshMLServerButton, gridBagConstraints);
        this._mobilinkLabel = new JLabel(bundle.getString("UNKNOWN_MOBILINK"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 21, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        this._mlServerBody.add((Component)this._mobilinkLabel, gridBagConstraints);
        ++n;
        this._mobilinkTableGridy = n++;
        this._lastUploadDesc = new JLabel(bundle.getString("LAST_UPLOAD"));
        this._lastUploadDesc.setVisible(false);
        gridBagConstraints = new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, INDENTED_DESCRIPTION_LABEL_INSETS, 0, 0);
        this._mlServerBody.add((Component)this._lastUploadDesc, gridBagConstraints);
        this._lastUploadLabel = new JLabel(_unknownValueStr);
        this._lastUploadLabel.setVisible(false);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        this._mlServerBody.add((Component)this._lastUploadLabel, gridBagConstraints);
        this._lastDownloadDesc = new JLabel(bundle.getString("LAST_DOWNLOAD"));
        this._lastDownloadDesc.setVisible(false);
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, INDENTED_DESCRIPTION_LABEL_INSETS, 0, 0);
        this._mlServerBody.add((Component)this._lastDownloadDesc, gridBagConstraints);
        this._lastDownloadLabel = new JLabel(_unknownValueStr);
        this._lastDownloadLabel.setVisible(false);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        this._mlServerBody.add((Component)this._lastDownloadLabel, gridBagConstraints);
        this._qanywhereLabel = new JLabel(bundle.getString("UNKNOWN_QANYWHERE"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 21, 0, TOP_GAP_INSETS, 0, 0);
        this._mlServerBody.add((Component)this._qanywhereLabel, gridBagConstraints);
        ++n;
        this._qanywhereTableGridy = n++;
        this._lastActivityDesc = new JLabel(bundle.getString("LAST_ACTIVITY"));
        this._lastActivityDesc.setVisible(false);
        gridBagConstraints = new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, INDENTED_DESCRIPTION_LABEL_INSETS, 0, 0);
        this._mlServerBody.add((Component)this._lastActivityDesc, gridBagConstraints);
        this._lastActivityLabel = new JLabel(_unknownValueStr);
        this._lastActivityLabel.setVisible(false);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        this._mlServerBody.add((Component)this._lastActivityLabel, gridBagConstraints);
        JLabel jLabel = new JLabel(bundle.getString("NOTIFIERS"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 21, 0, TOP_GAP_INSETS, 0, 0);
        this._mlServerBody.add((Component)jLabel, gridBagConstraints);
        ++n;
        this._notifierTableGridy = n++;
        this._notifierCountDesc = new JLabel(bundle.getString("NUMBER_OF_NOTIFIERS"));
        gridBagConstraints = new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, INDENTED_DESCRIPTION_LABEL_INSETS, 0, 0);
        this._mlServerBody.add((Component)this._notifierCountDesc, gridBagConstraints);
        this._notifierCountLabel = new JLabel(_unknownValueStr);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        this._mlServerBody.add((Component)this._notifierCountLabel, gridBagConstraints);
        this._mlServerPanel = new DBDiagramCollapsiblePanel(bundle.getString("ML_SERVER_TITLE"), ASAComponentsImageLoader.getImageIcon("mlplugin", 1002), this._mlServerBody);
        this._mlServerPanel.setCollapsed(true);
        this._mlServerPanel.addActionListener(this._collapsiblePanelActionListener);
        this._mlServerPanel.addFocusListener(this._collapsiblePanelFocusListener);
        this._mlServerPanel.setOpaque(false);
        this._collapsiblePanelsPanel.add((Component)this._mlServerPanel, this.createCollapsiblePanelGBC(6));
    }

    private PrintingPanel createMLServerPrintPanel(Graphics graphics, int n) {
        PrintingLabel printingLabel;
        String[] stringArray;
        PrintingLabelMetadata[] printingLabelMetadataArray;
        PrintingPanel printingPanel = null;
        PrintingLabel printingLabel2 = null;
        PrintingLabel printingLabel3 = null;
        PrintingPanel printingPanel2 = new PrintingPanel();
        PrintingComponent printingComponent = this._mlServerPanel.createTitlePrintingComponent(graphics);
        printingPanel2.add(printingComponent);
        int n2 = 32;
        int n3 = printingComponent.getHeight();
        n3 += 3;
        int n4 = n2 + 20;
        int n5 = n - n4;
        PrintingLabelMetadata printingLabelMetadata = NORMAL_PRINTING_METADATA.createCopy();
        int n6 = 0;
        printingComponent = this.createPrintingLabel(this._mobilinkLabel.getText());
        printingComponent.setLocation(n2, n3);
        printingPanel2.add(printingComponent);
        n3 += printingComponent.getHeight();
        if (this._mobilinkTable != null && this._mobilinkScrollPane.isVisible()) {
            n3 += 5;
            printingLabelMetadataArray = new PrintingLabelMetadata[3];
            printingLabelMetadataArray[0] = NORMAL_PRINTING_METADATA.createCopy();
            printingLabelMetadataArray[0].truncateToFit = true;
            printingLabelMetadataArray[1] = NORMAL_PRINTING_METADATA.createCopy();
            printingLabelMetadataArray[1].maxWidth = n5 / 3;
            printingLabelMetadataArray[2] = printingLabelMetadataArray[1];
            printingComponent = this.createPrintingTable(this._mobilinkTable, printingLabelMetadataArray, n5);
            printingComponent.setLocation(n4, n3);
            printingPanel2.add(printingComponent);
            n3 += printingComponent.getHeight();
        } else if (this._lastUploadDesc.isVisible()) {
            stringArray = new String[]{this._lastUploadDesc.getText(), this._lastDownloadDesc.getText()};
            printingLabelMetadata.maxWidth = n5 / 2;
            printingPanel = this.createPrintingLabelsColumn(stringArray, null, printingLabelMetadata);
            printingPanel.setLocation(n4, n3);
            printingPanel2.add(printingPanel);
            n6 = ((PrintingComponent)printingPanel).getWidth();
            n3 += ((PrintingComponent)printingPanel).getHeight();
        }
        printingComponent = this.createPrintingLabel(this._qanywhereLabel.getText());
        printingComponent.setLocation(n2, n3 += 10);
        printingPanel2.add(printingComponent);
        n3 += printingComponent.getHeight();
        if (this._qanywhereTable != null && this._qanywhereScrollPane.isVisible()) {
            n3 += 5;
            printingLabelMetadataArray = new PrintingLabelMetadata[2];
            printingLabelMetadataArray[0] = NORMAL_PRINTING_METADATA.createCopy();
            printingLabelMetadataArray[0].truncateToFit = true;
            printingLabelMetadataArray[1] = NORMAL_PRINTING_METADATA.createCopy();
            printingLabelMetadataArray[1].maxWidth = n5 / 2;
            printingComponent = this.createPrintingTable(this._qanywhereTable, printingLabelMetadataArray, n5);
            printingComponent.setLocation(n4, n3);
            printingPanel2.add(printingComponent);
            n3 += printingComponent.getHeight();
        } else if (this._lastActivityDesc.isVisible()) {
            printingLabelMetadata.maxWidth = n5 / 2;
            printingLabel2 = this.createPrintingLabel(this._lastActivityDesc.getText());
            printingLabelMetadata.truncateLabel(printingLabel2);
            printingLabel2.setLocation(n4, n3);
            printingPanel2.add(printingLabel2);
            n6 = Math.max(n6, printingLabel2.getWidth());
            n3 += printingLabel2.getHeight();
        }
        printingComponent = this.createPrintingLabel(bundle.getString("NOTIFIERS"));
        printingComponent.setLocation(n2, n3 += 10);
        printingPanel2.add(printingComponent);
        n3 += printingComponent.getHeight();
        if (this._notifierTable != null && this._notifierScrollPane.isVisible()) {
            n3 += 5;
            printingLabelMetadataArray = new PrintingLabelMetadata[2];
            printingLabelMetadataArray[0] = NORMAL_PRINTING_METADATA.createCopy();
            printingLabelMetadataArray[0].truncateToFit = true;
            printingLabelMetadataArray[1] = NORMAL_PRINTING_METADATA.createCopy();
            printingLabelMetadataArray[1].maxWidth = n5 / 3;
            printingComponent = this.createPrintingTable(this._notifierTable, printingLabelMetadataArray, n5);
            printingComponent.setLocation(n4, n3);
            printingPanel2.add(printingComponent);
            n3 += printingComponent.getHeight();
        } else if (this._notifierCountDesc.isVisible()) {
            printingLabelMetadata.maxWidth = n5 / 2;
            printingLabel3 = this.createPrintingLabel(this._notifierCountDesc.getText());
            printingLabelMetadata.truncateLabel(printingLabel3);
            printingLabel3.setLocation(n4, n3);
            printingPanel2.add(printingLabel3);
            n6 = Math.max(n6, printingLabel3.getWidth());
        }
        n6 += n4;
        n6 += 10;
        if (printingPanel != null) {
            stringArray = new String[]{this._lastUploadLabel.getText(), this._lastDownloadLabel.getText()};
            printingLabelMetadata = NORMAL_PRINTING_METADATA.createCopy();
            printingLabelMetadata.maxWidth = n5 - n6;
            printingComponent = this.createPrintingLabelsColumn(stringArray, null, printingLabelMetadata);
            printingComponent.setLocation(n6, printingPanel.getY());
            printingPanel2.add(printingComponent);
        }
        if (printingLabel2 != null) {
            printingLabelMetadata.maxWidth = n5 - n6;
            printingLabel = this.createPrintingLabel(this._lastActivityLabel.getText());
            printingLabelMetadata.truncateLabel(printingLabel);
            printingLabel.setLocation(n6, printingLabel2.getY());
            printingPanel2.add(printingLabel);
        }
        if (printingLabel3 != null) {
            printingLabelMetadata.maxWidth = n5 - n6;
            printingLabel = this.createPrintingLabel(this._notifierCountLabel.getText());
            printingLabelMetadata.truncateLabel(printingLabel);
            printingLabel.setLocation(n6, printingLabel3.getY());
            printingPanel2.add(printingLabel);
        }
        return printingPanel2;
    }

    private void createMirrorNode(String string) {
        this._mirrorNode = new TopologyNode(bundle.getString("MIRROR_NODE"), Integer.MAX_VALUE, string, 100, ASAComponentsImageLoader.getImageIcon("database", 1002), 4, true, true, bundle.getString("DB_MIRRORING_FEATURE"));
        this._mirrorNode.setEnabled(false);
        this._mirrorNode.addActionListener(this._topologyActionListener);
        this._mirrorNodeGBC = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 19, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        this._topologyDiagramPanel.add((Component)this._mirrorNode, this._mirrorNodeGBC);
    }

    private void createMirroringPanel() {
        JPanel jPanel = UIUtils.createExplorerBarGroup();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        this._mirroringLabel = new SybMultiLineLabel("");
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, n, 2, 1, 1.0, 0.0, 21, 2, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._mirroringLabel, gridBagConstraints);
        JLabel jLabel = new JLabel(bundle.getString("PRIMARY_SERVER"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 21, 0, TOP_GAP_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel(bundle.getString("NAME"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, INDENTED_DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._primaryNameLabel = new SybLimitedWidthLabel(_unknownValueStr);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 2, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._primaryNameLabel, gridBagConstraints);
        jLabel = new JLabel(bundle.getString("STATE_FILE"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, INDENTED_DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._primaryStateFileLabel = new SybPathnameLabel(_unknownValueStr, 0);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 2, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._primaryStateFileLabel, gridBagConstraints);
        jLabel = new JLabel(bundle.getString("ARBITER_SERVER"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 21, 0, TOP_GAP_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel(bundle.getString("NAME"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, INDENTED_DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._arbiterNameLabel = new SybLimitedWidthLabel(_unknownValueStr);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 2, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._arbiterNameLabel, gridBagConstraints);
        jLabel = new JLabel(bundle.getString("STATUS"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, INDENTED_DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._arbiterStatusClickPanel = new ClickablePanel(new GridLayout(1, 1));
        this._arbiterStatusClickPanel.setEnabled(false);
        this._arbiterStatusLabel = DBDiagramUtils.createJLabelForWarning(_unknownValueStr);
        this._arbiterStatusClickPanel.add(this._arbiterStatusLabel);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._arbiterStatusClickPanel, gridBagConstraints);
        jLabel = new JLabel(bundle.getString("MIRROR_SERVER"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 21, 0, TOP_GAP_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel(bundle.getString("NAME"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, INDENTED_DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._mirrorNameLabel = new SybLimitedWidthLabel(_unknownValueStr);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 2, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._mirrorNameLabel, gridBagConstraints);
        jLabel = new JLabel(bundle.getString("STATUS"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, INDENTED_DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._mirrorStatusClickPanel = new ClickablePanel(new GridLayout(1, 1));
        this._mirrorStatusClickPanel.setEnabled(false);
        this._mirrorStatusLabel = DBDiagramUtils.createJLabelForWarning(_unknownValueStr);
        this._mirrorStatusClickPanel.add(this._mirrorStatusLabel);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._mirrorStatusClickPanel, gridBagConstraints);
        jLabel = new JLabel(bundle.getString("MIRRORING_SYSTEM"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 0.0, 0.0, 21, 0, TOP_GAP_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        jLabel = new JLabel(bundle.getString("STATE"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, INDENTED_DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._mirroringStateLabel = new JLabel(_unknownValueStr);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 2, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._mirroringStateLabel, gridBagConstraints);
        jLabel = new JLabel(bundle.getString("MODE"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, INDENTED_DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._mirroringModeLabel = new JLabel(_unknownValueStr);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 2, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._mirroringModeLabel, gridBagConstraints);
        jLabel = new JLabel(bundle.getString("SEQUENCE"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, INDENTED_DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._mirroringSeqLabel = new JLabel(_unknownValueStr);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 2, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._mirroringSeqLabel, gridBagConstraints);
        this._mirroringPanel = new DBDiagramCollapsiblePanel(bundle.getString("DATABASE_MIRROR_TITLE"), ASAComponentsImageLoader.getImageIcon("mirroring_server", 1002), jPanel);
        this._mirroringPanel.setCollapsed(true);
        this._mirroringPanel.addActionListener(this._collapsiblePanelActionListener);
        this._mirroringPanel.addFocusListener(this._collapsiblePanelFocusListener);
        this._mirroringPanel.setOpaque(false);
        this._collapsiblePanelsPanel.add((Component)this._mirroringPanel, this.createCollapsiblePanelGBC(4));
    }

    private PrintingPanel createMirroringPrintPanel(Graphics graphics, int n) {
        PrintingPanel printingPanel = new PrintingPanel();
        PrintingComponent printingComponent = this._mirroringPanel.createTitlePrintingComponent(graphics);
        printingPanel.add(printingComponent);
        int n2 = printingComponent.getHeight();
        n2 += 3;
        int n3 = 32;
        int n4 = n3 + 20;
        String[] stringArray = new String[]{bundle.getString("NAME"), bundle.getString("STATE_FILE")};
        PrintingLabelMetadata printingLabelMetadata = NORMAL_PRINTING_METADATA.createCopy();
        printingLabelMetadata.maxWidth = n / 2;
        PrintingPanel printingPanel2 = this.createPrintingLabelsColumn(stringArray, null, printingLabelMetadata);
        printingPanel2.setX(n4);
        n3 = 32;
        n2 = printingComponent.getHeight();
        n2 += 3;
        stringArray[0] = bundle.getString("NAME");
        stringArray[1] = bundle.getString("STATUS");
        boolean[] blArray = new boolean[]{false, this._arbiterStatusClickPanel.isEnabled()};
        printingLabelMetadata.warningType = 4;
        PrintingPanel printingPanel3 = this.createPrintingLabelsColumn(stringArray, blArray, printingLabelMetadata);
        printingPanel3.setX(n4);
        blArray[1] = this._mirrorStatusClickPanel.isEnabled();
        PrintingPanel printingPanel4 = this.createPrintingLabelsColumn(stringArray, blArray, printingLabelMetadata);
        printingPanel4.setX(n4);
        String[] stringArray2 = new String[]{bundle.getString("STATE"), bundle.getString("MODE"), bundle.getString("SEQUENCE")};
        PrintingPanel printingPanel5 = this.createPrintingLabelsColumn(stringArray2, null, printingLabelMetadata);
        printingPanel5.setX(n4);
        int n5 = n4;
        n5 += Math.max(Math.max(((PrintingComponent)printingPanel2).getWidth(), ((PrintingComponent)printingPanel3).getWidth()), Math.max(((PrintingComponent)printingPanel4).getWidth(), ((PrintingComponent)printingPanel5).getWidth()));
        n5 += 10;
        printingComponent = this.createPrintingLabel(bundle.getString("PRIMARY_SERVER"));
        printingComponent.setLocation(n3, n2);
        printingPanel.add(printingComponent);
        printingPanel2.setY(n2 += printingComponent.getHeight());
        printingPanel.add(printingPanel2);
        stringArray[0] = this._primaryNameLabel.getText();
        stringArray[1] = this._primaryStateFileLabel.getFullText();
        printingLabelMetadata.maxWidth = n - n5;
        PrintingLabelMetadata printingLabelMetadata2 = printingLabelMetadata.createCopy();
        printingLabelMetadata2.truncationType = 1;
        PrintingLabelMetadata[] printingLabelMetadataArray = new PrintingLabelMetadata[]{printingLabelMetadata, printingLabelMetadata2};
        printingComponent = this.createPrintingLabelsColumn(stringArray, null, printingLabelMetadataArray);
        printingComponent.setLocation(n5, n2);
        printingPanel.add(printingComponent);
        n2 += printingComponent.getHeight();
        printingComponent = this.createPrintingLabel(bundle.getString("ARBITER_SERVER"));
        printingComponent.setLocation(n3, n2 += 10);
        printingPanel.add(printingComponent);
        printingPanel3.setY(n2 += printingComponent.getHeight());
        printingPanel.add(printingPanel3);
        stringArray[0] = this._arbiterNameLabel.getText();
        stringArray[1] = this._arbiterStatusLabel.getText();
        blArray[1] = this._arbiterStatusClickPanel.isEnabled();
        printingLabelMetadata.warningType = 2;
        printingComponent = this.createPrintingLabelsColumn(stringArray, blArray, printingLabelMetadata);
        printingComponent.setLocation(n5, n2);
        printingPanel.add(printingComponent);
        n2 += printingComponent.getHeight();
        printingComponent = this.createPrintingLabel(bundle.getString("MIRROR_SERVER"));
        printingComponent.setLocation(n3, n2 += 10);
        printingPanel.add(printingComponent);
        printingPanel4.setY(n2 += printingComponent.getHeight());
        printingPanel.add(printingPanel4);
        stringArray[0] = this._mirrorNameLabel.getText();
        stringArray[1] = this._mirrorStatusLabel.getText();
        blArray[1] = this._mirrorStatusClickPanel.isEnabled();
        printingComponent = this.createPrintingLabelsColumn(stringArray, blArray, printingLabelMetadata);
        printingComponent.setLocation(n5, n2);
        printingPanel.add(printingComponent);
        n2 += printingComponent.getHeight();
        printingComponent = this.createPrintingLabel(bundle.getString("MIRRORING_SYSTEM"));
        printingComponent.setLocation(n3, n2 += 10);
        printingPanel.add(printingComponent);
        printingPanel5.setY(n2 += printingComponent.getHeight());
        printingPanel.add(printingPanel5);
        stringArray2[0] = this._mirroringStateLabel.getText();
        stringArray2[1] = this._mirroringModeLabel.getText();
        stringArray2[2] = this._mirroringSeqLabel.getText();
        printingComponent = this.createPrintingLabelsColumn(stringArray2, null, printingLabelMetadata);
        printingComponent.setLocation(n5, n2);
        printingPanel.add(printingComponent);
        return printingPanel;
    }

    private void createMobilinkNode() {
        this._mobilinkNode = new TopologyNode(bundle.getString("MOBILINK_NODE_ONE"), Integer.MAX_VALUE, bundle.getString("MOBILINK_NODE_TWO"), Integer.MAX_VALUE, ASAComponentsImageLoader.getImageIcon("mlplugin", 1002), 4, true, false, bundle.getString("MOBILINK_FEATURE"));
        this._mobilinkNode.setEnabled(false);
        this._mobilinkNode.addActionListener(this._topologyActionListener);
        this._mobilinkNodeGBC = new GridBagConstraints(4, 0, 1, 1, 0.0, 0.0, 19, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        this._topologyDiagramPanel.add((Component)this._mobilinkNode, this._mobilinkNodeGBC);
    }

    private void createMobilinkTable() {
        String[] stringArray = new String[]{bundle.getString("TABLE_OWNER_COLUMN"), bundle.getString("LAST_UPLOAD_COLUMN"), bundle.getString("LAST_DOWNLOAD_COLUMN")};
        this._mobilinkTableModel = new StatisticsTableModel(3, stringArray, 2);
        this._mobilinkTable = new JTable(this._mobilinkTableModel);
        this._mobilinkTable.setDefaultRenderer(Object.class, _toolTipCellRenderer);
        this._mobilinkTable.setTableHeader(new ToolTipTableHeader(this._mobilinkTable.getColumnModel()));
        this._mobilinkTable.setAutoCreateRowSorter(true);
        this._mobilinkTable.setColumnSelectionAllowed(false);
        this._mobilinkTable.setFocusable(false);
        this.resizeTable(this._mobilinkTable, 0);
        this._mobilinkTable.setRowSelectionAllowed(false);
        this._mobilinkTable.getTableHeader().setReorderingAllowed(false);
        this._mobilinkScrollPane = new JScrollPane(this._mobilinkTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, this._mobilinkTableGridy, 2, 1, 1.0, 0.0, 21, 2, ML_SERVER_TABLE_INSETS, 0, 0);
        this._mlServerBody.add((Component)this._mobilinkScrollPane, gridBagConstraints);
    }

    private void createNotifierTable() {
        String[] stringArray = new String[]{bundle.getString("TABLE_OWNER_COLUMN"), bundle.getString("NUMBER_OF_NOTIFIERS_COLUMN")};
        this._notifierTableModel = new StatisticsTableModel(2, stringArray, 2);
        this._notifierTable = new JTable(this._notifierTableModel);
        TableColumnModel tableColumnModel = this._notifierTable.getColumnModel();
        tableColumnModel.getColumn(0).setCellRenderer(_toolTipCellRenderer);
        this._notifierTable.setTableHeader(new ToolTipTableHeader(tableColumnModel));
        this._notifierTable.setAutoCreateRowSorter(true);
        this._notifierTable.setColumnSelectionAllowed(false);
        this._notifierTable.setFocusable(false);
        this.resizeTable(this._notifierTable, 0);
        this._notifierTable.setRowSelectionAllowed(false);
        this._notifierTable.getTableHeader().setReorderingAllowed(false);
        this._notifierScrollPane = new JScrollPane(this._notifierTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, this._notifierTableGridy, 2, 1, 1.0, 0.0, 21, 2, ML_SERVER_TABLE_INSETS, 0, 0);
        this._mlServerBody.add((Component)this._notifierScrollPane, gridBagConstraints);
    }

    private void createQAnywhereNode() {
        this._qanywhereNode = new TopologyNode(bundle.getString("QANYWHERE_NODE_ONE"), Integer.MAX_VALUE, bundle.getString("QANYWHERE_NODE_TWO"), Integer.MAX_VALUE, ASAComponentsImageLoader.getImageIcon("qaplugin", 1002), 4, true, false, bundle.getString("QANYWHERE_FEATURE"));
        this._qanywhereNode.setEnabled(false);
        this._qanywhereNode.addActionListener(this._topologyActionListener);
        this._qanywhereNodeGBC = new GridBagConstraints(4, 1, 1, 1, 0.0, 0.0, 19, 0, DBDiagramUtils.LEFT_INSETS, 0, 0);
        this._topologyDiagramPanel.add((Component)this._qanywhereNode, this._qanywhereNodeGBC);
    }

    private void createQAnywhereTable() {
        String[] stringArray = new String[]{bundle.getString("TABLE_OWNER_COLUMN"), bundle.getString("LAST_ACTIVITY_COLUMN")};
        this._qanywhereTableModel = new StatisticsTableModel(2, stringArray, 2);
        this._qanywhereTable = new JTable(this._qanywhereTableModel);
        this._qanywhereTable.setDefaultRenderer(Object.class, _toolTipCellRenderer);
        this._qanywhereTable.setTableHeader(new ToolTipTableHeader(this._qanywhereTable.getColumnModel()));
        this._qanywhereTable.setAutoCreateRowSorter(true);
        this._qanywhereTable.setColumnSelectionAllowed(false);
        this._qanywhereTable.setFocusable(false);
        this.resizeTable(this._qanywhereTable, 0);
        this._qanywhereTable.setRowSelectionAllowed(false);
        this._qanywhereTable.getTableHeader().setReorderingAllowed(false);
        this._qanywhereScrollPane = new JScrollPane(this._qanywhereTable);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, this._qanywhereTableGridy, 2, 1, 1.0, 0.0, 21, 2, ML_SERVER_TABLE_INSETS, 0, 0);
        this._mlServerBody.add((Component)this._qanywhereScrollPane, gridBagConstraints);
    }

    private void createRemServersNode() {
        this._remServersNode = new TopologyNode(bundle.getString("REMOTE_SERVERS_NODE_ONE"), Integer.MAX_VALUE, bundle.getString("REMOTE_SERVERS_NODE_TWO"), Integer.MAX_VALUE, ASAComponentsImageLoader.getImageIcon("remserver", 1002), 4, true, true, bundle.getString("REMOTE_SERVERS_FEATURE"));
        this._remServersNode.setEnabled(false);
        this._remServersNode.addActionListener(this._topologyActionListener);
        this._remServersNodeGBC = new GridBagConstraints(4, 2, 1, 1, 0.0, 0.0, 19, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        this._topologyDiagramPanel.add((Component)this._remServersNode, this._remServersNodeGBC);
    }

    private void createRemServersPanel() {
        JPanel jPanel = UIUtils.createExplorerBarGroup();
        jPanel.setLayout(new GridLayout(1, 1));
        String[] stringArray = new String[]{bundle.getString("NAME_COLUMN"), bundle.getString("INFO_COLUMN"), bundle.getString("STATUS_COLUMN")};
        this._remServersTableModel = new StatisticsTableModel(3, stringArray, 5);
        this._remServersCellPanels = new ArrayList(5);
        this._remServersTable = new JTable(this._remServersTableModel);
        TableColumnModel tableColumnModel = this._remServersTable.getColumnModel();
        tableColumnModel.getColumn(2).setCellRenderer(new WarningAwareCellRenderer(this._remServersTableModel));
        this._remServersTable.setTableHeader(new ToolTipTableHeader(tableColumnModel));
        this._remServersTable.setAutoCreateRowSorter(true);
        this._remServersTable.setColumnSelectionAllowed(false);
        this._remServersTable.setDefaultRenderer(Object.class, _toolTipCellRenderer);
        this._remServersTable.setFocusable(false);
        this.resizeTable(this._remServersTable, 0);
        this._remServersTable.setRowSelectionAllowed(false);
        this._remServersTable.getTableHeader().setReorderingAllowed(false);
        jPanel.add(new JScrollPane(this._remServersTable));
        this._remServersPanel = new DBDiagramCollapsiblePanel(bundle.getString("REMOTE_SERVERS_TITLE"), ASAComponentsImageLoader.getImageIcon("remserver", 1002), jPanel);
        this._remServersPanel.setCollapsed(true);
        this._remServersPanel.addActionListener(this._collapsiblePanelActionListener);
        this._remServersPanel.addFocusListener(this._collapsiblePanelFocusListener);
        this._remServersPanel.setOpaque(false);
        this._collapsiblePanelsPanel.add((Component)this._remServersPanel, this.createCollapsiblePanelGBC(5));
    }

    private PrintingPanel createRemServersPrintPanel(Graphics graphics, int n) {
        PrintingPanel printingPanel = new PrintingPanel();
        PrintingComponent printingComponent = this._remServersPanel.createTitlePrintingComponent(graphics);
        printingPanel.add(printingComponent);
        int n2 = 32;
        int n3 = printingComponent.getHeight();
        n3 += 3;
        int n4 = n - n2;
        PrintingLabelMetadata[] printingLabelMetadataArray = new PrintingLabelMetadata[3];
        printingLabelMetadataArray[0] = NORMAL_PRINTING_METADATA.createCopy();
        printingLabelMetadataArray[0].maxWidth = n4 / 3;
        printingLabelMetadataArray[1] = NORMAL_PRINTING_METADATA.createCopy();
        printingLabelMetadataArray[1].truncateToFit = true;
        printingLabelMetadataArray[2] = printingLabelMetadataArray[0].createCopy();
        printingLabelMetadataArray[2].warningType = 2;
        printingComponent = this.createPrintingTable(this._remServersTable, printingLabelMetadataArray, n4);
        printingComponent.setX(n2);
        printingComponent.setY(n3);
        printingPanel.add(printingComponent);
        return printingPanel;
    }

    private void createSQLRemoteNode() {
        this._sqlRemoteNode = new TopologyNode(bundle.getString("SQL_REMOTE_NODE_ONE"), Integer.MAX_VALUE, bundle.getString("SQL_REMOTE_NODE_TWO"), Integer.MAX_VALUE, ASAComponentsImageLoader.getImageIcon("sruser", 1002), 4, true, false, bundle.getString("SQL_REMOTE_FEATURE"));
        this._sqlRemoteNode.setEnabled(false);
        this._sqlRemoteNode.addActionListener(this._topologyActionListener);
        this._sqlRemoteNodeGBC = new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 19, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        this._topologyDiagramPanel.add((Component)this._sqlRemoteNode, this._sqlRemoteNodeGBC);
    }

    private void createSQLRemotePanel() {
        JPanel jPanel = UIUtils.createExplorerBarGroup();
        jPanel.setLayout(new GridLayout(1, 1));
        String[] stringArray = new String[]{bundle.getString("USER_ID_COLUMN"), bundle.getString("TIME_SENT_COLUMN"), bundle.getString("TIME_RECEIVED_COLUMN")};
        this._sqlRemoteTableModel = new StatisticsTableModel(3, stringArray, 5);
        this._sqlRemoteTable = new JTable(this._sqlRemoteTableModel);
        TableColumnModel tableColumnModel = this._sqlRemoteTable.getColumnModel();
        this._sqlRemoteTable.setTableHeader(new ToolTipTableHeader(tableColumnModel));
        this._sqlRemoteTable.setAutoCreateRowSorter(true);
        this._sqlRemoteTable.setColumnSelectionAllowed(false);
        this._sqlRemoteTable.setDefaultRenderer(Object.class, _toolTipCellRenderer);
        this._sqlRemoteTable.setFocusable(false);
        this.resizeTable(this._sqlRemoteTable, 0);
        this._sqlRemoteTable.setRowSelectionAllowed(false);
        this._sqlRemoteTable.getTableHeader().setReorderingAllowed(false);
        jPanel.add(new JScrollPane(this._sqlRemoteTable));
        this._sqlRemotePanel = new DBDiagramCollapsiblePanel(bundle.getString("SQL_REMOTE_TITLE"), ASAComponentsImageLoader.getImageIcon("sruser", 1002), jPanel);
        this._sqlRemotePanel.setCollapsed(true);
        this._sqlRemotePanel.addActionListener(this._collapsiblePanelActionListener);
        this._sqlRemotePanel.addFocusListener(this._collapsiblePanelFocusListener);
        this._sqlRemotePanel.setOpaque(false);
        this._collapsiblePanelsPanel.add((Component)this._sqlRemotePanel, this.createCollapsiblePanelGBC(7));
    }

    private PrintingPanel createSQLRemotePrintPanel(Graphics graphics, int n) {
        PrintingPanel printingPanel = new PrintingPanel();
        PrintingComponent printingComponent = this._sqlRemotePanel.createTitlePrintingComponent(graphics);
        printingPanel.add(printingComponent);
        int n2 = 32;
        int n3 = printingComponent.getHeight();
        n3 += 3;
        int n4 = n - n2;
        PrintingLabelMetadata[] printingLabelMetadataArray = new PrintingLabelMetadata[3];
        printingLabelMetadataArray[0] = NORMAL_PRINTING_METADATA.createCopy();
        printingLabelMetadataArray[0].maxWidth = n4 / 3;
        printingLabelMetadataArray[1] = NORMAL_PRINTING_METADATA.createCopy();
        printingLabelMetadataArray[1].truncateToFit = true;
        printingLabelMetadataArray[2] = printingLabelMetadataArray[1];
        printingComponent = this.createPrintingTable(this._sqlRemoteTable, printingLabelMetadataArray, n4);
        printingComponent.setX(n2);
        printingComponent.setY(n3);
        printingPanel.add(printingComponent);
        return printingPanel;
    }

    private void createStaticInfoComponents() {
        this._dbNameLabel = new SybLimitedWidthLabel(360);
        DBDiagramUtils.boldLabelFont((JLabel)this._dbNameLabel);
        DBDiagramUtils.increaseLabelFontSize((JLabel)this._dbNameLabel, 4.0f);
        this._dbNameLabel.setIcon((Icon)this._dbIcon);
        this._dbNameLabel.setIconTextGap(5);
        this._dbNameLabel.setText(_unknownValueStr);
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 0, 0, 0), 0, 0);
        this._staticInfoPanel.add((Component)this._dbNameLabel, gridBagConstraints);
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(null);
        jPanel.setOpaque(false);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 2, new Insets(5, 5, 0, 0), 0, 0);
        this._staticInfoPanel.add((Component)jPanel, gridBagConstraints);
        int n = 0;
        JLabel jLabel = new JLabel(bundle.getString("VERSION"));
        gridBagConstraints = new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._versionLabel = new JLabel(_unknownValueStr);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._versionLabel, gridBagConstraints);
        jLabel = new JLabel(bundle.getString("PLATFORM"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._platformLabel = new SybLimitedWidthLabel();
        this._platformLabel.setText(_unknownValueStr);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 2, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._platformLabel, gridBagConstraints);
        jLabel = new JLabel(bundle.getString("HOST_NAME"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._hostNameLabel = new SybLimitedWidthLabel(180);
        this._hostNameLabel.setText(_unknownValueStr);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 2, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._hostNameLabel, gridBagConstraints);
        jLabel = new JLabel(bundle.getString("PORT_NUMBER"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._portLabel = new JLabel(_unknownValueStr);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._portLabel, gridBagConstraints);
        jLabel = new JLabel(bundle.getString("WEB_PORT_NUMBER"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._webPortLabel = new JLabel(_unknownValueStr);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._webPortLabel, gridBagConstraints);
        this._alternateNameDesc = new JLabel(bundle.getString("ALTERNATE_NAME"));
        this._alternateNameDesc.setVisible(false);
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)this._alternateNameDesc, gridBagConstraints);
        this._alternateNameLabel = new SybLimitedWidthLabel(180);
        this._alternateNameLabel.setText(_unknownValueStr);
        this._alternateNameLabel.setVisible(false);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 2, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._alternateNameLabel, gridBagConstraints);
        this._alternateNameDesc.setVisible(false);
        this._alternateNameLabel.setVisible(false);
        jLabel = new JLabel(bundle.getString("PAGE_SIZE"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._pageSizeLabel = new JLabel(_unknownValueStr);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 21, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._pageSizeLabel, gridBagConstraints);
        this._checkForUpdatesButton = new SybButton(bundle.getString("CHECK_FOR_UPDATES"));
        this._checkForUpdatesButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DBDiagramPanel.this.checkForUpdatesButtonClicked();
            }
        });
        gridBagConstraints = new GridBagConstraints(0, ++n, 2, 1, 1.0, 0.0, 10, 0, TOP_GAP_INSETS, 0, 0);
        jPanel.add((Component)this._checkForUpdatesButton, gridBagConstraints);
    }

    private PrintingPanel createStaticInfoPrintPanel(Graphics graphics, int n) {
        PrintingPanel printingPanel = new PrintingPanel();
        Font font = this._dbNameLabel.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        PrintingComponent printingComponent = new PrintingLabel(this._dbName, font, fontMetrics, this._dbNameLabel.getForeground(), this._dbIcon, this._dbNameLabel.getIconTextGap());
        printingPanel.add(printingComponent);
        int n2 = printingComponent.getHeight();
        PrintingLabelMetadata printingLabelMetadata = NORMAL_PRINTING_METADATA.createCopy();
        printingLabelMetadata.maxWidth = n / 2;
        String[] stringArray = this._alternateNameDesc.isVisible() ? new String[7] : new String[6];
        stringArray[0] = bundle.getString("VERSION");
        stringArray[1] = bundle.getString("PLATFORM");
        stringArray[2] = bundle.getString("HOST_NAME");
        stringArray[3] = bundle.getString("PORT_NUMBER");
        stringArray[4] = bundle.getString("WEB_PORT_NUMBER");
        if (this._alternateNameDesc.isVisible()) {
            stringArray[5] = bundle.getString("ALTERNATE_NAME");
            stringArray[6] = bundle.getString("PAGE_SIZE");
        } else {
            stringArray[5] = bundle.getString("PAGE_SIZE");
        }
        printingComponent = this.createPrintingLabelsColumn(stringArray, null, printingLabelMetadata);
        printingComponent.setY(n2);
        printingPanel.add(printingComponent);
        int n3 = printingComponent.getWidth() + 10;
        printingLabelMetadata.maxWidth = n - n3;
        stringArray[0] = this._versionLabel.getText();
        stringArray[1] = this._platformLabel.getText();
        stringArray[2] = this._hostNameLabel.getText();
        stringArray[3] = this._portLabel.getText();
        stringArray[4] = this._webPortLabel.getText();
        if (this._alternateNameDesc.isVisible()) {
            stringArray[5] = this._alternateNameLabel.getText();
            stringArray[6] = this._pageSizeLabel.getText();
        } else {
            stringArray[5] = this._pageSizeLabel.getText();
        }
        printingComponent = this.createPrintingLabelsColumn(stringArray, null, printingLabelMetadata);
        printingComponent.setLocation(n3, n2);
        printingPanel.add(printingComponent);
        return printingPanel;
    }

    private void createStatisticsPanel() {
        JPanel jPanel = UIUtils.createExplorerBarGroup();
        jPanel.setLayout(new GridBagLayout());
        int n = 0;
        JLabel jLabel = new JLabel(bundle.getString("DISK_READS"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 0, DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._diskReadsLabel = new JLabel(_unknownValueStr);
        gridBagConstraints = new GridBagConstraints(1, n, 2, 1, 1.0, 0.0, 21, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._diskReadsLabel, gridBagConstraints);
        jLabel = new JLabel(bundle.getString("DISK_WRITES"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._diskWritesLabel = new JLabel(_unknownValueStr);
        gridBagConstraints = new GridBagConstraints(1, n, 2, 1, 1.0, 0.0, 21, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._diskWritesLabel, gridBagConstraints);
        jLabel = new JLabel(bundle.getString("CURRENT_IO"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._currentIOLabel = new JLabel(_unknownValueStr);
        gridBagConstraints = new GridBagConstraints(1, n, 2, 1, 1.0, 0.0, 21, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._currentIOLabel, gridBagConstraints);
        this._unschReqDesc = new JLabel(bundle.getString("UNSCHEDULED_REQUESTS"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)this._unschReqDesc, gridBagConstraints);
        this._unschReqLabel = DBDiagramUtils.createJLabelForWarning(_unknownValueStr);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 21, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._unschReqLabel, gridBagConstraints);
        this._unschReqClickPanel = new ClickablePanel();
        this._unschReqClickPanel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints(0, n, 2, 1, 0.0, 0.0, 21, 1, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._unschReqClickPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(2, n, 1, 1, 1.0, 0.0, 21, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)new EmptyComponent(), gridBagConstraints);
        this._statisticsPanel = new DBDiagramCollapsiblePanel(bundle.getString("STATISTICS_TITLE"), ASAComponentsImageLoader.getImageIcon("statistics", 1002), jPanel);
        this._statisticsPanel.setCollapsed(true);
        this._statisticsPanel.addActionListener(this._collapsiblePanelActionListener);
        this._statisticsPanel.addFocusListener(this._collapsiblePanelFocusListener);
        this._statisticsPanel.setOpaque(false);
        gridBagConstraints = this.createCollapsiblePanelGBC(0);
        gridBagConstraints.insets = DBDiagramUtils.ZERO_INSETS;
        this._collapsiblePanelsPanel.add((Component)this._statisticsPanel, gridBagConstraints);
    }

    private PrintingPanel createStatisticsPrintPanel(Graphics graphics, int n) {
        PrintingPanel printingPanel = new PrintingPanel();
        PrintingComponent printingComponent = this._statisticsPanel.createTitlePrintingComponent(graphics);
        printingPanel.add(printingComponent);
        int n2 = 32;
        int n3 = printingComponent.getHeight();
        n3 += 3;
        String[] stringArray = new String[]{bundle.getString("DISK_READS"), bundle.getString("DISK_WRITES"), bundle.getString("CURRENT_IO"), bundle.getString("UNSCHEDULED_REQUESTS")};
        boolean[] blArray = new boolean[]{false, false, false, this._unschReqClickPanel.isEnabled()};
        PrintingLabelMetadata printingLabelMetadata = new PrintingLabelMetadata();
        printingLabelMetadata.maxWidth = n / 2;
        printingLabelMetadata.truncationType = 0;
        printingLabelMetadata.warningType = 2;
        printingComponent = this.createPrintingLabelsColumn(stringArray, blArray, printingLabelMetadata);
        printingComponent.setLocation(n2, n3);
        printingPanel.add(printingComponent);
        n2 += printingComponent.getWidth() + 10;
        stringArray = new String[]{this._diskReadsLabel.getText(), this._diskWritesLabel.getText(), this._currentIOLabel.getText(), this._unschReqLabel.getText()};
        printingLabelMetadata.warningType = 3;
        printingComponent = this.createPrintingLabelsColumn(stringArray, blArray, printingLabelMetadata);
        printingComponent.setLocation(n2, n3);
        printingPanel.add(printingComponent);
        return printingPanel;
    }

    private void createUI() {
        this.setLayout(new GridLayout(1, 1));
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setOpaque(false);
        this._leftScrollPane = new JScrollPane(jPanel, 20, 31);
        this._leftScrollPane.setOpaque(false);
        this._leftScrollPane.getViewport().setOpaque(false);
        this._staticInfoPanel = new JPanel();
        this._staticInfoPanel.setOpaque(false);
        this._staticInfoPanel.setLayout(new GridBagLayout());
        this.createStaticInfoComponents();
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 2, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._staticInfoPanel, gridBagConstraints);
        JSeparator jSeparator = new JSeparator(0);
        jSeparator.setMinimumSize(jSeparator.getPreferredSize());
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 1.0, 1.0, 20, 2, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)jSeparator, gridBagConstraints);
        this._featuresPanel = new JPanel();
        this._featuresPanel.setOpaque(false);
        this._featuresPanel.setLayout(new GridBagLayout());
        this.createFeaturesComponents();
        gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 2, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._featuresPanel, gridBagConstraints);
        this._detailsPanel = new JPanel();
        this._detailsPanel.setOpaque(false);
        this._detailsPanel.setLayout(new GridBagLayout());
        this.createDetailsComponents();
        this._splitPane = new JSplitPane(1, this._leftScrollPane, this._detailsPanel);
        this._splitPane.setDividerSize(8);
        this._splitPane.setOpaque(false);
        this._splitPane.setOneTouchExpandable(true);
        this._splitPane.setResizeWeight(0.0);
        this.add(this._splitPane);
        this.updateDividerLocation();
    }

    private void createUsersPanel() {
        JPanel jPanel = UIUtils.createExplorerBarGroup();
        jPanel.setLayout(new GridBagLayout());
        String[] stringArray = new String[]{bundle.getString("USER_ID_COLUMN"), bundle.getString("CONN_ID_COLUMN"), bundle.getString("AVG_TRANS_TIME_COLUMN")};
        this._transTimesTableModel = new StatisticsTableModel(3, stringArray, 5);
        this._transTimesTable = new JTable(this._transTimesTableModel);
        TableColumnModel tableColumnModel = this._transTimesTable.getColumnModel();
        tableColumnModel.getColumn(0).setCellRenderer(_toolTipCellRenderer);
        this._transTimesTable.setTableHeader(new ToolTipTableHeader(tableColumnModel));
        this._transTimesTable.setAutoCreateRowSorter(true);
        this._transTimesTable.setColumnSelectionAllowed(false);
        this._transTimesTable.setFocusable(false);
        this.resizeTable(this._transTimesTable, 0);
        this._transTimesTable.setRowSelectionAllowed(false);
        this._transTimesTable.getTableHeader().setReorderingAllowed(false);
        stringArray = new String[]{bundle.getString("USER_ID_COLUMN"), bundle.getString("CONN_ID_COLUMN"), bundle.getString("BLOCKED_ON_COLUMN")};
        this._blockedConnsTableModel = new StatisticsTableModel(3, stringArray, 5);
        this._blockedConnsTable = new JTable(this._blockedConnsTableModel);
        tableColumnModel = this._blockedConnsTable.getColumnModel();
        tableColumnModel.getColumn(0).setCellRenderer(_toolTipCellRenderer);
        this._blockedConnsTable.setTableHeader(new ToolTipTableHeader(tableColumnModel));
        this._blockedConnsTable.setAutoCreateRowSorter(true);
        this._blockedConnsTable.setColumnSelectionAllowed(false);
        this._blockedConnsTable.setFocusable(false);
        this.resizeTable(this._blockedConnsTable, 0);
        this._blockedConnsTable.setRowSelectionAllowed(false);
        this._blockedConnsTable.getTableHeader().setReorderingAllowed(false);
        int n = 0;
        JLabel jLabel = new JLabel(bundle.getString("USER_COUNT"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 21, 2, DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._userCountLabel = new JLabel(_unknownValueStr);
        gridBagConstraints = new GridBagConstraints(1, n, 2, 1, 1.0, 0.0, 21, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._userCountLabel, gridBagConstraints);
        jLabel = new JLabel(bundle.getString("MAX_CONNECTIONS"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)jLabel, gridBagConstraints);
        this._maxConnsLabel = new JLabel(_unknownValueStr);
        gridBagConstraints = new GridBagConstraints(1, n, 2, 1, 1.0, 0.0, 21, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._maxConnsLabel, gridBagConstraints);
        this._transTimesLabel = new JLabel(bundle.getString("UNKNOWN_TRANSACTION_TIMES"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 3, 1, 0.0, 0.0, 21, 0, new Insets(10, 0, 0, 0), 0, 0);
        jPanel.add((Component)this._transTimesLabel, gridBagConstraints);
        this._transTimesScrollPane = new JScrollPane(this._transTimesTable);
        gridBagConstraints = new GridBagConstraints(0, ++n, 3, 1, 1.0, 0.0, 21, 2, new Insets(5, 20, 0, 0), 0, 0);
        jPanel.add((Component)this._transTimesScrollPane, gridBagConstraints);
        EmptyComponent emptyComponent = new EmptyComponent();
        gridBagConstraints = new GridBagConstraints(0, ++n, 3, 1, 0.0, 0.0, 21, 0, new Insets(10, 0, 0, 0), 0, 0);
        jPanel.add((Component)emptyComponent, gridBagConstraints);
        this._blockedConnCountDesc = new JLabel(bundle.getString("BLOCKED_CONN_COUNT"));
        gridBagConstraints = new GridBagConstraints(0, ++n, 1, 1, 0.0, 0.0, 21, 0, DESCRIPTION_LABEL_INSETS, 0, 0);
        jPanel.add((Component)this._blockedConnCountDesc, gridBagConstraints);
        this._blockedConnCountLabel = DBDiagramUtils.createJLabelForWarning(_unknownValueStr);
        gridBagConstraints = new GridBagConstraints(1, n, 1, 1, 0.0, 0.0, 21, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._blockedConnCountLabel, gridBagConstraints);
        this._blockedConnsClickPanel = new ClickablePanel();
        this._blockedConnsClickPanel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints(0, n, 2, 1, 0.0, 0.0, 21, 1, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)this._blockedConnsClickPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints(2, n, 1, 1, 1.0, 0.0, 21, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        jPanel.add((Component)new EmptyComponent(), gridBagConstraints);
        this._blockedConnsScrollPane = new JScrollPane(this._blockedConnsTable);
        gridBagConstraints = new GridBagConstraints(0, ++n, 3, 1, 1.0, 0.0, 21, 2, new Insets(5, 20, 0, 0), 0, 0);
        jPanel.add((Component)this._blockedConnsScrollPane, gridBagConstraints);
        this._usersPanel = new DBDiagramCollapsiblePanel(bundle.getString("CONNECTED_USERS_TITLE"), ASAComponentsImageLoader.getImageIcon("connuser", 1002), jPanel);
        this._usersPanel.setCollapsed(true);
        this._usersPanel.addActionListener(this._collapsiblePanelActionListener);
        this._usersPanel.addFocusListener(this._collapsiblePanelFocusListener);
        this._usersPanel.setOpaque(false);
        this._collapsiblePanelsPanel.add((Component)this._usersPanel, this.createCollapsiblePanelGBC(3));
    }

    private PrintingPanel createUsersPrintPanel(Graphics graphics, int n) {
        PrintingLabelMetadata[] printingLabelMetadataArray;
        PrintingLabelMetadata printingLabelMetadata;
        PrintingLabelMetadata printingLabelMetadata2;
        int n2;
        PrintingPanel printingPanel = new PrintingPanel();
        PrintingComponent printingComponent = this._usersPanel.createTitlePrintingComponent(graphics);
        printingPanel.add(printingComponent);
        int n3 = 32;
        int n4 = printingComponent.getHeight();
        String[] stringArray = new String[]{bundle.getString("USER_COUNT"), bundle.getString("MAX_CONNECTIONS")};
        PrintingLabelMetadata printingLabelMetadata3 = NORMAL_PRINTING_METADATA.createCopy();
        printingLabelMetadata3.maxWidth = n / 2;
        printingComponent = this.createPrintingLabelsColumn(stringArray, null, printingLabelMetadata3);
        printingComponent.setLocation(n3, n4 += 3);
        printingPanel.add(printingComponent);
        int n5 = this._blockedConnsClickPanel.isEnabled() ? 2 : 0;
        PrintingLabel printingLabel = this.createPrintingLabel(bundle.getString("BLOCKED_CONN_COUNT"), n5);
        int n6 = Math.max(printingComponent.getWidth(), ((PrintingComponent)printingLabel).getWidth());
        int n7 = n3 + n6 + 10;
        stringArray = new String[]{this._userCountLabel.getText(), this._maxConnsLabel.getText()};
        printingLabelMetadata3.maxWidth = n - n7;
        printingComponent = this.createPrintingLabelsColumn(stringArray, null, printingLabelMetadata3);
        printingComponent.setLocation(n7, n4);
        printingPanel.add(printingComponent);
        n4 += printingComponent.getHeight() + 10;
        printingComponent = this.createPrintingLabel(this._transTimesLabel.getText());
        printingComponent.setLocation(n3, n4);
        printingPanel.add(printingComponent);
        if (this._transTimesScrollPane.isVisible()) {
            n4 += printingComponent.getHeight() + 5;
            n2 = n - n3;
            printingLabelMetadata2 = new PrintingLabelMetadata();
            printingLabelMetadata2.truncateToFit = true;
            printingLabelMetadata = new PrintingLabelMetadata();
            printingLabelMetadata.maxWidth = n2 / 3;
            printingLabelMetadataArray = new PrintingLabelMetadata[]{printingLabelMetadata2, printingLabelMetadata, printingLabelMetadata};
            printingComponent = this.createPrintingTable(this._transTimesTable, printingLabelMetadataArray, n2);
            printingComponent.setLocation(n3 + 20, n4);
            printingPanel.add(printingComponent);
        }
        printingLabel.setLocation(n3, n4 += printingComponent.getHeight() + 10);
        printingPanel.add(printingLabel);
        n5 = this._blockedConnsClickPanel.isEnabled() ? 3 : 0;
        printingComponent = this.createPrintingLabel(this._blockedConnCountLabel.getText(), n5);
        printingComponent.setLocation(n7, n4);
        printingPanel.add(printingComponent);
        if (this._blockedConnsScrollPane.isVisible()) {
            n4 += printingComponent.getHeight() + 5;
            n2 = n - n3;
            printingLabelMetadata2 = new PrintingLabelMetadata();
            printingLabelMetadata2.truncateToFit = true;
            printingLabelMetadata = new PrintingLabelMetadata();
            printingLabelMetadata.maxWidth = n2 / 3;
            printingLabelMetadataArray = new PrintingLabelMetadata[]{printingLabelMetadata2, printingLabelMetadata, printingLabelMetadata};
            printingComponent = this.createPrintingTable(this._blockedConnsTable, printingLabelMetadataArray, n2);
            printingComponent.setLocation(n3 + 20, n4);
            printingPanel.add(printingComponent);
        }
        return printingPanel;
    }

    private static String findParameterInProtocol(String string, ProtocolOption protocolOption) {
        for (int i = 0; i < protocolOption.getParameterCount(); ++i) {
            String string2 = protocolOption.getParameterName(i);
            if (!string2.equalsIgnoreCase(string)) continue;
            return protocolOption.getParameterValue(i);
        }
        return null;
    }

    private static String formatFreeSpace(long l) {
        if (l >= 0x10000000000L) {
            return String.format(DBDiagramResourcesBase.getBundle().getString("FILE_SIZE_TERABYTES"), (double)l / 1.099511627776E12);
        }
        if (l >= 0x40000000L) {
            return String.format(DBDiagramResourcesBase.getBundle().getString("FILE_SIZE_GIGABYTES"), (double)l / 1.073741824E9);
        }
        if (l >= 0x100000L) {
            return String.format(DBDiagramResourcesBase.getBundle().getString("FILE_SIZE_MEGABYTES"), (double)l / 1048576.0);
        }
        if (l >= 1024L) {
            return String.format(DBDiagramResourcesBase.getBundle().getString("FILE_SIZE_KILOBYTES"), (double)l / 1024.0);
        }
        return String.format(DBDiagramResourcesBase.getBundle().getString("FILE_SIZE_BYTES"), l);
    }

    private void getMLServerTableOwners() throws SQLException {
        if (this._mlServerTableOwners == null) {
            this._mlServerTableOwners = new HashMap(10);
        }
        this._mlServerTableOwners.clear();
        String[] stringArray = new String[]{"ml_user", "ml_subscription", "ml_qa_global_props", "ml_qa_messages", "ml_property"};
        for (int i = 0; i < 5; ++i) {
            String string = "SELECT U.user_name FROM SYS.SYSTAB T JOIN SYS.SYSUSER U ON U.user_id = T.creator WHERE T.table_name = '" + stringArray[i] + "'";
            Object[][] objectArray = this._client.executeSQL(this, string);
            if (objectArray == null) continue;
            String[] stringArray2 = new String[objectArray.length];
            for (int j = 0; j < objectArray.length; ++j) {
                stringArray2[j] = objectArray[j][0].toString();
            }
            this._mlServerTableOwners.put(stringArray[i], stringArray2);
        }
    }

    private Object getProperty(String string, String string2) throws SQLException {
        Object[][] objectArray = this._client.executeSQL(this, "SELECT " + string + " ( '" + string2 + "' )");
        if (objectArray == null || objectArray.length < 1 || objectArray[0].length < 1 || objectArray[0][0] == null) {
            return null;
        }
        return objectArray[0][0];
    }

    private String getPropertyStr(String string, String string2) throws SQLException {
        Object object = this.getProperty(string, string2);
        if (object == null) {
            return bundle.getString("ERROR_GETTING_VALUE");
        }
        return object.toString();
    }

    private String[] getProperties(String[][] stringArray) throws SQLException {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        String[] stringArray2 = null;
        stringBuilder.append("SELECT ");
        for (n = 0; n < stringArray.length; ++n) {
            stringBuilder.append(stringArray[n][0]).append(" ( '").append(stringArray[n][1]).append("' )");
            if (n + 1 >= stringArray.length) continue;
            stringBuilder.append(", ");
        }
        Object[][] objectArray = this._client.executeSQL(this, stringBuilder.toString());
        if (objectArray != null) {
            stringArray2 = new String[objectArray[0].length];
            for (n = 0; n < objectArray[0].length; ++n) {
                if (objectArray[0][n] == null || objectArray[0][n].toString().length() == 0) {
                    if (stringArray[n][2].equals("N")) {
                        stringArray2[n] = bundle.getString("ERROR_GETTING_VALUE");
                        continue;
                    }
                    stringArray2[n] = null;
                    continue;
                }
                stringArray2[n] = objectArray[0][n].toString();
            }
        }
        return stringArray2;
    }

    private void handleSQLException(SQLException sQLException, boolean bl) {
        if ((this._showSQLExceptionDialog | bl) & !this._resourcesReleased) {
            String string = bundle.getFormatted("SQL_EXCEPTION_DURING_MANUAL_REFRESH", sQLException.getLocalizedMessage() + "\n" + bundle.getFormatted("SQLCODE_AND_ODBC_3_STATE", Integer.toString(sQLException.getErrorCode()), sQLException.getSQLState()));
            SybOptionPane.showMessageDialog((Component)this, (Object)string, (String)bundle.getString("ERROR_DIALOG_TITLE"), (int)0);
        }
    }

    private void refreshDbspaces() {
        String string = null;
        String string2 = null;
        long l = 0L;
        if (this._isStopped) {
            return;
        }
        boolean bl = this._platformLabel.getText().toLowerCase().contains("windows ce");
        boolean bl2 = this._platformLabel.getText().toLowerCase().contains("win");
        boolean bl3 = this._platformLabel.getText().toLowerCase().contains("darwin");
        this.clearDbspaces();
        try {
            String string3 = this._databaseVersion == 1000 ? "SELECT files.dbspace_name, files.file_name, freespace.free_space FROM sys.sysfile files LEFT OUTER JOIN sa_disk_free_space() freespace ON files.dbspace_name = freespace.dbspace_name WHERE files.dbspace_name <> 'temporary' AND files.dbspace_name <> 'temp'" : "SELECT files.dbfile_name, files.file_name, freespace.free_space, freespace.total_space FROM sys.sysdbfile files LEFT OUTER JOIN sa_disk_free_space() freespace ON files.dbfile_name = freespace.dbspace_name WHERE files.dbfile_name <> 'temporary' AND files.dbfile_name <> 'temp'";
            Object[][] objectArray = this._client.executeSQL(this, string3);
            if (objectArray != null && this._mainDirectory != null) {
                for (int i = 0; i < objectArray.length; ++i) {
                    CellPanel cellPanel;
                    ClientNotifier clientNotifier;
                    String[] stringArray = new String[3];
                    stringArray[0] = objectArray[i][0].toString();
                    String string4 = objectArray[i][1].toString();
                    File file = new File(string4);
                    stringArray[1] = bl || !bl2 || file.isAbsolute() || bl3 ? string4 : this._mainDirectory + string4;
                    boolean bl4 = false;
                    boolean bl5 = false;
                    if (!bl && (this._databaseVersion == 1000 && objectArray[i][2] == null || this._databaseVersion != 1000 && objectArray[i][2] == null && objectArray[i][3] == null)) {
                        bl4 = true;
                        stringArray[2] = bundle.getString("FILE_NOT_FOUND");
                    } else if (objectArray[i][2] == null) {
                        stringArray[2] = bundle.getString("UNKNOWN_VALUE");
                    } else if (!(objectArray[i][2] instanceof Long)) {
                        stringArray[2] = bundle.getString("ERROR_GETTING_VALUE");
                    } else {
                        long l2 = (Long)objectArray[i][2];
                        string = DBDiagramPanel.formatFreeSpace(l2);
                        if (this._databaseVersion == 1000) {
                            stringArray[2] = string;
                        } else if (!(objectArray[i][3] instanceof Long)) {
                            stringArray[2] = bundle.getString("ERROR_GETTING_VALUE");
                        } else {
                            l = (Long)objectArray[i][3];
                            double d = (double)Math.round((double)l2 * 10000.0 / (double)l) / 100.0;
                            string2 = String.format("%.1f%%", d);
                            stringArray[2] = string + " (" + string2 + ")";
                            string3 = "SELECT SUM( db_property( 'pagesize' ) * db_extended_property( 'FileSize' ,dbspace_name ) ) from SYS.SYSFILE";
                            Object[][] objectArray2 = this._client.executeSQL(this, string3);
                            if (objectArray2 != null && objectArray2[0][0] instanceof BigDecimal) {
                                BigDecimal bigDecimal = (BigDecimal)objectArray2[0][0];
                                bl5 = (double)l2 < bigDecimal.doubleValue() * 2.0;
                            }
                        }
                    }
                    this._dbspacesTableModel.add(stringArray, bl4 | bl5);
                    if (bl4) {
                        this._atLeastOneWarning = true;
                        this._dbspacesPanel.addWarning(bundle.getFormatted("FILE_NOT_FOUND_WARNING", stringArray[0]));
                        clientNotifier = new ClientNotifier(this._client, this, 3, stringArray[0], null);
                        cellPanel = new CellPanel(this._dbspacesTable, this._dbspacesTableModel.getRowCount() - 1, 2);
                        this._clientNotifiers.add(clientNotifier);
                        cellPanel.addActionListener(clientNotifier);
                        this._dbspacesCellPanels.add(cellPanel);
                        continue;
                    }
                    if (!bl5) continue;
                    this._atLeastOneWarning = true;
                    this._dbspacesPanel.addWarning(bundle.getFormatted("LOW_DBSPACE_SPACE_WARNING", stringArray[0]));
                    String[] stringArray2 = new String[]{string, DBDiagramPanel.formatFreeSpace(l), string2};
                    clientNotifier = new ClientNotifier(this._client, this, 2, stringArray[0], stringArray2);
                    cellPanel = new CellPanel(this._dbspacesTable, this._dbspacesTableModel.getRowCount() - 1, 2);
                    this._clientNotifiers.add(clientNotifier);
                    cellPanel.addActionListener(clientNotifier);
                    this._dbspacesCellPanels.add(cellPanel);
                }
                this.resizeTable(this._dbspacesTable, 5);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DBDiagramPanel.this.refreshLogs();
                }
            });
        }
        catch (SQLException sQLException) {
            this.handleSQLException(sQLException, false);
            this.stopRefreshAll();
        }
    }

    private void refreshDynamicInfo() {
        this.clearClientNotifiers();
        this._atLeastOneWarning = false;
        this.setShowWarningAtTop(false);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DBDiagramPanel.this.refreshStatistics();
            }
        });
    }

    private void refreshLogs() {
        boolean bl;
        String string = null;
        long l = 0L;
        if (this._isStopped) {
            return;
        }
        this.clearLogs();
        if (this._logEnabled) {
            try {
                ClientNotifier clientNotifier;
                String[] stringArray;
                BigDecimal bigDecimal;
                double d;
                String string2;
                long l2;
                String string3;
                String string4 = this._databaseVersion == 1000 ? "SELECT free_space FROM sa_disk_free_space( 'translog' )" : "SELECT free_space, total_space FROM sa_disk_free_space( 'translog' )";
                Object[][] objectArray = this._client.executeSQL(this, string4);
                boolean bl2 = false;
                if (objectArray == null) {
                    string3 = bundle.getString("UNKNOWN_VALUE");
                    this._logSpaceLabel.setText(string3);
                    this._logSpaceClickPanel.setToolTipText(string3);
                } else if (!(objectArray[0][0] instanceof Long)) {
                    string3 = bundle.getString("ERROR_GETTING_VALUE");
                    this._logSpaceLabel.setText(string3);
                    this._logSpaceClickPanel.setToolTipText(string3);
                } else {
                    l2 = (Long)objectArray[0][0];
                    string2 = DBDiagramPanel.formatFreeSpace(l2);
                    if (this._databaseVersion == 1000) {
                        string3 = string2;
                    } else if (!(objectArray[0][1] instanceof Long)) {
                        string3 = bundle.getString("ERROR_GETTING_VALUE");
                    } else {
                        l = (Long)objectArray[0][1];
                        d = (double)Math.round((double)l2 * 10000.0 / (double)l) / 100.0;
                        string = String.format("%.1f%%", d);
                        string3 = string2 + " (" + string + ")";
                        string4 = "SELECT SUM( db_property( 'pagesize' ) * db_extended_property( 'FileSize','translog' ) )";
                        Object[][] objectArray2 = this._client.executeSQL(this, string4);
                        if (objectArray2 != null && objectArray2[0][0] instanceof BigDecimal) {
                            bigDecimal = (BigDecimal)objectArray2[0][0];
                            bl2 = (double)l2 < bigDecimal.doubleValue() * 2.0;
                        }
                    }
                    this._logSpaceLabel.setText(string3);
                    this._logSpaceClickPanel.setToolTipText(string3);
                    if (bl2) {
                        this._atLeastOneWarning = true;
                        this._logsPanel.addWarning(bundle.getString("LOW_LOG_SPACE_WARNING"));
                        DBDiagramUtils.showWarning(this._logSpaceLabel);
                        stringArray = new String[]{string2, DBDiagramPanel.formatFreeSpace(l), string};
                        clientNotifier = new ClientNotifier(this._client, this, 4, "", stringArray);
                        this._clientNotifiers.add(clientNotifier);
                        this._logSpaceClickPanel.addActionListener(clientNotifier);
                        this._logSpaceClickPanel.setEnabled(true);
                        this._logSpaceClickPanel.setShowBorder(true);
                    }
                }
                if (this._mirrorLogEnabled) {
                    string4 = this._databaseVersion == 1000 ? "SELECT free_space FROM sa_disk_free_space( 'translogmirror' )" : "SELECT free_space, total_space FROM sa_disk_free_space( 'translogmirror' )";
                    objectArray = this._client.executeSQL(this, string4);
                    if (objectArray == null) {
                        string3 = bundle.getString("UNKNOWN_VALUE");
                        this._mirrorLogSpaceLabel.setText(string3);
                        this._mirrorLogSpaceClickPanel.setToolTipText(string3);
                    } else if (!(objectArray[0][0] instanceof Long)) {
                        string3 = bundle.getString("ERROR_GETTING_VALUE");
                        this._mirrorLogSpaceLabel.setText(string3);
                        this._mirrorLogSpaceClickPanel.setToolTipText(string3);
                        bl2 = false;
                    } else {
                        l2 = (Long)objectArray[0][0];
                        string2 = DBDiagramPanel.formatFreeSpace(l2);
                        if (this._databaseVersion == 1000) {
                            string3 = string2;
                        } else if (!(objectArray[0][1] instanceof Long)) {
                            string3 = bundle.getString("ERROR_GETTING_VALUE");
                        } else {
                            l = (Long)objectArray[0][1];
                            d = (double)Math.round((double)l2 * 10000.0 / (double)l) / 100.0;
                            string = String.format("%.1f%%", d);
                            string3 = string2 + " (" + string + ")";
                            string4 = "SELECT SUM( db_property( 'pagesize' ) * db_extended_property( 'FileSize','translogmirror' ) )";
                            objectArray = this._client.executeSQL(this, string4);
                            if (objectArray != null && objectArray[0][0] instanceof BigDecimal) {
                                bigDecimal = (BigDecimal)objectArray[0][0];
                                bl2 = (double)l2 < bigDecimal.doubleValue() * 2.0;
                            }
                        }
                        this._mirrorLogSpaceLabel.setText(string3);
                        this._mirrorLogSpaceClickPanel.setToolTipText(string3);
                        if (bl2) {
                            this._atLeastOneWarning = true;
                            this._logsPanel.addWarning(bundle.getString("LOW_MIRROR_LOG_SPACE_WARNING"));
                            DBDiagramUtils.showWarning(this._mirrorLogSpaceLabel);
                            stringArray = new String[]{string2, DBDiagramPanel.formatFreeSpace(l), string};
                            clientNotifier = new ClientNotifier(this._client, this, 5, "", stringArray);
                            this._clientNotifiers.add(clientNotifier);
                            this._mirrorLogSpaceClickPanel.addActionListener(clientNotifier);
                            this._mirrorLogSpaceClickPanel.setEnabled(true);
                            this._mirrorLogSpaceClickPanel.setShowBorder(true);
                        }
                    }
                }
                bl = true;
            }
            catch (SQLException sQLException) {
                this.handleSQLException(sQLException, false);
                this.stopRefreshAll();
                bl = false;
            }
        } else {
            bl = true;
        }
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DBDiagramPanel.this.refreshUsers();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshMirroring() {
        boolean bl;
        BufferedReader bufferedReader = null;
        if (this._isStopped) {
            return;
        }
        this.clearMirroring();
        if (this._mirroringEnabled) {
            try {
                ClientNotifier clientNotifier;
                boolean bl2;
                String string;
                Object object = this.getProperty("DB_PROPERTY", "ArbiterState");
                if (object == null) {
                    string = bundle.getString("ERROR_GETTING_VALUE");
                    bl2 = true;
                } else if (object.toString().equalsIgnoreCase("connected")) {
                    string = bundle.getString("ARBITER_STATUS_GOOD");
                    bl2 = false;
                } else {
                    string = bundle.getString("ARBITER_STATUS_BAD");
                    bl2 = true;
                }
                this._arbiterStatusLabel.setText(string);
                if (bl2) {
                    this._atLeastOneWarning = true;
                    this._mirroringPanel.addWarning(bundle.getString("ARBITER_DISCONNECTED_WARNING"));
                    DBDiagramUtils.showWarning(this._arbiterStatusLabel);
                    clientNotifier = new ClientNotifier(this._client, this, 8, "", null);
                    this._clientNotifiers.add(clientNotifier);
                    this._arbiterStatusClickPanel.addActionListener(clientNotifier);
                    this._arbiterStatusClickPanel.setEnabled(true);
                    this._arbiterStatusClickPanel.setShowBorder(true);
                    this._arbiterNode.setWarning(true);
                }
                if ((object = this.getProperty("DB_PROPERTY", "PartnerState")) == null) {
                    string = bundle.getString("ERROR_GETTING_VALUE");
                    bl2 = true;
                } else if (object.toString().equalsIgnoreCase("connected")) {
                    string = bundle.getString("MIRROR_STATUS_GOOD");
                    bl2 = false;
                } else {
                    string = bundle.getString("MIRROR_STATUS_BAD");
                    bl2 = true;
                }
                this._mirrorStatusLabel.setText(string);
                if (bl2) {
                    this._atLeastOneWarning = true;
                    this._mirroringPanel.addWarning(bundle.getString("MIRROR_DISCONNECTED_WARNING"));
                    DBDiagramUtils.showWarning(this._mirrorStatusLabel);
                    clientNotifier = new ClientNotifier(this._client, this, 9, "", null);
                    this._clientNotifiers.add(clientNotifier);
                    this._mirrorStatusClickPanel.addActionListener(clientNotifier);
                    this._mirrorStatusClickPanel.setEnabled(true);
                    this._mirrorStatusClickPanel.setShowBorder(true);
                    this._mirrorNode.setWarning(true);
                }
                this._mirroringStateLabel.setText(this.getPropertyStr("DB_PROPERTY", "MirrorState"));
                try {
                    bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(this._stateFile)));
                    String string2 = bufferedReader.readLine();
                    while (string2 != null) {
                        if (string2.startsWith("Mode")) {
                            string = string2.substring(string2.indexOf("=") + 1);
                            this._mirroringModeLabel.setText(string);
                        } else if (string2.startsWith("Sequence")) {
                            string = string2.substring(string2.indexOf("=") + 1);
                            this._mirroringSeqLabel.setText(string);
                        }
                        string2 = bufferedReader.readLine();
                    }
                }
                catch (IOException iOException) {
                    this._mirroringSeqLabel.setText(bundle.getString("STATE_FILE_IO_EXCEPTION"));
                    this._mirroringModeLabel.setText(bundle.getString("STATE_FILE_IO_EXCEPTION"));
                }
                finally {
                    if (bufferedReader != null) {
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                bl = true;
            }
            catch (SQLException sQLException) {
                this.handleSQLException(sQLException, false);
                bl = false;
            }
        } else {
            bl = true;
        }
        if (bl) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DBDiagramPanel.this.refreshRemServers();
                }
            });
        } else {
            this.stopRefreshAll();
        }
        this.enableTopologyNodes();
    }

    private void refreshMLServer() {
        this._mlServerRefreshStarted = true;
        this.clearMLServer();
        try {
            this.getMLServerTableOwners();
            this.refreshMLServer(this._mlServerTableOwners, null);
        }
        catch (SQLException sQLException) {
            this.handleSQLException(sQLException, false);
        }
    }

    private String parseDateString(Object object) {
        String string = null;
        if (object == null) {
            return bundle.getString("NEVER");
        }
        try {
            string = _dateParser.format(_dateParser.parse(object.toString()));
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        if (string == null) {
            string = object.toString();
        }
        return string;
    }

    private void refreshMLServer(HashMap<String, String[]> hashMap, HashMap<String, Object[][]> hashMap2) throws SQLException {
        String[] stringArray;
        Object[][] objectArray;
        String string;
        int n;
        if (this._stateInfoToSave == null) {
            this._stateInfoToSave = new StateInfo();
        }
        this._stateInfoToSave.wasMLServerRefreshed = true;
        this._stateInfoToSave.tableOwnersHM = hashMap;
        if (hashMap2 == null) {
            if (this._stateInfoToSave.resultsHM == null) {
                this._stateInfoToSave.resultsHM = new HashMap();
            } else {
                this._stateInfoToSave.resultsHM.clear();
            }
        } else {
            this._stateInfoToSave.resultsHM = hashMap2;
        }
        this._mobilinkEnabled = false;
        String[] stringArray2 = hashMap.get("ml_user");
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                string = "SELECT COUNT( * ) FROM " + stringArray2[n] + ".ml_user";
                if (hashMap2 == null) {
                    objectArray = this._client.executeSQL(this, string);
                    this._stateInfoToSave.resultsHM.put(string, objectArray);
                } else {
                    objectArray = hashMap2.get(string);
                }
                if (objectArray == null || !(objectArray[0][0] instanceof Integer) || (Integer)objectArray[0][0] <= 0) continue;
                this._mobilinkEnabled = true;
                break;
            }
        }
        if (this._mobilinkEnabled && this._mlServerPanel == null) {
            this.createMLServerPanel();
        }
        if (this._mobilinkNode == null) {
            this.createMobilinkNode();
        }
        this._topologyNeedsUpdate = true;
        this.refreshTopology(false);
        this._qanywhereEnabled = false;
        stringArray2 = hashMap.get("ml_qa_global_props");
        if (stringArray2 != null) {
            for (n = 0; n < stringArray2.length; ++n) {
                string = "SELECT COUNT( * ) FROM " + stringArray2[n] + ".ml_qa_global_props";
                if (hashMap2 == null) {
                    objectArray = this._client.executeSQL(this, string);
                    this._stateInfoToSave.resultsHM.put(string, objectArray);
                } else {
                    objectArray = hashMap2.get(string);
                }
                if (objectArray == null || !(objectArray[0][0] instanceof Integer) || (Integer)objectArray[0][0] <= 0) continue;
                this._qanywhereEnabled = true;
                break;
            }
        }
        if (this._qanywhereEnabled && this._mlServerPanel == null) {
            this.createMLServerPanel();
        }
        if (this._qanywhereNode == null) {
            this.createQAnywhereNode();
        }
        this._topologyNeedsUpdate = true;
        this.refreshTopology(false);
        this._notifierEnabled = false;
        stringArray2 = hashMap.get("ml_property");
        if (stringArray2 != null) {
            if (this._mlServerPanel == null) {
                this.createMLServerPanel();
            }
            if (stringArray2.length == 1) {
                if (this._notifierScrollPane != null) {
                    this._notifierScrollPane.setVisible(false);
                }
                this._notifierCountDesc.setVisible(true);
                this._notifierCountLabel.setVisible(true);
                string = "SELECT COUNT( DISTINCT property_set_name ) FROM " + stringArray2[0] + ".ml_property " + "WHERE component_name LIKE 'SIS%' " + "AND property_set_name LIKE 'Notifier(%'";
                if (hashMap2 == null) {
                    objectArray = this._client.executeSQL(this, string);
                    this._stateInfoToSave.resultsHM.put(string, objectArray);
                } else {
                    objectArray = hashMap2.get(string);
                }
                if (objectArray != null && objectArray[0][0] instanceof Integer) {
                    if ((Integer)objectArray[0][0] == 0) {
                        this._notifierCountLabel.setText("0");
                    } else {
                        this._notifierCountLabel.setText(objectArray[0][0].toString());
                        this._notifierEnabled = true;
                    }
                }
            } else {
                if (this._notifierScrollPane == null) {
                    this.createNotifierTable();
                }
                this._notifierScrollPane.setVisible(true);
                this._notifierCountDesc.setVisible(false);
                this._notifierCountLabel.setVisible(false);
                for (n = 0; n < stringArray2.length; ++n) {
                    stringArray = new String[2];
                    stringArray[0] = stringArray2[n];
                    string = "SELECT COUNT( DISTINCT property_set_name ) FROM " + stringArray2[n] + ".ml_property " + "WHERE component_name LIKE 'SIS%' " + "AND property_set_name LIKE 'Notifier(%'";
                    if (hashMap2 == null) {
                        objectArray = this._client.executeSQL(this, string);
                        this._stateInfoToSave.resultsHM.put(string, objectArray);
                    } else {
                        objectArray = hashMap2.get(string);
                    }
                    if (objectArray == null || !(objectArray[0][0] instanceof Integer)) {
                        stringArray[1] = bundle.getString("ERROR_GETTING_VALUE");
                    } else if ((Integer)objectArray[0][0] == 0) {
                        stringArray[1] = "0";
                    } else {
                        stringArray[1] = objectArray[0][0].toString();
                        this._notifierEnabled = true;
                    }
                    this._notifierTableModel.add(stringArray, false);
                }
                this.resizeTable(this._notifierTable, 5);
            }
        } else if (this._mlServerPanel != null) {
            this._notifierCountLabel.setText("0");
        }
        if (this._mobilinkEnabled) {
            this._mobilinkLabel.setText(bundle.getString("MOBILINK"));
            stringArray2 = hashMap.get("ml_subscription");
            if (stringArray2.length == 1) {
                if (this._mobilinkScrollPane != null) {
                    this._mobilinkScrollPane.setVisible(false);
                }
                this._lastUploadDesc.setVisible(true);
                this._lastUploadLabel.setVisible(true);
                this._lastDownloadDesc.setVisible(true);
                this._lastDownloadLabel.setVisible(true);
                string = "SELECT MAX( last_upload_time ), MAX( last_download_time ) FROM " + stringArray2[0] + ".ml_subscription";
                if (hashMap2 == null) {
                    objectArray = this._client.executeSQL(this, string);
                    this._stateInfoToSave.resultsHM.put(string, objectArray);
                } else {
                    objectArray = hashMap2.get(string);
                }
                if (objectArray == null) {
                    this._lastUploadLabel.setText(bundle.getString("ERROR_GETTING_VALUE"));
                    this._lastDownloadLabel.setText(bundle.getString("ERROR_GETTING_VALUE"));
                } else {
                    this._lastUploadLabel.setText(this.parseDateString(objectArray[0][0]));
                    this._lastDownloadLabel.setText(this.parseDateString(objectArray[0][1]));
                }
            } else {
                if (this._mobilinkScrollPane == null) {
                    this.createMobilinkTable();
                }
                this._mobilinkScrollPane.setVisible(true);
                this._lastUploadDesc.setVisible(false);
                this._lastUploadLabel.setVisible(false);
                this._lastDownloadDesc.setVisible(false);
                this._lastDownloadLabel.setVisible(false);
                for (n = 0; n < stringArray2.length; ++n) {
                    stringArray = new String[3];
                    stringArray[0] = stringArray2[n];
                    string = "SELECT MAX( last_upload_time ), MAX( last_download_time ) FROM " + stringArray2[n] + ".ml_subscription";
                    if (hashMap2 == null) {
                        objectArray = this._client.executeSQL(this, string);
                        this._stateInfoToSave.resultsHM.put(string, objectArray);
                    } else {
                        objectArray = hashMap2.get(string);
                    }
                    if (objectArray == null) {
                        stringArray[1] = bundle.getString("ERROR_GETTING_VALUE");
                        stringArray[2] = bundle.getString("ERROR_GETTING_VALUE");
                    } else {
                        stringArray[1] = this.parseDateString(objectArray[0][0]);
                        stringArray[2] = this.parseDateString(objectArray[0][1]);
                    }
                    this._mobilinkTableModel.add(stringArray, false);
                }
                this.resizeTable(this._mobilinkTable, 5);
            }
        } else if (this._mlServerPanel != null) {
            this._mobilinkLabel.setText(bundle.getString("NO_MOBILINK"));
            if (this._mobilinkScrollPane != null) {
                this._mobilinkScrollPane.setVisible(false);
            }
            this._lastUploadDesc.setVisible(false);
            this._lastUploadLabel.setVisible(false);
            this._lastDownloadDesc.setVisible(false);
            this._lastDownloadLabel.setVisible(false);
        }
        if (this._qanywhereEnabled) {
            this._qanywhereLabel.setText(bundle.getString("QANYWHERE"));
            stringArray2 = hashMap.get("ml_qa_messages");
            if (stringArray2.length == 1) {
                if (this._qanywhereScrollPane != null) {
                    this._qanywhereScrollPane.setVisible(false);
                }
                this._lastActivityDesc.setVisible(true);
                this._lastActivityLabel.setVisible(true);
                string = "SELECT MAX( statustime ) FROM " + stringArray2[0] + ".ml_qa_messages";
                if (hashMap2 == null) {
                    objectArray = this._client.executeSQL(this, string);
                    this._stateInfoToSave.resultsHM.put(string, objectArray);
                } else {
                    objectArray = hashMap2.get(string);
                }
                if (objectArray == null) {
                    this._lastActivityLabel.setText(bundle.getString("ERROR_GETTING_VALUE"));
                } else {
                    this._lastActivityLabel.setText(this.parseDateString(objectArray[0][0]));
                }
            } else {
                if (this._qanywhereScrollPane == null) {
                    this.createQAnywhereTable();
                }
                this._qanywhereScrollPane.setVisible(true);
                this._lastActivityDesc.setVisible(false);
                this._lastActivityLabel.setVisible(false);
                for (n = 0; n < stringArray2.length; ++n) {
                    stringArray = new String[2];
                    stringArray[0] = stringArray2[n];
                    string = "SELECT MAX( statustime ) FROM " + stringArray2[n] + ".ml_qa_messages";
                    if (hashMap2 == null) {
                        objectArray = this._client.executeSQL(this, string);
                        this._stateInfoToSave.resultsHM.put(string, objectArray);
                    } else {
                        objectArray = hashMap2.get(string);
                    }
                    stringArray[1] = objectArray == null ? bundle.getString("ERROR_GETTING_VALUE") : this.parseDateString(objectArray[0][0]);
                    this._qanywhereTableModel.add(stringArray, false);
                }
                this.resizeTable(this._qanywhereTable, 5);
            }
        } else if (this._mlServerPanel != null) {
            this._qanywhereLabel.setText(bundle.getString("NO_QANYWHERE"));
            if (this._qanywhereScrollPane != null) {
                this._qanywhereScrollPane.setVisible(false);
            }
            this._lastActivityDesc.setVisible(false);
            this._lastActivityLabel.setVisible(false);
        }
    }

    private void refreshMLServerClicked() {
        if (this.startRefresh()) {
            this.refreshMLServer();
            this.stopRefresh();
        }
    }

    private void checkForUpdatesButtonClicked() {
        this._checkForUpdatesButton.setEnabled(false);
        this._client.showCheckForUpdatesDialog(this);
        this._checkForUpdatesButton.setEnabled(true);
    }

    private void checkMLServer() {
        if (this._isStopped) {
            return;
        }
        try {
            this.getMLServerTableOwners();
            if (this._mlServerTableOwners.size() == 0) {
                if (this._mlServerPanel != null) {
                    this._mlServerPanel.setVisible(false);
                }
                this.refreshMLServer();
            } else if (this._mlServerPanel == null) {
                this.createMLServerPanel();
                this.clearMLServer();
            } else if (!this._mlServerPanel.isVisible()) {
                this._mlServerPanel.setVisible(true);
                this.clearMLServer();
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DBDiagramPanel.this.refreshSQLRemote();
                }
            });
        }
        catch (SQLException sQLException) {
            this.handleSQLException(sQLException, false);
            this.stopRefreshAll();
        }
    }

    private void refreshRemServers() {
        if (this._isStopped) {
            return;
        }
        this.clearRemServers();
        try {
            String string = "SELECT srvname, srvinfo FROM SYS.SYSSERVER WHERE srvclass <> 'directory'";
            Object[][] objectArray = this._client.executeSQL(this, string);
            if (objectArray == null) {
                if (this._remServersPanel != null && this._remServersPanel.isVisible()) {
                    this._remServersPanel.setVisible(false);
                }
                this._remServersEnabled = false;
                this._topologyNeedsUpdate = true;
            } else {
                if (this._remServersPanel == null) {
                    this.createRemServersPanel();
                } else if (!this._remServersPanel.isVisible()) {
                    this._remServersPanel.setVisible(true);
                }
                this._remServersEnabled = true;
                this._topologyNeedsUpdate = true;
                for (int i = 0; i < objectArray.length; ++i) {
                    int n;
                    String[] stringArray = new String[3];
                    stringArray[0] = objectArray[i][0].toString();
                    stringArray[1] = objectArray[i][1].toString();
                    try {
                        string = "CALL sp_remote_tables( '" + stringArray[0] + "', NULL, NULL, NULL, 1 )";
                        this._client.executeSQL(this, string);
                        stringArray[2] = bundle.getString("GOOD_STATUS");
                        n = 0;
                    }
                    catch (SQLException sQLException) {
                        int n2 = sQLException.getErrorCode();
                        if (n2 == -660) {
                            stringArray[2] = bundle.getString("CONNECTION_CLOSED");
                            n = 1;
                        }
                        if (n2 == -656) {
                            stringArray[2] = bundle.getString("CANNOT_CONNECT");
                            n = 2;
                        }
                        throw sQLException;
                    }
                    boolean bl = n != 0;
                    this._remServersTableModel.add(stringArray, bl);
                    if (!bl) continue;
                    this._atLeastOneWarning = true;
                    if (n == 1) {
                        this._remServersPanel.addWarning(bundle.getFormatted("CONNECTION_CLOSED_WARNING", stringArray[0]));
                    } else {
                        this._remServersPanel.addWarning(bundle.getFormatted("CANNOT_CONNECT_WARNING", stringArray[0]));
                    }
                    CellPanel cellPanel = new CellPanel(this._remServersTable, this._remServersTableModel.getRowCount() - 1, 2);
                    ClientNotifier clientNotifier = new ClientNotifier(this._client, this, 7, stringArray[0], null);
                    this._clientNotifiers.add(clientNotifier);
                    cellPanel.addActionListener(clientNotifier);
                    this._remServersCellPanels.add(cellPanel);
                    this._remServersNode.setWarning(true);
                }
                this.resizeTable(this._remServersTable, 5);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DBDiagramPanel.this.checkMLServer();
                }
            });
        }
        catch (SQLException sQLException) {
            this.handleSQLException(sQLException, false);
            this.stopRefreshAll();
        }
        this.enableTopologyNodes();
    }

    private void refreshSQLRemote() {
        if (this._isStopped) {
            return;
        }
        this.clearSQLRemote();
        try {
            String string = "SELECT U.user_name, R.time_sent, R.time_received FROM SYSREMOTEUSER R JOIN SYS.SYSUSER U ON U.user_id = R.user_id";
            Object[][] objectArray = this._client.executeSQL(this, string);
            if (objectArray == null) {
                if (this._sqlRemotePanel != null && this._sqlRemotePanel.isVisible()) {
                    this._sqlRemotePanel.setVisible(false);
                }
                this._sqlRemoteEnabled = false;
            } else {
                if (this._sqlRemotePanel == null) {
                    this.createSQLRemotePanel();
                } else if (!this._sqlRemotePanel.isVisible()) {
                    this._sqlRemotePanel.setVisible(true);
                }
                this._sqlRemoteEnabled = true;
                for (int i = 0; i < objectArray.length; ++i) {
                    String[] stringArray = new String[]{objectArray[i][0].toString(), this.parseDateString(objectArray[i][1]), this.parseDateString(objectArray[i][2])};
                    this._sqlRemoteTableModel.add(stringArray, false);
                }
                this.resizeTable(this._sqlRemoteTable, 5);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DBDiagramPanel.this.refreshTopology(true);
                }
            });
        }
        catch (SQLException sQLException) {
            this.handleSQLException(sQLException, false);
            this.stopRefreshAll();
        }
    }

    private void refreshStatistics() {
        if (this._isStopped) {
            return;
        }
        this.clearStatistics();
        try {
            this._diskReadsLabel.setText(this.getPropertyStr("DB_PROPERTY", "DiskRead"));
            this._diskWritesLabel.setText(this.getPropertyStr("DB_PROPERTY", "DiskWrite"));
            this._currentIOLabel.setText(this.getPropertyStr("DB_PROPERTY", "CurrIO"));
            Object object = this.getProperty("PROPERTY", "UnschReq");
            String string = object == null ? bundle.getString("ERROR_GETTING_VALUE") : object.toString();
            this._unschReqLabel.setText(string);
            if (object == null || !string.equals("0")) {
                this._atLeastOneWarning = true;
                this._statisticsPanel.addWarning(bundle.getFormatted("UNSCHEDULED_REQUESTS_WARNING", string));
                this.showWarningHack(this._unschReqDesc, this._unschReqLabel);
                ClientNotifier clientNotifier = new ClientNotifier(this._client, this, 1, "", null);
                this._clientNotifiers.add(clientNotifier);
                this._unschReqClickPanel.addActionListener(clientNotifier);
                this._unschReqClickPanel.setEnabled(true);
                this._unschReqClickPanel.setShowBorder(true);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DBDiagramPanel.this.refreshDbspaces();
                }
            });
        }
        catch (SQLException sQLException) {
            this.handleSQLException(sQLException, false);
            this.stopRefreshAll();
        }
    }

    private void refreshTopology(boolean bl) {
        Insets insets = new Insets(0, 0, 16, 0);
        Insets insets2 = new Insets(0, 0, 4, 0);
        boolean bl2 = false;
        int n = 0;
        boolean bl3 = false;
        if (this._isStopped) {
            return;
        }
        if (this._topologyNeedsUpdate) {
            int n2;
            if (this._mirroringEnabled) {
                n2 = this._mirrorNode.getPreferredSize().width;
                n = this._arbiterNode.getPreferredSize().width;
                if (n2 > n) {
                    n = n2;
                }
                if (this._sqlRemoteEnabled) {
                    bl2 = true;
                }
            }
            if (this._mobilinkEnabled && (n2 = this._mobilinkNode.getPreferredSize().width) > n) {
                n = n2;
            }
            if (this._qanywhereEnabled) {
                n2 = this._qanywhereNode.getPreferredSize().width;
                if (n2 > n) {
                    n = n2;
                }
                bl3 = true;
            }
            if (this._remServersEnabled) {
                n2 = this._remServersNode.getPreferredSize().width;
                if (n2 > n) {
                    n = n2;
                }
                if (this._sqlRemoteEnabled) {
                    bl3 = true;
                }
            }
            int n3 = this._dbNode.getPreferredSize().width;
            if (this._sqlRemoteEnabled && (n2 = this._sqlRemoteNode.getPreferredSize().width) > n3) {
                n3 = n2;
            }
            if (n > 0) {
                int n4;
                Dimension dimension;
                int n5 = 88 - (n + n3) / 2;
                if (this._mirroringEnabled & (this._mobilinkEnabled | this._qanywhereEnabled | this._remServersEnabled)) {
                    dimension = new Dimension(n, 0);
                    this._leftTopologyStrut.setMinimumSize(dimension);
                    this._leftTopologyStrut.setPreferredSize(dimension);
                    this._leftTopologyStrut.invalidate();
                    this._leftTopologyStrut.setVisible(true);
                    this._rightTopologyStrut.setMinimumSize(dimension);
                    this._rightTopologyStrut.setPreferredSize(dimension);
                    this._rightTopologyStrut.invalidate();
                    this._rightTopologyStrut.setVisible(true);
                } else {
                    this._leftTopologyStrut.setVisible(false);
                    this._rightTopologyStrut.setVisible(false);
                }
                if (this._mirroringEnabled) {
                    n4 = n5 > 0 ? n5 : 0;
                    if (bl2 && n4 < 10) {
                        n4 = 10;
                    }
                } else {
                    n4 = 0;
                }
                dimension = new Dimension(n4, 0);
                this._midLeftTopologyStrut.setPreferredSize(dimension);
                this._midLeftTopologyStrut.setMinimumSize(dimension);
                this._midLeftTopologyStrut.invalidate();
                if (this._mobilinkEnabled | this._qanywhereEnabled | this._remServersEnabled) {
                    n4 = n5 > 0 ? n5 : 0;
                    if (bl3 && n4 < 10) {
                        n4 = 10;
                    }
                } else {
                    n4 = 0;
                }
                dimension = new Dimension(n4, 0);
                this._midRightTopologyStrut.setPreferredSize(dimension);
                this._midRightTopologyStrut.setMinimumSize(dimension);
                this._midRightTopologyStrut.invalidate();
            }
            if (this._sqlRemoteEnabled && this._dbNodeGBC.insets != insets) {
                this._dbNodeGBC.insets = insets;
                this._topologyDiagramPanel.add((Component)this._dbNode, this._dbNodeGBC);
            } else if (this._dbNodeGBC.insets != DBDiagramUtils.ZERO_INSETS) {
                this._dbNodeGBC.insets = DBDiagramUtils.ZERO_INSETS;
            }
            if (this._mobilinkEnabled) {
                if (this._qanywhereEnabled && this._mobilinkNodeGBC.insets != insets2) {
                    this._mobilinkNodeGBC.insets = insets2;
                    this._topologyDiagramPanel.add((Component)this._mobilinkNode, this._mobilinkNodeGBC);
                } else if (this._mobilinkNodeGBC.insets != DBDiagramUtils.ZERO_INSETS) {
                    this._mobilinkNodeGBC.insets = DBDiagramUtils.ZERO_INSETS;
                    this._topologyDiagramPanel.add((Component)this._mobilinkNode, this._mobilinkNodeGBC);
                }
            }
            if (this._qanywhereEnabled) {
                if (this._remServersEnabled && this._qanywhereNodeGBC.insets != insets2) {
                    this._qanywhereNodeGBC.insets = insets2;
                    this._topologyDiagramPanel.add((Component)this._qanywhereNode, this._qanywhereNodeGBC);
                } else if (this._qanywhereNodeGBC.insets != DBDiagramUtils.ZERO_INSETS) {
                    this._qanywhereNodeGBC.insets = DBDiagramUtils.ZERO_INSETS;
                    this._topologyDiagramPanel.add((Component)this._qanywhereNode, this._qanywhereNodeGBC);
                }
            }
            this.validate();
            this._topologyDiagramPanel.repaint();
            this.updateDividerLocation();
            this._topologyNeedsUpdate = false;
        }
        if (bl) {
            if (this._stateInfoToRestore != null) {
                this.restoreStateInfo();
            }
            this.stopRefreshAll();
        }
        this.enableTopologyNodes();
    }

    private void enableTopologyNodes() {
        if (this._arbiterNode != null) {
            this._arbiterNode.setEnabled(this._mirroringEnabled);
        }
        if (this._mirrorNode != null) {
            this._mirrorNode.setEnabled(this._mirroringEnabled);
        }
        if (this._mobilinkNode != null) {
            this._mobilinkNode.setEnabled(this._mobilinkEnabled);
        }
        if (this._qanywhereNode != null) {
            this._qanywhereNode.setEnabled(this._qanywhereEnabled);
        }
        if (this._remServersNode != null) {
            this._remServersNode.setEnabled(this._remServersEnabled);
        }
        if (this._sqlRemoteNode != null) {
            this._sqlRemoteNode.setEnabled(this._sqlRemoteEnabled);
        }
    }

    private void refreshUsers() {
        String[] stringArray = null;
        if (this._isStopped) {
            return;
        }
        this.clearUsers();
        try {
            int n;
            Object[][] objectArray = this._client.executeSQL(this, "SELECT COUNT(*) FROM sa_conn_info()");
            if (objectArray == null || objectArray.length < 1 || objectArray[0].length < 1 || objectArray[0][0] == null) {
                this._userCountLabel.setText(_unknownValueStr);
            } else {
                this._userCountLabel.setText(String.valueOf(objectArray[0][0]));
            }
            objectArray = this._client.executeSQL(this, "SELECT Userid, t1.Number, CAST ( Value AS DATETIME ) FROM sa_conn_info() t1 INNER JOIN sa_conn_properties() t2 ON t1.Number = t2.Number WHERE PropName = 'LastReqTime' AND Value <> '' ORDER BY Value");
            if (objectArray == null) {
                this._transTimesLabel.setText(bundle.getString("NO_TRANSACTION_TIMES"));
            } else {
                for (n = 0; n < objectArray.length && n < 5; ++n) {
                    stringArray = new String[3];
                    stringArray[0] = objectArray[n][0].toString();
                    stringArray[1] = objectArray[n][1].toString();
                    if (objectArray[n][2] instanceof Timestamp) {
                        long l = ((Timestamp)objectArray[n][2]).getTime();
                        long l2 = System.currentTimeMillis();
                        long l3 = (l2 - l) / 1000L;
                        stringArray[2] = Long.toString(l3);
                    } else {
                        stringArray[2] = bundle.getString("ERROR_GETTING_VALUE");
                    }
                    this._transTimesTableModel.add(stringArray, false);
                }
                this.resizeTable(this._transTimesTable, Integer.MAX_VALUE);
                this._transTimesLabel.setText(bundle.getFormatted("TRANSACTION_TIMES", Integer.toString(5)));
                this._transTimesScrollPane.setVisible(true);
            }
            objectArray = this._client.executeSQL(this, "SELECT B.Userid, B.Number, (SELECT A.Userid FROM sa_conn_info() A WHERE A.Number = B.BlockedOn) FROM sa_conn_info() B WHERE B.BlockedOn <> 0");
            if (objectArray == null) {
                this._blockedConnCountLabel.setText("0");
            } else {
                String string = Integer.toString(objectArray.length);
                this._blockedConnCountLabel.setText(string);
                this._atLeastOneWarning = true;
                this._usersPanel.addWarning(bundle.getFormatted("BLOCKED_CONNS_WARNING", string));
                this.showWarningHack(this._blockedConnCountDesc, this._blockedConnCountLabel);
                ClientNotifier clientNotifier = new ClientNotifier(this._client, this, 6, "", null);
                this._clientNotifiers.add(clientNotifier);
                this._blockedConnsClickPanel.addActionListener(clientNotifier);
                this._blockedConnsClickPanel.setEnabled(true);
                this._blockedConnsClickPanel.setShowBorder(true);
                for (n = 0; n < objectArray.length; ++n) {
                    stringArray = new String[]{objectArray[n][0].toString(), objectArray[n][1].toString(), objectArray[n][2].toString()};
                    this._blockedConnsTableModel.add(stringArray, false);
                }
                this.resizeTable(this._blockedConnsTable, 5);
                this._blockedConnsScrollPane.setVisible(true);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DBDiagramPanel.this.refreshMirroring();
                }
            });
        }
        catch (SQLException sQLException) {
            this.handleSQLException(sQLException, false);
            this.stopRefreshAll();
        }
    }

    private void resizeTable(JTable jTable, int n) {
        int n2 = jTable.getRowCount();
        int n3 = jTable.getRowHeight();
        int n4 = n2 > n ? n3 * n + n3 / 2 : n3 * n2;
        jTable.setPreferredScrollableViewportSize(new Dimension(300, n4));
    }

    private void restoreStateInfo() {
        this._statisticsPanel.setCollapsed(this._stateInfoToRestore.wasStatisticsPanelCollapsed);
        this._dbspacesPanel.setCollapsed(this._stateInfoToRestore.wasDbspacesPanelCollapsed);
        if (this._logsPanel != null) {
            this._logsPanel.setCollapsed(this._stateInfoToRestore.wasLogsPanelCollapsed);
        }
        this._usersPanel.setCollapsed(this._stateInfoToRestore.wasUsersPanelCollapsed);
        if (this._mirroringPanel != null) {
            this._mirroringPanel.setCollapsed(this._stateInfoToRestore.wasMirroringPanelCollapsed);
        }
        if (this._remServersPanel != null) {
            this._remServersPanel.setCollapsed(this._stateInfoToRestore.wasRemServersPanelCollapsed);
        }
        if (this._mlServerPanel != null) {
            this._mlServerPanel.setCollapsed(this._stateInfoToRestore.wasMLServerPanelCollapsed);
        }
        if (this._sqlRemotePanel != null) {
            this._sqlRemotePanel.setCollapsed(this._stateInfoToRestore.wasSQLRemotePanelCollapsed);
        }
        if (this._mlServerPanel != null && this._stateInfoToRestore.wasMLServerRefreshed && !this._mlServerRefreshStarted) {
            this._mlServerRefreshStarted = true;
            try {
                this.refreshMLServer(this._stateInfoToRestore.tableOwnersHM, this._stateInfoToRestore.resultsHM);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this._splitPane.setDividerLocation(this._stateInfoToRestore.splitPaneDividerLocation);
        this.validate();
        if (this._detailsScrollPane.getHorizontalScrollBar().isVisible()) {
            this._detailsScrollPane.getHorizontalScrollBar().setValue(this._stateInfoToRestore.detailsHSBValue);
        }
        if (this._detailsScrollPane.getVerticalScrollBar().isVisible()) {
            this._detailsScrollPane.getVerticalScrollBar().setValue(this._stateInfoToRestore.detailsVSBValue);
        }
        if (this._leftScrollPane.getVerticalScrollBar().isVisible()) {
            this._leftScrollPane.getVerticalScrollBar().setValue(this._stateInfoToRestore.leftVSBValue);
        }
        this._stateInfoToRestore.releaseResources();
        this._stateInfoToRestore = null;
    }

    private void scrollToCollapsiblePanel(DBDiagramCollapsiblePanel dBDiagramCollapsiblePanel) {
        Rectangle rectangle = new Rectangle();
        this._detailsScrollPane.validate();
        dBDiagramCollapsiblePanel.getBounds(rectangle);
        this._collapsiblePanelsPanel.scrollRectToVisible(rectangle);
    }

    private void setShowWarningAtTop(boolean bl) {
        if (bl) {
            this._detailsLabel.setIcon(_redLightIcon);
        } else {
            this._detailsLabel.setIcon(_greenLightIcon);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showStaticInfo() throws SQLException {
        String[][] stringArray = new String[][]{{"DB_PROPERTY", "Name", "N"}, {"DB_PROPERTY", "AlternateServerName", "Y"}, {"DB_PROPERTY", "PageSize", "Y"}, {"PROPERTY", "ProductVersion", "N"}, {"PROPERTY", "PlatformVer", "N"}, {"PROPERTY", "MachineName", "N"}, {"CONNECTION_PROPERTY", "ServerPort", "N"}, {"PROPERTY", "MaxConnections", "N"}, {"DB_PROPERTY", "File", "Y"}, {"DB_PROPERTY", "LogName", "Y"}, {"DB_PROPERTY", "LogMirrorName", "Y"}, {"DB_PROPERTY", "ArbiterState", "Y"}};
        try {
            String string;
            String[] stringArray2 = this.getProperties(stringArray);
            this._dbName = stringArray2[0];
            this._dbNameLabel.setText(this._dbName);
            this._dbNameLabel.setToolTipText(this._dbName);
            this.createDatabaseNode(this._dbName);
            this._dbNode.boldFont();
            this._dbNode.increaseFontSize(1.0f);
            Iterator iterator = _stateInfoList.iterator();
            while (iterator.hasNext()) {
                StateInfo stateInfo = (StateInfo)iterator.next();
                if (!stateInfo.dbName.equals(this._dbName)) continue;
                this._stateInfoToRestore = stateInfo;
                iterator.remove();
                break;
            }
            if ((string = stringArray2[1]) != null) {
                this._alternateNameDesc.setVisible(true);
                this._alternateNameLabel.setVisible(true);
                this._alternateNameLabel.setText(string.toString());
                this._alternateNameLabel.setToolTipText(string.toString());
            }
            if ((string = stringArray2[2]) == null) {
                this._pageSizeLabel.setText("");
            } else {
                try {
                    long l = Integer.parseInt(string.toString());
                    this._pageSizeLabel.setText(DBDiagramPanel.formatFreeSpace(l));
                }
                catch (NumberFormatException numberFormatException) {
                    this._pageSizeLabel.setText("");
                }
            }
            this._versionLabel.setText(stringArray2[3]);
            String string2 = stringArray2[4];
            this._platformLabel.setText(string2);
            this._platformLabel.setToolTipText(string2);
            string2 = stringArray2[5];
            this._hostNameLabel.setText(string2);
            this._hostNameLabel.setToolTipText(string2);
            string2 = stringArray2[6];
            if (string2.equals("0")) {
                this._portLabel.setText(bundle.getString("NOT_TCPIP_CONNECTION"));
            } else {
                this._portLabel.setText(string2);
            }
            string2 = this.getWebServerPort();
            if (string2 != null) {
                this._webPortLabel.setText(string2);
            } else {
                this._webPortLabel.setText(bundle.getString("NOT_WEB_SERVER"));
            }
            this._maxConnsLabel.setText(stringArray2[7]);
            string = stringArray2[8];
            if (string != null) {
                int n = string.toString().lastIndexOf(92);
                if (n == -1) {
                    n = string.toString().lastIndexOf(47);
                }
                this._mainDirectory = n == -1 ? "" : string.toString().substring(0, n + 1);
            }
            if ((string = stringArray2[9]) != null) {
                if (this._logsPanel == null) {
                    this.createLogsPanel();
                }
                this._logEnabled = true;
                string2 = string.toString();
                this._logFileLabel.setText(string2);
                this._logFileLabel.setToolTipText(string2);
                string = stringArray2[10];
                if (string == null) {
                    this._mirrorLogDesc.setText(bundle.getString("NO_MIRROR_LOG"));
                    this._mirrorLogFileDesc.setVisible(false);
                    this._mirrorLogFileLabel.setVisible(false);
                    this._mirrorLogSpaceDesc.setVisible(false);
                    this._mirrorLogSpaceClickPanel.setVisible(false);
                } else {
                    this._mirrorLogEnabled = true;
                    string2 = string.toString();
                    this._mirrorLogFileLabel.setText(string2);
                    this._mirrorLogFileLabel.setToolTipText(string2);
                }
            }
            if ((string = stringArray2[11]) != null) {
                if (this._mirroringPanel == null) {
                    this.createMirroringPanel();
                    this._topologyNeedsUpdate = true;
                }
                this._mirroringEnabled = true;
                this.showStaticMirroringInfo();
            }
            this._staticInfoShown = true;
        }
        finally {
            this.updateDividerLocation();
        }
    }

    private String getWebServerPort() throws SQLException {
        StringBuilder stringBuilder = null;
        Object object = this.getProperty("PROPERTY", "CommandLine");
        if (object == null) {
            return null;
        }
        String string = object.toString();
        String[] stringArray = CommandLineParser.split((String)string);
        for (int i = 0; i < stringArray.length - 1; ++i) {
            if (!stringArray[i].equalsIgnoreCase("-xs")) continue;
            int n = stringArray[i + 1].toLowerCase().indexOf("port");
            if (n > -1) {
                n = stringArray[i + 1].toLowerCase().indexOf("=", n);
                if (n <= -1) break;
                stringBuilder = new StringBuilder();
                for (int j = n; j < stringArray[i + 1].length(); ++j) {
                    if (stringArray[i + 1].charAt(j) == '0' || stringArray[i + 1].charAt(j) == '1' || stringArray[i + 1].charAt(j) == '2' || stringArray[i + 1].charAt(j) == '3' || stringArray[i + 1].charAt(j) == '4' || stringArray[i + 1].charAt(j) == '5' || stringArray[i + 1].charAt(j) == '6' || stringArray[i + 1].charAt(j) == '7' || stringArray[i + 1].charAt(j) == '8' || stringArray[i + 1].charAt(j) == '9') {
                        stringBuilder.append(stringArray[i + 1].charAt(j));
                        continue;
                    }
                    if (stringBuilder.length() <= 0) continue;
                    return stringBuilder.toString();
                }
                break;
            }
            if (stringArray[i + 1].toLowerCase().indexOf("https") > -1) {
                return "443";
            }
            if (stringArray[i + 1].toLowerCase().indexOf("http") <= -1) break;
            return "80";
        }
        return null;
    }

    private void showStaticMirroringInfo() throws SQLException {
        String string;
        int n;
        String[] stringArray = null;
        Object object = this.getProperty("PROPERTY", "CommandLine");
        if (object == null) {
            return;
        }
        String string2 = object.toString();
        String[] stringArray2 = CommandLineParser.split((String)string2);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        for (n = 0; n < stringArray2.length - 1; ++n) {
            if (!bl3 && stringArray2[n].equalsIgnoreCase("-n")) {
                string = stringArray2[n + 1];
                this._primaryNameLabel.setText(string);
                this._primaryNameLabel.setToolTipText(string);
                bl3 = true;
                ++n;
            } else if (!bl4 && stringArray2[n].equalsIgnoreCase("-xf")) {
                string = stringArray2[n + 1];
                this._stateFile = new File(string);
                if (!this._stateFile.isAbsolute()) {
                    this._stateFile = new File(this._mainDirectory + string);
                }
                this._primaryStateFileLabel.setText(string);
                this._primaryStateFileLabel.setToolTipText(string);
                bl4 = true;
                ++n;
            } else if (!bl5 && stringArray2[n].equalsIgnoreCase("-xp")) {
                stringArray = DBDiagramUtils.splitMirroringOptions(stringArray2[n + 1]);
                bl5 = true;
                ++n;
            }
            if (bl3 & bl4 & bl5) break;
        }
        if (bl5) {
            block1: for (n = 0; n < stringArray.length; ++n) {
                int n2;
                ProtocolOption protocolOption = CommandLineParser.parseComlinks((int)0, (String)stringArray[n]);
                string = protocolOption.getProtocolName();
                if (string.matches("partner.?")) {
                    for (n2 = 0; n2 < protocolOption.getParameterCount(); ++n2) {
                        string = protocolOption.getParameterName(n2);
                        if (!string.equalsIgnoreCase("ENG")) continue;
                        string = protocolOption.getParameterValue(n2);
                        this._mirrorNameLabel.setText(string);
                        this._mirrorNameLabel.setToolTipText(string);
                        this._mirrorNode.setLine2Text(string);
                        bl2 = true;
                        this._mirroringLabel.setText(bundle.getFormatted("MIRRORING_INTRO", this._dbName, string));
                        continue block1;
                    }
                    continue;
                }
                if (!string.matches("arbiter.?")) continue;
                for (n2 = 0; n2 < protocolOption.getParameterCount(); ++n2) {
                    string = protocolOption.getParameterName(n2);
                    if (!string.equalsIgnoreCase("ENG")) continue;
                    string = protocolOption.getParameterValue(n2);
                    this._arbiterNameLabel.setText(string);
                    this._arbiterNameLabel.setToolTipText(string);
                    this._arbiterNode.setLine2Text(string);
                    bl = true;
                    continue block1;
                }
            }
            if (!bl) {
                this._arbiterNode.setLine2Text(bundle.getString("ERROR_GETTING_VALUE"));
            }
            if (!bl2) {
                this._mirrorNode.setLine2Text(bundle.getString("ERROR_GETTING_VALUE"));
            }
        }
        this.enableTopologyNodes();
    }

    void showItemNotFoundDialog(int n, String string) {
        switch (n) {
            case 7: {
                SybOptionPane.showMessageDialog((Component)this, (Object)bundle.getFormatted("REMOTE_SERVER_NOT_FOUND_DIALOG", string));
                break;
            }
            case 3: {
                SybOptionPane.showMessageDialog((Component)this, (Object)bundle.getFormatted("DBSPACE_NOT_FOUND_DIALOG", string));
                break;
            }
        }
    }

    void showItemDialog(int n, String string, String[] stringArray) {
        switch (n) {
            case 2: {
                SybOptionPane.showMessageDialog((Component)this, (Object)(bundle.getFormatted("LOW_DBSPACE_SPACE_DIALOG", string) + bundle.getFormatted("LOW_SPACE_DIALOG_ONE", stringArray[0], stringArray[1]) + bundle.getFormatted("LOW_SPACE_DIALOG_TWO", stringArray[2])));
                break;
            }
            case 4: {
                SybOptionPane.showMessageDialog((Component)this, (Object)(bundle.getFormatted("LOW_LOG_SPACE_DIALOG", string) + bundle.getFormatted("LOW_SPACE_DIALOG_ONE", stringArray[0], stringArray[1]) + bundle.getFormatted("LOW_SPACE_DIALOG_TWO", stringArray[2])));
                break;
            }
            case 5: {
                SybOptionPane.showMessageDialog((Component)this, (Object)(bundle.getFormatted("LOW_MIRROR_SPACE_DIALOG", string) + bundle.getFormatted("LOW_SPACE_DIALOG_ONE", stringArray[0], stringArray[1]) + bundle.getFormatted("LOW_SPACE_DIALOG_TWO", stringArray[2])));
                break;
            }
            case 8: {
                SybOptionPane.showMessageDialog((Component)this, (Object)bundle.getString("ARBITER_DISCONNECTED_DIALOG"));
                break;
            }
            case 9: {
                SybOptionPane.showMessageDialog((Component)this, (Object)bundle.getString("MIRROR_DISCONNECTED_DIALOG"));
                break;
            }
        }
    }

    private void showWarningHack(JLabel jLabel, JLabel jLabel2) {
        EmptyBorder emptyBorder = new EmptyBorder(2, 2, 2, 0);
        EmptyBorder emptyBorder2 = new EmptyBorder(2, 0, 2, 2);
        jLabel.setBorder(emptyBorder);
        jLabel.setCursor(DBDiagramUtils.getHandCursor());
        DBDiagramUtils.showWarning(jLabel);
        jLabel2.setBorder(emptyBorder2);
        jLabel2.setCursor(DBDiagramUtils.getHandCursor());
        DBDiagramUtils.showWarningFont(jLabel2);
    }

    private boolean startRefresh() {
        if (this._isRefreshing || this._isStopped || this._resourcesReleased) {
            return false;
        }
        this._isRefreshing = true;
        if (this._refreshMLServerButton != null) {
            this._refreshMLServerButton.setEnabled(false);
        }
        this._refreshingLabel.setText(bundle.getString("REFRESH_IN_PROGRESS"));
        this.setCursor(Cursor.getPredefinedCursor(3));
        return true;
    }

    private void stopRefresh() {
        this.setCursor(null);
        this._refreshingLabel.setText(bundle.getFormatted("LAST_UPDATED", _dateParser.format(new Date())));
        if (this._refreshMLServerButton != null) {
            this._refreshMLServerButton.setEnabled(true);
        }
        try {
            this._client.commitConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this._isRefreshing = false;
    }

    private void refreshAll() {
        if (!this.startRefresh()) {
            return;
        }
        this._statisticsCleared = false;
        this._dbspacesCleared = false;
        this._logsCleared = false;
        this._usersCleared = false;
        this._mirroringCleared = false;
        this._remServersCleared = false;
        this._sqlRemoteCleared = false;
        try {
            if (!this._staticInfoShown) {
                this.showStaticInfo();
            }
            this.refreshDynamicInfo();
        }
        catch (SQLException sQLException) {
            this.handleSQLException(sQLException, true);
            this.stopRefreshAll();
        }
    }

    private void stopRefreshAll() {
        if (this._resourcesReleased) {
            return;
        }
        if (!this._statisticsCleared) {
            this.clearStatistics();
        }
        if (!this._dbspacesCleared) {
            this.clearDbspaces();
        }
        if (!this._logsCleared && this._logEnabled) {
            this.clearLogs();
        }
        if (!this._usersCleared) {
            this.clearUsers();
        }
        if (!this._mirroringCleared && this._mirroringEnabled) {
            this.clearMirroring();
        }
        if (!this._remServersCleared) {
            this.clearRemServers();
        }
        if (!this._sqlRemoteCleared) {
            this.clearSQLRemote();
        }
        if (this._atLeastOneWarning) {
            this.setShowWarningAtTop(true);
        }
        if (this._topologyNeedsUpdate) {
            this.updateDividerLocation();
        }
        this.stopRefresh();
    }

    private void topologyNodeClicked(ActionEvent actionEvent) {
        if (this._arbiterNode != null && this._arbiterNode.isActionSource(actionEvent)) {
            if (this._mirroringEnabled) {
                this._mirroringPanel.toggleCollapsedState();
            } else {
                this._client.showHelp(this, 101);
            }
        } else if (this._mirrorNode != null && this._mirrorNode.isActionSource(actionEvent)) {
            if (this._mirroringEnabled) {
                this._mirroringPanel.toggleCollapsedState();
            } else {
                this._client.showHelp(this, 102);
            }
        } else if (this._mobilinkNode != null && this._mobilinkNode.isActionSource(actionEvent)) {
            if (this._mobilinkEnabled) {
                this._mlServerPanel.toggleCollapsedState();
            } else {
                this._client.showHelp(this, 103);
            }
        } else if (this._qanywhereNode != null && this._qanywhereNode.isActionSource(actionEvent)) {
            if (this._qanywhereEnabled) {
                this._mlServerPanel.toggleCollapsedState();
            } else {
                this._client.showHelp(this, 104);
            }
        } else if (this._remServersNode != null && this._remServersNode.isActionSource(actionEvent)) {
            if (this._remServersEnabled) {
                this._remServersPanel.toggleCollapsedState();
            } else {
                this._client.showHelp(this, 105);
            }
        } else if (this._sqlRemoteNode != null && this._sqlRemoteNode.isActionSource(actionEvent)) {
            if (this._sqlRemoteEnabled) {
                this._sqlRemotePanel.toggleCollapsedState();
            } else {
                this._client.showHelp(this, 106);
            }
        }
    }

    private void updateDividerLocation() {
        this._leftScrollPane.setMinimumSize(this._leftScrollPane.getPreferredSize());
        this._splitPane.resetToPreferredSizes();
    }

    public void cancelPrint() {
        if (this._printJobThread != null) {
            this._printJobThread.cancel();
            this.releasePrintingPanel();
        }
    }

    public boolean isPrinting() {
        return this._printJobThread != null && this._printJobThread.isBusy();
    }

    void preparePrintingPanel(Graphics graphics) {
        this._printingTextMetrics = graphics.getFontMetrics(_printingTextFont);
        this._printingTitleMetrics = graphics.getFontMetrics(_printingTitleFont);
        this._printingHeaderMetrics = graphics.getFontMetrics(_printingHeaderFont);
        this._printingWarningMetrics = graphics.getFontMetrics(_printingWarningFont);
        this._printingPanel = new PrintingPaginatedPanel();
        int n = 0;
        PrintingPanel printingPanel = new PrintingPanel();
        PrintingLabel printingLabel = this.createPrintingLabel(this._panelTitle, 5);
        int n2 = printingLabel.getHeight() + 20;
        int n3 = 6;
        int n4 = n2 + 1 + 5;
        PrintingPanel printingPanel2 = this.createStaticInfoPrintPanel(graphics, 360);
        printingPanel2.setLocation(n3, n4);
        printingPanel.add(printingPanel2);
        n += ((PrintingComponent)printingPanel2).getWidth();
        PrintingPanel printingPanel3 = this.createFeaturesPrintPanel();
        n += ((PrintingComponent)printingPanel3).getWidth();
        n += 3;
        n += 20;
        n = Math.max(n, 800);
        n3 = n - 1 - 5;
        printingPanel3.setLocation(n3 -= ((PrintingComponent)printingPanel3).getWidth(), n4);
        printingPanel.add(printingPanel3);
        printingLabel.setX((n - printingLabel.getWidth()) / 2);
        printingPanel.add(printingLabel);
        n4 = printingPanel.getHeight();
        PrintingComponent printingComponent = new PrintingLine(0, n2, n - 1, n2);
        printingPanel.add(printingComponent);
        printingComponent = new PrintingLine(0, n2, 0, n4 += 6);
        printingPanel.add(printingComponent);
        printingComponent = new PrintingLine(n - 1, n2, n - 1, n4);
        printingPanel.add(printingComponent);
        printingComponent = new PrintingLine(0, n4, n - 1, n4);
        printingPanel.add(printingComponent);
        n3 -= 5;
        printingComponent = new PrintingLine(--n3, n2, n3, n4);
        printingPanel.add(printingComponent);
        this._printingPanel.add(printingPanel);
        n2 = n4;
        printingComponent = new PrintingJCWrapper(this._detailsLabel);
        printingComponent.setY(n2 += 20);
        this._printingPanel.add(printingComponent);
        n2 += this._detailsLabel.getHeight();
        printingComponent = this.createStatisticsPrintPanel(graphics, n);
        printingComponent.setY(n2 += 20);
        this._printingPanel.add(printingComponent);
        n2 += printingComponent.getHeight();
        printingComponent = this.createDbspacesPrintPanel(graphics, n);
        printingComponent.setY(n2 += 20);
        this._printingPanel.add(printingComponent);
        if (this._logEnabled) {
            n2 += printingComponent.getHeight();
            printingComponent = this.createLogsPrintPanel(graphics, n);
            printingComponent.setY(n2 += 20);
            this._printingPanel.add(printingComponent);
        }
        n2 += printingComponent.getHeight();
        printingComponent = this.createUsersPrintPanel(graphics, n);
        printingComponent.setY(n2 += 20);
        this._printingPanel.add(printingComponent);
        if (this._mirroringEnabled) {
            n2 += printingComponent.getHeight();
            printingComponent = this.createMirroringPrintPanel(graphics, n);
            printingComponent.setY(n2 += 20);
            this._printingPanel.add(printingComponent);
        }
        if (this._remServersEnabled) {
            n2 += printingComponent.getHeight();
            printingComponent = this.createRemServersPrintPanel(graphics, n);
            printingComponent.setY(n2 += 20);
            this._printingPanel.add(printingComponent);
        }
        if (this._mlServerPanel != null && this._mlServerPanel.isVisible()) {
            n2 += printingComponent.getHeight();
            printingComponent = this.createMLServerPrintPanel(graphics, n);
            printingComponent.setY(n2 += 20);
            this._printingPanel.add(printingComponent);
        }
        if (this._sqlRemoteEnabled) {
            n2 += printingComponent.getHeight();
            printingComponent = this.createSQLRemotePrintPanel(graphics, n);
            printingComponent.setY(n2 += 20);
            this._printingPanel.add(printingComponent);
        }
    }

    void releasePrintingPanel() {
        if (this._printingPanel != null) {
            this._printingPanel.releaseResources();
            this._printingPanel = null;
        }
        this._printingTextMetrics = null;
        this._printingTitleMetrics = null;
        this._printingHeaderMetrics = null;
        this._printingWarningMetrics = null;
    }

    double getScaleToFitPage(double d, double d2, boolean bl) {
        if (bl) {
            double d3 = d / (double)this._printingPanel.getWidth();
            double d4 = d2 / (double)this._printingPanel.getHeight();
            return Math.min(d3, d4);
        }
        double d5 = d / (double)this._printingPanel.getWidth();
        if (d5 * (double)this._printingPanel.getMinPageHeight() > d2) {
            d5 = d2 / (double)this._printingPanel.getMinPageHeight();
        }
        return d5;
    }

    int getPageCount() {
        return this._printingPanel.getPageCount();
    }

    void paginate(int n) {
        this._printingPanel.paginate(n - 2);
    }

    void printSinglePage(Graphics graphics) {
        this._printingPanel.print(graphics);
    }

    void printPage(Graphics graphics, int n) {
        graphics.translate(0, -this._printingPanel.getPageStart(n));
        this._printingPanel.printPage(graphics, n);
    }

    public void print(JDialog jDialog, String string, PrintJobListener printJobListener) {
        this.print((Window)jDialog, string, printJobListener);
    }

    public void print(JFrame jFrame, String string, PrintJobListener printJobListener) {
        this.print((Window)jFrame, string, printJobListener);
    }

    private void print(Window window, String string, PrintJobListener printJobListener) {
        PrintDialog printDialog = null;
        if (this._printJobThread != null) {
            while (this._printJobThread.isBusy()) {
                try {
                    this.wait(5L);
                }
                catch (Exception exception) {
                    // empty catch block
                    break;
                }
            }
        }
        PrinterJob printerJob = PrinterJob.getPrinterJob();
        PageFormat pageFormat = printerJob.defaultPage();
        this._printJobListener = printJobListener;
        printDialog = window instanceof JDialog ? new PrintDialog((Dialog)((JDialog)window)) : new PrintDialog((Frame)((JFrame)window));
        if (printDialog.showDialog(2, printerJob, pageFormat)) {
            this._fitToPage = printDialog.getScaleToFit();
            this._printJobThread = new PrintJobThread((Printable)this, printerJob, pageFormat, printJobListener);
            this._printJobThread.start();
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int n) {
        int n2 = (int)pageFormat.getImageableX() + 1;
        int n3 = (int)pageFormat.getImageableY() + 1;
        int n4 = (int)pageFormat.getImageableWidth() - 2;
        int n5 = (int)pageFormat.getImageableHeight() - 2;
        if (this._printingPanel == null) {
            this.preparePrintingPanel(graphics);
        }
        if (this._fitToPage) {
            double d;
            if (n >= 1) {
                this.releasePrintingPanel();
                return 1;
            }
            if (this._printJobListener != null) {
                this._printJobListener.printingPage(n + 1);
            }
            graphics.translate(n2, n3);
            if (graphics instanceof Graphics2D && (d = this.getScaleToFitPage(n4, n5, true)) < 1.0) {
                ((Graphics2D)graphics).scale(d, d);
            }
            this._printingPanel.print(graphics);
        } else {
            double d;
            if (!this._printingPanel.isPaginated()) {
                if (graphics instanceof Graphics2D) {
                    d = this.getScaleToFitPage(n4, n5, false);
                    d = Math.min(d, 1.0);
                } else {
                    d = 1.0;
                }
                this._printingPanel.paginate((int)((double)n5 / d));
            }
            if (n >= this._printingPanel.getPageCount()) {
                this.releasePrintingPanel();
                return 1;
            }
            if (this._printJobListener != null) {
                this._printJobListener.printingPage(n + 1);
            }
            graphics.translate(n2, n3);
            if (graphics instanceof Graphics2D && (d = this.getScaleToFitPage(n4, n5, false)) < 1.0) {
                ((Graphics2D)graphics).scale(d, d);
            }
            graphics.translate(0, -this._printingPanel.getPageStart(n));
            this._printingPanel.printPage(graphics, n);
        }
        return 0;
    }

    private PrintingLabel createPrintingLabel(String string) {
        return this.createPrintingLabel(string, 0);
    }

    private PrintingLabel createPrintingLabel(String string, int n) {
        Color color;
        FontMetrics fontMetrics;
        Font font;
        int n2 = 0;
        int n3 = 0;
        ImageIcon imageIcon = null;
        int n4 = 0;
        switch (n) {
            case 2: {
                font = _printingWarningFont;
                fontMetrics = this._printingWarningMetrics;
                color = _printingWarningColor;
                imageIcon = _printingWarningIcon;
                n4 = 5;
                n2 = _printingWarningHeight;
                break;
            }
            case 3: {
                font = _printingWarningFont;
                fontMetrics = this._printingWarningMetrics;
                color = _printingWarningColor;
                n2 = _printingWarningHeight;
                break;
            }
            case 4: {
                font = _printingTextFont;
                fontMetrics = this._printingTextMetrics;
                color = _printingTextColor;
                n2 = _printingWarningHeight;
                break;
            }
            case 1: {
                font = _printingHeaderFont;
                fontMetrics = this._printingHeaderMetrics;
                color = _printingTextColor;
                break;
            }
            case 5: {
                font = _printingTitleFont;
                fontMetrics = this._printingTitleMetrics;
                color = _printingTextColor;
                break;
            }
            default: {
                font = _printingTextFont;
                fontMetrics = this._printingTextMetrics;
                color = _printingTextColor;
            }
        }
        return new PrintingLabel(string, font, fontMetrics, color, imageIcon, n4, n3, n2);
    }

    private PrintingPanel createPrintingLabelsColumn(String[] stringArray, boolean[] blArray, PrintingLabelMetadata printingLabelMetadata) {
        PrintingPanel printingPanel = new PrintingPanel();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            PrintingLabel printingLabel = blArray != null && blArray[i] ? this.createPrintingLabel(stringArray[i], printingLabelMetadata.warningType) : this.createPrintingLabel(stringArray[i], 0);
            printingLabelMetadata.truncateLabel(printingLabel);
            printingLabel.setY(n);
            printingPanel.add(printingLabel);
            n += printingLabel.getHeight();
        }
        return printingPanel;
    }

    private PrintingPanel createPrintingLabelsColumn(String[] stringArray, boolean[] blArray, PrintingLabelMetadata[] printingLabelMetadataArray) {
        PrintingPanel printingPanel = new PrintingPanel();
        int n = 0;
        for (int i = 0; i < stringArray.length; ++i) {
            PrintingLabel printingLabel = blArray != null && blArray[i] ? this.createPrintingLabel(stringArray[i], printingLabelMetadataArray[i].warningType) : this.createPrintingLabel(stringArray[i], 0);
            printingLabelMetadataArray[i].truncateLabel(printingLabel);
            printingLabel.setY(n);
            printingPanel.add(printingLabel);
            n += printingLabel.getHeight();
        }
        return printingPanel;
    }

    private PrintingPanel createPrintingTable(JTable jTable, PrintingLabelMetadata[] printingLabelMetadataArray, int n) {
        int n2;
        int n3;
        int n4;
        PrintingPanel printingPanel = new PrintingPanel();
        StatisticsTableModel statisticsTableModel = (StatisticsTableModel)jTable.getModel();
        int n5 = jTable.getColumnCount();
        int n6 = jTable.getRowCount();
        int[] nArray = new int[n5];
        int[] nArray2 = new int[n5];
        PrintingLabel[] printingLabelArray = new PrintingLabel[n5];
        PrintingLabel[][] printingLabelArray2 = new PrintingLabel[n6][n5];
        boolean[] blArray = new boolean[n6];
        for (n4 = 0; n4 < n5; ++n4) {
            printingLabelArray[n4] = this.createPrintingLabel(jTable.getColumnName(n4), 1);
            nArray[n4] = printingLabelArray[n4].getWidth();
        }
        for (n3 = 0; n3 < n6; ++n3) {
            blArray[n3] = statisticsTableModel.displayWarningOnRow(jTable.convertRowIndexToModel(n3));
            for (n4 = 0; n4 < n5; ++n4) {
                printingLabelArray2[n3][n4] = blArray[n3] ? this.createPrintingLabel(jTable.getValueAt(n3, n4).toString(), printingLabelMetadataArray[n4].warningType) : this.createPrintingLabel(jTable.getValueAt(n3, n4).toString());
                nArray[n4] = Math.max(nArray[n4], printingLabelArray2[n3][n4].getWidth());
            }
        }
        int n7 = 1;
        int n8 = n7 += 7 * n5;
        for (n4 = 0; n4 < n5; ++n4) {
            n8 += nArray[n4];
        }
        if (n8 <= n) {
            for (n4 = 0; n4 < n5; ++n4) {
                nArray2[n4] = nArray[n4];
            }
            n2 = n8;
        } else {
            for (n4 = 0; n4 < n5; ++n4) {
                printingLabelMetadataArray[n4].truncateLabel(printingLabelArray[n4]);
                nArray2[n4] = printingLabelArray[n4].getWidth();
            }
            for (n3 = 0; n3 < n6; ++n3) {
                for (n4 = 0; n4 < n5; ++n4) {
                    printingLabelMetadataArray[n4].truncateLabel(printingLabelArray2[n3][n4]);
                    nArray2[n4] = Math.max(nArray2[n4], printingLabelArray2[n3][n4].getWidth());
                }
            }
            n2 = n7;
            for (n4 = 0; n4 < n5; ++n4) {
                n2 += nArray2[n4];
            }
            int n9 = n2 - n;
            if (n9 > 0) {
                int n10 = 0;
                for (n4 = 0; n4 < n5; ++n4) {
                    if (!printingLabelMetadataArray[n4].truncateToFit) continue;
                    ++n10;
                }
                int n11 = n9 % n10;
                int n12 = n11 == 0 ? n9 / n10 : (n9 + n10 - n11) / n10;
                for (n4 = 0; n4 < n5; ++n4) {
                    if (!printingLabelMetadataArray[n4].truncateToFit) continue;
                    int n13 = n4;
                    nArray2[n13] = nArray2[n13] - n12;
                    n2 -= n12;
                }
                for (n4 = 0; n4 < n5; ++n4) {
                    if (!printingLabelMetadataArray[n4].truncateToFit) continue;
                    for (n3 = 0; n3 < n6; ++n3) {
                        printingLabelMetadataArray[n4].truncateLabel(printingLabelArray2[n3][n4], nArray2[n4]);
                    }
                }
            }
        }
        PrintingLine printingLine = new PrintingLine(0, 0, n2 - 1, 0);
        printingPanel.add(printingLine);
        int n14 = 4;
        int n15 = 4;
        for (n4 = 0; n4 < n5; ++n4) {
            printingLabelArray[n4].setX(n14);
            printingLabelArray[n4].setY(n15);
            printingPanel.add(printingLabelArray[n4]);
            n14 += nArray2[n4];
            n14 += 7;
        }
        n15 += printingLabelArray[0].getHeight();
        printingLine = new PrintingLine(0, n15 += 3, n2 - 1, n15);
        printingPanel.add(printingLine);
        ++n15;
        for (n3 = 0; n3 < n6; ++n3) {
            n14 = 4;
            n15 += 3;
            int n16 = 0;
            for (n4 = 0; n4 < n5; ++n4) {
                printingLabelArray2[n3][n4].setX(n14);
                printingLabelArray2[n3][n4].setY(n15);
                printingPanel.add(printingLabelArray2[n3][n4]);
                n14 += nArray2[n4];
                n14 += 7;
                n16 = Math.max(n16, printingLabelArray2[n3][n4].getHeight());
            }
            printingLine = new PrintingLine(0, n15 += n16 + 3, n2 - 1, n15);
            printingPanel.add(printingLine);
            ++n15;
        }
        n14 = 0;
        for (n4 = 0; n4 < n5; ++n4) {
            printingLine = new PrintingLine(n14, 0, n14, n15 - 1);
            printingPanel.add(printingLine);
            n14 += 7 + nArray2[n4];
        }
        printingLine = new PrintingLine(n14, 0, n14, n15 - 1);
        printingPanel.add(printingLine);
        return printingPanel;
    }

    private class TopologyPanel
    extends JPanel {
        private static final float NE_NW_LINE_Y = 0.0f;
        private static final float E_W_LINE_Y = 0.375f;
        private static final float SE_SW_LINE_Y = 0.75f;
        private static final int HORI_GAP = 5;
        private static final int DB_HORI_GAP = 5;

        private TopologyPanel() {
        }

        @Override
        public void paint(Graphics graphics) {
            int n;
            Rectangle rectangle;
            if (DBDiagramPanel.this._dbNode == null) {
                return;
            }
            Rectangle rectangle2 = DBDiagramPanel.this._dbNode.getIconBounds();
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.addRenderingHints(new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON));
            if (!DBDiagramPanel.this._mirroringEnabled) {
                graphics.setColor(Color.lightGray);
            } else {
                graphics.setColor(Color.black);
            }
            if (DBDiagramPanel.this._arbiterNode != null && DBDiagramPanel.this._mirrorNode != null) {
                rectangle = DBDiagramPanel.this._arbiterNode.getIconBounds();
                graphics.drawLine(rectangle2.x - 5, rectangle2.y + (int)((float)rectangle2.height * 0.0f), rectangle.x + rectangle.width + 5, rectangle.y + (int)((float)rectangle.height * 0.75f));
                rectangle = DBDiagramPanel.this._mirrorNode.getIconBounds();
                graphics.drawLine(rectangle2.x - 5, rectangle2.y + (int)((float)rectangle2.height * 0.75f), rectangle.x + rectangle.width + 5, rectangle.y + (int)((float)rectangle.height * 0.0f));
                n = rectangle.x + rectangle.width / 2;
                graphics.drawLine(n, DBDiagramPanel.this._arbiterNode.getY() + DBDiagramPanel.this._arbiterNode.getHeight(), n, rectangle.y - 3);
            }
            if (!DBDiagramPanel.this._mobilinkEnabled) {
                graphics.setColor(Color.lightGray);
            } else {
                graphics.setColor(Color.black);
            }
            if (DBDiagramPanel.this._mobilinkNode != null) {
                rectangle = DBDiagramPanel.this._mobilinkNode.getIconBounds();
                graphics.drawLine(rectangle2.x + rectangle2.width + 5, rectangle2.y + (int)((float)rectangle2.height * 0.0f), rectangle.x - 5, rectangle.y + (int)((float)rectangle.height * 0.75f));
            }
            if (!DBDiagramPanel.this._qanywhereEnabled) {
                graphics.setColor(Color.lightGray);
            } else {
                graphics.setColor(Color.black);
            }
            if (DBDiagramPanel.this._qanywhereNode != null) {
                rectangle = DBDiagramPanel.this._qanywhereNode.getIconBounds();
                int n2 = rectangle2.y + (int)((float)rectangle2.height * 0.375f);
                graphics.drawLine(rectangle2.x + rectangle2.width + 5, n2, rectangle.x - 5, n2);
            }
            if (!DBDiagramPanel.this._remServersEnabled) {
                graphics.setColor(Color.lightGray);
            } else {
                graphics.setColor(Color.black);
            }
            if (DBDiagramPanel.this._remServersNode != null) {
                rectangle = DBDiagramPanel.this._remServersNode.getIconBounds();
                graphics.drawLine(rectangle2.x + rectangle2.width + 5, rectangle2.y + (int)((float)rectangle2.height * 0.75f), rectangle.x - 5, rectangle.y + (int)((float)rectangle.height * 0.0f));
            }
            if (!DBDiagramPanel.this._sqlRemoteEnabled) {
                graphics.setColor(Color.lightGray);
            } else {
                graphics.setColor(Color.black);
            }
            if (DBDiagramPanel.this._sqlRemoteNode != null) {
                rectangle = DBDiagramPanel.this._sqlRemoteNode.getBounds();
                n = rectangle2.x + rectangle2.width / 2;
                graphics.drawLine(n, rectangle2.y + rectangle2.height + 3, n, rectangle.y);
            }
            super.paint(graphics);
        }
    }

    private class StateInfo {
        String dbName;
        boolean wasMLServerRefreshed = false;
        HashMap<String, String[]> tableOwnersHM = null;
        HashMap<String, Object[][]> resultsHM = null;
        boolean wasDbspacesPanelCollapsed = true;
        boolean wasLogsPanelCollapsed = true;
        boolean wasMLServerPanelCollapsed = true;
        boolean wasMirroringPanelCollapsed = true;
        boolean wasRemServersPanelCollapsed = true;
        boolean wasSQLRemotePanelCollapsed = true;
        boolean wasStatisticsPanelCollapsed = true;
        boolean wasUsersPanelCollapsed = true;
        int detailsHSBValue = 0;
        int detailsVSBValue = 0;
        int leftVSBValue = 0;
        int splitPaneDividerLocation = 0;

        StateInfo() {
        }

        void releaseResources() {
            this.dbName = null;
            this.tableOwnersHM = null;
            this.resultsHM = null;
        }
    }
}

