/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.dbdiagram;

import com.sybase.asa.common.ASAComponentsImageLoader;
import com.sybase.util.SybLabel;
import com.sybase.util.SybLimitedWidthLabel;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.UIManager;

class DBDiagramUtils {
    static final Insets ZERO_INSETS = new Insets(0, 0, 0, 0);
    static final Insets LEFT_INSETS = new Insets(0, 50, 0, 0);
    static final Dimension ZERO_SIZE = new Dimension(0, 0);
    static final Color WARNING_COLOR = Color.RED;
    static ImageIcon _warningIcon = null;
    private static Font _defaultFont = null;
    private static Color _defaultColor = null;
    private static Cursor _handCursor = null;
    private static boolean _isInitialized = false;

    DBDiagramUtils() {
    }

    static Font boldFont(Font font) {
        return font.deriveFont(font.getStyle() | 1);
    }

    static void boldLabelFont(JLabel jLabel) {
        Font font = jLabel.getFont();
        jLabel.setFont(font.deriveFont(font.getStyle() | 1));
    }

    static void clearWarning(JLabel jLabel) {
        DBDiagramUtils.clearWarning(jLabel, _defaultFont, _defaultColor);
    }

    static void clearWarning(JLabel jLabel, Font font, Color color) {
        jLabel.setFont(font);
        jLabel.setForeground(color);
        jLabel.setIcon(null);
    }

    static JLabel createJLabelForWarning() {
        return DBDiagramUtils.createJLabelForWarning("");
    }

    static JLabel createJLabelForWarning(String string) {
        return new JLabel(string, null, 10);
    }

    static JLabel createLimitedLabelForWarning(int n) {
        return new SybLimitedWidthLabel(n);
    }

    static SybLabel createSybLabelForWarning(String string) {
        return new SybLabel(string, null, 10);
    }

    static Cursor getHandCursor() {
        return _handCursor;
    }

    static Font increaseFontSize(Font font, float f) {
        return font.deriveFont(font.getStyle(), (float)font.getSize() + f);
    }

    static void increaseLabelFontSize(JLabel jLabel, float f) {
        Font font = jLabel.getFont();
        jLabel.setFont(font.deriveFont(font.getStyle(), (float)font.getSize() + f));
    }

    static void init() {
        if (!_isInitialized) {
            _defaultFont = UIManager.getFont("Label.font");
            _defaultColor = UIManager.getColor("Label.foreground");
            _warningIcon = ASAComponentsImageLoader.getImageIcon("warn", 1001);
            _handCursor = Cursor.getPredefinedCursor(12);
            _isInitialized = true;
        }
    }

    static void showWarning(JLabel jLabel) {
        DBDiagramUtils.showWarningFont(jLabel);
        jLabel.setIcon(_warningIcon);
    }

    static void showWarningFont(JLabel jLabel) {
        DBDiagramUtils.boldLabelFont(jLabel);
        jLabel.setForeground(WARNING_COLOR);
    }

    static String[] splitMirroringOptions(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == ';') {
                if (n == 0) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder.delete(0, stringBuilder.length());
                    continue;
                }
                stringBuilder.append(c);
                continue;
            }
            if (c == '(' || c == '{') {
                stringBuilder.append(c);
                ++n;
                continue;
            }
            if (c == ')' || c == '}') {
                stringBuilder.append(c);
                --n;
                continue;
            }
            stringBuilder.append(c);
        }
        if (stringBuilder.length() > 0) {
            arrayList.add(stringBuilder.toString());
        }
        String[] stringArray = new String[]{};
        return arrayList.toArray(stringArray);
    }
}

