/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.dbdiagram;

import com.sybase.dbdiagram.printing.PrintingLabel;
import com.sybase.util.UIUtils;
import java.awt.FontMetrics;
import javax.swing.SwingUtilities;

class PrintingLabelMetadata {
    static final int NORMAL_TRUNCATION = 0;
    static final int FILENAME_TRUNCATION = 1;
    int maxWidth = Integer.MAX_VALUE;
    int truncationType = 0;
    boolean truncateToFit = false;
    int warningType = 4;

    PrintingLabelMetadata() {
    }

    PrintingLabelMetadata(int n, boolean bl, int n2) {
        this.truncationType = n;
        this.truncateToFit = bl;
        this.warningType = n2;
    }

    PrintingLabelMetadata createCopy() {
        PrintingLabelMetadata printingLabelMetadata = new PrintingLabelMetadata();
        printingLabelMetadata.maxWidth = this.maxWidth;
        printingLabelMetadata.truncateToFit = this.truncateToFit;
        printingLabelMetadata.truncationType = this.truncationType;
        printingLabelMetadata.warningType = this.warningType;
        return printingLabelMetadata;
    }

    void truncateLabel(PrintingLabel printingLabel) {
        this.truncateLabel(printingLabel, this.maxWidth);
    }

    void truncateLabel(PrintingLabel printingLabel, int n) {
        if (printingLabel.getWidth() <= n) {
            return;
        }
        String string = printingLabel.getText();
        FontMetrics fontMetrics = printingLabel.getFontMetrics();
        int n2 = printingLabel.getWidth() - SwingUtilities.computeStringWidth(fontMetrics, string);
        switch (this.truncationType) {
            case 1: {
                string = UIUtils.shrinkPathnameToWidth((String)string, (FontMetrics)fontMetrics, (int)(n - n2));
                break;
            }
            default: {
                string = UIUtils.truncateString((String)string, (FontMetrics)fontMetrics, (int)(n - n2));
            }
        }
        printingLabel.setText(string);
    }
}

