/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.dbdiagram;

import com.sybase.dbdiagram.ClickablePanel;
import com.sybase.dbdiagram.DBDiagramPanel;
import com.sybase.dbdiagram.DBDiagramUtils;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;

class TopologyNode
extends JPanel {
    private static final int MAX_WIDTH = 132;
    private boolean _canShowWarning;
    private boolean _clickable;
    private Dimension _fixedDimensions;
    private boolean _warningShown = false;
    private boolean _enabled;
    private Icon _icon = null;
    private JLabel _iconLabel;
    private JLabel _line1Label = null;
    private String _line1Text;
    private JLabel _line2Label = null;
    private String _line2Text;
    private String _featureName;
    private JPanel _mainPanel = null;
    private ClickablePanel _clickablePanel = null;

    TopologyNode(String string, int n, Icon icon, int n2, boolean bl, boolean bl2, String string2) {
        this(string, n, null, 0, icon, n2, bl, bl2, string2);
    }

    TopologyNode(String string, int n, String string2, int n2, Icon icon, int n3, boolean bl, boolean bl2, String string3) {
        GridBagConstraints gridBagConstraints;
        this.setOpaque(false);
        this._enabled = true;
        this._canShowWarning = bl2;
        this._clickable = bl;
        this._icon = icon;
        this._line1Text = string;
        this._line2Text = string2;
        this._featureName = string3;
        if (bl) {
            this._clickablePanel = new ClickablePanel();
            this.setLayout(new GridBagLayout());
            gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 19, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
            this.add((Component)this._clickablePanel, gridBagConstraints);
            this._mainPanel = this._clickablePanel;
        } else {
            this._mainPanel = this;
        }
        this._iconLabel = new JLabel(this._icon);
        gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 19, 0, new Insets(0, 0, n3, 0), 0, 0);
        this._mainPanel.setLayout(new GridBagLayout());
        this._mainPanel.add((Component)this._iconLabel, gridBagConstraints);
        this._line1Label = DBDiagramUtils.createLimitedLabelForWarning(n);
        this._line1Label.setHorizontalAlignment(0);
        this._line1Label.setText(string);
        gridBagConstraints = new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 19, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
        this._mainPanel.add((Component)this._line1Label, gridBagConstraints);
        if (string2 != null) {
            this._line2Label = DBDiagramUtils.createLimitedLabelForWarning(n2);
            this._line2Label.setHorizontalAlignment(0);
            this._line2Label.setText(string2);
            gridBagConstraints = new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 19, 0, DBDiagramUtils.ZERO_INSETS, 0, 0);
            this._mainPanel.add((Component)this._line2Label, gridBagConstraints);
            this._mainPanel.setToolTipText("<html>" + this._line1Text + "<br>" + this._line2Text + "</html>");
        } else {
            this._mainPanel.setToolTipText(this._line1Text);
        }
        this.updateSize();
    }

    void releaseResources() {
        this._icon = null;
        this._iconLabel = null;
        this._line1Label = null;
        this._line2Label = null;
        this._mainPanel = null;
        if (this._clickablePanel != null) {
            this._clickablePanel.releaseResources();
            this._clickablePanel = null;
        }
        this._fixedDimensions = null;
    }

    void addActionListener(ActionListener actionListener) {
        if (this._clickablePanel != null) {
            this._clickablePanel.addActionListener(actionListener);
        }
    }

    void boldFont() {
        DBDiagramUtils.boldLabelFont(this._line1Label);
        if (this._line2Label != null) {
            DBDiagramUtils.boldLabelFont(this._line2Label);
        }
        this.updateSize();
    }

    Rectangle getIconBounds() {
        Rectangle rectangle = this._iconLabel.getBounds();
        if (this._clickable) {
            rectangle.x += this._clickablePanel.getX();
            rectangle.y += this._clickablePanel.getY();
        }
        rectangle.x += this.getX();
        rectangle.y += this.getY();
        return rectangle;
    }

    void setLine2Text(String string) {
        this._line2Text = string;
        if (this._line2Text != null) {
            this._line2Label.setText(this._line2Text);
            this._mainPanel.setToolTipText("<html>" + this._line1Text + "<br>" + this._line2Text + "</html>");
        } else {
            this._line2Label.setText("");
            this._mainPanel.setToolTipText(this._line1Text);
        }
    }

    void increaseFontSize(float f) {
        DBDiagramUtils.increaseLabelFontSize(this._line1Label, f);
        if (this._line2Label != null) {
            DBDiagramUtils.increaseLabelFontSize(this._line2Label, f);
        }
        this.updateSize();
    }

    boolean isActionSource(ActionEvent actionEvent) {
        return actionEvent.getSource() == this._clickablePanel;
    }

    void removeActionListener(ActionListener actionListener) {
        this._clickablePanel.removeActionListener(actionListener);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.setMinimumSize(this._fixedDimensions);
        } else {
            this.setMinimumSize(DBDiagramUtils.ZERO_SIZE);
        }
        super.setVisible(bl);
    }

    void setWarning(boolean bl) {
        if (bl) {
            if (!this._warningShown) {
                DBDiagramUtils.showWarning(this._line1Label);
                if (this._line2Label != null) {
                    DBDiagramUtils.showWarningFont(this._line2Label);
                }
                this._warningShown = true;
            }
        } else if (this._warningShown) {
            DBDiagramUtils.clearWarning(this._line1Label);
            if (this._line2Label != null) {
                DBDiagramUtils.clearWarning(this._line2Label);
            }
            this._warningShown = false;
        }
    }

    private void updateSize() {
        if (this._clickable && this._canShowWarning) {
            DBDiagramUtils.showWarning(this._line1Label);
            if (this._line2Label != null) {
                DBDiagramUtils.showWarningFont(this._line2Label);
            }
            this.validate();
            this._fixedDimensions = this.getPreferredSize();
            DBDiagramUtils.clearWarning(this._line1Label);
            if (this._line2Label != null) {
                DBDiagramUtils.clearWarning(this._line2Label);
            }
            this.setPreferredSize(this._fixedDimensions);
            this.setMinimumSize(this._fixedDimensions);
        } else {
            this.validate();
            this._fixedDimensions = this.getPreferredSize();
            this.setMinimumSize(this._fixedDimensions);
        }
    }

    @Override
    public void setEnabled(boolean bl) {
        this._enabled = bl;
        if (this._enabled) {
            this._iconLabel.setIcon(this._icon);
            this._mainPanel.setToolTipText(null);
            if (this._line2Text != null) {
                this._mainPanel.setToolTipText("<html>" + this._line1Text + "<br>" + this._line2Text + "</html>");
            } else {
                this._mainPanel.setToolTipText(this._line1Text);
            }
        } else {
            this._iconLabel.setIcon(UIManager.getLookAndFeel().getDisabledIcon(this, this._icon));
            this._mainPanel.setToolTipText("<html>" + DBDiagramPanel.bundle.getFormatted("QUES_NODE_HELP_TIP1", this._featureName) + "<br>" + DBDiagramPanel.bundle.getString("QUES_NODE_HELP_TIP2") + "</html>");
        }
        this._line1Label.setEnabled(this._enabled);
        this._line2Label.setEnabled(this._enabled);
    }

    @Override
    public boolean isEnabled() {
        return this._enabled;
    }
}

