/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.dbdiagram.printing;

import com.sybase.dbdiagram.printing.PrintingComponent;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public class PrintingLabel
extends PrintingComponent {
    private int _actualWidth = 0;
    private int _actualHeight = 0;
    private Color _color;
    private int _contentHeight;
    private int _contentWidth;
    private Font _font;
    private FontMetrics _fm;
    private int _minHeight;
    private int _minWidth;
    private ImageIcon _icon;
    private int _iconGap;
    private boolean _isSimple;
    private String _text;

    public PrintingLabel(String string, Font font, FontMetrics fontMetrics, Color color) {
        this(string, font, fontMetrics, color, null, 0);
        this._isSimple = true;
    }

    public PrintingLabel(String string, Font font, FontMetrics fontMetrics, Color color, ImageIcon imageIcon, int n) {
        this(string, font, fontMetrics, color, imageIcon, n, 0, 0);
    }

    public PrintingLabel(String string, Font font, FontMetrics fontMetrics, Color color, ImageIcon imageIcon, int n, int n2, int n3) {
        this._font = font;
        this._fm = fontMetrics;
        this._color = color;
        this._icon = imageIcon;
        this._iconGap = n;
        this._minWidth = n2;
        this._minHeight = n3;
        this.setText(string);
        this._contentWidth = SwingUtilities.computeStringWidth(this._fm, this._text);
        this._contentHeight = this._fm.getHeight();
        if (this._icon != null) {
            this._contentWidth += this._icon.getIconWidth() + this._iconGap;
            this._contentHeight = Math.max(this._contentHeight, this._icon.getIconHeight());
        }
        this._actualWidth = Math.max(this._contentWidth, this._minWidth);
        this._actualHeight = Math.max(this._contentHeight, this._minHeight);
        this._isSimple = false;
    }

    @Override
    public void releaseResources() {
        this._color = null;
        this._font = null;
        this._icon = null;
        this._text = null;
        super.releaseResources();
    }

    public FontMetrics getFontMetrics() {
        return this._fm;
    }

    @Override
    public int getHeight() {
        return this._actualHeight;
    }

    public String getText() {
        return this._text;
    }

    @Override
    public int getWidth() {
        return this._actualWidth;
    }

    @Override
    public void print(Graphics graphics) {
        graphics.setColor(this._color);
        graphics.setFont(this._font);
        if (this._isSimple) {
            graphics.drawString(this._text, this._x, this._y + this._contentHeight);
        } else {
            int n = this._x;
            int n2 = this._y + this._font.getSize();
            int n3 = Math.max(this._minHeight, this._contentHeight);
            int n4 = n3 - this._font.getSize();
            if (n4 >= 0) {
                n2 += n4 / 2;
            }
            if (this._icon != null) {
                int n5 = n3 - this._icon.getIconHeight();
                if (n5 >= 0) {
                    graphics.drawImage(this._icon.getImage(), this._x, this._y + n5 / 2, null);
                } else {
                    graphics.drawImage(this._icon.getImage(), this._x, this._y, null);
                }
                n += this._icon.getIconWidth() + this._iconGap;
            }
            graphics.drawString(this._text, n, n2);
        }
    }

    public void setText(String string) {
        this._text = string;
        this._contentWidth = SwingUtilities.computeStringWidth(this._fm, this._text);
        if (this._icon != null) {
            this._contentWidth += this._icon.getIconWidth() + this._iconGap;
        }
        int n = this._actualWidth;
        this._actualWidth = Math.max(this._contentWidth, this._minWidth);
        if (this._parent != null) {
            this._parent.childWidthChanged(this, n, this._actualWidth);
        }
    }
}

