/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.dbdiagram.printing;

import com.sybase.dbdiagram.printing.PrintingComponent;
import com.sybase.dbdiagram.printing.PrintingPanel;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;

public class PrintingPaginatedPanel
extends PrintingPanel {
    private static final boolean WARN_WHEN_PAGINATION_CLEARED = true;
    private TreeMap<MyKey, PrintingComponent> _sortedComponents = new TreeMap();
    private ArrayList<MyKey> _pageStarts;
    private int _minPageHeight;

    public PrintingPaginatedPanel() {
        super(null);
        this._components = this._sortedComponents.values();
        this._pageStarts = new ArrayList();
        this._minPageHeight = 0;
    }

    @Override
    public void releaseResources() {
        if (this._pageStarts != null) {
            this._pageStarts.clear();
            this._pageStarts = null;
        }
        this._sortedComponents = null;
        super.releaseResources();
    }

    @Override
    public void add(PrintingComponent printingComponent) {
        if (this.isPaginated()) {
            this._pageStarts.clear();
        }
        this._sortedComponents.put(new MyKey(printingComponent), printingComponent);
        this.childAdded(printingComponent);
    }

    @Override
    protected void childHeightChanged(PrintingComponent printingComponent, int n, int n2) {
        if (this.isPaginated()) {
            this._pageStarts.clear();
        }
        super.childHeightChanged(printingComponent, n, n2);
    }

    @Override
    protected void childYChanged(PrintingComponent printingComponent, int n, int n2) {
        if (this.isPaginated()) {
            this._pageStarts.clear();
        }
        super.childYChanged(printingComponent, n, n2);
    }

    public int getMinPageHeight() {
        if (!this._heightIsValid) {
            this.validateHeight();
        }
        return this._minPageHeight;
    }

    public int getPageCount() {
        if (!this.isPaginated()) {
            throw new IllegalStateException("getPageCount() called when panel is not paginated.");
        }
        return this._pageStarts.size() - 1;
    }

    public int getPageStart(int n) {
        if (!this.isPaginated()) {
            throw new IllegalStateException("getPageStart() called when panel is not paginated.");
        }
        return this._pageStarts.get((int)n).y;
    }

    public boolean isPaginated() {
        return this._pageStarts.size() > 0;
    }

    public void paginate(int n) {
        this._pageStarts.clear();
        if (this._sortedComponents.size() == 0) {
            return;
        }
        if (!this._heightIsValid) {
            this.validateHeight();
        }
        Iterator iterator = this._components.iterator();
        PrintingComponent printingComponent = (PrintingComponent)iterator.next();
        this._pageStarts.add(new MyKey(printingComponent));
        int n2 = printingComponent.getY() + n;
        while (iterator.hasNext()) {
            printingComponent = (PrintingComponent)iterator.next();
            if (printingComponent.getY() + printingComponent.getHeight() <= n2) continue;
            this._pageStarts.add(new MyKey(printingComponent));
            n2 = printingComponent.getY() + n;
        }
        this._pageStarts.add(new MyKey(0, printingComponent.getY() + 1));
    }

    public void printPage(Graphics graphics, int n) {
        if (!this.isPaginated()) {
            throw new IllegalStateException("printPage() called when panel is not paginated.");
        }
        if (n < 0 || n >= this._pageStarts.size() - 1) {
            throw new IllegalArgumentException("pageIndex '" + n + "' is invalid.");
        }
        SortedMap<MyKey, PrintingComponent> sortedMap = this._sortedComponents.subMap(this._pageStarts.get(n), this._pageStarts.get(n + 1));
        Iterator<PrintingComponent> iterator = sortedMap.values().iterator();
        graphics.translate(this._x, this._y);
        while (iterator.hasNext()) {
            iterator.next().print(graphics);
        }
        graphics.translate(-this._x, -this._y);
    }

    @Override
    protected void updateHeightBasedOnChild(PrintingComponent printingComponent) {
        this._minPageHeight = Math.max(this._minPageHeight, printingComponent.getHeight());
        super.updateHeightBasedOnChild(printingComponent);
    }

    @Override
    protected void validateHeight() {
        this._minPageHeight = 0;
        super.validateHeight();
    }

    private class MyKey
    implements Comparable<MyKey> {
        int x;
        int y;

        MyKey() {
            this.x = 0;
            this.y = 0;
        }

        MyKey(int n, int n2) {
            this.x = n;
            this.y = n2;
        }

        MyKey(PrintingComponent printingComponent) {
            this.x = printingComponent.getX();
            this.y = printingComponent.getY();
        }

        @Override
        public int compareTo(MyKey myKey) {
            if (this.y == myKey.y) {
                return this.x - myKey.x;
            }
            return this.y - myKey.y;
        }

        public boolean equals(MyKey myKey) {
            return this.y == myKey.y && this.x == myKey.x;
        }
    }
}

