/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.dbdiagram.printing;

import com.sybase.dbdiagram.printing.PrintingComponent;
import java.awt.Graphics;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class PrintingPanel
extends PrintingComponent {
    protected Collection<PrintingComponent> _components;
    protected int _width;
    protected boolean _widthIsValid;
    protected int _height;
    protected boolean _heightIsValid;

    public PrintingPanel() {
        this(new ArrayList<PrintingComponent>());
    }

    PrintingPanel(Collection<PrintingComponent> collection) {
        this._components = collection;
        this._width = 0;
        this._height = 0;
        this._widthIsValid = true;
        this._heightIsValid = true;
    }

    @Override
    public void releaseResources() {
        if (this._components != null) {
            Iterator<PrintingComponent> iterator = this._components.iterator();
            while (iterator.hasNext()) {
                iterator.next().releaseResources();
            }
            this._components.clear();
            this._components = null;
        }
        super.releaseResources();
    }

    public void add(PrintingComponent printingComponent) {
        this._components.add(printingComponent);
        this.childAdded(printingComponent);
    }

    protected void childAdded(PrintingComponent printingComponent) {
        printingComponent.setParent(this);
        if (this._widthIsValid) {
            this.updateWidthBasedOnChild(printingComponent);
        }
        if (this._heightIsValid) {
            this.updateHeightBasedOnChild(printingComponent);
        }
    }

    protected void childHeightChanged(PrintingComponent printingComponent, int n, int n2) {
        if (this._heightIsValid) {
            if (n < n2) {
                this.updateHeightBasedOnChild(printingComponent);
            } else if (n > n2) {
                this.invalidateHeight();
            }
        }
    }

    protected void childWidthChanged(PrintingComponent printingComponent, int n, int n2) {
        if (this._widthIsValid) {
            if (n < n2) {
                this.updateWidthBasedOnChild(printingComponent);
            } else if (n > n2) {
                this.invalidateWidth();
            }
        }
    }

    protected void childXChanged(PrintingComponent printingComponent, int n, int n2) {
        if (this._widthIsValid) {
            if (n < n2) {
                this.updateWidthBasedOnChild(printingComponent);
            } else if (n > n2) {
                this.invalidateWidth();
            }
        }
    }

    protected void childYChanged(PrintingComponent printingComponent, int n, int n2) {
        if (this._heightIsValid) {
            if (n < n2) {
                this.updateHeightBasedOnChild(printingComponent);
            } else if (n > n2) {
                this.invalidateHeight();
            }
        }
    }

    @Override
    public int getHeight() {
        if (!this._heightIsValid) {
            this.validateHeight();
        }
        return this._height;
    }

    @Override
    public int getWidth() {
        if (!this._widthIsValid) {
            this.validateWidth();
        }
        return this._width;
    }

    @Override
    public void print(Graphics graphics) {
        Iterator<PrintingComponent> iterator = this._components.iterator();
        graphics.translate(this._x, this._y);
        while (iterator.hasNext()) {
            iterator.next().print(graphics);
        }
        graphics.translate(-this._x, -this._y);
    }

    protected void invalidateHeight() {
        this._heightIsValid = false;
        if (this._parent != null) {
            this._parent.invalidateHeight();
        }
    }

    protected void invalidateWidth() {
        this._widthIsValid = false;
        if (this._parent != null) {
            this._parent.invalidateWidth();
        }
    }

    protected void updateHeightBasedOnChild(PrintingComponent printingComponent) {
        int n = printingComponent.getY() + printingComponent.getHeight();
        if (n > this._height) {
            this._height = n;
            if (this._parent != null && this._parent._heightIsValid) {
                this._parent.updateHeightBasedOnChild(this);
            }
        }
    }

    protected void updateWidthBasedOnChild(PrintingComponent printingComponent) {
        int n = printingComponent.getX() + printingComponent.getWidth();
        if (n > this._width) {
            this._width = n;
            if (this._parent != null && this._parent._widthIsValid) {
                this._parent.updateWidthBasedOnChild(this);
            }
        }
    }

    protected void validateHeight() {
        Iterator<PrintingComponent> iterator = this._components.iterator();
        this._height = 0;
        while (iterator.hasNext()) {
            this.updateHeightBasedOnChild(iterator.next());
        }
        this._heightIsValid = true;
    }

    protected void validateWidth() {
        Iterator<PrintingComponent> iterator = this._components.iterator();
        this._width = 0;
        while (iterator.hasNext()) {
            this.updateWidthBasedOnChild(iterator.next());
        }
        this._widthIsValid = true;
    }
}

