/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.indexConsultant;

import com.ianywhere.textCompleter.SCEditorWithTextCompleter;
import com.ianywhere.textCompleter.TextCompleterAdapter;
import com.sybase.asa.common.ASAComponentsImageLoader;
import com.sybase.central.editor.Parser;
import com.sybase.central.editor.WsqlParser;
import com.sybase.indexConsultant.ICHelpManager;
import com.sybase.indexConsultant.IndexWizardPlanViewer;
import com.sybase.indexConsultant.IxtAnalysis;
import com.sybase.indexConsultant.IxtDB;
import com.sybase.indexConsultant.IxtDBVersion10;
import com.sybase.indexConsultant.IxtDBVersion9;
import com.sybase.indexConsultant.IxtDriver;
import com.sybase.indexConsultant.IxtFeedback;
import com.sybase.indexConsultant.IxtIndex;
import com.sybase.indexConsultant.IxtQuery;
import com.sybase.util.DialogUtils;
import com.sybase.util.SybButton;
import com.sybase.util.SybCheckBox;
import com.sybase.util.SybFileChooser;
import com.sybase.util.SybFileFilter;
import com.sybase.util.SybLabel;
import com.sybase.util.SybModalDialog;
import com.sybase.util.SybOptionPane;
import com.sybase.util.SybRadioButton;
import com.sybase.util.SybTextArea;
import com.sybase.util.UIUtils;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import javax.swing.table.TableRowSorter;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class IndexWizard
extends SybModalDialog
implements ActionListener {
    private static final int FIELD_WIDTH = 10;
    private static final int VERT_SPACING = 8;
    private static final int MAJOR_VERT_SPACING = 16;
    private static final int HORIZ_SPACING = 5;
    private static final int HORIZ_INDENT = 16;
    private static final int DIALOG_WIDTH = 700;
    private static final long BYTES_IN_MEG = 1000000L;
    private int _currentPanel = -1;
    private static final int null_PANEL = -1;
    private static final int OPTIONS_PANEL = 0;
    private static final int INDEX_SIZE_PANEL = 1;
    private static final int ANALYSIS_PANEL = 2;
    private static final int SCRIPT_PANEL = 3;
    private static final int NUM_PANELS = 4;
    private static final int DELETE_STATEMENT = 10;
    private static final int SELECT_STATEMENT = 11;
    private static final int UPDATE_STATEMENT = 12;
    private static final int INVALID_STATEMENT = 13;
    private IndexWizardPanel[] _panelList = null;
    private OptionsPanel _optionsPanel = null;
    private IndexSizePanel _indexSizePanel = null;
    private AnalysisPanel _analysisPanel = null;
    private ScriptPanel _scriptPanel = null;
    private JPanel _displayPanel = null;
    private CardLayout _displayLayout = null;
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    private static final String F1_KEY = "F1_KEY";
    static Insets INSETS = new Insets(5, 5, 5, 5);
    static Insets INSETS_LEFT = new Insets(0, 10, 0, 0);
    static Insets INSETS_NONE = new Insets(0, 0, 0, 0);
    static Insets INSETS_INDENT = new Insets(5, 22, 5, 5);
    static Insets INSETS_HORIZONTAL = new Insets(5, 5, 0, 0);
    static Insets INSETS_HORIZONTAL_INDENT = new Insets(5, 22, 0, 0);
    private SybButton _cancel = null;
    private SybButton _help = null;
    private SybButton _back = null;
    private SybButton _next = null;
    static final String TITLE = "TITLE";
    static final String OK = "OK";
    static final String CANCEL = "CANCEL";
    static final String HELP = "HELP";
    static final String NEXT = "NEXT";
    static final String BACK = "BACK";
    static final String CLOSE = "CLOSE";
    static final String YES = "YES";
    static final String NO = "NO";
    static final String ERROR_ONLY_SEL_UPD_DEL_ALLOWED = "ERROR_ONLY_SEL_UPD_DEL_ALLOWED";
    static final String ERROR_ONLY_SINGLE_QUERY_ALLOWED = "ERROR_ONLY_SINGLE_QUERY_ALLOWED";
    static final String ERROR_WHILE_TUNING = "ERROR_WHILE_TUNING";
    static final String ERROR_NO_RESULTS = "ERROR_NO_RESULTS";
    static final String ERROR_QUERIES_DISCARDED = "ERROR_QUERIES_DISCARDED";
    static final String WARNING_INDEX_WIZARD = "WARNING_INDEX_WIZARD";
    static final String ERROR_INDEX_WIZARD = "ERROR_INDEX_WIZARD";
    static final String ERROR_PLAN_OBTAINABLE = "ERROR_PLAN_OBTAINABLE";
    static final String ERROR_INDEX_TABLES_NOT_FOUND = "ERROR_INDEX_TABLES_NOT_FOUND";
    static final String ERROR_COULD_NOT_SAVE = "ERROR_COULD_NOT_SAVE";
    static final String CLUSTERED_DESCRIPTION = "CLUSTERED_DESCRIPTION";
    static final String RECOMMEND_CLUSTERED_INDEX = "RECOMMEND_CLUSTERED_INDEX";
    static final String KEEP_2ND_INDEX_DESCRIPTION = "KEEP_2ND_INDEX_DESCRIPTION";
    static final String KEEP_2ND_INDEX = "KEEP_2ND_INDEX";
    static final String LIMIT_INDEX_SIZE_DESCRIPTION = "LIMIT_INDEX_SIZE_DESCRIPTION";
    static final String LIMIT_INDEX_SIZE_TO = "LIMIT_INDEX_SIZE_TO";
    static final String MEGABYTES = "MEGABYTES";
    static final String MEGABYTES_CURRENT = "MEGABYTES_CURRENT";
    static final String PERCENT_OF_TABLE = "PERCENT_OF_TABLE";
    static final String PERCENT_OF_TABLE_CURRENT = "PERCENT_OF_TABLE_CURRENT";
    static final String CURRENT_SIZE_OF_INDEX = "CURRENT_SIZE_OF_INDEX";
    static final String TUNING_RESULTS = "TUNING_RESULTS";
    static final String SUMMARY = "SUMMARY";
    static final String VIRTUAL_INDEXES = "VIRTUAL_INDEXES";
    static final String UPDATES = "UPDATES";
    static final String UNUSED = "UNUSED";
    static final String PLAN_VIEW = "PLAN_VIEW";
    static final String SHOW_PLAN_WITH_INDEX = "SHOW_PLAN_WITH_INDEX";
    static final String SHOW_PLAN_WITHOUT_INDEX = "SHOW_PLAN_WITHOUT_INDEX";
    static final String WITHOUT_VIRTUAL_INDEX = "WITHOUT_VIRTUAL_INDEX";
    static final String WITH_VIRTUAL_INDEX = "WITH_VIRTUAL_INDEX";
    static final String ID = "ID";
    static final String ATTRIBUTE = "ATTRIBUTE";
    static final String VALUE = "VALUE";
    static final String TOTAL_RECOMMENDED_INDEXES = "TOTAL_RECOMMENDED_INDEXES";
    static final String SPACE_REQUIREMENTS = "SPACE_REQUIREMENTS";
    static final String MAINTENANCE_COSTS = "MAINTENANCE_COSTS";
    static final String TOTAL_BENEFITS = "TOTAL_BENEFITS";
    static final String RI_CREATOR = "RI_CREATOR";
    static final String RI_TABLE = "RI_TABLE";
    static final String RI_COLUMNS = "RI_COLUMNS";
    static final String RI_CLUSTERED = "RI_CLUSTERED";
    static final String RI_TYPES = "RI_TYPES";
    static final String RI_PAGES = "RI_PAGES";
    static final String RI_RELATIVE_BENEFIT = "RI_RELATIVE_BENEFIT";
    static final String RI_TOTAL_BENEFIT = "RI_TOTAL_BENEFIT";
    static final String RI_UPDATE_COST = "RI_UPDATE_COST";
    static final String RI_TOTAL_COST_BENEFIT = "RI_TOTAL_COST_BENEFIT";
    static final String UI_TABLE = "UI_TABLE";
    static final String UI_SECONDARY_INDEX = "UI_SECONDARY_INDEX";
    static final String L_MESSAGE_TYPE = "L_MESSAGE_TYPE";
    static final String L_MESSAGE = "L_MESSAGE";
    static final String U_QUERY_TYPE = "U_QUERY_TYPE";
    static final String U_ROWS_AFFECT = "U_ROWS_AFFECT";
    static final String U_TABLES = "U_TABLES";
    static final String U_COLUMNS = "U_COLUMNS";
    static final String PRESENT_SRCRIPT = "PRESENT_SRCRIPT";
    static final String USE_SCRIPT = "USE_SCRIPT";
    static final String WARNING_BEFORE_ADDING_SCIRPT = "WARNING_BEFORE_ADDING_SCIRPT";
    static final String SAVE_SCRIPT = "SAVE_SCRIPT";
    static final String SAVE_QUERY = "SAVE_QUERY";
    static final String OVERWRITE_FILE = "OVERWRITE_FILE";
    static final String SCRIPT_PREVIOUSLY_EXECUTED = "SCRIPT_PREVIOUSLY_EXECUTED";
    static final String PLAN_VIEWER = "PLAN_VIEWER";
    static final String WORKING = "WORKING";
    static final String LOADING_PLAN = "LOADING_PLAN";
    static final String REMOVE_VIRT_INDEX = "REMOVE_VIRT_INDEX";
    static final String SHOW_VIRT_INDEX = "SHOW_VIRT_INDEX";
    static final String SQL_FILE_DESCRIPTION = "SQL_FILE_DESCRIPTION";
    String HELP_INDEX_WIZARD = "HELP_ISQL_INDEX_WIZARD";
    private Connection _connection = null;
    private String[] _initialSaveFolder;
    private String _helpFolder = "";
    private String _helpPrefix = "";
    private String _helpSuffix = "";
    private IxtDriver _driver = null;
    private IxtAnalysis _analysis = null;
    private String _inputSql = null;
    private JFrame _parent = null;
    private boolean _isUpdate = false;
    private boolean _shuttingDown = false;
    private IndexWizard _this = null;
    private static final String GO = "GO";
    private IxtDB _ixtDB;
    private int _version;
    private int _loggingSession;
    private long _queryID;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void create(JFrame jFrame, Connection connection, String string, char c, String[] stringArray, String string2, String string3, String string4, int n, long l, int n2) {
        IndexWizard indexWizard = null;
        IxtDB ixtDB = n2 == 9 ? new IxtDBVersion9() : new IxtDBVersion10();
        try {
            if (!ixtDB.runIndexConsultantTablesCheck(connection)) {
                IndexWizard.handleError(IxtDriver.getI18NMessage(ERROR_INDEX_TABLES_NOT_FOUND), (Component)jFrame);
                return;
            }
        }
        catch (SQLException sQLException) {
            IndexWizard.handleError(sQLException, (Component)jFrame);
            return;
        }
        try {
            if (!ixtDB.runIndexConsultantPermissionCheck(connection)) {
                if (n2 < 11) {
                    IndexWizard.handleError(IxtDriver.getI18NMessage("DBA_PERMISSION_REQUIRED"), (Component)jFrame);
                } else {
                    IndexWizard.handleError(IxtDriver.getI18NMessage("DBA_PERMISSION_REQUIRED_11"), (Component)jFrame);
                }
                return;
            }
        }
        catch (SQLException sQLException) {
            IndexWizard.handleError(sQLException, (Component)jFrame);
            return;
        }
        int n3 = IndexWizard.determineStatementType(string);
        if (n3 == 13) {
            IndexWizard.handleError(IxtDriver.getI18NMessage(ERROR_ONLY_SEL_UPD_DEL_ALLOWED), (Component)jFrame);
            return;
        }
        if (n == 0 && l == 0L) {
            if (IndexWizard.containsMultipleStatements(string, c)) {
                IndexWizard.handleError(IxtDriver.getI18NMessage(ERROR_ONLY_SINGLE_QUERY_ALLOWED), (Component)jFrame);
                return;
            }
            try {
                connection.prepareStatement(string);
            }
            catch (SQLException sQLException) {
                IndexWizard.handleError(sQLException, (Component)jFrame);
                return;
            }
        }
        boolean bl = n3 == 12;
        try {
            indexWizard = new IndexWizard(jFrame, connection, string, bl, stringArray, string2, string3, string4, n, l, n2);
            indexWizard.init();
            indexWizard.setLocationRelativeTo(jFrame);
            UIUtils.ensureWindowIsVisible((Window)((Object)indexWizard));
            indexWizard.setVisible(true);
            if (indexWizard != null) {
                indexWizard.destroyUI();
            }
        }
        catch (Throwable throwable) {
            if (indexWizard != null) {
                super.destroyUI();
            }
            throw throwable;
        }
    }

    private IndexWizard(JFrame jFrame, Connection connection, String string, boolean bl, String[] stringArray, String string2, String string3, String string4, int n, long l, int n2) {
        super((Frame)jFrame);
        this._connection = connection;
        this._parent = jFrame;
        this._isUpdate = bl;
        this._this = this;
        this._initialSaveFolder = stringArray;
        this._helpFolder = string2;
        this._helpPrefix = string3;
        this._helpSuffix = string4;
        this._version = n2;
        this._ixtDB = this._version == 9 ? new IxtDBVersion9() : new IxtDBVersion10();
        this._inputSql = string;
        this._loggingSession = n;
        this._queryID = l;
    }

    private void init() {
        this._optionsPanel = new OptionsPanel();
        this._indexSizePanel = new IndexSizePanel();
        this._analysisPanel = new AnalysisPanel();
        this._scriptPanel = new ScriptPanel();
        this._panelList = new IndexWizardPanel[]{this._optionsPanel, this._indexSizePanel, this._analysisPanel, this._scriptPanel};
        this._displayLayout = new CardLayout();
        this._displayPanel = new JPanel(this._displayLayout);
        this._displayLayout.addLayoutComponent(this._optionsPanel, "options");
        this._displayLayout.addLayoutComponent(this._indexSizePanel, "indexSize");
        this._displayLayout.addLayoutComponent(this._analysisPanel, "analysis");
        this._displayLayout.addLayoutComponent(this._scriptPanel, "script");
        this._displayPanel.add((Component)this._optionsPanel, "options");
        this._displayPanel.add((Component)this._indexSizePanel, "indexSize");
        this._displayPanel.add((Component)this._analysisPanel, "analysis");
        this._displayPanel.add((Component)this._scriptPanel, "script");
        this.addWidgets();
        this._currentPanel = 0;
        this._back.setEnabled(false);
        this.pack();
        this.setSize(new Dimension(700, this.getHeight()));
    }

    private void addWidgets() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        IndexWizard.addComponent(jPanel2, new JSeparator(), 0, 0, 1, 1, 1.0, 0.9, 10, 2, INSETS, 0, 0);
        IndexWizard.addComponent(jPanel2, this.makeButtonPanel(), 0, 1, 1, 1, 1.0, 0.1, 13, 2, INSETS, 0, 0);
        SybLabel sybLabel = new SybLabel((Icon)ASAComponentsImageLoader.getImageIcon("indexconsultant", 1006));
        IndexWizard.addComponent(jPanel, (Component)sybLabel, 0, 0, 1, 1, 0.0, 0.0, 11, 2, INSETS, 0, 0);
        IndexWizard.addComponent(jPanel, this._displayPanel, 1, 0, 1, 1, 1.0, 1.0, 10, 1, INSETS, 0, 0);
        IndexWizard.addComponent(jPanel, jPanel2, 0, 1, 0, 1, 1.0, 0.0, 10, 2, INSETS_NONE, 0, 0);
        Container container = this.getContentPane();
        container.add(jPanel);
        this.getRootPane().registerKeyboardAction(this, F1_KEY, KeyStroke.getKeyStroke(112, 0, true), 2);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, false), 1);
        this.setTitle(IxtDriver.getI18NMessage(TITLE));
    }

    private JPanel makeButtonPanel() {
        int n;
        this._next = new SybButton(IxtDriver.getI18NMessage(NEXT));
        this._next.addActionListener((ActionListener)this);
        this._back = new SybButton(IxtDriver.getI18NMessage(BACK));
        this._back.addActionListener((ActionListener)this);
        this._cancel = new SybButton(IxtDriver.getI18NMessage(CANCEL));
        this._cancel.addActionListener((ActionListener)this);
        this._cancel.setDefaultCapable(false);
        this.getRootPane().setDefaultButton((JButton)this._next);
        this._help = new SybButton(IxtDriver.getI18NMessage(HELP));
        this._help.addActionListener((ActionListener)this);
        SybButton[] sybButtonArray = new SybButton[]{this._back, this._next, this._cancel, this._help};
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel.add(Box.createHorizontalGlue());
        for (n = 0; n < sybButtonArray.length - 1; ++n) {
            jPanel.add((Component)sybButtonArray[n]);
            jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        }
        jPanel.add((Component)sybButtonArray[n]);
        DialogUtils.makeComponentsSameWidth((JComponent[])sybButtonArray);
        return jPanel;
    }

    private void destroyUI() {
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(27, 0, false));
        this.getRootPane().unregisterKeyboardAction(KeyStroke.getKeyStroke(112, 0, true));
        this.getRootPane().setDefaultButton(null);
        this._cancel.removeActionListener((ActionListener)this);
        this._help.removeActionListener((ActionListener)this);
        this._next.removeActionListener((ActionListener)this);
        this._back.removeActionListener((ActionListener)this);
        this._cancel = null;
        this._help = null;
        this._next = null;
        this._back = null;
        for (int i = 0; i < this._panelList.length; ++i) {
            this._panelList[i].destroy();
        }
        this._connection = null;
        this._initialSaveFolder = null;
        this._helpFolder = null;
        this._helpPrefix = null;
        this._helpSuffix = null;
        try {
            if (this._analysis != null) {
                this._analysis.delete();
                this._analysis = null;
            }
        }
        catch (SQLException sQLException) {
            try {
                this.handleError(sQLException);
            }
            catch (ConnectionClosedException connectionClosedException) {
                // empty catch block
            }
        }
        DialogUtils.removeComponents((Container)((Object)this));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        try {
            if (object == this._cancel) {
                this.handleCancel();
            } else if (object == this._help || actionEvent.getActionCommand().equals(F1_KEY)) {
                this.handleHelp();
            } else if (object == this._next) {
                this.handleNext();
            } else if (object == this._back) {
                this.handleBack();
            } else {
                String string = actionEvent.getActionCommand();
                if (string != null && string.equals(ESCAPE_KEY_COMMAND)) {
                    this.handleCancel();
                }
            }
        }
        catch (ConnectionClosedException connectionClosedException) {
            this.handleCancel();
        }
    }

    private void handleBack() {
        this._panelList[this._currentPanel].onBack();
        --this._currentPanel;
        this._displayLayout.previous(this._displayPanel);
        this._panelList[this._currentPanel].onActive();
    }

    private void handleNext() throws ConnectionClosedException {
        this._panelList[this._currentPanel].onNext();
        ++this._currentPanel;
        this._displayLayout.next(this._displayPanel);
        this._panelList[this._currentPanel].refresh();
        this._panelList[this._currentPanel].onActive();
    }

    private void handleCancel() {
        this.setVisible(false);
    }

    private void handleHelp() {
        ICHelpManager.showHelpIndex((Window)((Object)this), this.HELP_INDEX_WIZARD, this._helpFolder, this._helpPrefix, this._helpSuffix);
    }

    private static int determineStatementType(String string) {
        string = IndexWizard.removeAllComments(string);
        if ((string = string.toLowerCase()).indexOf("select") == 0) {
            return 11;
        }
        if (string.indexOf("update") == 0) {
            return 12;
        }
        if (string.indexOf("delete") == 0) {
            return 10;
        }
        if (string.indexOf("insert") == 0 && string.indexOf("select") > 0) {
            return 11;
        }
        return 13;
    }

    private static boolean containsMultipleStatements(String string, char c) {
        return (string = IndexWizard.removeAllComments(string).toUpperCase().trim()).indexOf(c) != -1;
    }

    private static String removeAllComments(String string) {
        String string2 = "";
        string = string.trim();
        int n = (string = IndexWizard.removeWholeLineComments(string)).indexOf("/*");
        if (n == -1) {
            return string;
        }
        int n2 = string.indexOf("*/", n + 2);
        if (n2 == -1) {
            return string;
        }
        if (n > 0) {
            string2 = string.substring(0, n - 1);
        }
        string2 = string2 + string.substring(n2 + 2);
        return IndexWizard.removeAllComments(string2);
    }

    private static String removeWholeLineComments(String string) {
        string = IndexWizard.removeLinesWith(string, "//");
        return IndexWizard.removeLinesWith(string, "--");
    }

    private static String removeLinesWith(String string, String string2) {
        int n;
        while ((n = (string = string.trim()).indexOf(string2)) != -1) {
            int n2 = string.indexOf(10, n);
            if (n != 0 && n2 == -1) {
                string = string.substring(0, n);
                continue;
            }
            if (n == 0 && n2 == -1) {
                return "";
            }
            string = string.substring(0, n) + string.substring(n2 + 1);
        }
        return string;
    }

    private SybTextArea makeTextArea(String string) {
        SybTextArea sybTextArea = new SybTextArea(string);
        sybTextArea.setEnabled(true);
        sybTextArea.setEditable(false);
        sybTextArea.setFont(UIManager.getFont("Label.font"));
        sybTextArea.setBackground((Color)SystemColor.control);
        sybTextArea.setWrapStyleWord(true);
        sybTextArea.setLineWrap(true);
        sybTextArea.setFocusable(false);
        return sybTextArea;
    }

    static void addComponent(JPanel jPanel, Component component, int n, int n2, int n3, int n4, double d, double d2, int n5, int n6, Insets insets, int n7, int n8) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.gridwidth = n3;
        gridBagConstraints.gridheight = n4;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.anchor = n5;
        gridBagConstraints.fill = n6;
        gridBagConstraints.insets = insets;
        gridBagConstraints.ipadx = n7;
        gridBagConstraints.ipady = n8;
        jPanel.add(component, gridBagConstraints);
    }

    void handleError(String string) {
        IndexWizard.handleError(string, (Component)this._parent);
    }

    static void handleError(String string, Component component) {
        SybOptionPane.showMessageDialog((Component)component, (Object)string, (String)IxtDriver.getI18NMessage(ERROR_INDEX_WIZARD), (int)0);
    }

    void handleError(Exception exception) throws ConnectionClosedException {
        SQLException sQLException;
        IndexWizard.handleError(exception, (Component)this._parent);
        if (exception instanceof SQLException && ((sQLException = (SQLException)exception).getErrorCode() == -85 || sQLException.getErrorCode() == -308)) {
            this.handleCancel();
            throw new ConnectionClosedException();
        }
    }

    static void handleError(Exception exception, Component component) {
        SybOptionPane.showMessageDialog((Component)component, (Object)exception.getMessage(), (String)IxtDriver.getI18NMessage(ERROR_INDEX_WIZARD), (int)0);
    }

    static class ConnectionClosedException
    extends Exception {
        ConnectionClosedException() {
        }
    }

    static class NonEditableDefaultTableModel
    extends DefaultTableModel {
        public NonEditableDefaultTableModel(Vector vector, Vector vector2) {
            super(vector, vector2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public Class getColumnClass(int n) {
            return this.getValueAt(0, n).getClass();
        }
    }

    static class NonEditableSortableTable
    extends JTable {
        public NonEditableSortableTable(Vector vector, Vector vector2) {
            super(vector, vector2);
            this.setRowSorter(new TableRowSorter<TableModel>(this.getModel()));
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }

    private static class WizardIntegerTextField
    extends JTextField {
        private Toolkit _toolkit = Toolkit.getDefaultToolkit();

        public WizardIntegerTextField(int n) {
            super(n);
            this.setDocument(new IntegerDocument());
            this.setHorizontalAlignment(4);
        }

        public int getValue() {
            try {
                return Integer.parseInt(this.getText());
            }
            catch (NumberFormatException numberFormatException) {
                return 0;
            }
        }

        public void setValue(int n) {
            this.setText(String.valueOf(n));
        }

        private class IntegerDocument
        extends PlainDocument {
            private IntegerDocument() {
            }

            @Override
            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                char[] cArray = string.toCharArray();
                char[] cArray2 = new char[cArray.length];
                int n2 = 0;
                int n3 = cArray2.length;
                for (int i = 0; i < n3; ++i) {
                    if (Character.isDigit(cArray[i])) {
                        cArray2[n2++] = cArray[i];
                        continue;
                    }
                    WizardIntegerTextField.this._toolkit.beep();
                }
                super.insertString(n, new String(cArray2, 0, n2), attributeSet);
            }
        }
    }

    private class ScriptPanel
    extends IndexWizardPanel
    implements ActionListener {
        SybButton runScriptButton;
        SybButton saveButton;
        File sqlSavedFileName;
        boolean scriptPreviouslyRun;
        SCEditorWithTextCompleter editor;

        ScriptPanel() {
            this.sqlSavedFileName = null;
            this.scriptPreviouslyRun = false;
            this.editor = new SCEditorWithTextCompleter();
            this.editor.setEditorType((Parser)WsqlParser.getInstance());
            this.editor.setTextCompleterClient(new TextCompleterAdapter(){

                @Override
                public Connection getConnection() {
                    return IndexWizard.this._connection;
                }
            });
            this.setLayout(new GridBagLayout());
            SybTextArea sybTextArea = IndexWizard.this.makeTextArea(IxtDriver.getI18NMessage(IndexWizard.PRESENT_SRCRIPT));
            JScrollPane jScrollPane = new JScrollPane();
            jScrollPane.getViewport().add((Component)((Object)this.editor));
            this.runScriptButton = new SybButton(IxtDriver.getI18NMessage(IndexWizard.USE_SCRIPT));
            this.saveButton = new SybButton(IxtDriver.getI18NMessage(IndexWizard.SAVE_SCRIPT));
            SybButton[] sybButtonArray = new SybButton[]{this.runScriptButton, this.saveButton};
            DialogUtils.makeComponentsSameWidth((JComponent[])sybButtonArray);
            IndexWizard.addComponent(this, (Component)sybTextArea, 0, 0, 0, 1, 0.0, 0.0, 17, 2, INSETS, 0, 0);
            IndexWizard.addComponent(this, jScrollPane, 0, 1, 0, 1, 1.0, 0.95, 10, 1, INSETS, 0, 0);
            IndexWizard.addComponent(this, Box.createHorizontalStrut(100), 0, 2, 1, 1, 1.0, 0.0, 12, 2, INSETS, 0, 0);
            IndexWizard.addComponent(this, (Component)this.runScriptButton, 1, 2, 1, 1, 0.0, 0.05, 12, 0, INSETS, 0, 0);
            IndexWizard.addComponent(this, (Component)this.saveButton, 2, 2, 1, 1, 0.0, 0.05, 12, 0, INSETS, 0, 0);
            this.runScriptButton.addActionListener((ActionListener)this);
            this.saveButton.addActionListener((ActionListener)this);
        }

        @Override
        void refresh() throws ConnectionClosedException {
            try {
                this.editor.setText(IndexWizard.this._analysis.getUserScript(true));
                String string = IndexWizard.removeAllComments(this.editor.getText());
                this.runScriptButton.setEnabled(string.indexOf("CREATE") != -1 || string.indexOf("DROP") != -1);
            }
            catch (SQLException sQLException) {
                IndexWizard.this.handleError(sQLException);
            }
            IndexWizard.this._cancel.setText(IxtDriver.getI18NMessage(IndexWizard.CLOSE));
        }

        @Override
        void onActive() {
            this.saveButton.requestFocusInWindow();
        }

        @Override
        void onNext() {
        }

        @Override
        void destroy() {
            this.editor.destroy();
            this.runScriptButton.removeActionListener((ActionListener)this);
        }

        @Override
        void onBack() {
            IndexWizard.this._next.setEnabled(true);
            IndexWizard.this._back.setEnabled(false);
            IndexWizard.this._cancel.setText(IxtDriver.getI18NMessage(IndexWizard.CANCEL));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = true;
            int n = 0;
            String string = this.editor.getText();
            Object object = actionEvent.getSource();
            if (object == this.runScriptButton) {
                if (!this.editor.isChanged() && string.indexOf("CREATE") != -1) {
                    boolean bl2 = bl = SybOptionPane.showOptionDialog((Component)IndexWizard.this._parent, (Object)IxtDriver.getI18NMessage(IndexWizard.WARNING_BEFORE_ADDING_SCIRPT), (String)IxtDriver.getI18NMessage(IndexWizard.WARNING_INDEX_WIZARD), (int)0, (int)3, null, (Object[])new Object[]{IxtDriver.getI18NMessage(IndexWizard.YES), IxtDriver.getI18NMessage(IndexWizard.NO)}, (Object)IxtDriver.getI18NMessage(IndexWizard.YES)) == n;
                }
                if (bl && this.scriptPreviouslyRun) {
                    bl = SybOptionPane.showOptionDialog((Component)IndexWizard.this._parent, (Object)IxtDriver.getI18NMessage(IndexWizard.SCRIPT_PREVIOUSLY_EXECUTED), (String)IxtDriver.getI18NMessage(IndexWizard.WARNING_INDEX_WIZARD), (int)0, (int)3, null, (Object[])new Object[]{IxtDriver.getI18NMessage(IndexWizard.YES), IxtDriver.getI18NMessage(IndexWizard.NO)}, (Object)IxtDriver.getI18NMessage(IndexWizard.YES)) == n;
                }
                try {
                    if (bl) {
                        IndexWizard.this._connection.prepareStatement(string).execute();
                        this.scriptPreviouslyRun = true;
                    }
                }
                catch (SQLException sQLException) {
                    try {
                        IndexWizard.this.handleError(sQLException);
                    }
                    catch (ConnectionClosedException connectionClosedException) {}
                }
            } else if (object == this.saveButton) {
                this.handleSaveScript();
            }
        }

        private void handleSaveScript() {
            File file;
            SybFileChooser sybFileChooser = new SybFileChooser(18);
            SybFileFilter sybFileFilter = new SybFileFilter("sql", IxtDriver.getI18NMessage(IndexWizard.SQL_FILE_DESCRIPTION), null);
            sybFileChooser.setFilters(new SybFileFilter[]{sybFileFilter}, 0);
            File file2 = null;
            if (IndexWizard.this._initialSaveFolder != null && IndexWizard.this._initialSaveFolder.length > 0 && IndexWizard.this._initialSaveFolder[0] != null) {
                file2 = new File(IndexWizard.this._initialSaveFolder[0]);
            }
            if (sybFileChooser.showDialog((Window)((Object)IndexWizard.this), file2, file = this.sqlSavedFileName != null && sybFileFilter.accept(this.sqlSavedFileName) ? this.sqlSavedFileName : null)) {
                this.saveScriptToFile(sybFileChooser.getSelectedFile());
                if (IndexWizard.this._initialSaveFolder != null && IndexWizard.this._initialSaveFolder.length > 0) {
                    ((IndexWizard)IndexWizard.this)._initialSaveFolder[0] = sybFileChooser.getSelectedFile().getParent();
                }
            }
        }

        private void saveScriptToFile(File file) {
            try {
                String string;
                String string2 = this.editor.getText();
                StringReader stringReader = new StringReader(string2);
                BufferedReader bufferedReader = new BufferedReader(stringReader);
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                OutputStreamWriter outputStreamWriter = new OutputStreamWriter(fileOutputStream);
                String string3 = System.getProperty("line.separator");
                while ((string = bufferedReader.readLine()) != null) {
                    outputStreamWriter.write(string);
                    outputStreamWriter.write(string3);
                }
                bufferedReader.close();
                stringReader.close();
                outputStreamWriter.flush();
                outputStreamWriter.close();
                this.sqlSavedFileName = file;
            }
            catch (IOException iOException) {
                IndexWizard.this.handleError(IxtDriver.getI18NMessage(IndexWizard.ERROR_COULD_NOT_SAVE) + iOException.getMessage());
            }
        }
    }

    private class AnalysisPanel
    extends IndexWizardPanel
    implements ActionListener {
        JTabbedPane tabbedPane;
        NonEditableSortableTable indexes;
        NonEditableSortableTable affected;
        NonEditableSortableTable physical;
        NonEditableSortableTable summary;
        SybButton viewPlanButton;
        SybButton viewPlanIndexButton;
        SybLabel viewPlanLabel;
        SybLabel viewPlanIndexLabel;

        AnalysisPanel() {
            this.setLayout(new GridBagLayout());
            this.addWidgets();
            this.init();
        }

        private Vector<String> getRecommenedHeader() {
            Vector<String> vector = new Vector<String>();
            vector.add(IxtDriver.getI18NMessage(IndexWizard.ID));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.RI_CREATOR));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.RI_TABLE));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.RI_COLUMNS));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.RI_CLUSTERED));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.RI_TYPES));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.RI_PAGES));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.RI_RELATIVE_BENEFIT));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.RI_TOTAL_BENEFIT));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.RI_UPDATE_COST));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.RI_TOTAL_COST_BENEFIT));
            return vector;
        }

        private Vector<String> getUpdateHeader() {
            Vector<String> vector = new Vector<String>();
            vector.add(IxtDriver.getI18NMessage(IndexWizard.ID));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.U_QUERY_TYPE));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.U_ROWS_AFFECT));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.U_TABLES));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.U_COLUMNS));
            return vector;
        }

        private Vector<String> getUnusedHeader() {
            Vector<String> vector = new Vector<String>();
            vector.add(IxtDriver.getI18NMessage(IndexWizard.ID));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.UI_TABLE));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.UI_SECONDARY_INDEX));
            return vector;
        }

        private void createTables() throws ConnectionClosedException, SQLException {
            int n;
            int n2 = 3;
            this.generateSummaryTable();
            Vector<String> vector = new Vector<String>();
            vector.add(IxtDriver.getI18NMessage(IndexWizard.RI_CREATOR));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.RI_TABLE));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.RI_COLUMNS));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.RI_CLUSTERED));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.RI_TYPES));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.RI_PAGES));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.RI_RELATIVE_BENEFIT));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.RI_TOTAL_BENEFIT));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.RI_UPDATE_COST));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.RI_TOTAL_COST_BENEFIT));
            Vector<IxtIndex> vector2 = IndexWizard.this._analysis.getIndexResults();
            Iterator<IxtIndex> iterator = vector2.iterator();
            Vector<Vector<Object>> vector3 = new Vector<Vector<Object>>();
            while (iterator.hasNext()) {
                vector3.add(iterator.next().convertToFullIDXVector());
            }
            IxtAnalysis.TableDescriptor tableDescriptor = new IxtAnalysis.TableDescriptor(vector, vector3);
            this.addID(tableDescriptor.getData(), tableDescriptor.getHeader());
            vector = this.getRecommenedHeader();
            this.indexes = new NonEditableSortableTable(tableDescriptor.getData(), (Vector)vector);
            this.indexes.setModel(new NonEditableDefaultTableModel((Vector)tableDescriptor.getData(), (Vector)vector));
            this.indexes.createDefaultColumnsFromModel();
            boolean bl = tableDescriptor.getData().size() != 0;
            Vector<Vector<Object>> vector4 = tableDescriptor.getData();
            boolean bl2 = false;
            for (n = 0; n < vector4.size() && !bl2; ++n) {
                if (!vector4.elementAt(n).elementAt(5).equals("VIRTUAL")) continue;
                bl2 = true;
            }
            this.viewPlanIndexButton.setEnabled(bl && bl2);
            this.viewPlanIndexLabel.setEnabled(bl && bl2);
            if (IndexWizard.this._isUpdate) {
                Vector<IxtQuery> vector5 = IndexWizard.this._analysis.getAffectedResults();
                vector3 = new Vector();
                Iterator<IxtQuery> iterator2 = vector5.iterator();
                while (iterator2.hasNext()) {
                    vector3.add(iterator2.next().convertToAffectedResultsVector());
                }
                tableDescriptor = new IxtAnalysis.TableDescriptor(vector, vector3);
                vector = this.getUpdateHeader();
                this.addID(tableDescriptor.getData(), tableDescriptor.getHeader());
                for (n = 0; n < tableDescriptor.getData().size(); ++n) {
                    Vector<Object> vector6 = tableDescriptor.getData().elementAt(n);
                    vector6.remove(n2);
                }
                tableDescriptor.getHeader().remove(n2);
                this.affected = new NonEditableSortableTable(tableDescriptor.getData(), (Vector)vector);
                this.affected.setModel(new NonEditableDefaultTableModel((Vector)tableDescriptor.getData(), (Vector)vector));
                this.affected.createDefaultColumnsFromModel();
            }
            vector2 = IndexWizard.this._analysis.getPhysicalResults();
            vector3 = new Vector();
            iterator = vector2.iterator();
            while (iterator.hasNext()) {
                vector3.add(iterator.next().convertToUselessIDXVector());
            }
            tableDescriptor = new IxtAnalysis.TableDescriptor(vector, vector3);
            this.addID(tableDescriptor.getData(), tableDescriptor.getHeader());
            vector = this.getUnusedHeader();
            this.physical = new NonEditableSortableTable(tableDescriptor.getData(), (Vector)vector);
            this.physical.setModel(new NonEditableDefaultTableModel((Vector)tableDescriptor.getData(), (Vector)vector));
            this.physical.createDefaultColumnsFromModel();
        }

        private void generateSummaryTable() throws SQLException, ConnectionClosedException {
            int n = 0;
            int n2 = 0;
            double d = 0.0;
            double d2 = 0.0;
            if (!this.isVisible() || IndexWizard.this._analysis == null) {
                return;
            }
            Vector<String> vector = new Vector<String>();
            vector.add(IxtDriver.getI18NMessage(IndexWizard.ATTRIBUTE));
            vector.add(IxtDriver.getI18NMessage(IndexWizard.VALUE));
            Vector<IxtIndex> vector2 = IndexWizard.this._analysis.getIndexResults();
            if (vector2 == null) {
                IndexWizard.this.handleError(IxtDriver.getI18NMessage(IndexWizard.ERROR_NO_RESULTS));
                return;
            }
            n = vector2.size();
            for (IxtIndex object : vector2) {
                n2 = (int)((long)n2 + object.getSize());
                d += object.getDUIPenalty();
            }
            for (IxtQuery n3 : IndexWizard.this._analysis.getQueryResults()) {
                double n4 = n3.getTotalBenefit();
                if (!(n4 > 0.0)) continue;
                d2 += n4;
            }
            int n3 = IndexWizard.this._analysis.getDiscardedQueryResults().size();
            if (n3 > 0) {
                IndexWizard.this.handleError(IxtDriver.getI18NMessage(IndexWizard.ERROR_QUERIES_DISCARDED));
                throw new ConnectionClosedException();
            }
            Vector vector3 = new Vector();
            int n4 = 0;
            ++n4;
            Vector<Object> vector4 = new Vector<Object>();
            vector4.add(IxtDriver.getI18NMessage(IndexWizard.TOTAL_RECOMMENDED_INDEXES));
            vector4.add(new IxtFeedback.IxtVariableDecimal(n));
            vector3.add(vector4);
            ++n4;
            vector4 = new Vector();
            vector4.add(IxtDriver.getI18NMessage(IndexWizard.SPACE_REQUIREMENTS));
            vector4.add(new IxtFeedback.IxtVariableDecimal(n2));
            vector3.add(vector4);
            ++n4;
            vector4 = new Vector();
            vector4.add(IxtDriver.getI18NMessage(IndexWizard.MAINTENANCE_COSTS));
            vector4.add(new IxtFeedback.IxtDecimal(d));
            vector3.add(vector4);
            ++n4;
            vector4 = new Vector();
            vector4.add(IxtDriver.getI18NMessage(IndexWizard.TOTAL_BENEFITS));
            vector4.add(new IxtFeedback.IxtDecimal(d2));
            vector3.add(vector4);
            this.summary = new NonEditableSortableTable(vector3, (Vector)vector);
            this.summary.setModel(new NonEditableDefaultTableModel(vector3, (Vector)vector));
            this.summary.createDefaultColumnsFromModel();
            this.summary.setShowHorizontalLines(false);
            this.summary.setShowVerticalLines(false);
        }

        private void addTableToTabbedPane(JTable jTable, String string) {
            this.adjustTableColumnWidths(jTable);
            jTable.setAutoResizeMode(0);
            JScrollPane jScrollPane = new JScrollPane(jTable);
            this.tabbedPane.add((Component)jScrollPane, string);
        }

        private void setColumnWidth(JTable jTable, int n, int n2) {
            TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
            tableColumn.setMinWidth(n2);
            tableColumn.setMaxWidth(n2);
            tableColumn.setPreferredWidth(n2);
        }

        private void setColumnWidthToFit(JTable jTable, int n) {
            JTableHeader jTableHeader;
            TableColumn tableColumn = jTable.getColumnModel().getColumn(n);
            TableCellRenderer tableCellRenderer = tableColumn.getHeaderRenderer();
            TableCellRenderer tableCellRenderer2 = tableColumn.getCellRenderer();
            int n2 = 0;
            if (tableCellRenderer == null && (jTableHeader = jTable.getTableHeader()) != null) {
                tableCellRenderer = jTableHeader.getDefaultRenderer();
            }
            if (tableCellRenderer2 == null) {
                tableCellRenderer2 = tableCellRenderer;
            }
            if (tableCellRenderer != null) {
                n2 = tableCellRenderer.getTableCellRendererComponent((JTable)jTable, (Object)((String)tableColumn.getHeaderValue()), (boolean)false, (boolean)false, (int)-1, (int)n).getPreferredSize().width;
            }
            int n3 = jTable.getRowCount();
            for (int i = 0; i < n3; ++i) {
                int n4 = tableCellRenderer2.getTableCellRendererComponent((JTable)jTable, (Object)jTable.getValueAt((int)i, (int)n), (boolean)false, (boolean)false, (int)-1, (int)n).getPreferredSize().width;
                n2 = Math.max(n2, n4);
            }
            this.setColumnWidth(jTable, n, n2 += jTable.getIntercellSpacing().width);
        }

        private void adjustTableColumnWidths(JTable jTable) {
            int n = jTable.getColumnCount();
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            for (int i = 0; i < n; ++i) {
                this.setColumnWidthToFit(jTable, i);
                tableColumnModel.getColumn(i).setMaxWidth(Integer.MAX_VALUE);
            }
        }

        @Override
        void refresh() throws ConnectionClosedException {
            try {
                this.createTables();
                this.tabbedPane.removeAll();
                this.addTableToTabbedPane(this.summary, IxtDriver.getI18NMessage(IndexWizard.SUMMARY));
                this.addTableToTabbedPane(this.indexes, IxtDriver.getI18NMessage(IndexWizard.VIRTUAL_INDEXES));
                if (IndexWizard.this._isUpdate) {
                    this.addTableToTabbedPane(this.affected, IxtDriver.getI18NMessage(IndexWizard.UPDATES));
                }
                this.addTableToTabbedPane(this.physical, IxtDriver.getI18NMessage(IndexWizard.UNUSED));
                this.renameAnalysisToEnsureNonConflictingIndexes();
                IndexWizard.this._cancel.setText(IxtDriver.getI18NMessage(IndexWizard.CANCEL));
            }
            catch (SQLException sQLException) {
                IndexWizard.this.handleError(sQLException);
            }
        }

        @Override
        void onActive() {
            this.tabbedPane.requestFocusInWindow();
        }

        @Override
        void onNext() throws ConnectionClosedException {
            IndexWizard.this._next.setEnabled(false);
            IndexWizard.this._back.setEnabled(true);
        }

        @Override
        void destroy() {
            this.viewPlanButton.removeActionListener((ActionListener)this);
            this.viewPlanIndexButton.removeActionListener((ActionListener)this);
        }

        @Override
        void onBack() {
        }

        private void renameAnalysisToEnsureNonConflictingIndexes() throws ConnectionClosedException {
            Vector<IxtIndex> vector = null;
            Vector vector2 = null;
            String string = null;
            int n = 0;
            try {
                vector2 = new Vector();
                Vector<IxtQuery> vector3 = IndexWizard.this._analysis.getQueryResults();
                if (vector3.size() == 0) {
                    return;
                }
                string = vector3.elementAt(0).getText();
                vector = IndexWizard.this._analysis.getIndexesUsed(string);
                if (vector == null || vector.size() == 0) {
                    return;
                }
                while (true) {
                    String string2 = "SELECT count( table_name ) FROM SYSTABLE KEY JOIN SYSINDEX WHERE table_name = '" + vector.elementAt(0).getTable().getName() + "' AND index_name like '%index_consultant" + n + "%'";
                    ResultSet resultSet = IndexWizard.this._connection.prepareStatement(string2).executeQuery();
                    resultSet.next();
                    int n2 = resultSet.getInt(1);
                    if (n2 == 0) break;
                    ++n;
                }
                IndexWizard.this._analysis.updateName(IndexWizard.this._connection.getMetaData().getUserName() + "_index_consultant" + n);
            }
            catch (SQLException sQLException) {
                IndexWizard.this.handleError(sQLException);
            }
        }

        private void addWidgets() {
            SybLabel sybLabel = new SybLabel(IxtDriver.getI18NMessage(IndexWizard.TUNING_RESULTS));
            this.tabbedPane = new JTabbedPane();
            SybLabel sybLabel2 = new SybLabel(IxtDriver.getI18NMessage(IndexWizard.PLAN_VIEW));
            this.viewPlanButton = new SybButton(IxtDriver.getI18NMessage(IndexWizard.SHOW_PLAN_WITHOUT_INDEX));
            this.viewPlanIndexButton = new SybButton(IxtDriver.getI18NMessage(IndexWizard.SHOW_PLAN_WITH_INDEX));
            DialogUtils.makeComponentsSameWidth((JComponent[])new SybButton[]{this.viewPlanButton});
            this.viewPlanLabel = new SybLabel(IxtDriver.getI18NMessage(IndexWizard.WITHOUT_VIRTUAL_INDEX));
            this.viewPlanIndexLabel = new SybLabel(IxtDriver.getI18NMessage(IndexWizard.WITH_VIRTUAL_INDEX));
            IndexWizard.addComponent(this, (Component)sybLabel, 0, 0, 0, 1, 1.0, 0.0, 18, 0, INSETS, 0, 0);
            IndexWizard.addComponent(this, this.tabbedPane, 0, 1, 0, 1, 1.0, 0.9, 18, 1, INSETS, 0, 0);
            IndexWizard.addComponent(this, (Component)sybLabel2, 0, 2, 0, 1, 1.0, 0.0, 18, 2, INSETS, 0, 0);
            IndexWizard.addComponent(this, (Component)this.viewPlanButton, 1, 3, 1, 1, 0.0, 0.0, 13, 2, INSETS_NONE, 0, 0);
            IndexWizard.addComponent(this, (Component)this.viewPlanLabel, 2, 3, 5, 1, 0.0, 0.0, 13, 2, INSETS_LEFT, 0, 0);
            IndexWizard.addComponent(this, (Component)this.viewPlanIndexButton, 1, 4, 1, 1, 0.0, 0.0, 13, 2, INSETS_NONE, 0, 0);
            IndexWizard.addComponent(this, (Component)this.viewPlanIndexLabel, 2, 4, 5, 1, 0.0, 0.1, 13, 2, INSETS_LEFT, 0, 0);
        }

        private void init() {
            this.viewPlanButton.addActionListener((ActionListener)this);
            this.viewPlanIndexButton.addActionListener((ActionListener)this);
        }

        private void addID(Vector<Vector<Object>> vector, Vector<String> vector2) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                Vector<Object> vector3 = vector.get(i);
                if (vector3 == null) continue;
                vector3.add(0, new Integer(i + 1));
            }
            vector2.add(0, IxtDriver.getI18NMessage(IndexWizard.ID));
        }

        private void showPlanViewer(boolean bl) {
            IndexWizardPlanViewer.create((JDialog)((Object)IndexWizard.this._this), IndexWizard.this._inputSql, IndexWizard.this._loggingSession, IndexWizard.this._queryID, IndexWizard.this._analysis, bl, this.viewPlanIndexButton.isEnabled(), IndexWizard.this._connection);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.viewPlanButton) {
                this.showPlanViewer(false);
            } else if (object == this.viewPlanIndexButton) {
                this.showPlanViewer(true);
            }
        }
    }

    private class IndexSizePanel
    extends IndexWizardPanel
    implements ItemListener {
        SybCheckBox limitSizeCheckBox;
        SybRadioButton maximumSizeRadioButton;
        SybRadioButton maximumPercentRadioButton;
        WizardIntegerTextField maximumSizeIntegerTextField;
        WizardIntegerTextField maximumPercentIntegerTextField;
        SybLabel megabyteLabel;
        SybLabel percentageLabel;
        SybLabel physicalIndexSizeIntegerTextField;
        SybLabel physicalIndexPercentIntegerTextField;

        IndexSizePanel() {
            this.setLayout(new GridBagLayout());
            this.addWidgets();
            this.addListeners();
        }

        @Override
        void refresh() throws ConnectionClosedException {
            this.initFields();
        }

        @Override
        void onActive() {
            this.limitSizeCheckBox.requestFocusInWindow();
        }

        @Override
        void destroy() {
            this.limitSizeCheckBox.removeItemListener((ItemListener)this);
            this.maximumSizeRadioButton.removeItemListener((ItemListener)this);
            this.maximumPercentRadioButton.removeItemListener((ItemListener)this);
        }

        @Override
        void onNext() throws ConnectionClosedException {
            IndexWizard.this._back.setEnabled(false);
            this.applyWorkload();
        }

        @Override
        void onBack() {
            IndexWizard.this._back.setEnabled(false);
        }

        private void addWidgets() {
            SybTextArea sybTextArea = IndexWizard.this.makeTextArea(IxtDriver.getI18NMessage(IndexWizard.LIMIT_INDEX_SIZE_DESCRIPTION));
            IndexWizard.addComponent(this, (Component)sybTextArea, 0, 0, 0, 1, 1.0, 0.0, 17, 2, INSETS, 0, 0);
            IndexWizard.addComponent(this, this.createIndexSizePanel(), 0, 1, 0, 1, 0.0, 1.0, 18, 2, INSETS_HORIZONTAL_INDENT, 0, 0);
        }

        private JPanel createIndexSizePanel() {
            int n = 0;
            int n2 = 350;
            JPanel jPanel = new JPanel();
            jPanel.setPreferredSize(new Dimension(500, 350));
            jPanel.setLayout(new GridBagLayout());
            this.limitSizeCheckBox = new SybCheckBox(IxtDriver.getI18NMessage(IndexWizard.LIMIT_INDEX_SIZE_TO));
            IndexWizard.addComponent(jPanel, (Component)this.limitSizeCheckBox, 1, n, 0, 1, 1.0, 1.0, 17, 2, INSETS_NONE, 0, 0);
            this.maximumSizeRadioButton = new SybRadioButton();
            this.maximumSizeIntegerTextField = new WizardIntegerTextField(4);
            this.maximumPercentRadioButton = new SybRadioButton();
            this.maximumPercentIntegerTextField = new WizardIntegerTextField(4);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add((AbstractButton)this.maximumSizeRadioButton);
            buttonGroup.add((AbstractButton)this.maximumPercentRadioButton);
            this.megabyteLabel = new SybLabel(IxtDriver.getI18NMessage(IndexWizard.MEGABYTES));
            this.maximumSizeRadioButton.setMnemonic(this.megabyteLabel.getEmbeddedMnemonic().getMnemonic());
            this.percentageLabel = new SybLabel(IxtDriver.getI18NMessage(IndexWizard.PERCENT_OF_TABLE));
            this.maximumPercentRadioButton.setMnemonic(this.percentageLabel.getEmbeddedMnemonic().getMnemonic());
            IndexWizard.addComponent(jPanel, (Component)this.maximumPercentRadioButton, 1, ++n, 1, 1, 0.0, 0.0, 21, 0, INSETS_HORIZONTAL_INDENT, 0, 0);
            IndexWizard.addComponent(jPanel, this.maximumPercentIntegerTextField, 2, n, 1, 1, 0.0, 0.0, 21, 2, INSETS, 0, 0);
            IndexWizard.addComponent(jPanel, (Component)this.percentageLabel, 3, n, 0, 1, 0.96, 0.0, 21, 2, new Insets(8, 5, 5, 5), 0, 0);
            IndexWizard.addComponent(jPanel, Box.createHorizontalStrut(n2), 4, n, 0, 1, 0.0, 0.0, 21, 2, INSETS_HORIZONTAL, 0, 0);
            IndexWizard.addComponent(jPanel, (Component)this.maximumSizeRadioButton, 1, ++n, 1, 1, 0.0, 0.0, 21, 0, INSETS_HORIZONTAL_INDENT, 0, 0);
            IndexWizard.addComponent(jPanel, this.maximumSizeIntegerTextField, 2, n, 1, 1, 0.0, 0.0, 21, 2, INSETS, 0, 0);
            IndexWizard.addComponent(jPanel, (Component)this.megabyteLabel, 3, n, 0, 1, 0.96, 0.0, 21, 2, new Insets(8, 5, 5, 5), 0, 0);
            IndexWizard.addComponent(jPanel, Box.createHorizontalStrut(n2), 4, n, 0, 1, 0.0, 0.0, 21, 2, INSETS_HORIZONTAL, 0, 0);
            IndexWizard.addComponent(jPanel, this.createPhysicalIndexPanel(), 0, ++n, 0, 1, 0.0, 0.0, 18, 0, INSETS_NONE, 0, 0);
            return jPanel;
        }

        JPanel createPhysicalIndexPanel() {
            Insets insets = new Insets(5, 30, 5, 5);
            int n = 0;
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            SybLabel sybLabel = new SybLabel(IxtDriver.getI18NMessage(IndexWizard.CURRENT_SIZE_OF_INDEX));
            SybLabel sybLabel2 = new SybLabel(IxtDriver.getI18NMessage(IndexWizard.MEGABYTES_CURRENT));
            SybLabel sybLabel3 = new SybLabel(IxtDriver.getI18NMessage(IndexWizard.PERCENT_OF_TABLE_CURRENT));
            this.physicalIndexSizeIntegerTextField = new SybLabel();
            this.physicalIndexPercentIntegerTextField = new SybLabel();
            IndexWizard.addComponent(jPanel, (Component)sybLabel, 0, n, 0, 1, 1.0, 0.0, 18, 2, INSETS, 0, 0);
            IndexWizard.addComponent(jPanel, (Component)this.physicalIndexSizeIntegerTextField, 2, ++n, 1, 1, 0.0, 0.0, 18, 2, insets, 0, 0);
            IndexWizard.addComponent(jPanel, (Component)sybLabel2, 3, n, 0, 1, 0.96, 0.0, 18, 2, INSETS, 0, 0);
            IndexWizard.addComponent(jPanel, (Component)this.physicalIndexPercentIntegerTextField, 2, ++n, 1, 1, 0.0, 0.0, 18, 2, insets, 0, 0);
            IndexWizard.addComponent(jPanel, (Component)sybLabel3, 3, n, 0, 1, 0.96, 0.0, 18, 2, INSETS, 0, 0);
            return jPanel;
        }

        private void initFields() throws ConnectionClosedException {
            int n = 0;
            this.limitSizeCheckBox.setSelected(true);
            this.maximumPercentRadioButton.setSelected(true);
            this.maximumPercentIntegerTextField.setText("100");
            try {
                IndexWizard.this._ixtDB;
                n = IxtDB.getNumberPhysicalIndexPages(IndexWizard.this._connection);
                if (n < 0) {
                    n = 0;
                }
                IndexWizard.this._ixtDB;
                this.physicalIndexSizeIntegerTextField.setText(Integer.toString((int)((long)(n * IxtDB.getPageSize(IndexWizard.this._connection)) / 1000000L)));
                this.physicalIndexPercentIntegerTextField.setText("0");
                IndexWizard.this._ixtDB;
                if (IxtDB.getNumberTablePages(IndexWizard.this._connection) > 0) {
                    IndexWizard.this._ixtDB;
                    this.physicalIndexPercentIntegerTextField.setText(Integer.toString(100 * n / IxtDB.getNumberTablePages(IndexWizard.this._connection)));
                }
            }
            catch (SQLException sQLException) {
                IndexWizard.this.handleError(sQLException);
            }
        }

        private void addListeners() {
            this.limitSizeCheckBox.addItemListener((ItemListener)this);
            this.maximumSizeRadioButton.addItemListener((ItemListener)this);
            this.maximumPercentRadioButton.addItemListener((ItemListener)this);
        }

        private void enableComponents() {
            boolean bl = this.limitSizeCheckBox.isSelected();
            this.maximumSizeRadioButton.setEnabled(bl);
            this.maximumSizeIntegerTextField.setEnabled(bl && this.maximumSizeRadioButton.isSelected());
            if (this.maximumSizeIntegerTextField.isEnabled()) {
                this.maximumSizeIntegerTextField.requestFocusInWindow();
            }
            this.maximumPercentRadioButton.setEnabled(bl);
            this.maximumPercentIntegerTextField.setEnabled(bl && this.maximumPercentRadioButton.isSelected());
            if (this.maximumPercentIntegerTextField.isEnabled()) {
                this.maximumPercentIntegerTextField.requestFocusInWindow();
            }
            this.megabyteLabel.setEnabled(bl);
            this.percentageLabel.setEnabled(bl);
        }

        void applyWorkload() throws ConnectionClosedException {
            int n = Integer.MAX_VALUE;
            int n2 = 0;
            try {
                if (this.limitSizeCheckBox.isSelected()) {
                    if (this.maximumSizeRadioButton.isSelected()) {
                        int n3 = this.maximumSizeIntegerTextField.getValue() * 1000000;
                        IndexWizard.this._ixtDB;
                        n = n3 / IxtDB.getPageSize(IndexWizard.this._connection);
                    } else {
                        int n4 = this.maximumPercentIntegerTextField.getValue();
                        IndexWizard.this._ixtDB;
                        n = n4 * IxtDB.getNumberTablePages(IndexWizard.this._connection);
                    }
                } else {
                    n = Integer.MAX_VALUE;
                }
                if (IndexWizard.this._analysis != null) {
                    IndexWizard.this._analysis.delete();
                    IndexWizard.this._analysis = null;
                }
                IndexWizard.this._analysis = new IxtAnalysis(IndexWizard.this._connection, IndexWizard.this._connection.getMetaData().getUserName() + "_index_consultant", 0L, null, IndexWizard.this._version);
                IndexWizard.this._driver = new IxtDriver(((IndexWizard)IndexWizard.this)._optionsPanel.clusteredCheckBox.isSelected(), ((IndexWizard)IndexWizard.this)._optionsPanel.keepExistingCheckBox.isSelected(), n, IndexWizard.this._analysis, IndexWizard.this._connection);
                if (IndexWizard.this._loggingSession == 0 && IndexWizard.this._queryID == 0L) {
                    IndexWizard.this._analysis.populateAnalysisFromSingleQuery(IndexWizard.this._inputSql);
                } else {
                    IndexWizard.this._analysis.populateAnalysisFromSingleQuery(IndexWizard.this._loggingSession, IndexWizard.this._queryID);
                }
                n2 = IndexWizard.this._driver.tune();
                if (n2 != 0) {
                    IndexWizard.this.handleError(IxtDriver.getI18NMessage(IndexWizard.ERROR_WHILE_TUNING));
                }
            }
            catch (Exception exception) {
                IndexWizard.this.handleError(exception);
            }
        }

        @Override
        public void itemStateChanged(ItemEvent itemEvent) {
            this.enableComponents();
        }
    }

    private class OptionsPanel
    extends IndexWizardPanel {
        SybCheckBox clusteredCheckBox;
        SybCheckBox keepExistingCheckBox;

        OptionsPanel() {
            this.setLayout(new GridBagLayout());
            this.addWidgets();
            this.initFields();
        }

        private void addWidgets() {
            this.clusteredCheckBox = new SybCheckBox(IxtDriver.getI18NMessage(IndexWizard.RECOMMEND_CLUSTERED_INDEX));
            SybTextArea sybTextArea = IndexWizard.this.makeTextArea(IxtDriver.getI18NMessage(IndexWizard.CLUSTERED_DESCRIPTION));
            IndexWizard.addComponent(this, (Component)sybTextArea, 0, 0, 0, 1, 1.0, 0.0, 18, 2, INSETS_NONE, 0, 0);
            IndexWizard.addComponent(this, (Component)this.clusteredCheckBox, 0, 1, 0, 1, 1.0, 0.0, 18, 2, INSETS_NONE, 0, 0);
            IndexWizard.addComponent(this, Box.createVerticalStrut(4), 0, 2, 0, 1, 1.0, 0.1, 18, 2, INSETS_NONE, 0, 0);
            this.keepExistingCheckBox = new SybCheckBox(IxtDriver.getI18NMessage(IndexWizard.KEEP_2ND_INDEX));
            SybTextArea sybTextArea2 = IndexWizard.this.makeTextArea(IxtDriver.getI18NMessage(IndexWizard.KEEP_2ND_INDEX_DESCRIPTION));
            IndexWizard.addComponent(this, (Component)sybTextArea2, 0, 3, 0, 1, 1.0, 0.0, 18, 2, INSETS_NONE, 0, 0);
            IndexWizard.addComponent(this, (Component)this.keepExistingCheckBox, 0, 4, 0, 1, 1.0, 0.0, 18, 2, INSETS_NONE, 0, 0);
            IndexWizard.addComponent(this, Box.createVerticalStrut(4), 0, 5, 0, 1, 1.0, 0.9, 18, 2, INSETS_NONE, 0, 0);
        }

        private void initFields() {
            this.clusteredCheckBox.setSelected(true);
            this.keepExistingCheckBox.setSelected(true);
        }

        @Override
        void refresh() {
        }

        @Override
        void onActive() {
            this.clusteredCheckBox.requestFocusInWindow();
        }

        @Override
        void destroy() {
        }

        @Override
        void onNext() throws ConnectionClosedException {
            IndexWizard.this._back.setEnabled(true);
        }

        @Override
        void onBack() {
        }
    }

    private static abstract class IndexWizardPanel
    extends JPanel {
        private IndexWizardPanel() {
        }

        abstract void refresh() throws ConnectionClosedException;

        abstract void onActive();

        abstract void destroy();

        abstract void onNext() throws ConnectionClosedException;

        abstract void onBack();
    }
}

