/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.indexConsultant;

import com.sybase.asa.planview.AccessPlanViewer;
import com.sybase.indexConsultant.IndexWizard;
import com.sybase.indexConsultant.IxtAnalysis;
import com.sybase.indexConsultant.IxtDriver;
import com.sybase.indexConsultant.IxtIndex;
import com.sybase.util.SwingWorker;
import com.sybase.util.SybButton;
import com.sybase.util.SybLabel;
import com.sybase.util.SybModalDialog;
import com.sybase.util.SybTextArea;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;

public class IndexWizardPlanViewer
extends SybModalDialog
implements MouseListener,
ActionListener {
    private static final String ESCAPE_KEY_COMMAND = "EscapeKey";
    private IndexTunerPlanViewerPanel _planViewer;
    private boolean _hasCompleted;
    private IxtAnalysis _analysis;
    private String _queryText;
    private int _loggingSession;
    private long _queryID;
    private boolean _useVirt;
    private boolean _virtualIndexAllowed;
    private Vector<String> _dropIndexes;
    private Connection _conn;
    private IndexWizardPlanViewer _indexPlanViewer;

    static void create(JDialog jDialog, String string, int n, long l, IxtAnalysis ixtAnalysis, boolean bl, boolean bl2, Connection connection) {
        IndexWizardPlanViewer indexWizardPlanViewer = new IndexWizardPlanViewer(jDialog, string, n, l, ixtAnalysis, bl, bl2, connection);
        indexWizardPlanViewer.setVisible(true);
        indexWizardPlanViewer.destroy();
    }

    public void destroy() {
        if (this._hasCompleted) {
            this._planViewer.removeAccessPlan();
        }
        this.removeVirtualIndex();
        this.removeMouseListener(this);
    }

    private IndexWizardPlanViewer(JDialog jDialog, String string, int n, long l, IxtAnalysis ixtAnalysis, boolean bl, boolean bl2, Connection connection) {
        super((Dialog)jDialog);
        this.addMouseListener(this);
        this._indexPlanViewer = this;
        this._virtualIndexAllowed = bl2;
        this._useVirt = bl;
        this._queryText = string;
        this._loggingSession = n;
        this._queryID = l;
        this._analysis = ixtAnalysis;
        this._hasCompleted = false;
        this._planViewer = new IndexTunerPlanViewerPanel(this);
        this._conn = connection;
        this.setTitle(IxtDriver.getI18NMessage("PLAN_VIEWER"));
        Container container = this.getContentPane();
        container.add(this._planViewer);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(27, 0, true), 2);
        this.getRootPane().registerKeyboardAction(this, ESCAPE_KEY_COMMAND, KeyStroke.getKeyStroke(10, 0, true), 2);
        this.pack();
        this.setLocationRelativeTo(jDialog);
        this.prepareVirtualIndex();
        this.displayPlan();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
    }

    private void prepareVirtualIndex() {
        Vector<IxtIndex> vector = null;
        Vector<String> vector2 = null;
        String string = null;
        if (!this._useVirt) {
            return;
        }
        try {
            vector2 = new Vector<String>();
            string = this._analysis.getQueryResults().elementAt(0).getText();
            vector = this._analysis.getIndexesUsed(string);
            for (int i = 0; i < vector.size(); ++i) {
                vector2.add(vector.elementAt(i).isClustered() ? "CLUSTERED" : "");
            }
            this._dropIndexes = this._analysis.createVirtualIndexes(vector, vector2, 0);
        }
        catch (SQLException sQLException) {
            try {
                IndexWizard.handleError(sQLException, (Component)((Object)this._indexPlanViewer));
                this._analysis.dropVirtualIndexes(this._dropIndexes);
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            return;
        }
    }

    private void removeVirtualIndex() {
        if (this._useVirt) {
            try {
                this._analysis.dropVirtualIndexes(this._dropIndexes);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    private void displayPlan() {
        this._planViewer.startWorker();
        this._planViewer.setFocusable(true);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        this.setSize();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        this.setSize();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        this.setSize();
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.setSize();
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.setSize();
    }

    private void setSize() {
        this._planViewer.setPreferredSize(this._planViewer.getSize());
    }

    private JScrollPane makeScrollPane(JComponent jComponent) {
        JScrollPane jScrollPane = new JScrollPane(jComponent);
        return jScrollPane;
    }

    class IndexTunerPlanViewerPanel
    extends JPanel
    implements ActionListener {
        AccessPlanViewer accessPlan = null;
        SybLabel statusLabel;
        SybTextArea tempText;
        private SwingWorker worker;
        SybButton showPlanButton;
        JScrollPane scrollPane;
        IndexTunerPlanViewerPanel _indexTunerPlanViewer;

        IndexTunerPlanViewerPanel(IndexWizardPlanViewer indexWizardPlanViewer2) {
            this.setLayout(new GridBagLayout());
            int n = 100;
            this._indexTunerPlanViewer = this;
            this.statusLabel = new SybLabel(IxtDriver.getI18NMessage("LOADING_PLAN"));
            this.tempText = new SybTextArea(IxtDriver.getI18NMessage("WORKING"));
            this.tempText.setEditable(false);
            this.scrollPane = IndexWizardPlanViewer.this.makeScrollPane((JComponent)this.tempText);
            IndexWizard.addComponent(this, this.scrollPane, 0, 2, 0, 1, 0.0, 1.0, 10, 1, IndexWizard.INSETS, 0, 0);
            this.showPlanButton = new SybButton(IxtDriver.getI18NMessage("SHOW_PLAN_WITHOUT_INDEX"));
            this.showPlanButton.addActionListener((ActionListener)this);
            this.setPlanLabel();
            IndexWizard.addComponent(this, Box.createGlue(), 0, 3, 1, 1, 0.5, 0.0, 10, 2, IndexWizard.INSETS_NONE, 0, 0);
            if (IndexWizardPlanViewer.this._virtualIndexAllowed) {
                IndexWizard.addComponent(this, Box.createHorizontalStrut(n), 0, 3, 1, 1, 5.0, 0.0, 10, 2, IndexWizard.INSETS_NONE, 0, 0);
                IndexWizard.addComponent(this, (Component)this.showPlanButton, 1, 3, 1, 1, 0.1, 0.0, 13, 0, IndexWizard.INSETS, 0, 0);
                IndexWizard.addComponent(this, Box.createHorizontalStrut(n), 3, 3, 1, 1, 5.0, 0.0, 17, 2, IndexWizard.INSETS_NONE, 0, 0);
            }
            this.setPreferredSize(new Dimension(500, 450));
        }

        void setPlanLabel() {
            if (IndexWizardPlanViewer.this._useVirt) {
                this.showPlanButton.setText(IxtDriver.getI18NMessage("REMOVE_VIRT_INDEX"));
            } else {
                this.showPlanButton.setText(IxtDriver.getI18NMessage("SHOW_VIRT_INDEX"));
            }
        }

        void removeAccessPlan() {
            if (this.accessPlan != null) {
                this.remove(this.accessPlan);
                this.accessPlan = null;
            }
            IndexWizard.addComponent(this, this.scrollPane, 0, 2, 0, 1, 0.0, 1.0, 10, 1, IndexWizard.INSETS, 0, 0);
        }

        void displayAccessPlan() {
            this.remove(this.scrollPane);
            IndexWizard.addComponent(this, this.accessPlan, 0, 2, 0, 1, 0.0, 1.0, 10, 1, IndexWizard.INSETS, 0, 0);
        }

        void startWorker() {
            this.worker = new SwingWorker(1, false){

                public Object construct() {
                    IndexWizardPlanViewer.this._indexPlanViewer.setCursor(new Cursor(3));
                    IndexWizardPlanViewer.this._planViewer.setCursor(new Cursor(3));
                    IndexWizard.addComponent(IndexTunerPlanViewerPanel.this._indexTunerPlanViewer, (Component)IndexTunerPlanViewerPanel.this.statusLabel, 0, 1, 0, 1, 1.0, 0.0, 17, 1, IndexWizard.INSETS, 0, 0);
                    IndexWizardPlanViewer.this.pack();
                    IndexTunerPlanViewerPanel.this.repaint();
                    IndexTunerPlanViewerPanel.this.displayGraphicalPlan();
                    return null;
                }

                public void finished() {
                    IndexTunerPlanViewerPanel.this.setFocusable(true);
                    IndexWizardPlanViewer.this._indexPlanViewer.setCursor(new Cursor(0));
                    IndexWizardPlanViewer.this._planViewer.setCursor(new Cursor(0));
                    IndexTunerPlanViewerPanel.this._indexTunerPlanViewer.remove((Component)IndexTunerPlanViewerPanel.this.statusLabel);
                    IndexWizardPlanViewer.this.pack();
                    IndexTunerPlanViewerPanel.this.repaint();
                    IndexWizardPlanViewer.this._hasCompleted = true;
                }
            };
            this.worker.start();
        }

        public void displayGraphicalPlan() {
            Vector<String> vector = null;
            this.showPlanButton.setEnabled(false);
            try {
                if (IndexWizardPlanViewer.this._queryText != null) {
                    vector = IndexWizardPlanViewer.this._analysis.getPlan(IndexWizardPlanViewer.this._queryText, IndexWizardPlanViewer.this._loggingSession, IndexWizardPlanViewer.this._queryID);
                }
            }
            catch (SQLException sQLException) {
                vector = null;
            }
            if (vector == null) {
                this.tempText.setText(IxtDriver.getI18NMessage("ERROR_PLAN_OBTAINABLE"));
            } else {
                int n;
                StringBuffer stringBuffer = new StringBuffer(256);
                int n2 = vector.size();
                for (n = 0; n < n2; ++n) {
                    if (n > 0) {
                        stringBuffer.append("\n");
                    }
                    stringBuffer.append(vector.elementAt(n).toString());
                }
                if (this.accessPlan != null) {
                    this.removeAccessPlan();
                }
                this.accessPlan = new AccessPlanViewer(null, null, null);
                n = this.accessPlan.setPlan(new StringReader(stringBuffer.toString())) ? 1 : 0;
                if (n != 0) {
                    try {
                        this.accessPlan.requestFocus();
                        this.displayAccessPlan();
                    }
                    catch (Exception exception) {}
                } else {
                    this.accessPlan = null;
                    this.tempText.setText(IxtDriver.getI18NMessage("ERROR_PLAN_OBTAINABLE"));
                }
            }
            this.setPlanLabel();
            this.showPlanButton.setEnabled(true);
        }

        private void switchGraphicalPlan() {
            this.removeAccessPlan();
            IndexWizardPlanViewer.this.removeVirtualIndex();
            IndexWizardPlanViewer.this._useVirt = !IndexWizardPlanViewer.this._useVirt && IndexWizardPlanViewer.this._virtualIndexAllowed;
            IndexWizardPlanViewer.this.prepareVirtualIndex();
            this.startWorker();
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == this.showPlanButton) {
                this.switchGraphicalPlan();
            }
        }
    }
}

