/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.indexConsultant;

import com.sybase.indexConsultant.IxtColumn;
import com.sybase.indexConsultant.IxtConfiguration;
import com.sybase.indexConsultant.IxtDB;
import com.sybase.indexConsultant.IxtDBVersion10;
import com.sybase.indexConsultant.IxtDBVersion9;
import com.sybase.indexConsultant.IxtElement;
import com.sybase.indexConsultant.IxtIndex;
import com.sybase.indexConsultant.IxtPhase;
import com.sybase.indexConsultant.IxtQuery;
import com.sybase.indexConsultant.IxtTable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class IxtAnalysis {
    String _timestamp;
    long _id;
    boolean _wasSaved;
    Connection _conn;
    String _name;
    static HashMap<Long, IxtTable> _tables = new HashMap();
    static Vector<IxtColumn> _columns = new Vector();
    static HashMap<Long, IxtQuery> _queries = new HashMap();
    static Vector<IxtIndex> _physicalindexes = new Vector();
    static Vector<IxtIndex> _virtualindexes = new Vector();
    Vector<IxtIndex> _indexesUsed;
    Vector<IxtIndex> _uselessIndexes;
    Vector<IxtQuery> _queriesUsed;
    Vector<IxtQuery> _queriesDiscarded;
    Vector<IxtQuery> _affectedResults;
    int _max_table_size;
    boolean _configsLoaded;
    IxtDB _ixtDB;
    int _version;
    String _logging_session_id;
    private boolean _managesOwnAnalysis;
    private boolean _tablesLoaded = false;
    private boolean _indexesLoaded = false;
    private boolean _queriesLoaded = false;
    private IxtPhase _lastPhase;
    private static final String GET_INDEXES_SQL = "select sup.user_name, st.table_name as \"Table\", list( STRING(sc.column_id) + '|' + sc.column_name + '|' + if iix.column_order = 'D' then 'DESC' else '' endif order by iix.sequence ) as \"Columns\", if is_clustered = 2 then 'CLUSTERED' else '' endif as \"Clustered\", if is_virtual = 1 then 'VIRTUAL' else 'PHYSICAL' endif as \"Type\", num_pages as \"Pages\", round(tool_relative_benefit, 0) as \"Relative Benefit\", \"Total Cost Benefit\" - \"Update Cost\" as \"Total Benefit\", round(tool_update_cost, 2) as \"Update Cost\", round(tool_total_benefit, 2) as \"Total Cost Benefit\", ii.table_id, ii.index_id from dbo.ix_consultant_index ii natural join (select index_id,table_id,column_id,column_order,sequence from dbo.ix_consultant_ixcol ic where ic.master_id = ? and ic.phase_id = ( select max(phase_id) from dbo.ix_consultant_query_phase where master_id = ? ) UNION select index_id,table_id,column_id,\"order\",sequence from SYS.SYSIXCOL) as iix join SYS.SYSTABLE st on ii.table_id = st.table_id join SYS.SYSUSERPERMS sup on sup.user_id = st.creator join SYS.SYSCOLUMN sc on ii.table_id = sc.table_id and iix.column_id = sc.column_id where ii.master_id = ? and \"Total Cost Benefit\" is not NULL and ii.phase_id = ( select max(phase_id) from dbo.ix_consultant_query_phase where master_id = ? ) group by sup.user_name, \"table\", ii.table_id, ii.index_id, \"clustered\", \"Type\", num_pages, \"Relative Benefit\", \"Total Cost Benefit\", \"Update Cost\", \"Total Benefit\"  order by ii.table_id, ii.index_id; ";
    private static final String GET_USELESS_PHYSICAL_SQL = " select distinct table_name as \"Table\", index_name as \"Secondary Index\", sup.user_name, SYS.SYSINDEX.index_id, SYS.SYSINDEX.table_id  from SYS.SYSINDEX  join SYS.SYSTABLE on SYS.SYSINDEX.table_id = SYS.SYSTABLE.table_id  join SYS.SYSUSERPERMS sup on sup.user_id = SYS.SYSTABLE.creator  where SYS.SYSINDEX.table_id in (select table_id from dbo.ix_consultant_query_index  where master_id = ?)  and SYS.SYSTABLE.creator <> 3 and SYS.SYSTABLE.creator <> 0  except  select distinct SYS.SYSTABLE.table_name as \"Table\",  SYS.SYSINDEX.index_name as \"Secondary Index\",  sup.user_name,  dbo.ix_consultant_index.index_id,  dbo.ix_consultant_index.table_id  from dbo.ix_consultant_index natural join SYS.SYSINDEX  join SYS.SYSTABLE on SYS.SYSINDEX.table_id = SYS.SYSTABLE.table_id  join SYS.SYSUSERPERMS sup on sup.user_id = SYS.SYSTABLE.creator  where master_id = ? and phase_id = (select max(phase_id) from dbo.ix_consultant_query_phase where master_id = ?) ";

    public IxtDB getIxtDB() {
        return this._ixtDB;
    }

    public IxtAnalysis(Connection connection, String string, long l, String string2, int n) {
        this._name = string;
        this._timestamp = string2;
        this._id = l;
        this._wasSaved = false;
        this._conn = connection;
        this._version = n;
        this._ixtDB = this._version == 9 ? new IxtDBVersion9() : new IxtDBVersion10();
        this._indexesUsed = new Vector();
        this._uselessIndexes = new Vector();
        this._queriesUsed = new Vector();
        this._queriesDiscarded = new Vector();
        this._affectedResults = new Vector();
        _columns = new Vector();
        this._max_table_size = 0;
        this._configsLoaded = false;
    }

    public void sendPhase(IxtPhase ixtPhase) {
        this._lastPhase = ixtPhase;
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        return this.getName();
    }

    public void setSaved(boolean bl) {
        this._wasSaved = bl;
    }

    public boolean isSaved() {
        return this._wasSaved;
    }

    public void delete() throws SQLException {
        Statement statement = this._conn.createStatement();
        statement.execute("call dbo.sa_remove_index_consultant_analysis( " + this._id + " )");
        if (this._version != 9 && this._managesOwnAnalysis) {
            statement.execute("call dbo.sa_remove_tracing_data( " + this._logging_session_id + " )");
        }
        this._conn.commit();
        statement.close();
    }

    public void updateName(String string) throws SQLException {
        String string2 = "update dbo.ix_consultant_master set name = '" + string + "' where name = '" + this.getName() + "'";
        Statement statement = this._conn.createStatement();
        statement.execute(string2);
        this._conn.commit();
        statement.close();
        this._name = string;
    }

    public IxtTable findTable(long l) {
        return _tables.get(new Long(l));
    }

    public void populateAnalysisFromSingleQuery(String string) throws SQLException {
        string = this.makeCanonical(string);
        Statement statement = this._conn.createStatement();
        if (this._version == 9) {
            String string2 = "begin declare my_user_id integer; select uid into my_user_id from sysusers where name = connection_property( 'UserID' ); insert into ix_consultant_workload values( default, " + this._id + ", my_user_id, 1, connection_property( 'CurrentCacheSize' ), 1, 9, 2, NULL, " + string + ", NULL, NULL ); " + "commit; " + "end; ";
            statement.execute(string2);
            this._conn.commit();
        } else {
            String string3 = "begin \ndeclare logging_session integer; \ndeclare user_object_id_var bigint; \ndeclare supplied_master_id integer; \ndeclare querystr long varchar; \nset supplied_master_id = " + this._id + "; \n" + "set querystr = " + string + "; \n" + "select object_id into user_object_id_var from sysuser where user_name = connection_property('UserID'); \n" + "select max(logging_session_id) into logging_session from dbo.sa_diagnostic_request; \n" + "set logging_session = if logging_session is null then 1 else logging_session+1 endif; \n" + "insert into dbo.sa_diagnostic_connection values( logging_session, connection_property('Number'), NULL, connection_property('UserID'), NULL, NULL, NULL ); \n" + "insert into dbo.sa_diagnostic_statement values( logging_session, 1, NULL, NULL, 123, querystr ); \n" + "insert into dbo.sa_diagnostic_query values( logging_session, 1, 1, user_object_id_var, current time, property('CurrentCacheSize') * 1024, 1, 9, 2, 1, 15, 5, 40, 0, 0, NULL, NULL, NULL ); \n" + "insert into dbo.sa_diagnostic_cursor values( logging_session, 1, 1, connection_property('isolation_level'), 0, 0, 0, 0, 0, 0, NULL ); \n" + "insert into dbo.sa_diagnostic_request( logging_session_id, request_id, start_time, finish_time, duration_ms, connection_number, request_type, statement_id, query_id, cursor_id, sql_code ) \n" + "values( logging_session, 1, current time, current time, 0, connection_property( 'Number' ), 3, NULL, NULL, 1, NULL ); \n" + "insert into ix_consultant_query_text( master_id, logging_session, text_id, count ) \n" + "select supplied_master_id, logging_session_id, query_id, count(*) \n" + "from dbo.sa_diagnostic_query q where q.logging_session_id = logging_session \n" + "group by query_id, logging_session_id; \n" + "end; ";
            System.out.println(string3);
            statement.execute(string3);
            this._conn.commit();
            ResultSet resultSet = statement.executeQuery("select logging_session from ix_consultant_query_text where master_id = " + this._id);
            resultSet.next();
            this._logging_session_id = resultSet.getString(1);
            System.out.println("Got this far!");
        }
        statement.close();
        this._managesOwnAnalysis = true;
    }

    public void populateAnalysisFromSingleQuery(int n, long l) throws SQLException {
        this._logging_session_id = Long.toString(n);
        String string = "insert into ix_consultant_query_text( master_id, logging_session, text_id, count ) values( " + this._id + ", " + this._logging_session_id + ", " + Long.toString(l) + ", 1 ) ";
        Statement statement = this._conn.createStatement();
        statement.execute(string);
        this._conn.commit();
        statement.close();
        this._managesOwnAnalysis = false;
    }

    private String makeCanonical(String string) {
        return "'" + string.replace("'", "''") + "'";
    }

    public String getTimestamp() {
        return this._timestamp;
    }

    public void setID(long l) {
        this._id = l;
    }

    public long getID() {
        return this._id;
    }

    public HashMap<Long, IxtTable> getTables() {
        return _tables;
    }

    public void clearTableVirtIndexes() {
        for (IxtTable ixtTable : _tables.values()) {
            ixtTable.clearVirtIndexes();
        }
    }

    public int getMaxTableSize() {
        return this._max_table_size;
    }

    public Iterator<IxtQuery> getQueryIterator() {
        return _queries.values().iterator();
    }

    public Iterator<IxtIndex> getPhysicalIndexIterator() {
        return this.getPhysicalIndexes().iterator();
    }

    public Vector<IxtIndex> getPhysicalIndexes() {
        return _physicalindexes;
    }

    static Vector<Vector<Object>> getVectorFromResultSet(ResultSet resultSet) throws SQLException {
        Vector<Vector<Object>> vector = new Vector<Vector<Object>>();
        int n = resultSet.getMetaData().getColumnCount();
        while (resultSet.next()) {
            Vector<Object> vector2 = new Vector<Object>();
            for (int i = 1; i <= n; ++i) {
                vector2.add(resultSet.getObject(i));
            }
            vector.add(vector2);
        }
        return vector;
    }

    static Vector<String> getColumnNamesFromResultSet(ResultSet resultSet) throws SQLException {
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        Vector<String> vector = new Vector<String>();
        for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
            vector.add(resultSetMetaData.getColumnName(i));
        }
        return vector;
    }

    public void loadDB() throws SQLException {
        IxtDB.setMasterID(this._id);
        _tables.clear();
        _columns.clear();
        _physicalindexes.clear();
        _virtualindexes.clear();
        if (!this._tablesLoaded) {
            this.loadTablesColumns();
            this._tablesLoaded = true;
        }
        if (!this._indexesLoaded) {
            this.loadIndexes();
            this._indexesLoaded = true;
        }
    }

    public Vector<IxtIndex> getAllUsedIndexes() {
        Vector<IxtIndex> vector = new Vector<IxtIndex>();
        vector.addAll(_physicalindexes);
        vector.addAll(_virtualindexes);
        return vector;
    }

    public Vector<IxtIndex> getIndexResults() throws SQLException {
        Vector<IxtIndex> vector = new Vector<IxtIndex>();
        int n = 0;
        if (this._indexesUsed.isEmpty()) {
            if (this._lastPhase == null) {
                PreparedStatement preparedStatement = this._conn.prepareStatement(GET_INDEXES_SQL);
                preparedStatement.setString(1, Long.toString(this._id));
                preparedStatement.setString(2, Long.toString(this._id));
                preparedStatement.setString(3, Long.toString(this._id));
                preparedStatement.setString(4, Long.toString(this._id));
                ResultSet resultSet = preparedStatement.executeQuery();
                Vector<Vector<Object>> vector2 = IxtAnalysis.getVectorFromResultSet(resultSet);
                resultSet.close();
                preparedStatement.close();
                n = vector2.size();
                for (int i = 0; i < n; ++i) {
                    long l;
                    Vector<Object> vector3 = vector2.get(i);
                    long l2 = ((Number)vector3.get(11)).longValue();
                    IxtIndex ixtIndex = this.findIndex(l2, l = ((Number)vector3.get(10)).longValue());
                    if (ixtIndex == null) {
                        ixtIndex = new IxtIndex(l2, this.findTable(l), ((Number)vector3.get(5)).longValue(), true, "VirtIndex" + i, false);
                        _virtualindexes.add(ixtIndex);
                    }
                    ixtIndex.clearElements();
                    String string = (String)vector3.get(2);
                    StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
                    while (stringTokenizer.hasMoreTokens()) {
                        StringTokenizer stringTokenizer2 = new StringTokenizer(stringTokenizer.nextToken(), "|");
                        String string2 = stringTokenizer2.nextToken();
                        String string3 = stringTokenizer2.nextToken();
                        IxtColumn ixtColumn = new IxtColumn(Long.valueOf(string2), string3, ixtIndex.getTable());
                        IxtColumn ixtColumn2 = _columns.elementAt(_columns.indexOf(ixtColumn));
                        if (stringTokenizer2.hasMoreTokens()) {
                            ixtIndex.addElement(new IxtElement(ixtColumn2, -1));
                        } else {
                            ixtIndex.addElement(new IxtElement(ixtColumn2, 1));
                        }
                        ixtColumn2.addIndex(ixtIndex);
                    }
                    ixtIndex.setCreator((String)vector3.get(0));
                    ixtIndex.setIsClustered(((String)vector3.get(3)).equals("CLUSTERED"));
                    ixtIndex.setRelativeBenefit((Double)vector3.get(6));
                    ixtIndex.setTotalBenefit((Double)vector3.get(9));
                    ixtIndex.setDUIPenalty((Double)vector3.get(8));
                    if (!ixtIndex.isVirtual()) continue;
                    vector.add(ixtIndex);
                }
            } else {
                Vector<IxtIndex> vector4 = this._lastPhase.retrieveIndexes();
                for (IxtIndex ixtIndex : vector4) {
                    ixtIndex.setRelativeBenefit(ixtIndex.getRelativeBenefit());
                    ixtIndex.setTotalBenefit(ixtIndex.getBenefitSum());
                    ixtIndex.setDUIPenalty(ixtIndex.getDUIPenalty());
                    Iterator<IxtElement> iterator = ixtIndex.getElementIterator();
                    while (iterator.hasNext()) {
                        IxtElement ixtElement = iterator.next();
                        ixtElement.getColumn().addIndex(ixtIndex);
                    }
                    if (!ixtIndex.isVirtual()) continue;
                    vector.add(ixtIndex);
                }
            }
            this._indexesUsed = vector;
        }
        return this._indexesUsed;
    }

    private void _removeID(Vector<Vector<Object>> vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Vector<Object> vector2 = vector.get(i);
            if (vector2 == null) continue;
            vector2.remove(0);
        }
    }

    private void _trimEnd(Vector<Vector<Object>> vector) {
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            Vector<Object> vector2 = vector.get(i);
            if (vector2 == null) continue;
            vector2.remove(vector2.size() - 1);
        }
    }

    private IxtIndex findIndex(long l, long l2) {
        IxtIndex ixtIndex = new IxtIndex(l, this.findTable(l2), 0L, false, "", false);
        if (_physicalindexes.contains(ixtIndex)) {
            return _physicalindexes.elementAt(_physicalindexes.indexOf(ixtIndex));
        }
        if (_virtualindexes.contains(ixtIndex)) {
            return _virtualindexes.elementAt(_virtualindexes.indexOf(ixtIndex));
        }
        return null;
    }

    public Vector<IxtIndex> getPhysicalResults() throws SQLException {
        Vector<IxtIndex> vector = new Vector<IxtIndex>();
        if (this._uselessIndexes.isEmpty()) {
            if (this._lastPhase == null) {
                PreparedStatement preparedStatement = this._conn.prepareStatement(GET_USELESS_PHYSICAL_SQL);
                preparedStatement.setString(1, Long.toString(this._id));
                preparedStatement.setString(2, Long.toString(this._id));
                preparedStatement.setString(3, Long.toString(this._id));
                ResultSet resultSet = preparedStatement.executeQuery();
                Vector<Vector<Object>> vector2 = IxtAnalysis.getVectorFromResultSet(resultSet);
                resultSet.close();
                preparedStatement.close();
                for (Vector<Object> vector3 : vector2) {
                    long l = ((Number)vector3.get(3)).longValue();
                    long l2 = ((Number)vector3.get(4)).longValue();
                    IxtIndex ixtIndex = this.findIndex(l, l2);
                    ixtIndex.setCreator((String)vector3.get(2));
                    vector.add(ixtIndex);
                }
            } else {
                Vector<IxtIndex> vector4 = this._lastPhase.retrieveIndexes();
                for (IxtIndex ixtIndex : _physicalindexes) {
                    if (vector4.contains(ixtIndex) || ixtIndex.getName().equals("PKEY") || ixtIndex.isKey()) continue;
                    Iterator<IxtIndex> iterator = vector4.iterator();
                    boolean bl = false;
                    while (iterator.hasNext()) {
                        IxtIndex ixtIndex2 = iterator.next();
                        bl = ixtIndex.getTable().getName().equals(ixtIndex2.getTable().getName());
                        if (!bl) continue;
                        break;
                    }
                    if (!bl) continue;
                    vector.add(ixtIndex);
                }
            }
            this._uselessIndexes = vector;
        }
        return this._uselessIndexes;
    }

    public Vector<IxtQuery> getQueryResults() throws SQLException {
        Vector<Object> vector = new Vector<IxtQuery>();
        if (this._queriesUsed.isEmpty()) {
            if (this._lastPhase == null) {
                Vector<Object> vector22;
                String string = this._version == 9 ? " select text as \"Text\", iw.\"count\" * dt.\"count\" as \"Count\", \"Before\", \"After\",  \"Before\" - \"After\" as \"Difference\", dt.text_id, dt.phase_id from (  select iqt.text_id, count(iqt.text_id) as \"count\", iqt.no_tuner_score as \"Before\", iqp.current_score as \"After\", iqp.phase_id from dbo.ix_consultant_query_phase iqp, dbo.ix_consultant_query_text iqt, dbo.ix_consultant_query_index iqi  where iqp.master_id = ?  and iqp.master_id = iqt.master_id  and iqp.text_id = iqt.text_id  and iqp.text_id = iqi.text_id  and iqp.phase_id = iqi.phase_id  and iqp.phase_id = (select max(phase_id) from dbo.ix_consultant_query_phase where master_id = ? )  group by iqt.text_id, \"Before\", \"After\", iqp.phase_id ) dt, dbo.ix_consultant_workload iw  where dt.text_id = iw.text_id  and iw.master_id = ? " : " select s.statement_text as \"Text\", dt.\"count\" as \"Count\", \"Before\", \"After\",  \"Before\" - \"After\" as \"Difference\", dt.text_id, dt.phase_id from (  select iqt.text_id, count(iqt.text_id) as \"count\", iqt.no_tuner_score as \"Before\", iqp.current_score as \"After\", iqp.phase_id, iqt.logging_session from dbo.ix_consultant_query_phase iqp, dbo.ix_consultant_query_text iqt, dbo.ix_consultant_query_index iqi  where iqp.master_id = ?  and iqp.master_id = iqt.master_id  and iqp.text_id = iqt.text_id  and iqp.text_id = iqi.text_id  and iqp.phase_id = iqi.phase_id  and iqp.phase_id = (select max(phase_id) from dbo.ix_consultant_query_phase where master_id = ? )  group by iqt.text_id, \"Before\", \"After\", iqp.phase_id, iqt.logging_session  ) dt, dbo.sa_diagnostic_query q, dbo.sa_diagnostic_statement s  where dt.text_id = q.query_id  and dt.logging_session = q.logging_session_id  and q.logging_session_id = s.logging_session_id  and q.statement_id = s.statement_id ";
                PreparedStatement preparedStatement = this._conn.prepareStatement(string);
                preparedStatement.setString(1, Long.toString(this._id));
                preparedStatement.setString(2, Long.toString(this._id));
                if (this._version == 9) {
                    preparedStatement.setString(3, Long.toString(this._id));
                }
                ResultSet resultSet = preparedStatement.executeQuery();
                Vector<Vector<Object>> vector3 = IxtAnalysis.getVectorFromResultSet(resultSet);
                resultSet.close();
                preparedStatement.close();
                for (Vector<Object> vector22 : vector3) {
                    String string2 = (String)vector22.get(0);
                    IxtQuery ixtQuery = this.findQuery(string2);
                    if (ixtQuery == null) continue;
                    double d = (Double)vector22.get(3);
                    IxtConfiguration ixtConfiguration = new IxtConfiguration(ixtQuery, d, new Vector<IxtIndex>());
                    int n = ((Number)vector22.get(6)).intValue();
                    ixtQuery.setConfig(n, ixtConfiguration);
                }
                vector22 = this.getDiscardedQueryResults();
                vector = new Vector<IxtQuery>(_queries.values());
                vector.removeAll(vector22);
            } else {
                Iterator<IxtQuery> iterator = this._lastPhase.getInstance().getQueryIterator();
                Vector<IxtQuery> vector4 = this.getDiscardedQueryResults();
                while (iterator.hasNext()) {
                    IxtQuery ixtQuery = iterator.next();
                    if (vector4.contains(ixtQuery)) continue;
                    vector.remove(ixtQuery);
                    vector.add(ixtQuery);
                }
            }
            this._queriesUsed = vector;
        }
        return this._queriesUsed;
    }

    public Vector<IxtQuery> getDiscardedQueryResults() throws SQLException {
        Vector<IxtQuery> vector = new Vector<IxtQuery>();
        if (this._queriesDiscarded.isEmpty()) {
            String string = this._version == 9 ? " select text as \"Text\", text_id  from dbo.ix_consultant_workload iw  where iw.master_id = ? and iw.\"discarded\" is not NULL " : " select s.statement_text as \"Text\", qt.text_id  from dbo.ix_consultant_query_text qt, dbo.sa_diagnostic_query q, dbo.sa_diagnostic_statement s  where qt.master_id = ? and qt.\"discarded\" is not NULL  and qt.logging_session = q.logging_session_id  and q.logging_session_id = s.logging_session_id  and qt.text_id = q.query_id  and q.statement_id = s.statement_id ";
            PreparedStatement preparedStatement = this._conn.prepareStatement(string);
            preparedStatement.setString(1, Long.toString(this._id));
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<Vector<Object>> vector2 = IxtAnalysis.getVectorFromResultSet(resultSet);
            resultSet.close();
            preparedStatement.close();
            for (Vector<Object> vector3 : vector2) {
                String string2 = (String)vector3.get(0);
                IxtQuery ixtQuery = this.findQuery(string2);
                if (ixtQuery == null) continue;
                ixtQuery.setText(string2);
                vector.add(ixtQuery);
            }
            this._queriesDiscarded = vector;
        }
        return this._queriesDiscarded;
    }

    public Vector<IxtQuery> getAffectedResults() {
        if (this._affectedResults.isEmpty()) {
            IxtQuery ixtQuery2 = null;
            Vector<IxtQuery> vector = new Vector<IxtQuery>(_queries.values());
            for (IxtQuery ixtQuery2 : vector) {
                if (ixtQuery2 == null || ixtQuery2.getType().equals("SELECT")) continue;
                this._affectedResults.add(ixtQuery2);
            }
        }
        return this._affectedResults;
    }

    public Vector<String> getUselessPhysicalIndexes() throws SQLException {
        Vector<String> vector = new Vector<String>();
        Iterator<IxtIndex> iterator = this.getPhysicalResults().iterator();
        while (iterator.hasNext()) {
            vector.add(iterator.next().getName());
        }
        return vector;
    }

    public int getNumberOfAnalyzedQueries() throws SQLException {
        int n = 0;
        Iterator<IxtQuery> iterator = this.getQueryResults().iterator();
        while (iterator.hasNext()) {
            n = (int)((long)n + iterator.next().getCount());
        }
        return n;
    }

    public String getScript() {
        return "";
    }

    public String getUserScript(boolean bl) throws SQLException {
        IxtIndex ixtIndex = null;
        StringBuffer stringBuffer = new StringBuffer(1000);
        Iterator<IxtIndex> iterator = this.getPhysicalResults().iterator();
        if (!bl) {
            while (iterator.hasNext()) {
                ixtIndex = iterator.next();
                stringBuffer.append("\nDROP INDEX \"" + ixtIndex.getCreator() + "\".\"" + ixtIndex.getTable().getName() + "\".\"" + ixtIndex.getName() + "\";\n");
            }
        }
        Iterator<IxtIndex> iterator2 = this.getIndexResults().iterator();
        int n = 1;
        while (iterator2.hasNext()) {
            ixtIndex = iterator2.next();
            if (!ixtIndex.isVirtual()) continue;
            stringBuffer.append("\nCREATE ");
            if (ixtIndex.isClustered()) {
                stringBuffer.append("CLUSTERED ");
            }
            stringBuffer.append("INDEX \"ixc_" + this._name + "_" + Integer.toString(n) + "\" ON \"" + ixtIndex.getCreator() + "\".\"" + ixtIndex.getTable().getName() + "\" ( ");
            Iterator<IxtElement> iterator3 = ixtIndex.getElementIterator();
            while (iterator3.hasNext()) {
                IxtElement ixtElement = iterator3.next();
                stringBuffer.append("\"");
                stringBuffer.append(ixtElement.getColumn().getName());
                stringBuffer.append("\"");
                if (ixtElement.getDirection() == -1) {
                    stringBuffer.append(" DESC");
                }
                if (!iterator3.hasNext()) continue;
                stringBuffer.append(",");
            }
            stringBuffer.append(" );\n");
            if (ixtIndex.isClustered()) {
                stringBuffer.append("REORGANIZE TABLE \"" + ixtIndex.getCreator() + "\".\"" + ixtIndex.getTable().getName() + "\";\n");
            }
            ++n;
        }
        return new String(stringBuffer);
    }

    private void _loadConfigs() throws SQLException {
        String string = this._version == 9 ? "select distinct qi.index_id, qi.table_id, current_score, qi.text_id, w.text from dbo.ix_consultant_query_phase qp, dbo.ix_consultant_query_index qi, dbo.ix_consultant_workload w  where qi.phase_id = (select max(phase_id) from dbo.ix_consultant_query_phase where master_id = " + Long.toString(this._id) + " ) " + " and qi.master_id = " + Long.toString(this._id) + " and qi.text_id = qp.text_id " + " and qi.text_id = w.text_id " + " and qi.index_id = ? " + " and qi.table_id = ? " : "select distinct qi.index_id, qi.table_id, current_score, qi.text_id, s.statement_text from dbo.ix_consultant_query_phase qp, dbo.ix_consultant_query_index qi, dbo.sa_diagnostic_query q, dbo.sa_diagnostic_statement s  where qi.phase_id = (select max(phase_id) from dbo.ix_consultant_query_phase where master_id = " + Long.toString(this._id) + " ) " + " and qi.master_id = " + Long.toString(this._id) + " and qi.text_id = qp.text_id " + " and qi.logging_session = q.logging_session_id " + " and qi.text_id = q.query_id " + " and q.logging_session_id = s.logging_session_id " + " and q.statement_id = s.statement_id " + " and qi.text_id = q.query_id " + " and qi.index_id = ? " + " and qi.table_id = ? ";
        for (IxtIndex ixtIndex : this.getIndexResults()) {
            ixtIndex.clearConfigurations();
            PreparedStatement preparedStatement = this._conn.prepareStatement(string);
            preparedStatement.setString(1, Long.toString(ixtIndex.getID()));
            preparedStatement.setString(2, Long.toString(ixtIndex.getTable().getID()));
            ResultSet resultSet = preparedStatement.executeQuery();
            Vector<Vector<Object>> vector = IxtAnalysis.getVectorFromResultSet(resultSet);
            Iterator<Vector<Object>> iterator = vector.iterator();
            preparedStatement.close();
            while (iterator.hasNext()) {
                Vector<Object> vector2 = iterator.next();
                double d = (Double)vector2.get(2);
                String string2 = (String)vector2.get(4);
                IxtQuery ixtQuery = this.findQuery(string2);
                if (ixtQuery == null) continue;
                Vector<IxtIndex> vector3 = new Vector<IxtIndex>();
                vector3.add(ixtIndex);
                ixtIndex.addConfiguration(new IxtConfiguration(ixtQuery, d, vector3));
                ixtIndex.incrementTimesUsed();
            }
        }
        this._configsLoaded = true;
    }

    public Vector<IxtQuery> getAffectedQueries(String string, String string2) throws SQLException {
        if (this._lastPhase == null && !this._configsLoaded) {
            this._loadConfigs();
        }
        Vector<IxtQuery> vector = new Vector<IxtQuery>();
        IxtTable ixtTable = new IxtTable(0L, string, "", 0, 0);
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
        while (stringTokenizer.hasMoreTokens()) {
            IxtColumn ixtColumn = new IxtColumn(0L, stringTokenizer.nextToken(), ixtTable);
            ixtColumn = _columns.elementAt(_columns.indexOf(ixtColumn));
            for (IxtIndex ixtIndex : ixtColumn.getIndexes()) {
                for (IxtConfiguration ixtConfiguration : ixtIndex.getConfigurations()) {
                    IxtQuery ixtQuery = ixtConfiguration.getQuery();
                    vector.remove(ixtQuery);
                    vector.add(ixtQuery);
                }
            }
        }
        return vector;
    }

    private int getPositionInIndexList(Integer n, Integer n2) throws SQLException {
        String string = "select table_id, index_id from ix_consultant_index  where master_id = " + Long.toString(this._id) + " and phase_id = ( select max(phase_id) from ix_consultant_query_phase where master_id = " + Long.toString(this._id) + " ) " + " order by table_id, index_id ";
        Statement statement = this._conn.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        int n3 = 0;
        while (resultSet.next()) {
            ++n3;
            if (resultSet.getInt(1) != n.intValue() || resultSet.getInt(2) != n2.intValue()) continue;
            return n3;
        }
        statement.close();
        return -1;
    }

    public Vector<IxtIndex> getIndexesUsed(String string) throws SQLException {
        if (this._lastPhase == null && !this._configsLoaded) {
            this._loadConfigs();
        }
        Vector<IxtIndex> vector = new Vector<IxtIndex>();
        for (IxtIndex ixtIndex : this.getIndexResults()) {
            for (IxtConfiguration ixtConfiguration : ixtIndex.getConfigurations()) {
                if (!ixtConfiguration.getQuery().getText().equals(string)) continue;
                vector.remove(ixtIndex);
                vector.add(ixtIndex);
            }
        }
        return vector;
    }

    public Vector<String> createVirtualIndexes(Vector<IxtIndex> vector, Vector<String> vector2, int n) throws SQLException {
        int n2 = vector.size();
        Vector<String> vector3 = new Vector<String>();
        for (int i = 0; i < n2; ++i) {
            Object object;
            String string = vector2.get(i).toString();
            IxtIndex ixtIndex = vector.get(i);
            String string2 = "ixc_" + IxtIndex.identifierSubstring(this.toString()) + "_" + ixtIndex.getName();
            String string3 = ixtIndex.getCreator();
            String string4 = ixtIndex.getTable().getName();
            StringBuffer stringBuffer = new StringBuffer();
            Statement statement = this._conn.createStatement();
            Iterator<IxtElement> iterator = ixtIndex.getElementIterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                stringBuffer.append("\"");
                stringBuffer.append(((IxtElement)object).getColumn().getName());
                stringBuffer.append("\"");
                if (((IxtElement)object).getDirection() == -1) {
                    stringBuffer.append(" DESC");
                }
                if (!iterator.hasNext()) continue;
                stringBuffer.append(",");
            }
            statement.execute("CREATE VIRTUAL " + string + " INDEX \"" + string2 + "\" ON \"" + string3 + "\".\"" + string4 + "\" ( " + stringBuffer.toString() + " )");
            statement.close();
            object = "DROP INDEX \"" + string3 + "\".\"" + string4 + "\".\"" + string2 + "\"";
            vector3.add((String)object);
        }
        return vector3;
    }

    public void dropVirtualIndexes(Vector<String> vector) throws SQLException {
        if (vector == null) {
            return;
        }
        Statement statement = this._conn.createStatement();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            String string = vector.get(i).toString();
            try {
                statement.execute(string);
                continue;
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        statement.close();
    }

    public Vector<String> getPlan(String string, int n, long l) throws SQLException {
        ResultSet resultSet = null;
        Vector<String> vector = null;
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append("select graphical_plan( '");
            int n2 = string.length();
            for (int i = 0; i < n2; ++i) {
                char c = string.charAt(i);
                stringBuffer.append(c);
                if (c != '\'') continue;
                stringBuffer.append(c);
            }
            stringBuffer.append("'");
            stringBuffer.append(",1");
            stringBuffer.append(")");
        } else {
            stringBuffer.append("select traced_plan( ");
            stringBuffer.append(n);
            stringBuffer.append(", ");
            stringBuffer.append(l);
            stringBuffer.append(")");
        }
        Statement statement = this._conn.createStatement();
        resultSet = statement.executeQuery(stringBuffer.toString());
        resultSet.next();
        Object object = resultSet.getObject(1);
        if (object != null) {
            String string2 = object.toString();
            StringTokenizer stringTokenizer = new StringTokenizer(string2, "\n\r");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3 == null || string3.trim().length() == 0) continue;
                if (vector == null) {
                    vector = new Vector<String>();
                }
                vector.addElement(string3);
            }
        }
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            resultSet = null;
        }
        statement.close();
        return vector;
    }

    public Vector<Double> getTableSizeRatingLine(double d, double d2) throws SQLException {
        Vector<Double> vector = new Vector<Double>();
        double d3 = 0.0;
        double d4 = d2;
        String string = "select MAX(dt.\"TablePages\") from (select st.\"table_page_count\" + st.\"ext_page_count\" \"TablePages\" from SYS.SYSTABLE st where st.table_type = 'BASE' and st.table_id IN (select DISTINCT ii.table_id from dbo.ix_consultant_index ii where master_id = ? and ii.tool_total_benefit is not NULL and ii.phase_id = ( select max(phase_id) from dbo.ix_consultant_query_phase where master_id = ? )) ) dt";
        PreparedStatement preparedStatement = this._conn.prepareStatement(string);
        preparedStatement.setString(1, Long.toString(this._id));
        preparedStatement.setString(2, Long.toString(this._id));
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            long l = 0L;
            long l2 = resultSet.getLong(1);
            if (l2 - l != 0L) {
                d3 = (d2 - d) / (double)(l2 - l);
            }
            d4 = d2 - d3 * (double)l2;
        }
        resultSet.close();
        preparedStatement.close();
        vector.add(new Double(d3));
        vector.add(new Double(d4));
        return vector;
    }

    public Vector<Double> getQueriesAffectedRatingLine(double d, double d2, Vector<Vector<Object>> vector) throws SQLException {
        int n = vector.size();
        double d3 = -1.0;
        double d4 = 0.0;
        double d5 = d2;
        Vector<Double> vector2 = new Vector<Double>();
        double d6 = 0.0;
        for (int i = 0; i < n; ++i) {
            int n2;
            Vector<Object> vector3 = vector.get(i);
            Vector<IxtQuery> vector4 = this.getAffectedQueries(vector3.get(0).toString(), vector3.get(1).toString());
            if (vector4 == null || !((double)(n2 = vector4.size()) > d3)) continue;
            d3 = n2;
        }
        if (d3 - d6 != 0.0) {
            d4 = (d2 - d) / (d3 - d6);
        }
        d5 = d2 - d4 * d3;
        vector2.add(new Double(d4));
        vector2.add(new Double(d5));
        return vector2;
    }

    public Vector<Double> getUpdateCostRatingLine(double d, double d2, Vector<Vector<Object>> vector) {
        int n = vector.size();
        double d3 = -1.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = d2;
        Vector<Double> vector2 = new Vector<Double>();
        for (int i = 0; i < n; ++i) {
            Vector<Object> vector3 = vector.get(i);
            double d7 = ((Number)vector3.get(7)).doubleValue();
            if (!(d7 > d3)) continue;
            d3 = d7;
        }
        if (d4 - d3 != 0.0) {
            d5 = (d2 - d) / (d4 - d3);
        }
        d6 = d2 - d5 * d4;
        vector2.add(new Double(d5));
        vector2.add(new Double(d6));
        return vector2;
    }

    public Vector<Double> getBenefitRatingLine(double d, double d2, Vector<Vector<Object>> vector) {
        int n = vector.size();
        double d3 = -1.0;
        double d4 = 0.0;
        boolean bl = true;
        double d5 = 0.0;
        double d6 = d2;
        Vector<Double> vector2 = new Vector<Double>();
        for (int i = 0; i < n; ++i) {
            Vector<Object> vector3 = vector.get(i);
            Number number = (Number)vector3.get(6);
            if (number == null) continue;
            double d7 = number.doubleValue();
            if (d7 > d3 || bl) {
                d3 = d7;
                bl = false;
            }
            if (!(d7 < d4)) continue;
            d4 = d7;
        }
        if (d3 - d4 != 0.0) {
            d5 = (d2 - d) / (d3 - d4);
        }
        d6 = d2 - d5 * d3;
        vector2.add(new Double(d5));
        vector2.add(new Double(d6));
        return vector2;
    }

    public void removePartialPhase(int n) throws SQLException {
        Statement statement = this._conn.createStatement();
        String string = "delete from dbo.ix_consultant_log where master_id = " + this.getID() + " and phase_id = " + n;
        statement.execute(string);
        string = "delete from dbo.ix_consultant_ixcol where master_id = " + this.getID() + " and phase_id = " + n;
        statement.execute(string);
        string = "delete from dbo.ix_consultant_query_index where master_id = " + this.getID() + " and phase_id = " + n;
        statement.execute(string);
        string = "delete from dbo.ix_consultant_index where master_id = " + this.getID() + " and phase_id = " + n;
        statement.execute(string);
        string = "delete from dbo.ix_consultant_query_phase where master_id = " + this.getID() + " and phase_id = " + n;
        statement.execute(string);
        this._conn.commit();
        statement.close();
    }

    public int getNumPhasesCompleted() throws SQLException {
        String string = "select max(phase_id) from dbo.ix_consultant_log where master_id = ? and \"msg_type\" = 'INFO' and log_message = 'Completed phase'";
        PreparedStatement preparedStatement = this._conn.prepareStatement(string);
        preparedStatement.setString(1, Long.toString(this._id));
        ResultSet resultSet = preparedStatement.executeQuery();
        if (!resultSet.next()) {
            resultSet.close();
            preparedStatement.close();
            return 0;
        }
        int n = resultSet.getInt(1);
        resultSet.close();
        preparedStatement.close();
        return n;
    }

    public long getId() {
        return 0L;
    }

    public void loadTablesColumns() throws SQLException {
        IxtIndex ixtIndex = null;
        IxtColumn ixtColumn = null;
        String string = this._version == 9 ? "SELECT t.table_id, t.table_name, u.user_name, a.attribute_value, t.table_page_count + t.ext_page_count, c.column_id, c.column_name, if c.pkey = 'Y' then 1 else 0 endif FROM SYS.SYSTABLE t left outer join SYS.SYSATTRIBUTE a on a.object_id = t.table_id and a.attribute_id = 2 join SYS.SYSCOLUMN c on c.table_id = t.table_id join SYS.SYSUSERPERMS u on u.user_id = t.creator and u.user_id <> 0 and u.user_id <> 3" : "SELECT t.table_id, t.table_name, u.user_name, cast(t.clustered_index_id as long varchar), t.table_page_count + t.ext_page_count, c.column_id, c.column_name, if c.pkey = 'Y' then 1 else 0 endif FROM SYS.SYSTAB t join SYS.SYSCOLUMN c on c.table_id = t.table_id join SYS.SYSUSERPERMS u on u.user_id = t.creator and u.user_id <> 0 and u.user_id <> 3";
        PreparedStatement preparedStatement = this._conn.prepareStatement(string);
        ResultSet resultSet = preparedStatement.executeQuery();
        Vector<Vector<Object>> vector = IxtAnalysis.getVectorFromResultSet(resultSet);
        resultSet.close();
        preparedStatement.close();
        for (Vector<Object> vector2 : vector) {
            int n;
            long l = ((Number)vector2.get(0)).longValue();
            IxtTable ixtTable = this.findTable(l);
            String string2 = (String)vector2.get(3);
            int n2 = n = string2 == null ? 0 : Integer.valueOf(string2);
            if (ixtTable == null) {
                int n3 = ((Number)vector2.get(4)).intValue();
                ixtTable = new IxtTable(l, (String)vector2.get(1), (String)vector2.get(2), n, n3);
                _tables.put(new Long(l), ixtTable);
                if (ixtIndex != null && ixtIndex.getNumElements() > 0) {
                    ixtTable.addPhysicalIndex(ixtIndex);
                    _physicalindexes.add(ixtIndex);
                }
                ixtIndex = new IxtIndex(0L, ixtTable, 0L, false, "PKEY", true);
                if (n3 > this._max_table_size) {
                    this._max_table_size = n3;
                }
            }
            long l2 = ((Number)vector2.get(5)).longValue();
            String string3 = (String)vector2.get(6);
            boolean bl = ((Number)vector2.get(7)).intValue() == 1;
            ixtColumn = new IxtColumn(l2, string3, ixtTable);
            _columns.add(ixtColumn);
            ixtTable.addColumn(ixtColumn);
            if (!bl) continue;
            ixtIndex.addElement(new IxtElement(ixtColumn, 1));
        }
    }

    public void loadIndexes() throws SQLException {
        IxtIndex ixtIndex2;
        IxtTable ixtTable2;
        ResultSet resultSet = this._ixtDB.runPhysicalIndexesQuery();
        while (resultSet.next()) {
            ixtTable2 = this.findTable(resultSet.getLong(2));
            ixtIndex2 = new IxtIndex(resultSet.getLong(1), ixtTable2, 0L, false, resultSet.getString(3), resultSet.getInt(4) == 1);
            ixtTable2.addPhysicalIndex(ixtIndex2);
            _physicalindexes.add(ixtIndex2);
        }
        resultSet.close();
        for (IxtIndex ixtIndex2 : _physicalindexes) {
            resultSet = ixtIndex2.isKey() ? IxtDB.runKeyIndexColumnsQuery(ixtIndex2.getTable().getID(), ixtIndex2.getID()) : IxtDB.runPhysicalIndexColumnsQuery(ixtIndex2.getTable().getID(), ixtIndex2.getID());
            while (resultSet.next()) {
                ixtIndex2.addElement(new IxtElement(ixtIndex2.getTable().findColumn(resultSet.getLong(1)), resultSet.getInt(2)));
            }
            resultSet.close();
        }
        for (IxtTable ixtTable2 : _tables.values()) {
            if (ixtTable2.getClusterID() == 0 || (ixtIndex2 = ixtTable2.findPhysicalIndex(ixtTable2.getClusterID())) == null) continue;
            ixtIndex2.setIsClustered(true);
        }
        IxtAnalysis ixtAnalysis = this;
        resultSet = ixtAnalysis._ixtDB.runVirtualIndexesQuery();
        while (resultSet.next()) {
            ixtTable2 = this.findTable(resultSet.getLong(1));
            ixtIndex2 = new IxtIndex(resultSet.getLong(2), ixtTable2, 0L, true, resultSet.getString(7), false);
            ixtTable2.addVirtualIndex(ixtIndex2);
            _virtualindexes.add(ixtIndex2);
        }
        resultSet.close();
        for (IxtIndex ixtIndex2 : _virtualindexes) {
            resultSet = IxtDB.runVirtualIndexColumnsQuery(ixtIndex2.getTable().getID(), ixtIndex2.getID());
            while (resultSet.next()) {
                int n = resultSet.getByte(5) == 65 ? 1 : -1;
                ixtIndex2.addElement(new IxtElement(ixtIndex2.getTable().findColumn(resultSet.getLong(4)), n));
            }
            resultSet.close();
        }
        for (IxtTable ixtTable2 : _tables.values()) {
            if (ixtTable2.getClusterID() == 0 || (ixtIndex2 = ixtTable2.findVirtualIndex(ixtTable2.getClusterID())) == null) continue;
            ixtIndex2.setIsClustered(true);
        }
    }

    public IxtQuery findQuery(String string) {
        return _queries.get(new Long(string.hashCode()));
    }

    public void loadQueries() throws SQLException {
        if (!this._queriesLoaded) {
            IxtQuery ixtQuery;
            IxtDB.setMasterID(this._id);
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put("S", "SELECT");
            hashMap.put("U", "UPDATE");
            hashMap.put("I", "INSERT");
            hashMap.put("D", "DELETE");
            _queries.clear();
            ResultSet resultSet = this._ixtDB.runQueriesQuery();
            int n = 0;
            int n2 = 0;
            while (resultSet.next()) {
                String string = (String)hashMap.get(resultSet.getString(2));
                if (string == null) {
                    string = "N";
                }
                String string2 = resultSet.getString(5);
                ixtQuery = new IxtQuery(resultSet.getLong(1), string, resultSet.getDouble(3), resultSet.getDouble(4), string2);
                ixtQuery.setDiscarded(resultSet.getBoolean(5));
                IxtQuery ixtQuery2 = _queries.put(new Long(string2.hashCode()), ixtQuery);
                if (ixtQuery2 != null) {
                    ++n2;
                }
                ++n;
            }
            resultSet.close();
            resultSet = this._ixtDB.runWorkloadQuery();
            while (resultSet.next()) {
                long l = resultSet.getLong(2);
                long l2 = resultSet.getLong(3);
                String string = resultSet.getString(4);
                ixtQuery = this.findQuery(string);
                if (ixtQuery == null) continue;
                ixtQuery.addWorkloadItem(l, l2);
            }
            resultSet.close();
            this._queriesLoaded = true;
            this.loadAffected();
        }
    }

    void loadAffected() throws SQLException {
        IxtQuery ixtQuery = null;
        ResultSet resultSet = this._ixtDB.runAffectedColumnsQuery();
        while (resultSet.next()) {
            IxtTable ixtTable;
            String string = resultSet.getString(3);
            if (ixtQuery == null || !string.equals(ixtQuery.getText())) {
                ixtQuery = this.findQuery(string);
            }
            if (ixtQuery == null || (ixtTable = this.findTable(resultSet.getLong(1))) == null) continue;
            long l = resultSet.getLong(2);
            if (l == 0L) {
                ixtQuery.addAffectedTable(ixtTable);
                continue;
            }
            IxtColumn ixtColumn = ixtTable.findColumn(l);
            if (ixtColumn == null) continue;
            ixtQuery.addAffectedColumn(ixtColumn);
            ixtColumn.addAffectedQuery(ixtQuery);
            _columns.add(ixtColumn);
        }
        resultSet.close();
    }

    public static class TableDescriptor {
        Vector<Vector<Object>> _data;
        Vector<String> _header;

        public TableDescriptor(Vector<String> vector, Vector<Vector<Object>> vector2) {
            this._data = vector2;
            this._header = vector;
        }

        public Vector<String> getHeader() {
            return this._header;
        }

        public Vector<Vector<Object>> getData() {
            return this._data;
        }
    }
}

