/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.indexConsultant;

import com.sybase.indexConsultant.IxtIndex;
import com.sybase.indexConsultant.IxtQuery;
import java.util.Iterator;
import java.util.Vector;

public class IxtConfiguration {
    IxtQuery _query;
    Vector<IxtIndex> _indexes;
    double _cost;
    double _workingcost;

    public IxtConfiguration(IxtQuery ixtQuery, double d, Vector<IxtIndex> vector) {
        this._query = ixtQuery;
        this._indexes = vector;
        this._cost = d;
        this._workingcost = d;
        if (this._query.getVanillaCost() < this._cost) {
            // empty if block
        }
    }

    public int currentCostCompare(IxtConfiguration ixtConfiguration) {
        return Double.compare(this._workingcost, ixtConfiguration._workingcost);
    }

    public Iterator<IxtIndex> getIndexIterator() {
        return this._indexes.iterator();
    }

    public double getWorkingCost() {
        return this._workingcost;
    }

    public double getRealCost() {
        return this._cost;
    }

    public double getBenefit() {
        return (this._query.getVanillaCost() - this._workingcost) * (double)this._query.getCount();
    }

    public void removeIndex(IxtIndex ixtIndex) {
        this._indexes.remove(ixtIndex);
    }

    public void addIndex(IxtIndex ixtIndex) {
        this._indexes.add(ixtIndex);
    }

    public IxtQuery getQuery() {
        return this._query;
    }
}

