/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.indexConsultant;

import com.sybase.indexConsultant.IxtDBVersion10;
import com.sybase.indexConsultant.IxtDBVersion9;
import com.sybase.indexConsultant.IxtQuery;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;

public abstract class IxtDB {
    static Statement _stmt = null;
    static String _masterIDString;

    public static void setMasterID(long l) {
        _masterIDString = String.valueOf(l);
    }

    public static void setStatement(Statement statement) {
        if (_stmt != null && statement != _stmt) {
            try {
                _stmt.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        _stmt = statement;
    }

    public static Statement getStatement() {
        return _stmt;
    }

    public abstract ResultSet runTableQuery() throws SQLException;

    public static ResultSet runTableSizeQuery(long l) throws SQLException {
        String string = "select \"table_page_count\" + \"ext_page_count\" \"npages\" from SYS.SYSTABLE where table_id = " + l;
        return _stmt.executeQuery(string);
    }

    public abstract ResultSet runPhysicalIndexesQuery() throws SQLException;

    public static ResultSet runVirtualIndexesQuery() throws SQLException {
        String string = "call dbo.sa_virtual_sysindex()";
        return _stmt.executeQuery(string);
    }

    public static int estimateNumberPages(int n, int n2, int n3) {
        int n4 = 1;
        int n5 = n2;
        int n6 = 0;
        if (n3 == 1 || n2 == 0) {
            return n5;
        }
        double d = n / n2;
        if (d <= 1.0) {
            return n5;
        }
        while (n5 > 1) {
            n6 += n5;
            n5 = (int)((double)n5 / d);
            ++n4;
        }
        ++n6;
        n6 = (int)((double)n6 * ((double)n3 / (double)n4));
        return n6;
    }

    public abstract int getPhysicalIndexStats(String var1) throws SQLException;

    public static int getNumberPhysicalIndexPages(Connection connection) throws SQLException {
        try {
            return IxtDBVersion9.getNumberPhysicalIndexPages(connection);
        }
        catch (SQLException sQLException) {
            return IxtDBVersion10.getNumberPhysicalIndexPages(connection);
        }
    }

    public static int getPageSize(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        String string = "SELECT db_property( 'PageSize' )";
        int n = 0;
        ResultSet resultSet = statement.executeQuery(string);
        resultSet.next();
        n = resultSet.getInt(1);
        resultSet.close();
        statement.close();
        return n;
    }

    public static int getNumberTablePages(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT sum(table_page_count) FROM SYS.SYSTABLE");
        int n = resultSet.next() ? resultSet.getInt(1) : -1;
        resultSet.close();
        statement.close();
        return n;
    }

    public static long getConnectionId(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        ResultSet resultSet = statement.executeQuery("SELECT connection_property( 'Number' )");
        resultSet.next();
        long l = resultSet.getLong(1);
        resultSet.close();
        statement.close();
        return l;
    }

    public abstract boolean runIndexConsultantPermissionCheck(Connection var1) throws SQLException;

    public abstract boolean runIndexConsultantTablesCheck(Connection var1) throws SQLException;

    public static void runScript(Connection connection, String string) throws SQLException {
        connection.commit();
        Statement statement = connection.createStatement();
        statement.execute(string);
        connection.commit();
    }

    public static ResultSet runPhysicalIndexColumnsQuery(long l, long l2) throws SQLException {
        String string = "select column_id, if \"order\" = 'A' then 1 else -1 endif from SYS.SYSIXCOL where table_id = " + Long.toString(l) + " and index_id = " + Long.toString(l2) + " order by sequence";
        return _stmt.executeQuery(string);
    }

    public static ResultSet runVirtualIndexColumnsQuery(long l, long l2) throws SQLException {
        String string = "call dbo.sa_virtual_sysixcol()";
        return _stmt.executeQuery(string);
    }

    public static ResultSet runKeyIndexColumnsQuery(long l, long l2) throws SQLException {
        String string = "select foreign_column_id, 1  from SYS.SYSFKCOL where foreign_table_id = " + Long.toString(l) + " and foreign_key_id = " + Long.toString(l2) + " order by primary_column_id ";
        return _stmt.executeQuery(string);
    }

    public static ResultSet runColumnsQuery(long l) throws SQLException {
        String string = "select column_id, column_name, if pkey = 'Y' then 1 else 0 endif  from SYS.SYSCOLUMN where table_id = " + Long.toString(l) + " order by column_id";
        return _stmt.executeQuery(string);
    }

    public abstract ResultSet runQueriesQuery() throws SQLException;

    public abstract ResultSet runWorkloadQuery() throws SQLException;

    public static ResultSet runConfigurationsQuery(int n, long l) throws SQLException {
        String string = "select distinct qi.index_id, qi.table_id, num_pages, qp.current_score, is_clustered, cluster_score, is_virtual from dbo.ix_consultant_query_phase qp  natural join dbo.ix_consultant_query_index qi  natural join dbo.ix_consultant_index i  left outer join SYS.SYSINDEX s  on s.table_id = qi.table_id  and s.index_id = qi.index_id  where qi.phase_id = " + Integer.toString(n) + " and qi.text_id = " + Long.toString(l) + " and qi.master_id = " + _masterIDString;
        return _stmt.executeQuery(string);
    }

    public static ResultSet runIndexColumnsQuery(int n, long l, long l2) throws SQLException {
        String string = "select column_id, if column_order = 'A' then 1  else if column_order = 'I' then 0 else -1 endif endif from dbo.ix_consultant_ixcol i  where phase_id = " + Integer.toString(n) + " and i.table_id = " + Long.toString(l) + " and index_id = " + Long.toString(l2) + " and master_id = " + _masterIDString + " order by sequence";
        return _stmt.executeQuery(string);
    }

    public abstract ResultSet runAffectedColumnsQuery() throws SQLException;

    public static ResultSet runLogQuery() throws SQLException {
        String string = "select message_time, phase_id, workload_id, msg_type, sql_code, log_message from dbo.ix_consultant_log where msg_type != 'DEBUG' and master_id = " + _masterIDString + " order by message_time";
        return _stmt.executeQuery(string);
    }

    public abstract void runDiscardWorkloadItemsStatement(Iterator<IxtQuery> var1) throws SQLException;

    public static void runRecommendIndexesStatement(long l, int n, boolean bl, boolean bl2) throws SQLException {
        String string = "0";
        String string2 = "0";
        if (bl) {
            string = "1";
        }
        if (bl2) {
            string2 = "1";
        }
        String string3 = "call dbo.sa_recommend_indexes( " + Long.toString(l) + ", " + Integer.toString(n) + ", " + string + ", " + string2 + " )";
        IxtDB.debug("Executing: " + string3);
        _stmt.execute(string3);
    }

    public static void runTruncateStatement() throws SQLException {
        _stmt.execute("call dbo.sa_remove_index_consultant_analysis( " + _masterIDString + ")");
    }

    public static void runStopIndexTuningStatement() throws SQLException {
        _stmt.execute("call dbo.sa_stop_index_consultant()");
    }

    public static void runDisableIndexStatement(String string, String string2, String string3) throws SQLException {
        String string4 = "call dbo.sa_disable_index( '" + string + "', '" + string2 + "', '" + string3 + "' )";
        _stmt.execute(string4);
    }

    public static void runUpdateIndexTable(int n, long l, long l2, boolean bl, double d, double d2) throws SQLException {
        String string = bl ? ", is_clustered = 2" : "";
        String string2 = "update dbo.ix_consultant_index set tool_total_benefit = " + Double.toString(d) + ", tool_update_cost = " + Double.toString(d2) + ", tool_relative_benefit = 1" + string + " where master_id = " + _masterIDString + " and phase_id = " + Integer.toString(n) + " and table_id = " + Long.toString(l) + " and index_id = " + Long.toString(l2);
        _stmt.execute(string2);
        _stmt.getConnection().commit();
    }

    public static void runRelativeBenefitUpdateIndexTable(int n, long l, long l2, double d) throws SQLException {
        String string = "update dbo.ix_consultant_index set tool_relative_benefit = " + Double.toString(d) + " where master_id = " + _masterIDString + " and phase_id = " + Integer.toString(n) + " and table_id = " + Long.toString(l) + " and index_id = " + Long.toString(l2);
        _stmt.execute(string);
        _stmt.getConnection().commit();
    }

    public static String getColumnString(ResultSet resultSet, int n) throws SQLException {
        String string = resultSet.getString(n);
        if (string != null) {
            if (resultSet.getMetaData() == null || resultSet.getMetaData().getColumnType(n) == 1) {
                string = string.trim();
            }
        } else {
            string = "";
        }
        return string;
    }

    public static long getNewMasterID(String string) throws SQLException {
        ResultSet resultSet = _stmt.executeQuery("call dbo.sa_add_index_consultant_analysis('" + string + "')");
        resultSet.next();
        _masterIDString = resultSet.getString(1);
        long l = resultSet.getInt(1);
        resultSet.close();
        return l;
    }

    public static void putMessage(int n, String string, String string2) throws SQLException {
        String string3 = "insert into dbo.ix_consultant_log values ( default, default, " + _masterIDString + ", " + Integer.toString(n) + ", " + "0, '" + string + "', 0, '" + string2 + "' )";
        _stmt.execute(string3);
        _stmt.execute("commit");
    }

    public static void debug(String string) throws SQLException {
        IxtDB.putMessage(0, "DEBUG", string);
    }
}

