/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.indexConsultant;

import com.sybase.indexConsultant.IxtDB;
import com.sybase.indexConsultant.IxtQuery;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Iterator;

public class IxtDBVersion10
extends IxtDB {
    private static final String CHECK_AUTH = "SELECT COUNT(*) FROM SYS.SYSUSERAUTHORITY A JOIN SYS.SYSUSER u ON A.user_id = u.user_id WHERE A.auth in ( 'DBA', 'PROFILE' ) AND U.user_name = CURRENT_USER ";

    @Override
    public ResultSet runTableQuery() throws SQLException {
        String string = "select distinct table_id, table_name, user_name, clustered_index_id, table_page_count + ext_page_count  from SYS.SYSTAB st join SYS.SYSUSERPERMS sup on st.creator=sup.user_id order by table_id";
        return _stmt.executeQuery(string);
    }

    @Override
    public ResultSet runPhysicalIndexesQuery() throws SQLException {
        String string = "select index_id, table_id, index_name, 0 from SYS.SYSINDEX si where si.creator <> 0 and si.creator <> 3 UNION select fk.foreign_key_id, fk.foreign_table_id, fk.role, 1 from SYS.SYSFOREIGNKEY fk, SYS.SYSTABLE st where fk.foreign_table_id = st.table_id and st.creator <> 0 and st.creator <> 3";
        return _stmt.executeQuery(string);
    }

    @Override
    public boolean runIndexConsultantPermissionCheck(Connection connection) throws SQLException {
        try {
            Statement statement = connection.createStatement();
            ResultSet resultSet = statement.executeQuery(CHECK_AUTH);
            long l = 0L;
            resultSet.next();
            l = resultSet.getLong(1);
            statement.close();
            return l != 0L;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    @Override
    public boolean runIndexConsultantTablesCheck(Connection connection) throws SQLException {
        return true;
    }

    @Override
    public ResultSet runQueriesQuery() throws SQLException {
        String string = "select qt.text_id, qt.query_type, qt.no_tuner_score,  qt.num_rows_affected, s.statement_text, qt.discarded from dbo.ix_consultant_query_text qt, dbo.sa_diagnostic_query q, dbo.sa_diagnostic_statement s  where qt.master_id = " + _masterIDString + " and qt.logging_session = q.logging_session_id " + " and s.logging_session_id = q.logging_session_id " + " and s.statement_id = q.statement_id " + " and q.query_id = qt.text_id " + " order by qt.text_id";
        return _stmt.executeQuery(string);
    }

    @Override
    public ResultSet runWorkloadQuery() throws SQLException {
        String string = " select qt.text_id, qt.logging_session, qt.count, s.statement_text  from dbo.ix_consultant_query_text qt, dbo.sa_diagnostic_query q, dbo.sa_diagnostic_statement s  where discarded is null and qt.text_id is not null  and qt.text_id = q.query_id and q.statement_id = s.statement_id  and qt.master_id = " + _masterIDString;
        return _stmt.executeQuery(string);
    }

    @Override
    public ResultSet runAffectedColumnsQuery() throws SQLException {
        String string = "select ac.table_id,  if ac.column_id is NULL then 0 else column_id endif,  s.statement_text  from dbo.ix_consultant_affected_columns ac,  dbo.sa_diagnostic_query q, dbo.sa_diagnostic_statement s  where ac.master_id = " + _masterIDString + " and ac.text_id = q.query_id " + " and ac.logging_session = q.logging_session_id " + " and q.statement_id = s.statement_id ";
        return _stmt.executeQuery(string);
    }

    @Override
    public void runDiscardWorkloadItemsStatement(Iterator<IxtQuery> iterator) throws SQLException {
        StringBuffer stringBuffer = new StringBuffer("");
        int n = 0;
        stringBuffer.append("(");
        while (iterator.hasNext()) {
            if (n > 0) {
                stringBuffer.append(",");
            }
            IxtQuery ixtQuery = iterator.next();
            stringBuffer.append(ixtQuery.getID());
            ++n;
        }
        stringBuffer.append(")");
        String string = "update dbo.ix_consultant_query_text set discarded = 1  where text_id in " + new String(stringBuffer) + " and master_id = " + _masterIDString;
        _stmt.execute(string);
    }

    @Override
    public int getPhysicalIndexStats(String string) throws SQLException {
        int n = 1;
        ResultSet resultSet = _stmt.executeQuery("select pi.key_value_count, pi.leaf_page_count, pi.depth  from sys.sysphysidx pi, sys.sysidx i  where pi.table_id = i.table_id and pi.phys_index_id = i.phys_index_id  and i.index_name = '" + string + "'");
        if (resultSet.next()) {
            int n2 = resultSet.getInt(1);
            int n3 = resultSet.getInt(2);
            int n4 = resultSet.getInt(3);
            n = IxtDBVersion10.estimateNumberPages(n2, n3, n4);
        }
        resultSet.close();
        return n;
    }

    public static int getNumberPhysicalIndexPages(Connection connection) throws SQLException {
        Statement statement = connection.createStatement();
        int n = 0;
        ResultSet resultSet = statement.executeQuery("select sum(leaf_page_count) from sysphysidx");
        resultSet.next();
        n = resultSet.getInt(1);
        resultSet.close();
        statement.close();
        return n;
    }
}

