/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.indexConsultant;

import com.sybase.indexConsultant.IxtAnalysis;
import com.sybase.indexConsultant.IxtDB;
import com.sybase.indexConsultant.IxtFeedback;
import com.sybase.indexConsultant.IxtInstance;
import com.sybase.indexConsultant.IxtPhase;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;

public class IxtDriver {
    static final double PHASE_REDUCTION = 0.2;
    static IxtDriver _global;
    Statement _stmt;
    IxtAnalysis _analysis;
    IxtPhase _curphase;
    boolean _clustered_option;
    boolean _keep_existing_option;
    long _size_constraint;
    long _master_id;
    boolean _in_progress;
    boolean _is_done;
    boolean _can_stop_early;
    boolean _cancelTuning;
    boolean _was_autocommit;
    IxtFeedback _feedbackControl = null;
    static ResourceBundle _resourceBundle;
    static final String GOT_NEW_MASTER_ID = "GOT_NEW_MASTER_ID";
    static final String GENERATING_INDEXES = "GENERATING_INDEXES";
    static final String GENERATING_STRUCTURES = "GENERATING_STRUCTURES";
    static final String GETTING_PHASE_ONE = "GETTING_PHASE_ONE";
    static final String FOLDING_INDEXES = "FOLDING_INDEXES";
    static final String SUBSUMING_INDEXES = "SUBSUMING_INDEXES";
    static final String GENERATING_NEW_PHASE = "GENERATING_NEW_PHASE";
    static final String ELIM_DUP = "ELIM_DUP";
    static final String ACCOUNTING_FOR_UPDATES = "ACCOUNTING_FOR_UPDATES";
    static final String TRIMMING_EXCESS = "TRIMMING_EXCESS";
    static final String GENERATING_SUMMARY = "GENERATING_SUMMARY";
    static final String WRITING_REPORT = "WRITING_REPORT";
    static final String GETTING_CONFIGURATIONS = "GETTING_CONFIGURATIONS";
    static final String GETTING_CONFIGURATION = "GETTING_CONFIGURATION";
    static final String GETTING_VIRT_INDEXES = "GETTING_VIRT_INDEXES";
    static final String GETTING_VIRT_INDEX = "GETTING_VIRT_INDEX";
    static final String ACCOUNTING_FOR_UPDATE = "ACCOUNTING_FOR_UPDATE";
    static final String INDEX_PHYSICAL = "INDEX_PHYSICAL";
    static final String INDEX_VIRTUAL = "INDEX_VIRTUAL";
    static final String ERROR_INDEX_TABLES_NOT_FOUND = "ERROR_INDEX_TABLES_NOT_FOUND";
    static final String ERROR_ONLY_SEL_UPD_DEL_ALLOWED = "ERROR_ONLY_SEL_UPD_DEL_ALLOWED";
    static final String ERROR_ONLY_SINGLE_QUERY_ALLOWED = "ERROR_ONLY_SINGLE_QUERY_ALLOWED";
    static final String SQL_FILE_DESCRIPTION = "SQL_FILE_DESCRIPTION";
    static final String DBA_PERMISSION_REQUIRED = "DBA_PERMISSION_REQUIRED";
    static final String DBA_PERMISSION_REQUIRED_11 = "DBA_PERMISSION_REQUIRED_11";

    public static boolean getClusteredOption() {
        return IxtDriver._global._clustered_option;
    }

    public static boolean getKeepExistingOption() {
        return IxtDriver._global._keep_existing_option;
    }

    public static long getMasterID() {
        return IxtDriver._global._master_id;
    }

    public static long getSizeConstraint() {
        return IxtDriver._global._size_constraint;
    }

    public static void showSubstatus(String string) {
        IxtDriver._global._feedbackControl.showSubstatus(string);
    }

    public static void showStatus(String string) {
        IxtDriver._global._feedbackControl.showStatus(string);
    }

    public static IxtPhase getCurrentPhase() {
        return IxtDriver._global._curphase;
    }

    private int getSizeOfUselessPhysicalIndexes() {
        if (this._keep_existing_option) {
            return 0;
        }
        int n = 0;
        Vector<String> vector = null;
        try {
            vector = this._analysis.getUselessPhysicalIndexes();
        }
        catch (SQLException sQLException) {
            return 0;
        }
        if (vector == null) {
            return 0;
        }
        for (int i = 0; i < vector.size(); ++i) {
            int n2 = 0;
            try {
                n2 = this._analysis.getIxtDB().getPhysicalIndexStats(vector.get(i));
            }
            catch (SQLException sQLException) {
                n2 = 0;
            }
            if (n2 <= 0) continue;
            n += n2;
        }
        return n;
    }

    public boolean inProgress() {
        return this._in_progress;
    }

    public boolean isDone() {
        return this._is_done;
    }

    public boolean canStopEarly() {
        return this._can_stop_early;
    }

    public void cancel() {
        this._cancelTuning = true;
    }

    public void setFeedbackControl(IxtFeedback ixtFeedback) {
        this._feedbackControl = ixtFeedback;
    }

    public IxtDriver(boolean bl, boolean bl2, long l, IxtAnalysis ixtAnalysis, Connection connection) throws SQLException {
        _global = this;
        this._clustered_option = bl;
        this._keep_existing_option = bl2;
        this._size_constraint = l;
        this._in_progress = false;
        this._is_done = false;
        this._can_stop_early = false;
        this._cancelTuning = false;
        this._feedbackControl = new IxtFeedback();
        this._analysis = ixtAnalysis;
        this._stmt = connection.createStatement();
        this._was_autocommit = this._stmt.getConnection().getAutoCommit();
        this._stmt.getConnection().setAutoCommit(false);
        IxtDB.setStatement(this._stmt);
        IxtDB.runStopIndexTuningStatement();
        this._master_id = IxtDB.getNewMasterID(ixtAnalysis.getName());
        ixtAnalysis.setID(this._master_id);
        IxtDB.debug(IxtDriver.getI18NMessage(GOT_NEW_MASTER_ID) + " " + Long.toString(this._master_id));
    }

    public int tune() throws SQLException {
        int n = 1;
        boolean bl = true;
        this._in_progress = true;
        if (this._cancelTuning) {
            this._stmt.getConnection().setAutoCommit(this._was_autocommit);
            this._in_progress = false;
            this._is_done = true;
            return 0;
        }
        IxtDriver.showStatus(IxtDriver.getI18NMessage(GENERATING_INDEXES));
        IxtDB.runRecommendIndexesStatement(this._master_id, 1, this._clustered_option, this._keep_existing_option);
        IxtDriver.showStatus(IxtDriver.getI18NMessage(GENERATING_STRUCTURES));
        IxtInstance ixtInstance = new IxtInstance(this._analysis);
        ixtInstance.discardQueries();
        IxtDriver.showStatus(IxtDriver.getI18NMessage(GETTING_PHASE_ONE));
        this._curphase = new IxtPhase(1, ixtInstance, this._keep_existing_option);
        IxtDriver.showStatus(IxtDriver.getI18NMessage(FOLDING_INDEXES));
        this._curphase.augmentIndexesWithPhysical();
        this._curphase.foldIndexes(new IxtPhase.DuplicateFoldMatcher());
        this._curphase.clearNegatives();
        this._curphase.assignIndexPenalties();
        IxtDriver.showStatus(IxtDriver.getI18NMessage(SUBSUMING_INDEXES));
        this._curphase.foldIndexes(new IxtPhase.SubsumingFoldMatcher());
        this._curphase.clearNegatives();
        this._curphase.addReport();
        this._feedbackControl.setProgressComplete();
        this._feedbackControl.showResults(n, this._curphase);
        while (!this._cancelTuning && bl && this._curphase.getTotalSize() - (long)this.getSizeOfUselessPhysicalIndexes() > this._size_constraint) {
            this._feedbackControl.setProgressRestart();
            IxtDriver.showStatus(IxtDriver.getI18NMessage(GENERATING_NEW_PHASE));
            ++n;
            this._curphase = this._curphase.genNewPhase();
            IxtDriver.showStatus(IxtDriver.getI18NMessage(ELIM_DUP));
            this._curphase.foldIndexes(new IxtPhase.DuplicateFoldMatcher());
            IxtDriver.showStatus(IxtDriver.getI18NMessage(ACCOUNTING_FOR_UPDATES));
            this._curphase.assignIndexPenalties();
            IxtDriver.showStatus(IxtDriver.getI18NMessage(SUBSUMING_INDEXES));
            this._curphase.foldIndexes(new IxtPhase.SubsumingFoldMatcher());
            IxtDriver.showStatus(IxtDriver.getI18NMessage(TRIMMING_EXCESS));
            bl = this._curphase.trimPhase(this._size_constraint, 0.2);
            this._curphase.addReport();
            this._feedbackControl.setProgressComplete();
            this._feedbackControl.showResults(n, this._curphase);
        }
        if (this._cancelTuning || (double)this._curphase.getTotalSize() == 0.0) {
            this._stmt.getConnection().commit();
            this._stmt.getConnection().setAutoCommit(this._was_autocommit);
            this._in_progress = false;
            this._is_done = true;
            return 0;
        }
        this._feedbackControl.setProgressRestart();
        IxtDriver.showStatus(IxtDriver.getI18NMessage(GENERATING_SUMMARY));
        ++n;
        if (IxtDriver.getClusteredOption()) {
            this._curphase.selectClustered();
        }
        this._curphase = this._curphase.genNewPhase();
        IxtDriver.showStatus(IxtDriver.getI18NMessage(ACCOUNTING_FOR_UPDATES));
        this._curphase.foldIndexes(new IxtPhase.DuplicateFoldMatcher());
        this._curphase.assignIndexPenalties();
        this._curphase.selectClustered();
        IxtDriver.showStatus(IxtDriver.getI18NMessage(WRITING_REPORT));
        this._curphase.addReport();
        this._feedbackControl.setProgressComplete();
        this._feedbackControl.showResults(n, this._curphase);
        IxtDB.runStopIndexTuningStatement();
        this._stmt.getConnection().commit();
        this._stmt.getConnection().setAutoCommit(this._was_autocommit);
        this._in_progress = false;
        this._is_done = true;
        this._analysis.sendPhase(this._curphase);
        return 0;
    }

    static final String getI18NMessage(String string) {
        String string2 = "";
        try {
            string2 = (String)_resourceBundle.getObject(string);
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
        return string2;
    }

    static {
        _resourceBundle = null;
        String string = System.getProperty("language", System.getProperty("user.language", null));
        String string2 = System.getProperty("country", System.getProperty("user.region", null));
        if (string != null && string2 != null) {
            try {
                _resourceBundle = ResourceBundle.getBundle("com.sybase.indexConsultant.IndexConsultantResourceBundle", new Locale(string, string2));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (_resourceBundle == null) {
            try {
                _resourceBundle = ResourceBundle.getBundle("com.sybase.indexConsultant.IndexConsultantResourceBundle", Locale.getDefault());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (_resourceBundle == null) {
            try {
                _resourceBundle = ResourceBundle.getBundle("com.sybase.indexConsultant.IndexConsultantResourceBundle");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (_resourceBundle == null) {
            throw new MissingResourceException("Can't find resource for base name com.sybase.indexConsultant.IndexConsultantResourceBundle", "", "");
        }
    }
}

