/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.indexConsultant;

import com.sybase.indexConsultant.IxtPhase;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.Date;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import javax.swing.table.DefaultTableModel;

public class IxtFeedback {
    JProgressBar _progressBar;
    JLabel _statusLabel;
    JLabel _substatusLabel;
    DefaultTableModel _phaseSummary;

    public IxtFeedback() {
        this._progressBar = null;
        this._statusLabel = null;
        this._substatusLabel = null;
        this._phaseSummary = null;
    }

    public IxtFeedback(JProgressBar jProgressBar, JLabel jLabel, JLabel jLabel2, DefaultTableModel defaultTableModel) {
        this._progressBar = jProgressBar;
        this._statusLabel = jLabel;
        this._substatusLabel = jLabel2;
        this._phaseSummary = defaultTableModel;
    }

    public void showResults(int n, IxtPhase ixtPhase) {
        if (ixtPhase == null || this._phaseSummary == null || this._progressBar == null) {
            return;
        }
        double d = ixtPhase.getTotalPhaseCost();
        double d2 = ixtPhase.getImprovementSum();
        this._phaseSummary.addRow(new Object[]{new Integer(n), new IxtDecimal(d), new Long(ixtPhase.getTotalRecommendedSize()), new IxtDecimal(this._progressBar.getMaximum() <= 0 ? 0.0 : d2 / (double)this._progressBar.getMaximum()), new Timestamp(new Date().getTime()).toString()});
    }

    public void showSubstatus(String string) {
        if (this._substatusLabel != null) {
            this._substatusLabel.setText(string);
        }
    }

    public void showStatus(String string) {
        if (this._statusLabel != null) {
            this._statusLabel.setText(string);
        }
    }

    public void setProgressComplete() {
        if (this._progressBar != null) {
            this._progressBar.setValue(this._progressBar.getMaximum());
            this._progressBar.setString("100%");
        }
    }

    public void setProgressRestart() {
        if (this._progressBar != null) {
            this._progressBar.setValue(0);
            this._progressBar.setString("0%");
        }
    }

    public static class IxtVariableDecimal
    extends Number {
        private Double _value;
        private static DecimalFormat _form = new DecimalFormat();

        public IxtVariableDecimal(double d) {
            this._value = new Double(d);
        }

        public IxtVariableDecimal(String string) {
            this._value = new Double(string);
        }

        @Override
        public byte byteValue() {
            return this._value.byteValue();
        }

        @Override
        public double doubleValue() {
            return this._value;
        }

        @Override
        public float floatValue() {
            return this._value.floatValue();
        }

        @Override
        public int intValue() {
            return this._value.intValue();
        }

        @Override
        public long longValue() {
            return this._value.longValue();
        }

        @Override
        public short shortValue() {
            return this._value.shortValue();
        }

        public int compareTo(IxtDecimal ixtDecimal) {
            return this._value.compareTo(ixtDecimal._value);
        }

        public int hashCode() {
            return this._value.hashCode();
        }

        public String toString() {
            return _form.format(this.doubleValue());
        }

        static {
            _form.setMaximumFractionDigits(2);
            _form.setMinimumFractionDigits(0);
            _form.setDecimalSeparatorAlwaysShown(false);
            _form.setGroupingUsed(false);
        }
    }

    public static class IxtDecimal
    extends Number {
        private Double _value;
        private static DecimalFormat _form = new DecimalFormat();

        public IxtDecimal(double d) {
            this._value = new Double(d);
        }

        public IxtDecimal(String string) {
            this._value = new Double(string);
        }

        @Override
        public byte byteValue() {
            return this._value.byteValue();
        }

        @Override
        public double doubleValue() {
            return this._value;
        }

        @Override
        public float floatValue() {
            return this._value.floatValue();
        }

        @Override
        public int intValue() {
            return this._value.intValue();
        }

        @Override
        public long longValue() {
            return this._value.longValue();
        }

        @Override
        public short shortValue() {
            return this._value.shortValue();
        }

        public int compareTo(IxtDecimal ixtDecimal) {
            return this._value.compareTo(ixtDecimal._value);
        }

        public int hashCode() {
            return this._value.hashCode();
        }

        public String toString() {
            return _form.format(this.doubleValue());
        }

        static {
            _form.setMaximumFractionDigits(2);
            _form.setMinimumFractionDigits(2);
            _form.setDecimalSeparatorAlwaysShown(true);
            _form.setGroupingUsed(false);
        }
    }
}

