/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.indexConsultant;

import com.sybase.indexConsultant.IxtColumn;
import com.sybase.indexConsultant.IxtConfiguration;
import com.sybase.indexConsultant.IxtDriver;
import com.sybase.indexConsultant.IxtElement;
import com.sybase.indexConsultant.IxtFeedback;
import com.sybase.indexConsultant.IxtPhase;
import com.sybase.indexConsultant.IxtTable;
import com.sybase.util.Dbg;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Vector;

public class IxtIndex {
    static final double UPDATE_COST = 5.0E7;
    static final int CLUSTERED_UPDATE_PENALTY = 4;
    static final double SIZE_PENALTY_EXPONENT = 0.6;
    String _creator = "";
    long _id;
    IxtTable _table;
    long _size;
    boolean _virtual;
    String _name;
    boolean _is_clustered;
    double _cluster_score;
    boolean _disabled;
    Vector<IxtElement> _elements;
    Vector<IxtConfiguration> _configurations;
    double _duipenalty;
    double _total_benefit;
    double _relative_benefit;
    boolean _is_key;
    long _num_times_used;

    public IxtIndex(long l, IxtTable ixtTable, long l2, boolean bl, String string, boolean bl2) {
        this._id = l;
        this._table = ixtTable;
        this._size = l2;
        this._virtual = bl;
        this._name = string;
        this._is_key = bl2;
        this._disabled = false;
        this._elements = new Vector();
        this._configurations = new Vector();
        this._num_times_used = 0L;
    }

    public IxtTable getTable() {
        return this._table;
    }

    public long getID() {
        return this._id;
    }

    public boolean isKey() {
        return this._is_key;
    }

    public String getCreator() {
        return this._creator;
    }

    public void setCreator(String string) {
        this._creator = string;
    }

    public void setID(long l) {
        this._id = l;
    }

    public boolean isClustered() {
        return this._is_clustered;
    }

    public void clearElements() {
        this._elements.clear();
    }

    public IxtElement getElement(int n) {
        return this._elements.elementAt(n);
    }

    public int getNumElements() {
        return this._elements.size();
    }

    public Iterator<IxtElement> getElementIterator() {
        return this._elements.iterator();
    }

    public void setElements(Vector<IxtElement> vector) {
        this._elements = vector;
    }

    public boolean hasElement(IxtElement ixtElement) {
        return this._elements.indexOf(ixtElement) != -1;
    }

    public void disable() {
        this._disabled = true;
    }

    public void setIsClustered(boolean bl) {
        this._is_clustered = bl;
    }

    public void setSize(long l) {
        this._size = l;
    }

    public double getClusterScore() {
        return this._cluster_score;
    }

    public void setClusterScore(double d) {
        this._cluster_score = d;
    }

    public void addElement(IxtElement ixtElement) {
        this._elements.add(ixtElement);
    }

    IxtElement getIndexElement(int n) {
        return this._elements.elementAt(n);
    }

    public void addConfiguration(IxtConfiguration ixtConfiguration) {
        this._configurations.add(ixtConfiguration);
    }

    public Vector<IxtConfiguration> getConfigurations() {
        return this._configurations;
    }

    public void appendConfigurations(Vector<IxtConfiguration> vector) {
        this._configurations.addAll(vector);
    }

    public void clearConfigurations() {
        this._configurations = new Vector();
    }

    public Iterator<IxtConfiguration> getConfigurationIterator() {
        return this._configurations.iterator();
    }

    public boolean isVirtual() {
        return this._virtual;
    }

    public void setIsVirtual(boolean bl) {
        this._virtual = bl;
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public static String identifierSubstring(String string) {
        int n = Math.min(string.length(), 16);
        return string.substring(0, n);
    }

    public void incrementTimesUsed() {
        ++this._num_times_used;
    }

    public String generateName(long l) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("_");
        if (this._is_clustered) {
            stringBuffer.append("cl");
        }
        stringBuffer.append("$" + IxtIndex.identifierSubstring(this._table.getName()));
        stringBuffer.append("$" + IxtIndex.identifierSubstring(this.getElement(0).getColumn().getName()));
        stringBuffer.append(Long.toString(0xFFFFFFFFL - l));
        return new String(stringBuffer);
    }

    public String getName() {
        if (this._name == null) {
            return this.generateName(this._id);
        }
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
    }

    public long getSize() {
        return this._size;
    }

    public String genCreateStatement(boolean bl, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("create ");
        if (!bl) {
            stringBuffer.append(" virtual ");
        }
        if (this._is_clustered) {
            stringBuffer.append(" clustered ");
        }
        stringBuffer.append("index \"");
        if (this._name != null) {
            stringBuffer.append(this._name);
        } else if (string != null) {
            stringBuffer.append(string);
        } else {
            stringBuffer.append(this.generateName(this._id));
        }
        stringBuffer.append("\" on \"");
        stringBuffer.append(this._table.getCreator() + "\".\"" + this._table.getName());
        stringBuffer.append("\" (\"");
        for (int i = 0; i < this._elements.size(); ++i) {
            if (i > 0) {
                stringBuffer.append(", \"");
            }
            stringBuffer.append(this.getIndexElement(i).getColumn().getName());
            if (this.getIndexElement(i).getDirection() >= 0) {
                stringBuffer.append("\" ASC ");
                continue;
            }
            stringBuffer.append("\" DESC ");
        }
        stringBuffer.append(");");
        return new String(stringBuffer);
    }

    public IxtElement[] GetCommonOrder(IxtIndex ixtIndex) {
        return null;
    }

    public void setDUIPenalty(double d) {
        this._duipenalty = d;
    }

    public void setTotalBenefit(double d) {
        this._total_benefit = d;
    }

    public void setRelativeBenefit(double d) {
        this._relative_benefit = d;
    }

    public double retrieveRelativeBenefit() {
        return Math.rint(this._relative_benefit);
    }

    public double retrieveTotalCostBenefit() {
        return this._total_benefit;
    }

    public double retrieveUpdateCost() {
        return this._duipenalty;
    }

    public double retrieveTotalBenefit() {
        return this._total_benefit - this._duipenalty;
    }

    public double getDUIPenalty() {
        return this._duipenalty;
    }

    public double getBenefitSum() {
        double d = 0.0;
        for (IxtConfiguration ixtConfiguration : this._configurations) {
            d += ixtConfiguration.getBenefit();
        }
        return d;
    }

    public double getTotalBenefit() {
        double d = this.getBenefitSum();
        return d -= this._duipenalty;
    }

    public double getRelativeBenefit() {
        IxtPhase ixtPhase = IxtDriver.getCurrentPhase();
        double d = 0.0;
        if (ixtPhase.getMaxDUIPenalty() > 0.0) {
            d = -20.0 * this._duipenalty / ixtPhase.getMaxDUIPenalty();
        }
        double d2 = 0.0;
        if (ixtPhase.getMaxNumConfigs() > 0) {
            d2 = 20.0 * (double)this._configurations.size() / (double)ixtPhase.getMaxNumConfigs();
        }
        double d3 = 40.0 * (double)this._table.getSize() / (double)ixtPhase.getInstance().getMaxTableSize();
        double d4 = 0.0;
        if (ixtPhase.getMaxBenefitSum() > 0.0) {
            d4 = 35.0 * this.getBenefitSum() / ixtPhase.getMaxBenefitSum();
        }
        double d5 = this._is_clustered ? 20.0 : 1.0;
        double d6 = d3 + d5 + d4;
        d6 += d + d2;
        if ((d6 /= 13.5) < 1.0) {
            d6 = 1.0;
        }
        if (d6 > 10.0) {
            d6 = 10.0;
        }
        if (d6 == Double.NaN) {
            d6 = 1.0;
            Dbg.wassert((boolean)false);
        }
        this._relative_benefit = d6 = 1.0;
        return d6;
    }

    public boolean isOnTable(IxtTable ixtTable) {
        return this._table == ixtTable;
    }

    public boolean containsColumn(IxtColumn ixtColumn) {
        if (this._table != ixtColumn.getTable()) {
            return false;
        }
        for (IxtElement ixtElement : this._elements) {
            if (ixtElement.getColumn() != ixtColumn) continue;
            return true;
        }
        return false;
    }

    public void addDUIPenalty(double d) {
        this._duipenalty += d * 5.0E7 * Math.log(this._size);
        if (this._is_clustered) {
            this._duipenalty *= 4.0;
        }
    }

    public String elementsString() {
        String string = "";
        Iterator<IxtElement> iterator = this._elements.iterator();
        while (iterator.hasNext()) {
            IxtElement ixtElement = iterator.next();
            string = string + ixtElement.getColumn().getName();
            if (!iterator.hasNext()) continue;
            string = string + ",";
        }
        return string;
    }

    public Vector<Object> convertToUselessIDXVector() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this._table.getName());
        vector.add(this._name);
        return vector;
    }

    public Vector<Object> convertToFullIDXVector() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this._creator);
        vector.add(this._table.getName());
        vector.add(this.elementsString());
        if (this._is_clustered) {
            vector.add("CLUSTERED");
        } else {
            vector.add("");
        }
        if (this._virtual) {
            vector.add("VIRTUAL");
        } else {
            vector.add("PHYSICAL");
        }
        vector.add(new Long(this._size));
        vector.add(new IxtFeedback.IxtVariableDecimal(this.retrieveRelativeBenefit()));
        vector.add(new IxtFeedback.IxtDecimal(this.retrieveTotalCostBenefit()));
        vector.add(new IxtFeedback.IxtDecimal(this.retrieveUpdateCost()));
        vector.add(new IxtFeedback.IxtDecimal(this.retrieveTotalBenefit()));
        return vector;
    }

    public Vector<Object> convertToIndexesUsedVector() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this._creator);
        vector.add(this._table.getName());
        vector.add(this.elementsString());
        vector.add(this._is_clustered ? "CLUSTERED" : "");
        vector.add(this._virtual ? "VIRTUAL" : "PHYSICAL");
        return vector;
    }

    public boolean equals(Object object) {
        IxtIndex ixtIndex = (IxtIndex)object;
        return ixtIndex.getID() == this._id && ixtIndex.getTable().getID() == this._table.getID();
    }

    public Vector<IxtElement> getCommonOrder(IxtIndex ixtIndex) {
        IxtElement ixtElement3;
        int n = 0;
        int n2 = 1;
        int n3 = -1;
        Vector<IxtElement> vector = new Vector<IxtElement>();
        Vector<IxtElement> vector2 = new Vector<IxtElement>();
        Vector<IxtElement> vector3 = new Vector<IxtElement>();
        Vector<IxtElement> vector4 = new Vector<IxtElement>();
        boolean bl = false;
        int n4 = n;
        Vector<IxtElement> vector5 = new Vector<IxtElement>();
        int n5 = n;
        Iterator<IxtElement> iterator = this.getElementIterator();
        while (iterator.hasNext()) {
            ixtElement3 = iterator.next();
            if (!bl && ixtElement3.getDirection() == n) {
                vector.add(ixtElement3);
                continue;
            }
            bl = true;
            vector3.add(ixtElement3);
        }
        bl = false;
        Iterator<IxtElement> iterator2 = ixtIndex.getElementIterator();
        while (iterator2.hasNext()) {
            IxtElement ixtElement2 = iterator2.next();
            if (!bl && ixtElement2.getDirection() == n) {
                vector2.add(ixtElement2);
                continue;
            }
            bl = true;
            vector4.add(ixtElement2);
        }
        if (vector.size() < vector2.size()) {
            Vector<IxtElement> vector6 = vector;
            vector = vector2;
            vector2 = vector6;
            vector6 = vector3;
            vector3 = vector4;
            vector4 = vector6;
        }
        for (IxtElement ixtElement2 : vector2) {
            iterator = vector.iterator();
            if (!iterator.hasNext()) continue;
            ixtElement3 = iterator.next();
            if (new IxtElement.ExactComparator(n).compare(ixtElement2, ixtElement3) == 0) {
                vector5.add(new IxtElement(ixtElement3.getColumn(), n));
                iterator.remove();
                continue;
            }
            return null;
        }
        for (IxtElement ixtElement2 : vector4) {
            if (vector.size() > 0) {
                iterator = vector.iterator();
                if (!iterator.hasNext()) continue;
                ixtElement3 = iterator.next();
                if (new IxtElement.RoughComparator().compare(ixtElement2, ixtElement3) == 0) {
                    n5 = ixtElement3.getDominantDirection(ixtElement2);
                    vector5.add(new IxtElement(ixtElement2.getColumn(), n5));
                    iterator.remove();
                    continue;
                }
                return null;
            }
            if (vector3.size() > 0) {
                ixtElement3 = (IxtElement)vector3.elementAt(0);
                n5 = ixtElement2.getDirection();
                if (n4 == n && new IxtElement.ExactComparator(n2).compare(ixtElement2, ixtElement3) == 0) {
                    n4 = n2;
                    continue;
                }
                if (n4 == n && new IxtElement.ExactComparator(n3).compare(ixtElement2, ixtElement3) == 0) {
                    n4 = n3;
                    continue;
                }
                if (new IxtElement.ExactComparator(n4).compare(ixtElement2, ixtElement3) == 0) continue;
                if (new IxtElement.RoughComparator().compare(ixtElement2, ixtElement3) == 0) {
                    n5 = ixtElement2.getDominantDirection(ixtElement3);
                    continue;
                }
                return null;
            }
            vector5.add(new IxtElement(ixtElement2.getColumn(), n5));
        }
        if (vector3.size() > 0) {
            for (IxtElement ixtElement3 : vector3) {
                vector5.add(new IxtElement(ixtElement3.getColumn(), ixtElement3.getDirection()));
            }
        }
        if (n4 == n3) {
            for (IxtElement ixtElement3 : vector5) {
                ixtElement3.setDirection(ixtElement3.getDirection() * n3);
            }
        }
        return vector5;
    }

    static class RelativeBenefitComparator
    implements Comparator<IxtIndex> {
        RelativeBenefitComparator() {
        }

        @Override
        public int compare(IxtIndex ixtIndex, IxtIndex ixtIndex2) {
            return Double.compare(ixtIndex.getRelativeBenefit(), ixtIndex2.getRelativeBenefit());
        }

        public boolean equals(IxtIndex ixtIndex) {
            return false;
        }
    }

    static class TotalBenefitComparator
    implements Comparator<IxtIndex> {
        TotalBenefitComparator() {
        }

        @Override
        public int compare(IxtIndex ixtIndex, IxtIndex ixtIndex2) {
            return Double.compare(ixtIndex.getTotalBenefit(), ixtIndex2.getTotalBenefit());
        }

        public boolean equals(IxtIndex ixtIndex) {
            return false;
        }
    }

    static class TableComparator
    implements Comparator<IxtIndex> {
        TableComparator() {
        }

        @Override
        public int compare(IxtIndex ixtIndex, IxtIndex ixtIndex2) {
            if (ixtIndex._table == ixtIndex2._table) {
                return 0;
            }
            return 1;
        }

        public boolean equals(IxtIndex ixtIndex) {
            return false;
        }
    }

    static class SizeComparator
    implements Comparator<IxtIndex> {
        SizeComparator() {
        }

        @Override
        public int compare(IxtIndex ixtIndex, IxtIndex ixtIndex2) {
            return new Long(ixtIndex._size).compareTo(new Long(ixtIndex2._size));
        }

        public boolean equals(IxtIndex ixtIndex) {
            return false;
        }
    }

    static class ExactComparator
    implements Comparator<IxtIndex> {
        ExactComparator() {
        }

        @Override
        public int compare(IxtIndex ixtIndex, IxtIndex ixtIndex2) {
            if (ixtIndex._table.getID() != ixtIndex2._table.getID() || ixtIndex._elements.size() != ixtIndex2._elements.size()) {
                return 1;
            }
            for (int i = 0; i < ixtIndex._elements.size(); ++i) {
                if (ixtIndex.getIndexElement(i).getColumn() == ixtIndex2.getIndexElement(i).getColumn()) continue;
                return 1;
            }
            return 0;
        }

        public boolean equals(IxtIndex ixtIndex) {
            return false;
        }
    }
}

