/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.indexConsultant;

import com.sybase.indexConsultant.IxtAnalysis;
import com.sybase.indexConsultant.IxtColumn;
import com.sybase.indexConsultant.IxtIndex;
import com.sybase.indexConsultant.IxtQuery;
import com.sybase.indexConsultant.IxtTable;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class IxtInstance {
    static final double UNUSABLE_COST = 1.0E32;
    static final double MINIMUM_RELEVANCE_RATIO = 0.01;
    HashMap<Long, IxtTable> _tables = new HashMap();
    Vector<IxtColumn> _columns;
    HashMap<Long, IxtQuery> _queries = new HashMap();
    Vector<IxtIndex> _physicalindexes = new Vector();
    Vector<IxtQuery> _discardablequeries = new Vector();
    int _max_table_size = 0;
    IxtAnalysis _analysis;

    public IxtInstance(IxtAnalysis ixtAnalysis) throws SQLException {
        this._analysis = ixtAnalysis;
        this._analysis.loadDB();
        this._analysis.loadQueries();
        this.selectDiscardableQueries();
    }

    public IxtQuery findQuery(String string) {
        return this._analysis.findQuery(string);
    }

    public IxtTable findTable(long l) {
        return this._analysis.findTable(l);
    }

    public void clearTableVirtIndexes() {
        this._analysis.clearTableVirtIndexes();
    }

    public HashMap<Long, IxtTable> getTables() {
        return this._analysis.getTables();
    }

    public int getMaxTableSize() {
        return this._analysis.getMaxTableSize();
    }

    public Iterator<IxtQuery> getQueryIterator() {
        return this._analysis.getQueryIterator();
    }

    public Iterator<IxtQuery> getDiscardableIterator() {
        return this._discardablequeries.iterator();
    }

    public Vector<IxtQuery> getDiscardableQueries() {
        return this._discardablequeries;
    }

    public Iterator<IxtIndex> getPhysicalIndexIterator() {
        return this._analysis.getPhysicalIndexIterator();
    }

    public Vector<IxtIndex> getPhysicalIndexes() {
        return this._analysis.getPhysicalIndexes();
    }

    public void loadQueries() throws SQLException {
        this._analysis.loadQueries();
    }

    void selectDiscardableQueries() {
        double d = 0.0;
        Iterator<IxtQuery> iterator = this.getQueryIterator();
        while (iterator.hasNext()) {
            IxtQuery ixtQuery = iterator.next();
            if (ixtQuery.getVanillaCost() < 1.0E32) {
                d = Math.max(ixtQuery.getVanillaCost() * (double)ixtQuery.getCount(), d);
                continue;
            }
            this._discardablequeries.add(ixtQuery);
        }
    }

    public double getTotalVanillaCost() {
        double d = 0.0;
        Iterator<IxtQuery> iterator = this.getQueryIterator();
        while (iterator.hasNext()) {
            IxtQuery ixtQuery = iterator.next();
            d += ixtQuery.getVanillaCost();
        }
        return d;
    }

    public void discardQueries() throws SQLException {
        if (this._discardablequeries.size() > 0) {
            this._analysis.getIxtDB().runDiscardWorkloadItemsStatement(this.getDiscardableIterator());
        }
    }
}

