/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.indexConsultant;

import com.sybase.indexConsultant.IxtColumn;
import com.sybase.indexConsultant.IxtConfiguration;
import com.sybase.indexConsultant.IxtDB;
import com.sybase.indexConsultant.IxtDriver;
import com.sybase.indexConsultant.IxtElement;
import com.sybase.indexConsultant.IxtIndex;
import com.sybase.indexConsultant.IxtInstance;
import com.sybase.indexConsultant.IxtQuery;
import com.sybase.indexConsultant.IxtTable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;

public class IxtPhase {
    int _id;
    IxtInstance _instance;
    Vector<IxtConfiguration> _configurations;
    Vector<IxtIndex> _indexes;
    int _max_num_configs;
    double _max_benefit_sum;
    double _max_dui_penalty;
    boolean _keep_existing;

    public IxtPhase(int n, IxtInstance ixtInstance, boolean bl) throws SQLException {
        this._instance = ixtInstance;
        this._id = n;
        this._configurations = new Vector();
        this._indexes = new Vector();
        this._keep_existing = bl;
        this.getConfigurations();
        this.getIndexes();
        for (IxtConfiguration ixtConfiguration : this._configurations) {
            Iterator<IxtIndex> iterator = ixtConfiguration.getIndexIterator();
            while (iterator.hasNext()) {
                IxtIndex ixtIndex = iterator.next();
                this._indexes.add(ixtIndex);
            }
        }
        this._max_num_configs = 0;
        this._max_benefit_sum = 0.0;
        this._max_dui_penalty = 0.0;
    }

    public void getConfigurations() throws SQLException {
        IxtIndex ixtIndex = null;
        Iterator<IxtQuery> iterator = this._instance.getQueryIterator();
        int n = 0;
        IxtDriver.showSubstatus(IxtDriver.getI18NMessage("GETTING_CONFIGURATIONS"));
        this._instance.clearTableVirtIndexes();
        while (iterator.hasNext()) {
            IxtQuery ixtQuery = iterator.next();
            ResultSet resultSet = IxtDB.runConfigurationsQuery(this._id, ixtQuery.getID());
            double d = ixtQuery.getVanillaCost();
            Vector<IxtIndex> vector = new Vector<IxtIndex>();
            IxtDriver.showSubstatus(IxtDriver.getI18NMessage("GETTING_CONFIGURATION") + " " + Integer.toString(++n));
            while (resultSet.next()) {
                boolean bl;
                long l = resultSet.getLong(1);
                long l2 = resultSet.getLong(2);
                IxtTable ixtTable = this._instance.findTable(l2);
                if (ixtTable == null) continue;
                long l3 = resultSet.getLong(3);
                d = resultSet.getDouble(4);
                boolean bl2 = resultSet.getInt(5) != 0;
                double d2 = resultSet.getDouble(6);
                boolean bl3 = bl = resultSet.getInt(7) != 0;
                if (!bl) {
                    ixtIndex = ixtTable.findPhysicalIndex(l);
                    ixtIndex.setSize(l3);
                    if (ixtIndex.getConfigurations().size() > 0) {
                        ixtIndex.clearConfigurations();
                    }
                } else {
                    ixtIndex = new IxtIndex(l, ixtTable, l3, bl, null, false);
                }
                ixtIndex.setCreator(ixtTable.getCreator());
                ixtIndex.setClusterScore(d2);
                ixtIndex.setIsClustered(bl2);
                vector.add(ixtIndex);
            }
            resultSet.close();
            IxtConfiguration ixtConfiguration = new IxtConfiguration(ixtQuery, d, vector);
            this._configurations.add(ixtConfiguration);
            ixtQuery.setConfig(this._id, ixtConfiguration);
        }
    }

    public void augmentIndexesWithPhysical() {
        this._indexes.addAll(this._instance.getPhysicalIndexes());
    }

    void getIndexes() throws SQLException {
        Iterator<IxtConfiguration> iterator = this._configurations.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            IxtConfiguration ixtConfiguration = iterator.next();
            Iterator<IxtIndex> iterator2 = ixtConfiguration.getIndexIterator();
            IxtDriver.showSubstatus(IxtDriver.getI18NMessage("GETTING_VIRT_INDEXES"));
            while (iterator2.hasNext()) {
                IxtIndex ixtIndex = iterator2.next();
                IxtDriver.showSubstatus(IxtDriver.getI18NMessage("GETTING_VIRT_INDEX") + " " + Integer.toString(++n));
                ResultSet resultSet = IxtDB.runIndexColumnsQuery(this._id, ixtIndex.getTable().getID(), ixtIndex.getID());
                while (resultSet.next()) {
                    ixtIndex.addElement(new IxtElement(ixtIndex.getTable().findColumn(resultSet.getLong(1)), resultSet.getInt(2)));
                }
                resultSet.close();
                ixtIndex.addConfiguration(ixtConfiguration);
            }
        }
    }

    public Vector<IxtIndex> retrieveIndexes() {
        return this._indexes;
    }

    public void assignIndexPenalties() {
        int n = 0;
        Iterator<IxtQuery> iterator = this._instance.getQueryIterator();
        while (iterator.hasNext()) {
            IxtQuery ixtQuery = iterator.next();
            IxtDriver.showSubstatus(IxtDriver.getI18NMessage("ACCOUNTING_FOR_UPDATE") + " " + Integer.toString(++n));
            Iterator<IxtTable> iterator2 = ixtQuery.getAffectedTablesIterator();
            while (iterator2.hasNext()) {
                IxtTable ixtTable = iterator2.next();
                for (IxtIndex ixtIndex : this._indexes) {
                    if (!ixtIndex.isOnTable(ixtTable)) continue;
                    ixtIndex.addDUIPenalty((double)ixtQuery.getCount() * ixtQuery.getNumRowsAffected());
                }
            }
            Iterator<IxtColumn> iterator3 = ixtQuery.getAffectedColumnsIterator();
            while (iterator3.hasNext()) {
                IxtColumn ixtColumn = iterator3.next();
                for (IxtIndex ixtIndex : this._indexes) {
                    if (!ixtIndex.containsColumn(ixtColumn)) continue;
                    ixtIndex.addDUIPenalty((double)ixtQuery.getCount() * ixtQuery.getNumRowsAffected());
                }
            }
        }
    }

    public IxtPhase genNewPhase() throws SQLException {
        IxtDB.runStopIndexTuningStatement();
        this.generateIndexes();
        IxtDB.runRecommendIndexesStatement(IxtDriver.getMasterID(), this._id + 1, IxtDriver.getClusteredOption(), IxtDriver.getKeepExistingOption());
        this._instance.loadQueries();
        return new IxtPhase(this._id + 1, this._instance, this._keep_existing);
    }

    public double getTotalPhaseCost() {
        double d = 0.0;
        Iterator<IxtQuery> iterator = this._instance.getQueryIterator();
        while (iterator.hasNext()) {
            IxtQuery ixtQuery = iterator.next();
            IxtConfiguration ixtConfiguration = ixtQuery.getConfigurationByPhase(this._id);
            if (ixtConfiguration != null) {
                d += ixtConfiguration.getWorkingCost();
                continue;
            }
            d += ixtQuery.getVanillaCost();
        }
        return d;
    }

    public void generateIndexes() throws SQLException {
        for (IxtIndex ixtIndex : this._indexes) {
            String string;
            if (!ixtIndex.isVirtual()) continue;
            if (IxtDriver.getClusteredOption()) {
                ixtIndex.setIsClustered(false);
                string = ixtIndex.genCreateStatement(false, null);
                IxtDB.getStatement().execute(string);
                ixtIndex.setIsClustered(true);
            }
            string = ixtIndex.genCreateStatement(false, null);
            IxtDB.getStatement().execute(string);
        }
        Iterator<IxtIndex> iterator = this._instance.getPhysicalIndexIterator();
        while (iterator.hasNext()) {
            IxtIndex ixtIndex;
            ixtIndex = iterator.next();
            if (!ixtIndex.isDisabled() || ixtIndex.isKey() || !ixtIndex.isVirtual() && this._keep_existing) continue;
            IxtDB.runDisableIndexStatement(ixtIndex.getName(), ixtIndex.getTable().getName(), ixtIndex.getTable().getCreator());
        }
    }

    public long getTotalSize() {
        long l = 0L;
        for (IxtIndex ixtIndex : this._indexes) {
            l += ixtIndex.getSize();
        }
        return l;
    }

    public long getTotalRecommendedSize() {
        long l = 0L;
        for (IxtIndex ixtIndex : this._indexes) {
            if (!ixtIndex.isVirtual() && this._keep_existing) continue;
            l += ixtIndex.getSize();
        }
        return l;
    }

    public boolean trimFromFront(double d) {
        long l = 0L;
        Iterator<IxtIndex> iterator = this._indexes.iterator();
        boolean bl = false;
        while (iterator.hasNext() && (double)l < d) {
            IxtIndex ixtIndex = iterator.next();
            if (!ixtIndex.isVirtual() && this._keep_existing) continue;
            l += ixtIndex.getSize();
            ixtIndex.disable();
            iterator.remove();
            bl = true;
        }
        return bl;
    }

    public void selectClustered() {
        HashMap<IxtTable, IxtIndex> hashMap = new HashMap<IxtTable, IxtIndex>();
        for (IxtIndex ixtIndex : this._indexes) {
            if (ixtIndex.getTable().getClusterID() != 0) {
                ixtIndex.setIsClustered(false);
                continue;
            }
            if (hashMap.containsKey(ixtIndex.getTable())) {
                IxtIndex ixtIndex2 = (IxtIndex)hashMap.get(ixtIndex.getTable());
                if (ixtIndex2.isVirtual() && ixtIndex.getClusterScore() > ixtIndex2.getClusterScore()) {
                    hashMap.put(ixtIndex.getTable(), ixtIndex);
                    ixtIndex.setIsClustered(true);
                    ixtIndex2.setIsClustered(false);
                    continue;
                }
                ixtIndex.setIsClustered(false);
                continue;
            }
            if (!ixtIndex.isClustered()) continue;
            hashMap.put(ixtIndex.getTable(), ixtIndex);
        }
    }

    public double getImprovementSum() {
        double d = 0.0;
        for (IxtConfiguration ixtConfiguration : this._configurations) {
            d += ixtConfiguration.getBenefit();
        }
        return d;
    }

    public String makeSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        long l = 0L;
        for (IxtIndex ixtIndex : this._indexes) {
            stringBuffer.append(ixtIndex.genCreateStatement(true, ixtIndex.generateName(++l)));
        }
        Iterator<IxtIndex> iterator = this._instance.getPhysicalIndexIterator();
        while (iterator.hasNext()) {
            IxtIndex ixtIndex;
            ixtIndex = iterator.next();
            if (!ixtIndex.isDisabled() || !ixtIndex.isVirtual() && this._keep_existing) continue;
            stringBuffer.append("drop index " + ixtIndex.getTable().getCreator() + "." + ixtIndex.getTable().getName() + "." + ixtIndex.getName());
        }
        return new String(stringBuffer);
    }

    public void clearNegatives() {
        Iterator<IxtIndex> iterator = this._indexes.iterator();
        while (iterator.hasNext()) {
            IxtIndex ixtIndex = iterator.next();
            if (ixtIndex.isKey()) {
                iterator.remove();
                continue;
            }
            if (!(ixtIndex.getTotalBenefit() <= 0.0) || !ixtIndex.isVirtual() && this._keep_existing) continue;
            ixtIndex.disable();
            iterator.remove();
        }
    }

    public boolean trimPhase(long l, double d) {
        boolean bl = false;
        this.computeLimits();
        long l2 = this.getTotalSize();
        double d2 = (double)l2 * d;
        if ((double)l2 - d2 < (double)l) {
            d2 = Math.max(l2 - l, 0L);
        }
        this.clearNegatives();
        if (d2 > 0.0) {
            Collections.sort(this._indexes, new IxtIndex.RelativeBenefitComparator());
            bl = this.trimFromFront(d2);
        }
        return bl;
    }

    public void computeLimits() {
        ListIterator<IxtIndex> listIterator = this._indexes.listIterator();
        this._max_num_configs = 0;
        this._max_benefit_sum = 0.0;
        this._max_dui_penalty = 0.0;
        while (listIterator.hasNext()) {
            IxtIndex ixtIndex = listIterator.next();
            if (ixtIndex.getBenefitSum() > this._max_benefit_sum) {
                this._max_benefit_sum = ixtIndex.getBenefitSum();
            }
            if (ixtIndex.getDUIPenalty() > this._max_dui_penalty) {
                this._max_dui_penalty = ixtIndex.getDUIPenalty();
            }
            if (ixtIndex.getConfigurations().size() <= this._max_num_configs) continue;
            this._max_num_configs = ixtIndex.getConfigurations().size();
        }
    }

    public double getMaxBenefitSum() {
        return this._max_benefit_sum;
    }

    public int getMaxNumConfigs() {
        return this._max_num_configs;
    }

    public double getMaxDUIPenalty() {
        return this._max_dui_penalty;
    }

    public IxtInstance getInstance() {
        return this._instance;
    }

    public void foldIndexes(FoldMatcher foldMatcher) {
        IxtIndex ixtIndex;
        boolean bl = false;
        HashMap hashMap = new HashMap();
        for (IxtTable ixtTable : this._instance.getTables().values()) {
            hashMap.put(new Long(ixtTable.getID()), new Vector());
        }
        ListIterator<IxtIndex> listIterator = this._indexes.listIterator();
        while (listIterator.hasNext()) {
            ixtIndex = listIterator.next();
            Vector vector = (Vector)hashMap.get(new Long(ixtIndex.getTable().getID()));
            vector.add(ixtIndex);
        }
        for (Vector vector : hashMap.values()) {
            listIterator = vector.listIterator();
            while (listIterator.hasNext()) {
                ixtIndex = listIterator.next();
                if (ixtIndex.isDisabled()) continue;
                ListIterator listIterator2 = vector.listIterator(listIterator.nextIndex());
                while (listIterator2.hasNext()) {
                    IxtIndex ixtIndex2 = (IxtIndex)listIterator2.next();
                    if (ixtIndex2.isDisabled()) continue;
                    if (ixtIndex.getID() == ixtIndex2.getID() && ixtIndex.getTable().getID() == ixtIndex2.getTable().getID()) {
                        bl = true;
                    } else if (foldMatcher.canFold(ixtIndex, ixtIndex2)) {
                        Iterator<IxtConfiguration> iterator = ixtIndex2.getConfigurationIterator();
                        while (iterator.hasNext()) {
                            IxtConfiguration ixtConfiguration = iterator.next();
                            ixtConfiguration.removeIndex(ixtIndex2);
                            ixtConfiguration.addIndex(ixtIndex);
                        }
                        ixtIndex.appendConfigurations(ixtIndex2.getConfigurations());
                        bl = true;
                        if (ixtIndex.getName() == null && ixtIndex2.getName() != null) {
                            ixtIndex.setName(ixtIndex2.getName());
                        }
                    }
                    if (!bl) continue;
                    if (foldMatcher.isCommutative() && !ixtIndex2.isVirtual()) {
                        ixtIndex.disable();
                    } else if (ixtIndex2.isVirtual()) {
                        ixtIndex2.disable();
                        ixtIndex.setClusterScore(Math.max(ixtIndex.getClusterScore(), ixtIndex2.getClusterScore()));
                        ixtIndex.setIsClustered(ixtIndex.isClustered() || ixtIndex2.isClustered());
                        ixtIndex.appendConfigurations(ixtIndex2.getConfigurations());
                    } else {
                        ixtIndex2.disable();
                    }
                    bl = false;
                }
            }
        }
        listIterator = this._indexes.listIterator();
        while (listIterator.hasNext()) {
            ixtIndex = listIterator.next();
            if (!ixtIndex.isDisabled()) continue;
            listIterator.remove();
        }
    }

    public void addReport() throws SQLException {
        Iterator<IxtIndex> iterator = this._indexes.iterator();
        this.computeLimits();
        while (iterator.hasNext()) {
            StringBuffer stringBuffer = new StringBuffer(100);
            IxtIndex ixtIndex = iterator.next();
            if (!ixtIndex.isVirtual() && this._keep_existing) continue;
            Iterator<IxtElement> iterator2 = ixtIndex.getElementIterator();
            while (iterator2.hasNext()) {
                IxtElement ixtElement = iterator2.next();
                stringBuffer.append(ixtElement.getColumn().getName());
                if (!iterator2.hasNext()) continue;
                stringBuffer.append(", ");
            }
            IxtDB.runUpdateIndexTable(this._id, ixtIndex.getTable().getID(), ixtIndex.getID(), ixtIndex.isClustered(), ixtIndex.getTotalBenefit(), ixtIndex.getDUIPenalty());
        }
        for (IxtIndex ixtIndex : this._indexes) {
            if (!ixtIndex.isVirtual() && this._keep_existing || ixtIndex.isKey()) continue;
            IxtDB.runRelativeBenefitUpdateIndexTable(this._id, ixtIndex.getTable().getID(), ixtIndex.getID(), ixtIndex.getRelativeBenefit());
        }
        Iterator<IxtConfiguration> iterator3 = this._configurations.iterator();
    }

    static class SubsumingFoldMatcher
    implements FoldMatcher {
        SubsumingFoldMatcher() {
        }

        @Override
        public boolean canFold(IxtIndex ixtIndex, IxtIndex ixtIndex2) {
            Vector<IxtElement> vector = ixtIndex.getCommonOrder(ixtIndex2);
            if (vector == null) {
                return false;
            }
            ixtIndex.setElements(vector);
            ixtIndex2.setElements(vector);
            return true;
        }

        @Override
        public boolean isCommutative() {
            return false;
        }
    }

    static class DuplicateFoldMatcher
    implements FoldMatcher {
        IxtIndex.ExactComparator _comparator = new IxtIndex.ExactComparator();

        @Override
        public boolean canFold(IxtIndex ixtIndex, IxtIndex ixtIndex2) {
            return ixtIndex != ixtIndex2 && 0 == this._comparator.compare(ixtIndex, ixtIndex2);
        }

        @Override
        public boolean isCommutative() {
            return true;
        }
    }

    static interface FoldMatcher {
        public boolean canFold(IxtIndex var1, IxtIndex var2);

        public boolean isCommutative();
    }
}

