/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.indexConsultant;

import com.sybase.indexConsultant.IxtColumn;
import com.sybase.indexConsultant.IxtConfiguration;
import com.sybase.indexConsultant.IxtFeedback;
import com.sybase.indexConsultant.IxtTable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class IxtQuery {
    public static final String INSERT = "INSERT";
    public static final String DELETE = "DELETE";
    public static final String UPDATE = "UPDATE";
    public static final String SELECT = "SELECT";
    long _id;
    String _type;
    double _vanilla;
    long _count;
    HashMap<Integer, IxtConfiguration> _configs_by_phase;
    Vector<Long> _workloadqueries;
    double _numrowsaffected;
    boolean _discarded;
    Vector<IxtColumn> _affected_columns;
    String _text;
    Vector<IxtTable> _affected_tables;

    public IxtQuery(long l, String string, double d, double d2, String string2) {
        this._id = l;
        this._type = string;
        this._vanilla = d;
        this._numrowsaffected = d2;
        this._count = 1L;
        this._text = string2;
        this._affected_columns = new Vector();
        this._affected_tables = new Vector();
        this._configs_by_phase = new HashMap();
        this._workloadqueries = new Vector();
    }

    public long getID() {
        return this._id;
    }

    public String getText() {
        return this._text;
    }

    public void setText(String string) {
        this._text = string;
    }

    public String getType() {
        return this._type;
    }

    public boolean isDiscarded() {
        return this._discarded;
    }

    public void setDiscarded(boolean bl) {
        this._discarded = bl;
    }

    public void setType(String string) {
        this._type = string;
    }

    public void setConfig(int n, IxtConfiguration ixtConfiguration) {
        this._configs_by_phase.put(new Integer(n), ixtConfiguration);
    }

    public IxtConfiguration getConfigurationByPhase(int n) {
        return this._configs_by_phase.get(new Integer(n));
    }

    public void addWorkloadItem(long l, long l2) {
        this._workloadqueries.add(new Long(l));
        this._count += l2;
    }

    public void addAffectedTable(IxtTable ixtTable) {
        this._affected_tables.add(ixtTable);
    }

    public void addAffectedColumn(IxtColumn ixtColumn) {
        this._affected_columns.add(ixtColumn);
    }

    public Iterator<IxtTable> getAffectedTablesIterator() {
        return this._affected_tables.iterator();
    }

    public Iterator<IxtColumn> getAffectedColumnsIterator() {
        return this._affected_columns.iterator();
    }

    public double getNumRowsAffected() {
        return this._numrowsaffected;
    }

    public void setNumRowsAffected(double d) {
        this._numrowsaffected = d;
    }

    public double getVanillaCost() {
        return this._vanilla;
    }

    public long getCount() {
        return this._count;
    }

    public void setCount(long l) {
        this._count = l;
    }

    public double getWorkCost() {
        IxtConfiguration ixtConfiguration = this.getConfigurationByPhase(this._configs_by_phase.size());
        if (ixtConfiguration != null) {
            return ixtConfiguration.getWorkingCost();
        }
        return this.getVanillaCost();
    }

    public double getTotalBenefit() {
        return this.getVanillaCost() - this.getWorkCost();
    }

    public Vector<Object> convertToAffectedResultsVector() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this._type);
        vector.add(new IxtFeedback.IxtVariableDecimal(this._numrowsaffected));
        vector.add(this._text);
        Iterator<IxtTable> iterator = this._affected_tables.iterator();
        String string = "";
        while (iterator.hasNext()) {
            string = string + iterator.next().getName();
            if (!iterator.hasNext()) continue;
            string = string + ",";
        }
        vector.add(string);
        Iterator<IxtColumn> iterator2 = this._affected_columns.iterator();
        string = "";
        while (iterator2.hasNext()) {
            string = string + iterator2.next().getName();
            if (!iterator2.hasNext()) continue;
            string = string + ",";
        }
        vector.add(string);
        return vector;
    }

    public Vector<Object> convertToDiscardedQryVector() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this._text);
        return vector;
    }

    public Vector<Object> convertToQueryResultVector() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this._text);
        vector.add(new Long(this._count));
        vector.add(new IxtFeedback.IxtDecimal(this.getVanillaCost()));
        vector.add(new IxtFeedback.IxtDecimal(this.getWorkCost()));
        vector.add(new IxtFeedback.IxtDecimal(this.getTotalBenefit()));
        return vector;
    }

    public Vector<Object> convertToAffectedVector() {
        Vector<Object> vector = new Vector<Object>();
        vector.add(this._text);
        vector.add(new IxtFeedback.IxtDecimal(this.getVanillaCost()));
        vector.add(new IxtFeedback.IxtDecimal(this.getWorkCost()));
        return vector;
    }

    public boolean equals(IxtQuery ixtQuery) {
        return ixtQuery.getID() == this._id && ixtQuery.getText().equals(this._text);
    }
}

