/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.indexConsultant;

import com.sybase.indexConsultant.IxtAnalysis;
import com.sybase.indexConsultant.IxtDB;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;

public class Workload {
    boolean _wasSaved = false;
    String _name;
    Connection _conn;
    int _error;
    int _version;
    int _loggingSession;
    public static int WORKLOAD_NO_ERROR = 0;
    public static int WORKLOAD_START_ERROR = 1;
    public static int WORKLOAD_STOP_ERROR = 2;
    public static int WORKLOAD_PAUSE_RESUME_ERROR = 3;
    public static int WORKLOAD_STATUS_ERROR = 4;

    public Workload(Connection connection, String string, int n, int n2) {
        this._name = string;
        this._conn = connection;
        this._error = WORKLOAD_NO_ERROR;
        this._loggingSession = n2;
        this._version = n;
    }

    public String getName() {
        return this._name;
    }

    public String getUserName() {
        String string = null;
        try {
            Statement statement = this._conn.createStatement();
            ResultSet resultSet = statement.executeQuery("select current user");
            string = IxtDB.getColumnString(resultSet, 1);
            resultSet.close();
            statement.close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return string;
    }

    public String toString() {
        return this.getName();
    }

    public void setSaved(boolean bl) {
        this._wasSaved = bl;
    }

    public boolean isSaved() {
        return this._wasSaved;
    }

    public void setError(int n) {
        this._error = n;
    }

    public int getError() {
        return this._error;
    }

    public boolean wasError() {
        return this._error != WORKLOAD_NO_ERROR;
    }

    public void delete() throws SQLException {
        String string = "call SYS.sa_remove_index_consultant_workload( '" + this._name + "' )";
        Statement statement = this._conn.createStatement();
        statement.execute(string);
        this._conn.commit();
        statement.close();
    }

    public void delete(String string) throws SQLException {
        String string2 = "call SYS.sa_remove_index_consultant_workload( '" + string + "' )";
        Statement statement = this._conn.createStatement();
        statement.execute(string2);
        this._conn.commit();
        statement.close();
    }

    public void updateName(String string) throws SQLException {
        String string2 = "call SYS.sa_update_index_consultant_workload( '" + this._name + "'," + "'" + string + "' )";
        Statement statement = this._conn.createStatement();
        statement.execute(string2);
        this._conn.commit();
        statement.close();
        this._name = string;
    }

    public boolean workloadExists(String string) throws SQLException {
        String string2 = "select * from dbo.ix_consultant_capture where workload_name = ?";
        boolean bl = false;
        PreparedStatement preparedStatement = this._conn.prepareStatement(string2);
        preparedStatement.setString(1, string);
        ResultSet resultSet = preparedStatement.executeQuery();
        if (resultSet.next()) {
            bl = true;
        }
        resultSet.close();
        preparedStatement.close();
        return bl;
    }

    public void startCapturing() throws SQLException {
        Statement statement = this._conn.createStatement();
        statement.execute("call dbo.sa_start_workload_capture( '" + this._name + "' )");
        statement.close();
    }

    public void stopCapturing() throws SQLException {
        Statement statement = this._conn.createStatement();
        statement.execute("call dbo.sa_stop_workload_capture()");
        statement.close();
    }

    public void pauseCapturing() throws SQLException {
        Statement statement = this._conn.createStatement();
        statement.execute("call dbo.sa_pause_workload_capture()");
        statement.close();
    }

    public void resumeCapturing() throws SQLException {
        Statement statement = this._conn.createStatement();
        statement.execute("call dbo.sa_resume_workload_capture()");
        statement.close();
    }

    public Vector<Object> statusCapturing() throws SQLException {
        Statement statement = this._conn.createStatement();
        ResultSet resultSet = statement.executeQuery("call dbo.sa_get_workload_capture_status()");
        Vector<Object> vector = new Vector<Object>();
        if (!resultSet.next()) {
            return vector;
        }
        vector.add(IxtDB.getColumnString(resultSet, 2));
        if (!resultSet.next()) {
            return vector;
        }
        vector.add(new Integer(resultSet.getInt(2)));
        if (!resultSet.next()) {
            return vector;
        }
        vector.add(IxtDB.getColumnString(resultSet, 2));
        resultSet.close();
        statement.close();
        return vector;
    }

    public String getScript() {
        return "";
    }

    public long getId() {
        return 0L;
    }

    public int getNumberOfQueries() throws SQLException {
        int n = 1000;
        if (this._version == 9) {
            String string = " select count(*) from dbo.ix_consultant_capture where workload_name = ? ";
            PreparedStatement preparedStatement = this._conn.prepareStatement(string);
            preparedStatement.setString(1, this._name);
            ResultSet resultSet = preparedStatement.executeQuery();
            PreparedStatement preparedStatement2 = preparedStatement;
            resultSet.next();
            n = resultSet.getInt(1);
            resultSet.close();
            preparedStatement2.close();
        }
        return n;
    }

    public String getTimestampOfLastQuery() throws SQLException {
        String string;
        String string2 = null;
        if (this._version == 9) {
            string = " select capture_time from dbo.ix_consultant_capture where workload_name = '" + this._name + "' order by capture_time";
        } else {
            string = " select max(r.start_time) from sa_diagnostic_request r ";
            if (this._loggingSession != 0) {
                string = string + " where r.logging_session_id = " + Long.toString(this._loggingSession);
            }
        }
        Statement statement = this._conn.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        if (resultSet.next()) {
            string2 = IxtDB.getColumnString(resultSet, 1);
        }
        resultSet.close();
        statement.close();
        return string2;
    }

    public String getUserOfLastRecordedQuery() throws SQLException {
        String string;
        String string2 = null;
        if (this._version == 9) {
            string = " select dbo.SYSUSERS.name from dbo.sysusers,dbo.ix_consultant_capture where dbo.ix_consultant_capture.workload_name = '" + this._name + "' and dbo.sysusers.uid = dbo.ix_consultant_capture.user_id order by capture_time desc";
        } else {
            string = " select first c.user_name, r.start_time from sa_diagnostic_connection c, sa_diagnostic_request r where r.logging_session_id = c.logging_session_id and r.connection_number = c.connection_number ";
            if (this._loggingSession != 0) {
                string = string + "and r.logging_session_id = " + Long.toString(this._loggingSession);
            }
            string = string + " order by r.start_time desc ";
        }
        Statement statement = this._conn.createStatement();
        ResultSet resultSet = statement.executeQuery(string);
        if (resultSet.next()) {
            string2 = IxtDB.getColumnString(resultSet, 1);
        }
        resultSet.close();
        statement.close();
        return string2;
    }

    public Connection getConnection() {
        return this._conn;
    }

    public void applyWorkload(IxtAnalysis ixtAnalysis) throws SQLException {
        Object object;
        String string;
        if (this._version == 9) {
            string = " insert into dbo.ix_consultant_workload( master_id, user_id, count,  cache_size, optimization_goal, optimization_level, user_estimates,  plan_hash, text )  select " + Long.toString(ixtAnalysis.getID()) + " , user_id, count, cache_size, optimization_goal, optimization_level, " + " user_estimates, NULL, query_text " + " from dbo.ix_consultant_capture " + " where workload_name = '" + this._name + "'";
        } else {
            object = Long.toString(this._loggingSession);
            String string2 = Long.toString(ixtAnalysis.getID());
            string = "begin  insert into ix_consultant_query_text( master_id, logging_session, text_id, count )  select top 1000 " + string2 + ", MAX( q.logging_session_id ), q.query_id, count(*) " + " from sa_diagnostic_query q, sa_diagnostic_request r, sa_diagnostic_statement s " + " where s.logging_session_id = q.logging_session_id and s.statement_id = q.statement_id " + " and q.logging_session_id = r.logging_session_id and q.query_id = r.query_id ";
            if (this._loggingSession != 0) {
                string = string + " and q.logging_session_id = " + (String)object;
            }
            string = string + " group by s.signature, q.query_id order by sum(duration_ms);  end ";
        }
        System.out.println(string);
        object = this._conn.createStatement();
        object.execute(string);
        object.close();
    }
}

