/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.indexConsultant;

import com.sybase.indexConsultant.IxtDB;
import com.sybase.indexConsultant.Workload;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;

public class WorkloadSet
implements Enumeration {
    private boolean _isOpened = false;
    private Connection _conn;
    private Statement _stmt;
    private ResultSet _res;
    private int _version;
    private static WorkloadSet _workloads = null;
    private static final String SQL_SELECT_9 = "SELECT DISTINCT workload_name, 0 from dbo.ix_consultant_capture";
    private static final String SQL_SELECT_10 = "SELECT DISTINCT cast( logging_session_id as long varchar ), logging_session_id from sa_diagnostic_request";

    WorkloadSet(Connection connection, int n) {
        this._version = n;
        this._conn = connection;
    }

    public static WorkloadSet getWorkloads(Connection connection, int n) {
        _workloads = new WorkloadSet(connection, n);
        return _workloads;
    }

    public int getCount() {
        return 1;
    }

    public void open() throws SQLException {
        this._stmt = this._conn.createStatement();
        this._res = this._version == 9 ? this._stmt.executeQuery(SQL_SELECT_9) : this._stmt.executeQuery(SQL_SELECT_10);
        this._isOpened = true;
    }

    public void close() {
        try {
            if (this._isOpened) {
                this._res.close();
                this._stmt.close();
            }
            this._isOpened = false;
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        this._isOpened = false;
    }

    public Connection getConnection() {
        return this._conn;
    }

    @Override
    public boolean hasMoreElements() {
        try {
            if (this._isOpened) {
                return this._res.next();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return false;
    }

    public Object nextElement() {
        try {
            if (this._isOpened) {
                Workload workload = new Workload(this._conn, IxtDB.getColumnString(this._res, 1), this._version, this._res.getInt(2));
                return workload;
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        return null;
    }
}

