/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.DefaultValue;
import com.sybase.resultSetTable.ImageProcessor;
import com.sybase.resultSetTable.LongBinaryValue;
import com.sybase.resultSetTable.LongTextValue;
import com.sybase.resultSetTable.LongValue;
import com.sybase.resultSetTable.LongValueButton;
import com.sybase.resultSetTable.NullAwareTable;
import com.sybase.resultSetTable.RSTFile;
import com.sybase.resultSetTable.ResultSetTableModel;
import com.sybase.resultSetTable.ScrollableResultSet;
import com.sybase.util.FontHelper;
import com.sybase.util.SybComboBox;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Vector;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

class BaseCellEditor
extends AbstractCellEditor
implements ActionListener,
DocumentListener,
FocusListener,
KeyListener,
TableCellEditor,
UndoableEditListener {
    protected static final int LEFT_ALIGNMENT = 1;
    protected static final int RIGHT_ALIGNMENT = 2;
    protected NullAwareTable _nat = null;
    protected Component _editor = null;
    protected JComboBox _comboBox = null;
    protected JTextField _textField = null;
    protected LongValueButton _longValueButton = null;
    protected JPanel _panel = null;
    protected boolean _specialItemSelected = false;
    protected boolean _showNullItem = false;
    protected String _nullDisplayText = "(NULL)";
    protected int _nullItemIndex = -1;
    protected boolean _showDefaultValueItem = false;
    protected String _defaultDisplayText = "(DEFAULT)";
    protected int _defaultValueItemIndex = -1;
    protected RSTFile _fileItem = null;
    protected String _fileDisplayText = "(FILE)";
    protected LongValue _longValueItem = null;
    protected boolean _isModified = false;
    protected byte[] _imageItem = null;
    protected String _imageDisplayText = "(IMAGE)";
    protected boolean _ignoreUndoableEdits = false;
    protected String _insertedText = null;
    protected static final int UNKNOWN_SQL_TYPE = 0;
    protected int _sqlType = 0;
    protected boolean _isSigned = false;

    protected int getAlignment() {
        return 1;
    }

    protected Component createEditor(JTable jTable, int n) {
        JComponent jComponent = null;
        this._defaultValueItemIndex = -1;
        this._nullItemIndex = -1;
        Vector<Object> vector = this.getComboBoxItems();
        if (this._showNullItem || this._showDefaultValueItem || vector != null && vector.size() != 0) {
            Component component;
            if (this._comboBox == null) {
                this._comboBox = new SybComboBox();
                this._comboBox.setEditable(true);
                this._comboBox.setBorder(null);
                this._comboBox.addActionListener(this);
                this._comboBox.addKeyListener(this);
                new FontHelper(this._comboBox);
                component = this._comboBox.getEditor().getEditorComponent();
                component.addKeyListener(this);
                this.setEditorBorder(component);
            }
            this._comboBox.setSelectedIndex(-1);
            if (this.getAlignment() == 2 && (component = this._comboBox.getEditor().getEditorComponent()) instanceof JTextField) {
                ((JTextField)component).setHorizontalAlignment(4);
            }
            jComponent = this._comboBox;
        } else {
            if (this._textField == null) {
                this._textField = new JTextField();
                new FontHelper((JTextComponent)this._textField);
                this.setEditorBorder(this._textField);
                this._textField.addKeyListener(this);
            }
            if (this.getAlignment() == 2) {
                this._textField.setHorizontalAlignment(4);
            }
            jComponent = this._textField;
        }
        return jComponent;
    }

    public static boolean shouldShowDefaultOption(int n, ResultSetTableModel resultSetTableModel) {
        if (resultSetTableModel == null) {
            return false;
        }
        ScrollableResultSet scrollableResultSet = resultSetTableModel.getScrollableResultSet();
        if (scrollableResultSet == null) {
            return false;
        }
        int n2 = resultSetTableModel.getInsertRow();
        if (n2 != -1) {
            String string = scrollableResultSet.getColumnDefaultValue(n);
            if (string != null) {
                return !string.equalsIgnoreCase("NULL");
            }
            return false;
        }
        return false;
    }

    public static boolean shouldShowNullOption(int n, ResultSetTableModel resultSetTableModel) {
        if (resultSetTableModel == null) {
            return false;
        }
        ScrollableResultSet scrollableResultSet = resultSetTableModel.getScrollableResultSet();
        if (scrollableResultSet == null) {
            return false;
        }
        int n2 = scrollableResultSet.getColumnNullability(n);
        return n2 != 0;
    }

    private void getSpecialValues(int n, int n2) {
        this._showDefaultValueItem = false;
        this._showNullItem = false;
        ResultSetTableModel resultSetTableModel = (ResultSetTableModel)this._nat.getModel();
        if (BaseCellEditor.shouldShowNullOption(n2, resultSetTableModel)) {
            this._showNullItem = true;
            this._nullDisplayText = this._nat.getNullDisplayString();
        }
        if (BaseCellEditor.shouldShowDefaultOption(n2, resultSetTableModel)) {
            this._showDefaultValueItem = true;
            this._defaultDisplayText = this._nat.getDefaultValueDisplayString();
        }
        this._imageDisplayText = this._nat.getImageDisplayString();
        this._fileDisplayText = this._nat.getFileDisplayString();
    }

    protected Vector<Object> getComboBoxItems() {
        return null;
    }

    protected String convertCellValueToString(Object object) {
        return object.toString();
    }

    protected Object convertStringToCellValue(String string) {
        return string;
    }

    protected void setInitialValue(Object object) {
        this._fileItem = null;
        this._longValueItem = null;
        this._imageItem = null;
        this._specialItemSelected = false;
        this._isModified = false;
        if (this._editor == this._comboBox) {
            JComboBox jComboBox = (JComboBox)this._editor;
            int n = jComboBox.getItemCount();
            int n2 = -1;
            if (object == null) {
                this._specialItemSelected = true;
                n2 = this._showDefaultValueItem ? n - 2 : n - 1;
            } else if (object instanceof DefaultValue) {
                this._specialItemSelected = true;
                n2 = n - 1;
            } else if (object instanceof LongValue) {
                this._longValueItem = (LongValue)object;
                object = this._longValueItem.getTruncatedValue();
                if (object instanceof byte[] && ImageProcessor.isImage((byte[])object)) {
                    this._specialItemSelected = true;
                    this._imageItem = (byte[])object;
                    jComboBox.setSelectedItem(this._imageDisplayText);
                } else {
                    jComboBox.setSelectedItem(this.convertCellValueToString(object));
                }
            } else if (object instanceof byte[] && ImageProcessor.isImage((byte[])object)) {
                this._specialItemSelected = true;
                this._imageItem = (byte[])object;
                jComboBox.setSelectedItem(this._imageDisplayText);
            } else if (object instanceof RSTFile) {
                this._specialItemSelected = true;
                this._fileItem = (RSTFile)object;
                jComboBox.setSelectedItem(this._fileDisplayText);
            } else {
                jComboBox.setSelectedItem(this.convertCellValueToString(object));
            }
            if (n2 != -1) {
                jComboBox.setSelectedIndex(n2);
            }
        } else if (this._editor instanceof JTextField) {
            if (object instanceof LongValue) {
                this._longValueItem = (LongValue)object;
                object = this._longValueItem.getTruncatedValue();
                if (object instanceof byte[] && ImageProcessor.isImage((byte[])object)) {
                    this._specialItemSelected = true;
                    this._imageItem = (byte[])object;
                    ((JTextField)this._editor).setText(this._imageDisplayText);
                } else {
                    ((JTextField)this._editor).setText(this.convertCellValueToString(object));
                }
            } else if (object instanceof byte[] && ImageProcessor.isImage((byte[])object)) {
                this._specialItemSelected = true;
                this._imageItem = (byte[])object;
                ((JTextField)this._editor).setText(this._imageDisplayText);
            } else if (object instanceof RSTFile) {
                this._specialItemSelected = true;
                this._fileItem = (RSTFile)object;
                ((JTextField)this._editor).setText(this._fileDisplayText);
            } else {
                this._specialItemSelected = false;
                ((JTextField)this._editor).setText(this.convertCellValueToString(object));
            }
        }
    }

    protected void modifyCellEditorValue(Object object) {
        this._ignoreUndoableEdits = true;
        this.setInitialValue(object);
        this._ignoreUndoableEdits = false;
    }

    @Override
    public Object getCellEditorValue() {
        int n = -1;
        Object object = null;
        Object object2 = null;
        JComboBox jComboBox = null;
        if (this._editor == this._comboBox) {
            jComboBox = (JComboBox)this._editor;
            object = jComboBox.getSelectedItem();
            n = jComboBox.getSelectedIndex();
            if (jComboBox.isEditable() && (object2 = jComboBox.getEditor().getItem()) != null && !object2.equals(object)) {
                object = object2;
                n = -1;
            }
        } else if (this._editor instanceof JTextField) {
            object = ((JTextField)this._editor).getText();
        }
        if (this._specialItemSelected) {
            object = this._editor == this._comboBox && n != -1 ? (n == this._nullItemIndex ? null : (n == this._defaultValueItemIndex ? new DefaultValue() : this.convertStringToCellValue(object.toString()))) : (this._imageItem != null ? (this._longValueItem != null ? this._longValueItem : (Object)this._imageItem) : this._fileItem);
        } else if (this._longValueItem != null && !this._isModified) {
            object = this._longValueItem;
        } else {
            object = this.convertStringToCellValue(object.toString().trim());
            if (this._longValueItem != null) {
                if (this._longValueItem instanceof LongTextValue && object instanceof String) {
                    int n2 = this._longValueItem.getTruncationLength();
                    this._longValueItem = new LongTextValue((String)object, n2, this._nat, true);
                    object = this._longValueItem;
                } else if (this._longValueItem instanceof LongBinaryValue && object instanceof byte[]) {
                    int n3 = this._longValueItem.getTruncationLength();
                    this._longValueItem = new LongBinaryValue((byte[])object, n3, this._nat, true);
                    object = this._longValueItem;
                } else {
                    this._longValueItem = null;
                }
            }
        }
        return object;
    }

    @Override
    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
        this._nat = (NullAwareTable)jTable;
        ScrollableResultSet scrollableResultSet = ((ResultSetTableModel)this._nat.getModel()).getScrollableResultSet();
        if (scrollableResultSet != null) {
            this._sqlType = scrollableResultSet.getColumnType(n2);
            this._isSigned = scrollableResultSet.isColumnSigned(n2);
        } else {
            this._sqlType = 0;
            this._isSigned = false;
        }
        this._ignoreUndoableEdits = true;
        this.getSpecialValues(n, n2);
        Component component = this._editor;
        this._editor = this.createEditor(jTable, n2);
        if (this._editor == this._comboBox) {
            Vector<Object> vector = new Vector<Object>();
            Vector<Object> vector2 = this.getComboBoxItems();
            if (vector2 != null) {
                vector.addAll(vector2);
            }
            if (this._showNullItem) {
                this._nullItemIndex = vector.size();
                vector.add(this._nullDisplayText);
            }
            if (this._showDefaultValueItem) {
                this._defaultValueItemIndex = vector.size();
                vector.add(this._defaultDisplayText);
            }
            JComboBox jComboBox = (JComboBox)this._editor;
            jComboBox.setModel(new DefaultComboBoxModel(vector));
            if (jComboBox.getEditor().getEditorComponent() instanceof JTextComponent) {
                Document document = ((JTextComponent)jComboBox.getEditor().getEditorComponent()).getDocument();
                document.addDocumentListener(this);
                document.addUndoableEditListener(this);
            }
        } else if (this._editor instanceof JTextComponent) {
            Document document = ((JTextComponent)this._editor).getDocument();
            document.addDocumentListener(this);
            document.addUndoableEditListener(this);
        }
        this.setInitialValue(object);
        if (this._panel == null) {
            this._panel = new JPanel();
            this._panel.setLayout(new BorderLayout());
            this._panel.addFocusListener(this);
        }
        if (this._longValueButton == null) {
            this._longValueButton = this._nat.getLongValueButton();
        }
        if (this._editor != component) {
            if (component != null) {
                this._panel.remove(component);
            }
            this._panel.add(this._editor, "Center");
        }
        if (this._nat.canColumnHaveLongValues(n2)) {
            this._longValueButton.moveToCellEditor(this, this._panel, "East", n, n2);
        } else {
            this._longValueButton.hideFromCellEditor();
        }
        this._ignoreUndoableEdits = false;
        return this._panel;
    }

    protected void setEditorBorder(Component component) {
        if (component instanceof JComponent) {
            ((JComponent)component).setBorder(BorderFactory.createCompoundBorder(BorderFactory.createLineBorder(component.getForeground(), 1), BorderFactory.createEmptyBorder(1, 1, 1, 1)));
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        int n = this._comboBox.getSelectedIndex();
        if (n >= 0 && (n == this._nullItemIndex || n == this._defaultValueItemIndex)) {
            this._specialItemSelected = true;
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this._editor != null && this._editor instanceof JComponent) {
            ((JComponent)this._editor).grabFocus();
        }
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 10) {
            if (this._nat != null) {
                if ((keyEvent.getModifiersEx() & 0x200) == 0) {
                    this._nat.enterKeyPressed();
                } else {
                    this._nat.longValueButtonClicked();
                }
            }
            keyEvent.consume();
        } else if (this._specialItemSelected && (keyEvent.getKeyCode() == 8 || keyEvent.getKeyCode() == 127)) {
            if (this._editor instanceof JComboBox) {
                ((JComboBox)this._editor).setSelectedItem("");
                this._specialItemSelected = false;
            } else if (this._editor instanceof JTextComponent) {
                ((JTextComponent)this._editor).setText("");
                this._specialItemSelected = false;
            }
            keyEvent.consume();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        if (this._specialItemSelected && !this._ignoreUndoableEdits) {
            Document document = documentEvent.getDocument();
            try {
                this._insertedText = document.getText(documentEvent.getOffset(), documentEvent.getLength());
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
        if (!this._ignoreUndoableEdits) {
            this._isModified = true;
            if (this._specialItemSelected) {
                if (this._insertedText != null) {
                    this._ignoreUndoableEdits = true;
                    if (this._editor instanceof JComboBox) {
                        JComboBox jComboBox = (JComboBox)this._editor;
                        jComboBox.setSelectedItem(this._insertedText);
                        Component component = jComboBox.getEditor().getEditorComponent();
                        if (component instanceof JTextComponent) {
                            JTextComponent jTextComponent = (JTextComponent)component;
                            int n = jTextComponent.getCaretPosition();
                            jTextComponent.setSelectionStart(n);
                            jTextComponent.setSelectionEnd(n);
                        }
                    } else if (this._editor instanceof JTextComponent) {
                        JTextComponent jTextComponent = (JTextComponent)this._editor;
                        jTextComponent.setText(this._insertedText);
                    }
                    this._ignoreUndoableEdits = false;
                    this._insertedText = null;
                }
                this._specialItemSelected = false;
            }
        }
    }

    private static boolean dbgEnabled() {
        return false;
    }
}

