/*
 * Decompiled with CFR 0.152.
 */
package com.sybase.resultSetTable;

import com.sybase.resultSetTable.BaseCellEditor;

class BinaryCellEditor
extends BaseCellEditor {
    Object _originalValue = null;

    BinaryCellEditor() {
    }

    @Override
    protected String convertCellValueToString(Object object) {
        String string;
        if (object == null) {
            string = "";
        } else if (object instanceof byte[]) {
            byte[] byArray = (byte[])object;
            string = BinaryCellEditor.blobToString(byArray, byArray.length);
        } else {
            string = object.toString();
        }
        return string;
    }

    @Override
    protected Object convertStringToCellValue(String string) {
        Object object;
        if (string.isEmpty()) {
            object = new byte[]{};
        } else {
            try {
                object = this.stringToBlob(string);
            }
            catch (NumberFormatException numberFormatException) {
                object = string;
            }
        }
        return object;
    }

    static String blobToString(byte[] byArray, int n) {
        if (n < 0 || n > byArray.length) {
            n = byArray.length;
        }
        StringBuilder stringBuilder = new StringBuilder(n * 2 + 2);
        if (byArray != null && byArray.length > 0) {
            stringBuilder.append("0x");
            for (int i = 0; i < n; ++i) {
                int n2 = byArray[i];
                if (n2 < 0) {
                    n2 += 256;
                }
                int n3 = n2 >> 4;
                int n4 = n2 & 0xF;
                if (n3 < 10) {
                    stringBuilder.append((char)(48 + n3));
                } else {
                    stringBuilder.append((char)(97 + n3 - 10));
                }
                if (n4 < 10) {
                    stringBuilder.append((char)(48 + n4));
                    continue;
                }
                stringBuilder.append((char)(97 + n4 - 10));
            }
            if (byArray.length != n) {
                stringBuilder.append("...");
            }
        }
        return stringBuilder.toString();
    }

    private byte[] stringToBlob(String string) {
        int n = string.length();
        if (n < 2 || !string.regionMatches(true, 0, "0x", 0, 2) || (n & 1) == 1) {
            throw new NumberFormatException();
        }
        byte[] byArray = new byte[(n - 2) / 2];
        int n2 = 0;
        for (int i = 2; i < n; i += 2) {
            int n3 = Character.digit(string.charAt(i), 16);
            int n4 = Character.digit(string.charAt(i + 1), 16);
            if (n3 == -1 || n4 == -1) {
                throw new NumberFormatException("Invalid hex number: " + string.charAt(i) + string.charAt(i + 1));
            }
            byArray[n2++] = (byte)(n3 * 16 + n4);
        }
        return byArray;
    }

    private static boolean dbgEnabled() {
        return false;
    }
}

